/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleRd;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleIterationRule;
import com.ibm.able.rules.AbleRule;
import java.io.Serializable;
import java.util.Vector;

public class AbleDoWhileRule
extends AbleRule
implements AbleIterationRule,
Serializable {
    static final long serialVersionUID = 2001011800000000001L;
    static String clsNm = "AbleDoWhileRule";
    protected AbleExpression myTestExpression;
    protected Vector myConsequents;

    public AbleDoWhileRule(String string, AbleRd ableRd, AbleExpression ableExpression, Vector vector) {
        super(0, string, ableRd, null);
        this.myTestExpression = ableExpression;
        this.myConsequents = (Vector)vector.clone();
        this.ctorHelperSaveReferences();
    }

    private void ctorHelperSaveReferences() {
        this.addHeaderRdReferences();
        this.addRdReferences(this.myTestExpression.getReferents());
        if (!this.myConsequents.isEmpty()) {
            for (int i = 0; i < this.myConsequents.size(); ++i) {
                AbleConsequentClause ableConsequentClause = (AbleConsequentClause)this.myConsequents.elementAt(i);
                ableConsequentClause.addRuleRef(this);
                this.addRdReferences(ableConsequentClause.getReferents());
                this.addWrReference(ableConsequentClause.getLhsReferent());
            }
        }
    }

    public final AbleExpression getTestExpression() {
        return this.myTestExpression;
    }

    public int getNumberOfDoActions() {
        int n = 0;
        if (this.myConsequents != null) {
            n = this.myConsequents.size();
        }
        return n;
    }

    public final Vector getDoActions() {
        return this.myConsequents;
    }

    public String arlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.myConsequents.size();
        String string = "    " + this.myLabel;
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.arlCRdString() + "]: ");
        }
        stringBuffer2.append("      ");
        if (this.myComment.length() > 0 || !this.myProperties.isEmpty()) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        if (this.isTemplate()) {
            stringBuffer.append("template ");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.arlPreConditionsString());
        stringBuffer.append(stringBuffer3.toString() + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "do {" + Able.LS);
        stringBuffer.append(AbleDoWhileRule.arlActionBlockString(stringBuffer2.toString() + "  ", this.myConsequents));
        stringBuffer.append(stringBuffer2.toString() + "} while ( ");
        stringBuffer.append(this.myTestExpression.arlCRdString());
        stringBuffer.append(stringBuffer2.toString() + ");" + Able.LS);
        return stringBuffer.toString();
    }

    public String xmlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.myConsequents.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = this.isTemplate() ? " template=\"true\"" : "";
        String string3 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        stringBuffer.append("    <rule" + string + string3 + string2 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("    <doWhile>" + Able.LS);
        stringBuffer.append("      <antecedentExpr>" + Able.LS);
        stringBuffer.append(this.myTestExpression.xmlCRdString() + Able.LS);
        stringBuffer.append("      </antecedentExpr>" + Able.LS);
        stringBuffer.append("    <do_>" + Able.LS);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("      <action_>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(i)).xmlString() + Able.LS);
            stringBuffer.append("      </action_>" + Able.LS);
        }
        stringBuffer.append("    </do_>" + Able.LS);
        stringBuffer.append("    </doWhile>" + Able.LS);
        stringBuffer.append("     </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.myConsequents.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = this.isTemplate() ? " template=\"true\"" : "";
        String string3 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string4 = this.myFinalFlag ? " final=\"true\"" : "";
        stringBuffer.append("    <DoWhileRule" + string + string3 + string2 + string4 + ">" + Able.LS);
        stringBuffer.append(this.armlPreConditionsString());
        stringBuffer.append(this.armlPriorityString());
        stringBuffer.append(this.armlPropertiesString());
        stringBuffer.append("    <while>" + Able.LS);
        stringBuffer.append(this.myTestExpression.armlCRdString() + Able.LS);
        stringBuffer.append("    </while>" + Able.LS);
        stringBuffer.append("    <do>" + Able.LS);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(i)).armlString());
        }
        stringBuffer.append("    </do>" + Able.LS);
        stringBuffer.append("     </DoWhileRule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.myConsequents.size();
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer2.append("      ");
        stringBuffer.append(this.getTemplateHeaderString(vector));
        stringBuffer.append(stringBuffer2.toString() + "do '{'" + Able.LS);
        stringBuffer.append(AbleDoWhileRule.getTemplateActionBlockString(vector, stringBuffer2.toString() + "  ", this.myConsequents));
        stringBuffer.append(stringBuffer2.toString() + "'}' while ( ");
        stringBuffer.append(this.myTestExpression.getTemplateString(vector));
        stringBuffer.append(stringBuffer2.toString() + ");" + Able.LS);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        int n3 = this.myConsequents.size();
        String string = "    " + this.myLabel;
        int n4 = this.myLabel.length();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer2.append(" ");
        }
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.traceString(n) + "]: ");
        }
        for (n2 = 0; n2 < stringBuffer3.length(); ++n2) {
            stringBuffer2.append(" ");
        }
        stringBuffer.append(string + stringBuffer3.toString() + "while {");
        stringBuffer.append(stringBuffer2.toString() + "       do {");
        stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(0)).traceString(n));
        for (n2 = 1; n2 < n3; ++n2) {
            stringBuffer.append(Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "           " + ((AbleConsequentClause)this.myConsequents.elementAt(n2)).traceString(n));
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "          } while (");
        stringBuffer.append(stringBuffer2.toString() + "           " + this.myTestExpression.traceString(n));
        stringBuffer.append(stringBuffer2.toString() + "          )" + Able.LS);
        return stringBuffer.toString();
    }
}

