/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleConditionalRule;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleTreeActionNode;
import com.ibm.able.rules.AbleTreeConditionNode;
import com.ibm.able.rules.AbleTreeEdge;
import com.ibm.able.rules.AbleTreeNode;
import com.ibm.able.rules.AbleTreeRule;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class AbleDecisionTreeEngine
extends AbleInferenceEngine
implements Serializable {
    static final long serialVersionUID = 2003083100000000001L;
    static String clsNm = "AbleDecisionTreeEngine";

    public AbleDecisionTreeEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger) {
        super(ableRuleSet, ableLogger);
    }

    public AbleDecisionTreeEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger, AbleRuleBlock ableRuleBlock) {
        super(ableRuleSet, ableLogger, ableRuleBlock);
    }

    public boolean isRuleBlockValid(AbleRuleBlock ableRuleBlock) {
        boolean bl = true;
        String string = null;
        Iterator iterator = null;
        AbleRule ableRule = null;
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        String string2 = ableRuleBlock2.getName();
        String string3 = ableRuleBlock2.getEngineType();
        if (!AbleDecisionTreeEngine.conditionalRulesValid(this.myRuleSet, ableRuleBlock2)) {
            bl = false;
        }
        iterator = ableRuleBlock2.getPatternMatchRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPatternMatchRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getPredicateRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPredicateRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIterationRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIterationRulesAllowed", (Object[])new Object[]{string3, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        return bl;
    }

    public void infer(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        Vector vector;
        this.myRulesFiredCount = 0;
        if (ableRuleBlock != null) {
            this.processAssertions(ableRuleBlock);
        }
        if ((vector = this.myRuleBlock.getEnabledTreeRules()).size() > 0) {
            this.fireTreeRules(vector);
            return;
        }
        if (ableRuleBlock != null) {
            this.fireTriggeredRule(ableRuleBlock);
        }
    }

    private void fireTriggeredRule(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        if (this.myRuleSet.inferTraceMedium) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "fireTriggeredRule()", "Tr_Rs_FireTriggeredRule", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType, Integer.toString(1)});
        }
        this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock);
        if (this.myDebugLevel == 3) {
            this.fireEngineBreakpoint();
        }
        Enumeration enumeration = ableRuleBlock.getConditionalRules().elements();
        Boolean bl = null;
        while (enumeration.hasMoreElements()) {
            AbleConditionalRule ableConditionalRule = (AbleConditionalRule)enumeration.nextElement();
            this.checkRuleAntecedents(ableConditionalRule);
            bl = ableConditionalRule.getBooleanTruth();
            if (bl == null || !bl.booleanValue()) continue;
            this.processConsequent(ableConditionalRule);
            ++this.myRulesFiredCount;
            break;
        }
        if (this.myRuleSet.inferTraceMedium) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "fireTriggeredRule()", "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock.getName(), ableRuleBlock.myEngineType});
        }
    }

    private Boolean checkRuleAntecedents(AbleConditionalRule ableConditionalRule) throws AbleDataException {
        Boolean bl = null;
        this.myRuleSet.myInferenceContext.setRule(ableConditionalRule);
        Vector vector = ableConditionalRule.getAntecedents();
        for (int i = 0; i < vector.size(); ++i) {
            AbleAntecedentClause ableAntecedentClause = (AbleAntecedentClause)vector.elementAt(i);
            bl = ableAntecedentClause.getBooleanTruth();
            if (bl == null) {
                this.myRuleSet.myInferenceContext.setClause(ableAntecedentClause);
                bl = AbleDecisionTreeEngine.evalAntecedentClause(ableAntecedentClause);
            }
            if (bl == null) {
                ableConditionalRule.setBooleanTruth(bl);
                return bl;
            }
            if (bl.booleanValue()) continue;
            ableConditionalRule.setBooleanTruth(bl);
            return bl;
        }
        ableConditionalRule.setBooleanTruth(bl);
        return bl;
    }

    private void fireTreeRules(Vector vector) throws AbleDataException {
        if (this.myRuleSet.inferTraceMedium) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "fireTriggeredRule()", "Tr_Rs_FireTriggeredRule", new Object[]{this.myRuleBlock.getName(), this.myRuleBlock.myEngineType, Integer.toString(1)});
        }
        this.myRuleSet.myInferenceContext.setRuleBlock(this.myRuleBlock);
        if (this.myDebugLevel == 3) {
            this.fireEngineBreakpoint();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AbleTreeRule ableTreeRule = (AbleTreeRule)enumeration.nextElement();
            this.evalTree(ableTreeRule.getDecisionTree().getRootNode());
            ableTreeRule.setFired(true);
        }
        if (this.myRuleSet.inferTraceMedium) {
            this.myTracer.message(0x20000000000L, (Object)clsNm, "fireTriggeredRule()", "Tr_Rs_RuleBlockInferEnds", new Object[]{this.myRuleBlock.getName(), this.myRuleBlock.myEngineType});
        }
    }

    public boolean evalTree(AbleTreeNode ableTreeNode) throws AbleDataException {
        boolean bl = false;
        if (ableTreeNode instanceof AbleTreeConditionNode) {
            String string = ((AbleTreeConditionNode)ableTreeNode).getTerm().toString();
            Vector vector = ((AbleTreeConditionNode)ableTreeNode).getEdges();
            for (int i = 0; i < vector.size(); ++i) {
                AbleTreeEdge ableTreeEdge = (AbleTreeEdge)vector.get(i);
                AbleExpression ableExpression = ableTreeEdge.getAbleExpression();
                if (ableExpression.getBooleanValue()) {
                    bl = this.evalTree(ableTreeEdge.getChildNode());
                }
                if (!bl) {
                    continue;
                }
                break;
            }
        } else if (ableTreeNode instanceof AbleTreeActionNode) {
            Vector vector = ((AbleTreeActionNode)ableTreeNode).getAbleActions();
            this.processConsequentClauses(vector);
            bl = true;
        }
        return bl;
    }

    public void setControlParameter(String string, Object object) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{this.myRuleBlock.getEngineType(), string}));
    }

    public Object getControlParameter(String string) throws AbleDataException {
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsUnsupportedControlParameter", (Object[])new Object[]{this.myRuleBlock.getEngineType(), string}));
    }

    public void reset() {
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

