/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleRd;
import com.ibm.able.rules.AbleClause;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleLifespan;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleSelector;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;

public class AbleCorrelationRule
extends AbleRule
implements Serializable {
    protected AbleLifespan myLifeSpan;
    protected Vector myConditionArgs;
    protected Vector myCloneableArgs;
    protected Vector myConsequents;
    protected Vector myEventSelectors;
    protected HashSet myBindings;

    public AbleCorrelationRule(String string, AbleRd ableRd, Vector vector, Vector vector2, Vector vector3, Vector vector4, AbleRuleSet ableRuleSet) {
        super(0, string, ableRd, ableRuleSet);
        this.myConditionArgs = (Vector)vector.clone();
        this.myCloneableArgs = (Vector)vector2.clone();
        this.myEventSelectors = (Vector)vector3.clone();
        this.myConsequents = (Vector)vector4.clone();
        this.myBindings = new HashSet();
        this.ctorHelperSaveReferences();
    }

    private void ctorHelperSaveReferences() {
        Serializable serializable;
        int n;
        this.addHeaderRdReferences();
        if (!this.myEventSelectors.isEmpty()) {
            for (n = 0; n < this.myEventSelectors.size(); ++n) {
                serializable = (AbleSelector)this.myEventSelectors.elementAt(n);
                AbleExpression ableExpression = ((AbleSelector)serializable).getConstraintExpression();
                this.addRdReferences(ableExpression.getReferents());
            }
        }
        for (n = 0; n < this.myConsequents.size(); ++n) {
            serializable = (AbleConsequentClause)this.myConsequents.elementAt(n);
            if (serializable == null) continue;
            ((AbleClause)serializable).addRuleRef(this);
            this.addRdReferences(((AbleClause)serializable).getReferents());
            this.addWrReference(((AbleClause)serializable).getLhsReferent());
        }
    }

    public final Vector getSelectors() {
        return this.myEventSelectors;
    }

    public final Vector getConditionArgs() {
        return this.myConditionArgs;
    }

    public final Vector getCloneableArgs() {
        return this.myCloneableArgs;
    }

    public final Vector getActions() {
        return this.myConsequents;
    }

    public int getNumberOfSelectors() {
        int n = 0;
        if (this.myEventSelectors != null) {
            n = this.myEventSelectors.size();
        }
        return n;
    }

    public Vector getEventTypes() {
        return new Vector();
    }

    public String arlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myEventSelectors.size();
        int n3 = this.myConsequents.size();
        String string = "    " + this.myLabel;
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.arlCRdString() + "]: ");
        }
        stringBuffer2.append("      ");
        if (this.myComment.length() > 0 || !this.myProperties.isEmpty()) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        if (this.isTemplate()) {
            stringBuffer.append("template ");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.arlPreConditionsString());
        stringBuffer.append(stringBuffer3.toString() + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "event( ");
        stringBuffer.append(((AbleSelector)this.myEventSelectors.elementAt(0)).arlString());
        for (n = 1; n < n2; ++n) {
            stringBuffer.append("  &" + Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "      " + ((AbleSelector)this.myEventSelectors.elementAt(n)).arlString());
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "    )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "condition( ");
        stringBuffer.append(((AbleRd)this.myConditionArgs.get(0)).arlCRdString());
        for (n = 1; n < n2; ++n) {
            stringBuffer.append("  &" + Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "      " + ((AbleRd)this.myConditionArgs.get(n)).arlCRdString());
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "    )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "action  { ");
        stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(0)).arlString() + ";");
        for (n = 1; n < n3; ++n) {
            stringBuffer.append(Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "      " + ((AbleConsequentClause)this.myConsequents.elementAt(n)).arlString() + ";");
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "    }" + Able.LS);
        return stringBuffer.toString();
    }

    public String xmlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myEventSelectors.size();
        int n3 = this.myConsequents.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("      <event>" + Able.LS);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(((AbleSelector)this.myEventSelectors.elementAt(n)).xmlString());
        }
        stringBuffer.append("    <condition>" + Able.LS);
        for (n = 0; n < n3; ++n) {
            stringBuffer.append("      <arg>" + Able.LS);
            stringBuffer.append(((AbleRd)this.myConditionArgs.get(n)).xmlCRdString() + Able.LS);
            stringBuffer.append("      </arg>" + Able.LS);
        }
        stringBuffer.append("    </condition>" + Able.LS);
        stringBuffer.append("    <actions>" + Able.LS);
        for (n = 0; n < n3; ++n) {
            stringBuffer.append("      <action>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(n)).xmlString() + Able.LS);
            stringBuffer.append("      </action>" + Able.LS);
        }
        stringBuffer.append("    </actions>" + Able.LS);
        stringBuffer.append("    </event>" + Able.LS);
        stringBuffer.append("     </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myEventSelectors.size();
        int n3 = this.myConsequents.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        String string4 = this.myFinalFlag ? " final=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + string4 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("      <event>" + Able.LS);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(((AbleSelector)this.myEventSelectors.elementAt(n)).xmlString());
        }
        stringBuffer.append("    <condition>" + Able.LS);
        for (n = 0; n < n3; ++n) {
            stringBuffer.append("      <arg>" + Able.LS);
            stringBuffer.append(((AbleRd)this.myConditionArgs.get(n)).xmlCRdString() + Able.LS);
            stringBuffer.append("      </arg>" + Able.LS);
        }
        stringBuffer.append("    </condition>" + Able.LS);
        stringBuffer.append("    <actions>" + Able.LS);
        for (n = 0; n < n3; ++n) {
            stringBuffer.append("      <action>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(n)).xmlString() + Able.LS);
            stringBuffer.append("      </action>" + Able.LS);
        }
        stringBuffer.append("    </actions>" + Able.LS);
        stringBuffer.append("    </event>" + Able.LS);
        stringBuffer.append("     </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.myEventSelectors.size();
        int n3 = this.myConsequents.size();
        StringBuffer stringBuffer2 = new StringBuffer("");
        stringBuffer.append(this.getTemplateHeaderString(vector));
        stringBuffer2.append("      ");
        stringBuffer.append(stringBuffer2.toString() + "event( ");
        stringBuffer.append(((AbleSelector)this.myEventSelectors.elementAt(0)).getTemplateString(vector));
        for (n = 1; n < n2; ++n) {
            stringBuffer.append("  &" + Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "      " + ((AbleSelector)this.myEventSelectors.elementAt(n)).getTemplateString(vector));
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "    )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "condition( ");
        stringBuffer.append(((AbleRd)this.myConditionArgs.get(0)).getTemplateString(vector));
        for (n = 1; n < n2; ++n) {
            stringBuffer.append("  &" + Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "      " + ((AbleRd)this.myConditionArgs.get(n)).getTemplateString(vector));
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "    )" + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "action  { ");
        stringBuffer.append(((AbleConsequentClause)this.myConsequents.elementAt(0)).getTemplateString(vector) + ";");
        for (n = 1; n < n3; ++n) {
            stringBuffer.append(Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "      " + ((AbleConsequentClause)this.myConsequents.elementAt(n)).getTemplateString(vector) + ";");
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "    }" + Able.LS);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "    " + this.myLabel;
        String string2 = "";
        string2 = this.myPriority == PriorityDefault ? ": " : "[" + this.myPriority.traceString(n) + "]: ";
        stringBuffer.append(string);
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

