/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleRd;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleClause;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Vector;

public class AbleConditionalRule
extends AbleRule
implements Serializable {
    static final long serialVersionUID = 2001011800000000001L;
    static String clsNm = "AbleConditionalRule";
    protected Vector myAntecedents;
    protected Vector myAntExpressionList;
    protected Vector myThenList = new Vector();

    public AbleConditionalRule(String string, AbleRd ableRd, Vector vector, Vector vector2, Vector vector3) {
        super(0, string, ableRd, null);
        this.myAntExpressionList = (Vector)vector.clone();
        this.myAntecedents = (Vector)vector2.clone();
        this.myThenList = (Vector)vector3.clone();
        this.ctorHelperSaveReferences();
    }

    private void ctorHelperSaveReferences() {
        AbleClause ableClause;
        int n;
        this.addHeaderRdReferences();
        if (!this.myAntecedents.isEmpty()) {
            for (n = 0; n < this.myAntecedents.size(); ++n) {
                ableClause = (AbleAntecedentClause)this.myAntecedents.elementAt(n);
                ableClause.addRuleRef(this);
                this.addRdReferences(ableClause.getReferents());
            }
        }
        if (!this.myThenList.isEmpty()) {
            for (n = 0; n < this.myThenList.size(); ++n) {
                ableClause = (AbleConsequentClause)this.myThenList.elementAt(n);
                ableClause.addRuleRef(this);
                this.addWrReference(ableClause.getLhsReferent());
            }
        }
    }

    public final Vector getAntecedents() {
        return this.myAntecedents;
    }

    public long numberOfAntecedents() {
        long l = 0L;
        if (this.myAntecedents != null) {
            l = this.myAntecedents.size();
        }
        return l;
    }

    public final Vector getThenClauses() {
        return this.myThenList;
    }

    public long numberOfThenClauses() {
        long l = 0L;
        if (this.myThenList != null) {
            l = this.myThenList.size();
        }
        return l;
    }

    public void reset() {
        this.myFiredFlag = false;
        for (int i = 0; i < this.myAntecedents.size(); ++i) {
            AbleAntecedentClause ableAntecedentClause = (AbleAntecedentClause)this.myAntecedents.get(i);
            ableAntecedentClause.setBooleanTruth(null);
        }
    }

    public String arlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myAntExpressionList.size();
        String string = "    " + this.myLabel;
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.arlCRdString() + "]: ");
        }
        stringBuffer2.append("      ");
        if (this.myComment.length() > 0 || !this.myProperties.isEmpty()) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        if (this.isTemplate()) {
            stringBuffer.append("template ");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.arlPreConditionsString());
        stringBuffer.append(stringBuffer3.toString() + Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "if (");
        stringBuffer.append(((AbleExpression)this.myAntExpressionList.get(0)).arlCRdString());
        for (n = 1; n < n2; ++n) {
            stringBuffer.append("  ," + Able.LS);
            stringBuffer.append(stringBuffer2.toString() + "    " + ((AbleExpression)this.myAntExpressionList.get(n)).arlCRdString());
        }
        stringBuffer.append(")" + Able.LS);
        if (this.myThenList.size() == 1) {
            stringBuffer.append(stringBuffer2.toString() + "then ");
            stringBuffer.append(" " + ((AbleConsequentClause)this.myThenList.elementAt(0)).arlString() + ";" + Able.LS);
        } else {
            stringBuffer.append(stringBuffer2.toString() + "then { " + Able.LS);
            for (n = 0; n < this.myThenList.size(); ++n) {
                stringBuffer.append(stringBuffer2.toString() + "    " + ((AbleConsequentClause)this.myThenList.elementAt(n)).arlString() + ";" + Able.LS);
            }
        }
        if (this.myThenList.size() > 1) {
            stringBuffer.append(stringBuffer2.toString() + "}");
        }
        return stringBuffer.toString();
    }

    public String xmlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myAntExpressionList.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("      <if>" + Able.LS);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("      <antecedent>" + Able.LS);
            stringBuffer.append(((AbleExpression)this.myAntExpressionList.get(n)).xmlCRdString());
            stringBuffer.append("      </antecedent>" + Able.LS);
        }
        stringBuffer.append("    </if>" + Able.LS);
        stringBuffer.append("    <then>" + Able.LS);
        for (n = 0; n < this.myThenList.size(); ++n) {
            stringBuffer.append("      <consequent>" + Able.LS);
            stringBuffer.append(((AbleConsequentClause)this.myThenList.elementAt(n)).xmlString());
            stringBuffer.append("      </consequent>" + Able.LS);
        }
        stringBuffer.append("    </then>" + Able.LS);
        stringBuffer.append("    <else conditionalRule=\"true\" >" + Able.LS);
        stringBuffer.append("    </else>" + Able.LS);
        stringBuffer.append("    </rule>" + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.myAntExpressionList.size();
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        String string4 = this.myFinalFlag ? " final=\"true\"" : "";
        stringBuffer.append("    <IfThenRule" + string + string2 + string3 + string4 + ">" + Able.LS);
        stringBuffer.append(this.armlPreConditionsString());
        stringBuffer.append(this.armlPriorityString());
        stringBuffer.append(this.armlPropertiesString());
        stringBuffer.append("    <if>" + Able.LS);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(((AbleExpression)this.myAntExpressionList.get(n)).armlCRdString());
        }
        stringBuffer.append("    </if>" + Able.LS);
        stringBuffer.append("    <then>" + Able.LS);
        for (n = 0; n < this.myThenList.size(); ++n) {
            stringBuffer.append(((AbleConsequentClause)this.myThenList.elementAt(n)).armlString());
        }
        stringBuffer.append("    </then>" + Able.LS);
        stringBuffer.append("    </IfThenRule>" + Able.LS);
        return stringBuffer.toString();
    }

    public Vector getTemplateVars(AbleRuleSet ableRuleSet) throws AbleDataException {
        Serializable serializable;
        BitSet bitSet = this.myRdRefs;
        if (!this.myThenList.isEmpty()) {
            for (int i = 0; i < this.myThenList.size(); ++i) {
                serializable = (AbleConsequentClause)this.myThenList.elementAt(i);
                this.addRdReferences(serializable.getReferents());
            }
        }
        BitSet bitSet2 = new BitSet();
        bitSet2.or(this.myRdRefs);
        bitSet2.or(this.myWrRefs);
        serializable = ableRuleSet.getTemplateVariables(bitSet2);
        this.myRdRefs = bitSet;
        return serializable;
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTemplateHeaderString(vector));
        int n2 = this.myAntecedents.size();
        stringBuffer.append("if (");
        stringBuffer.append(((AbleAntecedentClause)this.myAntecedents.elementAt(0)).getTemplateString(vector));
        for (n = 1; n < n2; ++n) {
            stringBuffer.append("  and" + Able.LS);
            stringBuffer.append("    " + ((AbleAntecedentClause)this.myAntecedents.elementAt(n)).getTemplateString(vector));
        }
        stringBuffer.append(")" + Able.LS);
        if (this.myThenList.size() == 1) {
            stringBuffer.append("then ");
            stringBuffer.append(" " + ((AbleConsequentClause)this.myThenList.elementAt(0)).getTemplateString(vector) + ";" + Able.LS);
        } else {
            stringBuffer.append("then '{' " + Able.LS);
            for (n = 0; n < this.myThenList.size(); ++n) {
                stringBuffer.append("    " + ((AbleConsequentClause)this.myThenList.elementAt(n)).getTemplateString(vector) + ";" + Able.LS);
            }
        }
        if (this.myThenList.size() > 1) {
            stringBuffer.append("'}'");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        int n3 = this.myAntecedents.size();
        String string = "    " + this.myLabel;
        int n4 = this.myLabel.length();
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer2.append(" ");
        }
        if (this.myPriority == PriorityDefault) {
            stringBuffer3.append(": ");
        } else {
            stringBuffer3.append("[" + this.myPriority.traceString(n) + "]: ");
        }
        for (n2 = 0; n2 < stringBuffer3.length(); ++n2) {
            stringBuffer2.append(" ");
        }
        stringBuffer.append(string + stringBuffer3.toString() + "if\n");
        stringBuffer.append(stringBuffer2.toString() + "    " + ((AbleAntecedentClause)this.myAntecedents.elementAt(0)).traceString(n));
        for (n2 = 1; n2 < n3; ++n2) {
            stringBuffer.append("  and\n");
            stringBuffer.append(stringBuffer2.toString() + "    " + ((AbleAntecedentClause)this.myAntecedents.elementAt(n2)).traceString(n));
        }
        stringBuffer.append(Able.LS);
        stringBuffer.append(stringBuffer2.toString() + "  then\n");
        for (n2 = 0; n2 < this.myThenList.size(); ++n2) {
            stringBuffer.append(stringBuffer2.toString() + "    " + ((AbleConsequentClause)this.myThenList.elementAt(n2)).traceString(n) + Able.LS);
        }
        return stringBuffer.toString();
    }
}

