/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleReferences;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleLocation;
import com.ibm.able.rules.AbleRule;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Vector;

public abstract class AbleClause
implements Serializable {
    static final long serialVersionUID = 2000083100000000001L;
    protected AbleRd myLhs;
    protected int myOp;
    protected AbleRd myRhs;
    protected Vector myRuleRefs = new Vector();
    protected AbleLocation myLocation;

    protected AbleClause(AbleRd ableRd, int n, AbleRd ableRd2) {
        this.myLhs = ableRd;
        this.myOp = n;
        this.myRhs = ableRd2;
        this.checkVariableToClauseReference(this.myLhs);
        this.checkVariableToClauseReference(this.myRhs);
    }

    private void checkVariableToClauseReference(AbleRd ableRd) {
        if (ableRd instanceof AbleVariable) {
            AbleReferences ableReferences = ((AbleVariable)ableRd).getReferences();
            if (ableReferences != null) {
                ableReferences.addElement((Object)this);
            }
        } else if (ableRd instanceof AbleExpression) {
            AbleExpression ableExpression = (AbleExpression)ableRd;
            this.checkVariableToClauseReference(ableExpression.getLhs());
            this.checkVariableToClauseReference(ableExpression.getRhs());
        }
    }

    protected abstract String arlString();

    protected abstract String xmlString();

    protected abstract String traceString(int var1);

    public final AbleRd getLhs() {
        return this.myLhs;
    }

    public final int getOp() {
        return this.myOp;
    }

    public String getOpAsString() {
        return AbleData.Operator((int)this.myOp);
    }

    public final AbleRd getRhs() {
        return this.myRhs;
    }

    public void addRuleRef(AbleRule ableRule) {
        this.myRuleRefs.addElement(ableRule);
    }

    public final Vector getRuleRefs() {
        return this.myRuleRefs;
    }

    public AbleRule getRule() {
        return (AbleRule)this.myRuleRefs.firstElement();
    }

    protected int getLhsReferent() {
        if (this.myLhs == null) {
            return 0;
        }
        return this.myLhs.getReferent();
    }

    protected int getRhsReferent() {
        if (this.myRhs == null) {
            return 0;
        }
        return this.myRhs.getReferent();
    }

    protected int getReferent() {
        return this.myRhs.getReferent();
    }

    public BitSet getReferents() {
        BitSet bitSet = new BitSet();
        if (this.myLhs != null) {
            bitSet.or(this.myLhs.getReferents());
        }
        if (this.myRhs != null) {
            bitSet.or(this.myRhs.getReferents());
        }
        return bitSet;
    }

    public boolean equals(AbleClause ableClause) {
        if (this.myOp != ableClause.myOp) {
            return false;
        }
        if (this.myLhs != null ? !this.myLhs.equals(ableClause.myLhs) : ableClause.myLhs != null) {
            return false;
        }
        return !(this.myRhs != null ? !this.myRhs.equals(ableClause.myRhs) : ableClause.myRhs != null);
    }

    public int hashCode() {
        int n = this.myOp;
        if (this.myLhs != null) {
            n ^= this.myLhs.hashCode();
        }
        if (this.myRhs != null) {
            n ^= this.myRhs.hashCode();
        }
        return n;
    }

    public void setLocation(AbleLocation ableLocation) {
        this.myLocation = ableLocation;
    }

    public AbleLocation getLocation() {
        return this.myLocation;
    }

    public String toString() {
        return this.arlString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

