/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

class AbleByteCodeClass
implements Serializable {
    static final long serialVersionUID = 6012493537201028500L;
    protected String myName;
    protected String mySuperClass;
    protected String myComment = "";
    protected String[] myFieldInfo;
    protected byte[] myByteCodes;

    public AbleByteCodeClass(String string, String string2, String[] stringArray, byte[] byArray) {
        this.myName = string;
        this.myComment = string2;
        this.myFieldInfo = stringArray;
        this.myByteCodes = byArray;
    }

    public AbleByteCodeClass(String string, String string2, String string3, String[] stringArray, byte[] byArray) {
        this.myName = string;
        this.mySuperClass = string2;
        this.myComment = string3;
        this.myFieldInfo = stringArray;
        this.myByteCodes = byArray;
    }

    public String arlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.myComment != null && this.myComment.length() > 0) {
            stringBuffer.append("  " + this.getArlComment() + Able.LS);
        }
        stringBuffer.append("  class " + this.myName);
        if (this.mySuperClass == null) {
            stringBuffer.append(" {" + Able.LS);
        } else {
            stringBuffer.append(" extends " + this.mySuperClass + " {" + Able.LS);
        }
        int n = 0;
        for (int i = 0; i < this.myFieldInfo.length / 2; ++i) {
            stringBuffer.append("    ");
            stringBuffer.append(this.myFieldInfo[n++] + "  " + this.myFieldInfo[n++] + ";");
            stringBuffer.append(Able.LS);
        }
        stringBuffer.append("  }" + Able.LS);
        return stringBuffer.toString();
    }

    private String getArlComment() {
        if (this.myComment == null || this.myComment.length() == 0) {
            return "";
        }
        return "/** " + this.myComment + " */";
    }

    public String getComment() {
        return this.myComment.trim();
    }

    public String getName() {
        return this.myName;
    }

    public String xmlDclString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("       <declareClass className=\"" + this.myName + "\"");
        if (this.mySuperClass != null) {
            stringBuffer.append(" superClass=\"" + this.mySuperClass + "\"");
        }
        if (this.myComment != null) {
            stringBuffer.append(" comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"");
        }
        stringBuffer.append(" fieldInfo=\"");
        for (int i = 0; i < this.myFieldInfo.length; ++i) {
            stringBuffer.append(this.myFieldInfo[i] + " ");
        }
        stringBuffer.append("\">" + Able.LS);
        stringBuffer.append("       </declareClass>" + Able.LS);
        return stringBuffer.toString();
    }

    public byte[] getByteCodes() {
        return this.myByteCodes;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.mySuperClass != null && this.mySuperClass.indexOf(".") >= 0) {
            try {
                this.getClass().getClassLoader().loadClass(this.mySuperClass);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }
}

