/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleReferences;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleClauseReferences;
import com.ibm.able.rules.AbleConditionalRule;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleInferenceEngine;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleBreakpoint;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class AbleBackwardChainInferenceEngine
extends AbleInferenceEngine
implements Serializable {
    static final long serialVersionUID = 2000083100000000001L;
    static String clsNm = "AbleBackwardChainInferenceEngine";
    protected Stack myGoalClauseStack = new Stack();
    protected AbleVariable myGoalVariable;

    public AbleBackwardChainInferenceEngine(AbleRuleSet ableRuleSet, AbleLogger ableLogger, AbleRuleBlock ableRuleBlock) {
        super(ableRuleSet, ableLogger, ableRuleBlock);
    }

    public boolean isRuleBlockValid(AbleRuleBlock ableRuleBlock) {
        boolean bl = true;
        String string = null;
        Iterator iterator = null;
        AbleRule ableRule = null;
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        String string2 = ableRuleBlock2.getName();
        iterator = ableRuleBlock2.getPatternMatchRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPatternMatchRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getPredicateRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoPredicateRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIterationRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIterationRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        iterator = ableRuleBlock2.getIfThenElseRules().iterator();
        while (iterator.hasNext()) {
            ableRule = (AbleRule)iterator.next();
            string = Able.NlsMsg((String)"Ex_IeNoIfThenElseRulesAllowed", (Object[])new Object[]{clsNm, string2, ableRule.getIdLabelString()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        if (!AbleBackwardChainInferenceEngine.conditionalRulesValid(this.myRuleSet, ableRuleBlock2)) {
            bl = false;
        }
        iterator = ableRuleBlock2.getConditionalRules().iterator();
        while (iterator.hasNext()) {
            AbleConditionalRule ableConditionalRule = (AbleConditionalRule)iterator.next();
            if (ableConditionalRule.numberOfThenClauses() <= 1L) continue;
            string = Able.NlsMsg((String)"Ex_IeMultipleThenClausesNotAllowed", (Object[])new Object[]{clsNm, string2, ableConditionalRule.getLabel()});
            Able.MessageLog.text(4L, string);
            this.myRuleSet.addIsExReason(string);
            bl = false;
        }
        return bl;
    }

    public void infer(AbleRuleBlock ableRuleBlock) throws AbleDataException {
        AbleRuleBlock ableRuleBlock2 = ableRuleBlock;
        ableRuleBlock2.reset();
        this.myRulesFiredCount = 0;
        if (ableRuleBlock2 != null) {
            this.processAssertions(ableRuleBlock2);
        }
        if (this.myGoalVariable == null) {
            String string = Able.NlsMsg((String)"Ex_IeNoBackChainGoalVariable", (Object[])new Object[]{clsNm});
            Able.MessageLog.text(4L, string);
            this.myTracer.text(0x10000000000L, (Object)this, "infer", string);
            throw new AbleDataException(string);
        }
        this.myGoalClauseStack.clear();
        if (ableRuleBlock2 != null) {
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)clsNm, "infer()", "Tr_Rs_RuleBlockInferStarts", new Object[]{ableRuleBlock2.getName(), ableRuleBlock2.myEngineType});
            }
            this.myRuleSet.myInferenceContext.setRuleBlock(ableRuleBlock2);
            if (this.myDebugLevel == 3) {
                this.fireEngineBreakpoint();
            }
            this.backwardChain(this.myGoalVariable);
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)clsNm, "infer()", "Tr_Rs_RuleBlockInferEnds", new Object[]{ableRuleBlock2.getName(), ableRuleBlock2.myEngineType});
            }
        }
    }

    protected void reevaluateClausesWithChangedVariable(AbleClauseReferences ableClauseReferences) throws AbleDataException {
        for (int i = 0; i < ableClauseReferences.size(); ++i) {
            Object object = ableClauseReferences.elementAt(i);
            if (!(object instanceof AbleAntecedentClause)) continue;
            this.myRuleSet.myInferenceContext.setClause((AbleAntecedentClause)object);
            AbleBackwardChainInferenceEngine.evalAntecedentClause((AbleAntecedentClause)object);
        }
    }

    private void backwardChain(Object object) throws AbleDataException {
        AbleVariable ableVariable = (AbleVariable)object;
        String string = ableVariable.getName();
        AbleReferences ableReferences = ableVariable.getReferences();
        Vector vector = this.myRuleBlock.getEnabledConditionalRules();
        if (this.myRuleSet.isInferenceTraceMedium()) {
            this.myTracer.message(0x20000000000L, (Object)this, "backwardChain", "Tr_Rs_BackChainGoal", new Object[]{ableVariable.traceString(2)});
        }
        for (int i = 0; i < ableReferences.size(); ++i) {
            Object e = ableReferences.elementAt(i);
            if (this.myDebugLevel == 2) {
                this.fireEngineBreakpoint();
            }
            if (!(e instanceof AbleConsequentClause)) continue;
            AbleConsequentClause ableConsequentClause = (AbleConsequentClause)e;
            this.myGoalClauseStack.push(ableConsequentClause);
            if (this.myRuleSet.isInferenceTraceMedium()) {
                this.myTracer.message(0x20000000000L, (Object)this, "backwardChain", "Tr_Rs_GoalStack", new Object[]{this.myGoalClauseStack.toString()});
            }
            Vector vector2 = ableConsequentClause.getRuleRefs();
            vector2 = (Vector)vector2.clone();
            Boolean bl = Boolean.FALSE;
            do {
                AbleRule ableRule;
                if (!(ableRule = (AbleRule)vector2.remove(0)).isEnabled() || !vector.contains(ableRule)) continue;
                String string2 = ableRule.getIdLabelString();
                bl = this.backChain((AbleConditionalRule)ableRule);
                if (bl == null) {
                    if (!this.myRuleSet.isInferenceTraceLow()) continue;
                    this.myTracer.message(0x10000000000L, (Object)this, "backwardChain", "Tr_Rs_RuleTruthNull", new Object[]{string2});
                    continue;
                }
                if (bl.booleanValue()) {
                    ableVariable.setValue(ableConsequentClause.getRhs().getValue());
                    this.reevaluateClausesWithChangedVariable((AbleClauseReferences)ableVariable.getReferences());
                    this.myGoalClauseStack.pop();
                    if (this.myRuleSet.isInferenceTraceMedium()) {
                        this.myTracer.message(0x20000000000L, (Object)this, "backwardChain", "Tr_Rs_BackChainRuleTrue", new Object[]{string2, string, ableVariable.getValue()});
                    }
                    if (!this.myGoalClauseStack.empty()) continue;
                    if (!this.myRuleSet.isInferenceTraceLow()) break;
                    this.myTracer.message(0x10000000000L, (Object)this, "backwardChain", "Tr_Rs_BackChainGoalSolved", new Object[]{string, ableVariable.getValue()});
                    break;
                }
                if (!this.myRuleSet.isInferenceTraceMedium()) continue;
                this.myTracer.message(0x20000000000L, (Object)this, "backwardChain", "Tr_Rs_BackChainRuleFalse", new Object[]{string2, string});
            } while (vector2.size() > 0);
            if (bl.booleanValue()) break;
            this.myGoalClauseStack.pop();
        }
        if (ableVariable.getValue() == null && this.myRuleSet.isInferenceTraceLow()) {
            this.myTracer.message(0x10000000000L, (Object)this, "backwardChain", "Tr_Rs_BackChainGoalNotSolved", new Object[]{string});
        }
    }

    private Boolean backChain(AbleConditionalRule ableConditionalRule) throws AbleDataException {
        AbleRuleBreakpoint ableRuleBreakpoint;
        Vector vector = ableConditionalRule.getAntecedents();
        this.myRuleSet.myInferenceContext.setRule(ableConditionalRule);
        if (this.myDebugLevel >= 4) {
            this.fireEngineBreakpoint();
        }
        if (this.myDebugLevel == 1 && (ableRuleBreakpoint = ableConditionalRule.getBreakpoint()) != null && ableRuleBreakpoint.isEnabled()) {
            this.fireEngineBreakpoint();
        }
        for (int i = 0; i < vector.size(); ++i) {
            AbleAntecedentClause ableAntecedentClause = (AbleAntecedentClause)vector.elementAt(i);
            this.myRuleSet.myInferenceContext.setClause(ableAntecedentClause);
            if (ableAntecedentClause.getBooleanTruth() == null) {
                AbleRd ableRd;
                AbleRd ableRd2 = ableAntecedentClause.getLhs();
                if (ableRd2 instanceof AbleVariable && !((AbleVariable)ableRd2).isBound()) {
                    this.backwardChain((AbleVariable)ableRd2);
                    if (ableAntecedentClause.getBooleanTruth() == null && ableRd2 instanceof AbleVariable && !((AbleVariable)ableRd2).isBound()) {
                        ableRd = (AbleVariable)ableRd2;
                        this.askUser((AbleVariable)ableRd);
                        if (this.myRuleSet.isInferenceTraceMedium()) {
                            this.myTracer.message(0x20000000000L, (Object)this, "backChain()", "Tr_Rs_AskUser", new Object[]{ableRd.getName(), ableRd.getStringValue()});
                        }
                        if (ableRd.getValue() == null) {
                            return Boolean.FALSE;
                        }
                    }
                }
                if ((ableRd = ableAntecedentClause.getRhs()) instanceof AbleVariable && !((AbleVariable)ableRd).isBound()) {
                    this.backwardChain((AbleVariable)ableRd);
                    if (ableAntecedentClause.getBooleanTruth() == null && ableRd instanceof AbleVariable && !((AbleVariable)ableRd).isBound()) {
                        AbleVariable ableVariable = (AbleVariable)ableRd;
                        this.askUser(ableVariable);
                        if (this.myRuleSet.isInferenceTraceMedium()) {
                            this.myTracer.message(0x20000000000L, (Object)this, "backChain()", "Tr_Rs_AskUser", new Object[]{ableVariable.getName(), ableVariable.getStringValue()});
                        }
                        if (ableVariable.getValue() == null) {
                            return Boolean.FALSE;
                        }
                    }
                }
                AbleBackwardChainInferenceEngine.evalAntecedentClause(ableAntecedentClause);
                if (this.myRuleSet.isInferenceTraceHigh()) {
                    this.myTracer.message(0x40000000000L, (Object)this, "backChain()", "Tr_Rs_EvaluatedAntecedent", new Object[]{ableAntecedentClause.toString(), ableAntecedentClause.getBooleanTruth()});
                }
            }
            if (ableAntecedentClause.getBooleanTruth().booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void setControlParameter(String string, Object object) throws AbleDataException {
        if (string.equalsIgnoreCase("Goal")) {
            if (object instanceof String) {
                this.myGoalVariable = this.myRuleSet.getVariable((String)object);
            } else if (object instanceof AbleVariable) {
                this.myGoalVariable = (AbleVariable)object;
            } else {
                throw new AbleDataException(Able.NlsMsg((String)"Ex_RsSetControlParameter", (Object[])new Object[]{string, object, object.getClass().getName(), this.myRuleBlock.getEngineType()}));
            }
        }
    }

    public Object getControlParameter(String string) throws AbleDataException {
        if (string.equalsIgnoreCase("Goal")) {
            return this.myGoalVariable;
        }
        throw new AbleDataException(Able.NlsMsg((String)"Ex_RsGetControlParameter", (Object[])new Object[]{string, this.myRuleBlock.getEngineType()}));
    }

    public AbleVariable getGoalVariable() {
        return this.myGoalVariable;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

