/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import com.ibm.able.Able;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleRd;
import com.ibm.able.rules.AbleAssertionClause;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleSet;
import java.io.Serializable;
import java.util.Vector;

public class AbleAssertionRule
extends AbleRule
implements Serializable {
    static final long serialVersionUID = 2001011800000000001L;
    static String clsNm = "AbleAssertionRule";
    protected AbleAssertionClause myAssertion;

    public AbleAssertionRule(String string, AbleAssertionClause ableAssertionClause) {
        this(0, string, PriorityDefault, ableAssertionClause, null);
    }

    public AbleAssertionRule(String string, AbleRd ableRd, AbleAssertionClause ableAssertionClause) {
        this(0, string, ableRd, ableAssertionClause, null);
    }

    public AbleAssertionRule(int n, String string, AbleAssertionClause ableAssertionClause, AbleRuleSet ableRuleSet) {
        this(n, string, PriorityDefault, ableAssertionClause, ableRuleSet);
    }

    public AbleAssertionRule(int n, String string, AbleRd ableRd, AbleAssertionClause ableAssertionClause, AbleRuleSet ableRuleSet) {
        super(n, string, ableRd, ableRuleSet);
        this.myAssertion = ableAssertionClause;
        this.ctorHelperSaveReferences();
    }

    private void ctorHelperSaveReferences() {
        if (this.myAssertion != null) {
            this.myAssertion.addRuleRef(this);
            this.addWrReference(this.myAssertion.getLhsReferent());
            this.addRdReferences(this.myAssertion.getReferents());
            this.addHeaderRdReferences();
        }
    }

    public final AbleAssertionClause getAssertion() {
        return this.myAssertion;
    }

    public String arlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "    " + this.myLabel;
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (this.isDefaultPriority()) {
            stringBuffer2.append(": ");
        } else {
            stringBuffer2.append("[" + this.myPriority.arlCRdString() + "]: ");
        }
        if (this.myComment.length() > 0 || !this.myProperties.isEmpty()) {
            stringBuffer.append("    " + this.getArlComment() + Able.LS);
        }
        if (this.isTemplate()) {
            stringBuffer.append("template ");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.arlPreConditionsString());
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append(this.myAssertion.arlString());
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public String xmlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        stringBuffer.append("    <rule" + string + string2 + string3 + ">" + Able.LS);
        stringBuffer.append(this.xmlPreConditionsString());
        stringBuffer.append(this.xmlPriorityString());
        stringBuffer.append("      <assert>" + Able.LS);
        stringBuffer.append(this.myAssertion.xmlString());
        stringBuffer.append("      </assert>" + Able.LS);
        stringBuffer.append("    </rule>" + Able.LS + Able.LS);
        return stringBuffer.toString();
    }

    public String armlString() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = " label=\"" + this.myLabel + "\"";
        String string2 = " comment=\"" + AbleData.escapeXMLString((String)this.myComment) + "\"";
        String string3 = this.isTemplate() ? " template=\"true\"" : "";
        String string4 = this.myFinalFlag ? " final=\"true\"" : "";
        stringBuffer.append("    <AssertionRule" + string + string2 + string3 + string4 + ">" + Able.LS);
        stringBuffer.append(this.armlPreConditionsString());
        stringBuffer.append(this.armlPriorityString());
        stringBuffer.append(this.armlPropertiesString());
        stringBuffer.append("      <assert>" + AbleData.escapeXMLString((String)this.myAssertion.arlString()) + "</assert>" + Able.LS);
        stringBuffer.append("    </AssertionRule>" + Able.LS + Able.LS);
        return stringBuffer.toString();
    }

    public String getTemplateString(Vector vector) throws AbleDataException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTemplateHeaderString(vector));
        stringBuffer.append(this.myAssertion.getTemplateString(vector));
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.arlString();
    }

    public String traceString(int n) {
        switch (n) {
            case 1: {
                return this.trcString(n);
            }
            case 2: {
                return this.trcString(n);
            }
            case 3: {
                return this.arlString();
            }
            case 4: {
                return this.arlString();
            }
            case 5: {
                return this.xmlString();
            }
        }
        return this.arlString();
    }

    private String trcString(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "    " + this.myLabel;
        String string2 = "";
        string2 = this.myPriority == PriorityDefault ? ": " : "[" + this.myPriority.traceString(n) + "]: ";
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(this.myAssertion.traceString(n));
        return stringBuffer.toString();
    }
}

