/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.rules;

import antlr.LexerSharedInputState;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleLogger;
import com.ibm.able.data.AbleArrayVariable;
import com.ibm.able.data.AbleContinuousVariable;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleFuzzyVariable;
import com.ibm.able.data.AbleLhs;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AblePredicate;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleARLLexer;
import com.ibm.able.rules.AbleARLParser;
import com.ibm.able.rules.AbleAntecedentClause;
import com.ibm.able.rules.AbleAssertionClause;
import com.ibm.able.rules.AbleAssertionRule;
import com.ibm.able.rules.AbleConditionalRule;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleDoUntilRule;
import com.ibm.able.rules.AbleDoWhileRule;
import com.ibm.able.rules.AbleForLoopRule;
import com.ibm.able.rules.AbleHierarchicalPlanningRule;
import com.ibm.able.rules.AbleIfThenElseRule;
import com.ibm.able.rules.AbleParException;
import com.ibm.able.rules.AblePatternMatchRule;
import com.ibm.able.rules.AblePlanningRule;
import com.ibm.able.rules.AblePredicateFact;
import com.ibm.able.rules.AblePredicateRule;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;
import com.ibm.able.rules.AbleSelector;
import com.ibm.able.rules.AbleSwitchRule;
import com.ibm.able.rules.AbleSwitchStatement;
import com.ibm.able.rules.AbleTree;
import com.ibm.able.rules.AbleTreeAction;
import com.ibm.able.rules.AbleTreeActionNode;
import com.ibm.able.rules.AbleTreeCondition;
import com.ibm.able.rules.AbleTreeConditionNode;
import com.ibm.able.rules.AbleTreeEdge;
import com.ibm.able.rules.AbleTreePartialExpression;
import com.ibm.able.rules.AbleTreeRule;
import com.ibm.able.rules.AbleWhileDoRule;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class AbleARMLParser
extends DefaultHandler {
    protected Locator myLocator = null;
    protected AbleRuleSet myRuleSet = null;
    protected AbleLogger myTracer = null;
    protected boolean myStopOnParException = false;
    protected String myRuleSetName = "";
    protected String myComment;
    protected boolean myTemplateFlag;
    protected double myAlphaCut;
    protected String myEngineType;
    protected String myImportLibName;
    protected String myUserTypeName;
    protected String myUserTypeClass;
    protected String myVariableName;
    protected boolean myVarIsLocal = false;
    protected AbleVariable myDclVariable;
    protected boolean myVarInitializerFlag = false;
    protected AbleRd myVarInitializer;
    protected Vector myVarInitializerArgs;
    protected double myVariableContinuousLo;
    protected double myVariableContinuousHi;
    protected int myVariableLength;
    protected boolean myVariableStaticFlag;
    protected String myVariableType;
    protected String myVariableClassName;
    protected String myUserDefinedFunctionName;
    protected AbleFuzzyVariable myFuzzyVariable = null;
    protected String myTempString;
    protected StringBuffer myTempStringBuf = new StringBuffer();
    protected String myRuleBlockName;
    protected AbleRuleBlock myRuleBlock = null;
    protected String myRuleBlockReturnType;
    protected String myFormalSignature;
    protected double myRuleAntWeight;
    protected String myRuleHedges;
    protected String myRuleLabel;
    protected AbleRule myRule;
    protected Object[] myRulePreConditions;
    protected boolean myRuleReplacementMode;
    protected boolean inRuleBlockHeader = false;
    protected String myRuleBlockInferenceEngine;
    protected String myRuleBlockComment;
    protected Vector myAntClauses = new Vector();
    protected Vector myAntExpressionList = new Vector();
    protected AbleExpression myAntExpression = null;
    protected AbleRd myRulePriority;
    protected AbleRd myExpression = null;
    protected Stack myExpressionStack = new Stack();
    protected AbleExpression myBooleanExpression = null;
    protected AbleExpression myLogicalExpression = null;
    protected AbleRd myRuleCns = null;
    protected AbleAssertionClause myAstClause = null;
    protected AbleConsequentClause myCnsClause = null;
    protected Vector myThenList = new Vector();
    protected Vector myElseList = new Vector();
    protected Vector myWdWhenList = new Vector();
    protected String myWdSelVarName;
    protected String myWdSelVarType;
    protected boolean myWdSelPosFlag;
    protected AbleVariable myWdSelVariable;
    protected AblePredicate myPredLhs = null;
    protected Vector myPredClauses = new Vector();
    protected Vector myDoList = new Vector();
    protected Vector myForInitExprList;
    protected AbleExpression myForTestExpr;
    protected Vector myForIterExprList;
    protected AbleExpression myPlanPrecondition;
    protected Vector myFormalParameterList;
    protected Vector myPlanEffectsList;
    protected Vector myPlanExpansionList;
    protected AbleSwitchStatement mySwitchStatement;
    protected AbleTree myDecisionTree;
    protected AbleTreePartialExpression myTreeTerm;
    protected String myTreeTermRef;
    protected Vector myTreeValues;
    protected AbleTreePartialExpression myTreeValue;
    protected String myTreeValueRef;
    protected boolean inTreeSharedCondition;
    protected AbleTreeActionNode myTreeActionNode;
    protected AbleTreeConditionNode myTreeConditionNode;
    protected Stack myTreeStack = new Stack();
    protected AbleTreeEdge myTreeEdge;
    protected Hashtable myRuleProperties = new Hashtable();
    protected Stack myPropertyStack = new Stack();
    protected boolean inTagPredicateRuleBody = false;
    protected transient String mySource;
    protected transient StringReader myReader = null;
    protected transient AbleARLLexer myLexer = null;
    protected transient AbleARLParser myARLParser = null;
    protected transient LexerSharedInputState myLexerState = null;

    public void setDocumentLocator(Locator locator) {
        this.myLocator = locator;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (string2.equalsIgnoreCase("ruleSet")) {
                this.startRuleSet(attributes);
            } else if (string2.equalsIgnoreCase("library")) {
                this.hndlLibrary(attributes);
            } else if (string2.equalsIgnoreCase("import")) {
                this.hndlImport(attributes);
            } else if (string2.equalsIgnoreCase("predicates")) {
                this.endDclPredicate(attributes);
            } else if (string2.equalsIgnoreCase("declareClass")) {
                this.hndlDclInnerClass(attributes);
            } else if (string2.equalsIgnoreCase("variable")) {
                this.startVariable(attributes);
            } else if (string2.equalsIgnoreCase("FuzzyVariable")) {
                this.startFuzzyVariable(attributes);
            } else if (string2.equalsIgnoreCase("setDefinition")) {
                this.startSetDefinition();
            } else if (string2.equalsIgnoreCase("varInitializer")) {
                this.startVarInitializer();
            } else if (string2.equalsIgnoreCase("metaData")) {
                this.startRuleMetaData();
            } else if (string2.equalsIgnoreCase("variableReference")) {
                this.startVariableRef(attributes);
            } else if (string2.equalsIgnoreCase("expression")) {
                this.startExpression(attributes);
            } else if (string2.equalsIgnoreCase("expString")) {
                this.startExpression(attributes);
            } else if (string2.equalsIgnoreCase("predicate")) {
                this.startPredicate();
            } else if (string2.equalsIgnoreCase("inputs")) {
                this.startInputs(attributes);
            } else if (string2.equalsIgnoreCase("outputs")) {
                this.startOutputs(attributes);
            } else if (string2.equalsIgnoreCase("function")) {
                this.hndlDclFunction(attributes);
            } else if (string2.equalsIgnoreCase("RuleBlock")) {
                this.startRuleBlock(attributes);
            } else if (string2.equalsIgnoreCase("rule")) {
                this.saveRule(attributes);
            } else if (string2.equalsIgnoreCase("priority")) {
                this.startRulePriority();
            } else if (string2.equalsIgnoreCase("properties")) {
                this.hndlProperty(attributes);
            } else if (string2.equalsIgnoreCase("assert")) {
                this.startAssert();
            } else if (string2.equalsIgnoreCase("if")) {
                this.startIf();
            } else if (string2.equalsIgnoreCase("then")) {
                this.startThen();
            } else if (string2.equalsIgnoreCase("else")) {
                this.startElse();
            } else if (string2.equalsIgnoreCase("switch")) {
                this.startSwitch();
            } else if (string2.equalsIgnoreCase("pattern")) {
                this.startPattern(attributes);
            } else if (string2.equalsIgnoreCase("constraint")) {
                this.startConstraint();
            } else if (string2.equalsIgnoreCase("when")) {
                this.startWhen();
            } else if (string2.equalsIgnoreCase("while")) {
                this.startWhile();
            } else if (string2.equalsIgnoreCase("until")) {
                this.startUntil();
            } else if (string2.equalsIgnoreCase("do")) {
                this.startDo();
            } else if (string2.equalsIgnoreCase("action")) {
                this.startAction();
            } else if (string2.equalsIgnoreCase("head")) {
                this.startHead();
            } else if (string2.equalsIgnoreCase("body")) {
                this.startBody();
            } else if (string2.equalsIgnoreCase("TreeRule")) {
                this.startTreeRule(attributes);
            } else if (string2.equalsIgnoreCase("ConditionNode")) {
                this.startConditionNode(attributes);
            } else if (string2.equalsIgnoreCase("ActionNode")) {
                this.startActionNode(attributes);
            } else if (string2.equalsIgnoreCase("TreeAction")) {
                this.startTreeAction(attributes);
            } else if (string2.equalsIgnoreCase("Term")) {
                this.startTerm(attributes);
            } else if (string2.equalsIgnoreCase("TermRef")) {
                this.startTermRef(attributes);
            } else if (string2.equalsIgnoreCase("Value")) {
                this.startValue(attributes);
            } else if (string2.equalsIgnoreCase("ValueRef")) {
                this.startValueRef(attributes);
            } else if (string2.equalsIgnoreCase("Edge")) {
                this.startEdge(attributes);
            } else if (string2.equalsIgnoreCase("SharedCondition")) {
                this.startSharedCondition(attributes);
            } else if (string2.equalsIgnoreCase("SharedActionTerm")) {
                this.startSharedActionTerm(attributes);
            } else if (string2.equalsIgnoreCase("BooleanExpression")) {
                this.startBooleanExpression(attributes);
            } else if (string2.equalsIgnoreCase("LogicalAndExpression")) {
                this.startLogicalAndExpression(attributes);
            } else if (string2.equalsIgnoreCase("LogicalOrExpression")) {
                this.startLogicalOrExpression(attributes);
            } else if (string2.equalsIgnoreCase("LogicalNotExpression")) {
                this.startLogicalNotExpression(attributes);
            } else if (string2.equalsIgnoreCase("parameters")) {
                this.startParameters();
            } else if (string2.equalsIgnoreCase("formalParameter")) {
                this.hndlFormalParameter(attributes);
            } else if (string2.equalsIgnoreCase("effects")) {
                this.startPlanEffects();
            } else if (string2.equalsIgnoreCase("expansion")) {
                this.startPlanExpansion();
            } else if (string2.equalsIgnoreCase("AssertionRule")) {
                this.startAssertionRule(attributes);
            } else if (string2.equalsIgnoreCase("IfThenRule")) {
                this.startIfThenRule(attributes);
            } else if (string2.equalsIgnoreCase("IfThenElseRule")) {
                this.startIfThenElseRule(attributes);
            } else if (string2.equalsIgnoreCase("WhenDoRule")) {
                this.startWhenDoRule(attributes);
            } else if (string2.equalsIgnoreCase("WhileDoRule")) {
                this.startWhileDoRule(attributes);
            } else if (string2.equalsIgnoreCase("DoWhileRule")) {
                this.startDoWhileRule(attributes);
            } else if (string2.equalsIgnoreCase("DoUntilRule")) {
                this.startDoUntilRule(attributes);
            } else if (string2.equalsIgnoreCase("ForLoopRule")) {
                this.startForLoopRule(attributes);
            } else if (string2.equalsIgnoreCase("PlanRule")) {
                this.startPlanRule(attributes);
            } else if (string2.equalsIgnoreCase("SwitchRule")) {
                this.startSwitchRule(attributes);
            } else if (string2.equalsIgnoreCase("PredicateRule")) {
                this.startPredicateRule(attributes);
            } else if (string2.equalsIgnoreCase("PredicateFact")) {
                this.startPredicateFact(attributes);
            }
        }
        catch (AbleParException ableParException) {
            throw new SAXParseException(null, this.myLocator, (Exception)((Object)ableParException));
        }
        catch (RemoteException remoteException) {
            throw new SAXParseException(null, this.myLocator, remoteException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (string2.equalsIgnoreCase("Variable")) {
                this.endVariable();
            } else if (string2.equalsIgnoreCase("setDefinition")) {
                this.endSetDefinition();
            } else if (string2.equalsIgnoreCase("varInitializer")) {
                this.endVarInitializer();
            } else if (string2.equalsIgnoreCase("metadata")) {
                this.endRuleMetaData();
            } else if (string2.equalsIgnoreCase("priority")) {
                this.endRulePriority();
            } else if (string2.equalsIgnoreCase("ruleBlock")) {
                this.endRuleBlock();
            } else if (string2.equalsIgnoreCase("parameters")) {
                this.endParameters();
            } else if (string2.equalsIgnoreCase("ruleset")) {
                this.endRuleSet();
            } else if (string2.equalsIgnoreCase("inputs")) {
                this.endInputs();
            } else if (string2.equalsIgnoreCase("outputs")) {
                this.endOutputs();
            } else if (string2.equalsIgnoreCase("assert")) {
                this.endAssert();
            } else if (string2.equalsIgnoreCase("if")) {
                this.endIf();
            } else if (string2.equalsIgnoreCase("then")) {
                this.endThen();
            } else if (string2.equalsIgnoreCase("else")) {
                this.endElse();
            } else if (string2.equalsIgnoreCase("switch")) {
                this.endSwitch();
            } else if (string2.equalsIgnoreCase("expression")) {
                this.endExpression();
            } else if (string2.equalsIgnoreCase("expString")) {
                this.endExpression();
            } else if (string2.equalsIgnoreCase("predicate")) {
                this.endPredicate();
            } else if (string2.equalsIgnoreCase("head")) {
                this.endHead();
            } else if (string2.equalsIgnoreCase("body")) {
                this.endBody();
            } else if (string2.equalsIgnoreCase("pattern")) {
                this.endPattern();
            } else if (string2.equalsIgnoreCase("constraint")) {
                this.endConstraint();
            } else if (string2.equalsIgnoreCase("action")) {
                this.endAction();
            } else if (string2.equalsIgnoreCase("do")) {
                this.endDo();
            } else if (string2.equalsIgnoreCase("when")) {
                this.endWhen();
            } else if (string2.equalsIgnoreCase("while")) {
                this.endWhile();
            } else if (string2.equalsIgnoreCase("until")) {
                this.endUntil();
            } else if (string2.equalsIgnoreCase("precondition")) {
                this.endPlanPrecondition();
            } else if (string2.equalsIgnoreCase("effects")) {
                this.endPlanEffects();
            } else if (string2.equalsIgnoreCase("expansion")) {
                this.endPlanExpansion();
            } else if (string2.equalsIgnoreCase("forInit")) {
                this.endForInit();
            } else if (string2.equalsIgnoreCase("forTest")) {
                this.endForTest();
            } else if (string2.equalsIgnoreCase("forIter")) {
                this.endForIter();
            } else if (string2.equalsIgnoreCase("TreeRule")) {
                this.endTreeRule();
            } else if (string2.equalsIgnoreCase("ConditionNode")) {
                this.endConditionNode();
            } else if (string2.equalsIgnoreCase("ActionNode")) {
                this.endActionNode();
            } else if (string2.equalsIgnoreCase("TreeAction")) {
                this.endTreeAction();
            } else if (string2.equalsIgnoreCase("Term")) {
                this.endTerm();
            } else if (string2.equalsIgnoreCase("TermRef")) {
                this.endTermRef();
            } else if (string2.equalsIgnoreCase("Value")) {
                this.endValue();
            } else if (string2.equalsIgnoreCase("ValueRef")) {
                this.endValueRef();
            } else if (string2.equalsIgnoreCase("Edge")) {
                this.endEdge();
            } else if (string2.equalsIgnoreCase("SharedCondition")) {
                this.endSharedCondition();
            } else if (string2.equalsIgnoreCase("SharedActionTerm")) {
                this.endSharedActionTerm();
            } else if (string2.equalsIgnoreCase("BooleanExpression")) {
                this.endBooleanExpression();
            } else if (string2.equalsIgnoreCase("LogicalAndExpression")) {
                this.endLogicalAndExpression();
            } else if (string2.equalsIgnoreCase("LogicalOrExpression")) {
                this.endLogicalOrExpression();
            } else if (string2.equalsIgnoreCase("LogicalNotExpression")) {
                this.endLogicalNotExpression();
            } else if (string2.equalsIgnoreCase("AssertionRule")) {
                this.endAssertionRule();
            } else if (string2.equalsIgnoreCase("IfThenRule")) {
                this.endIfThenRule();
            } else if (string2.equalsIgnoreCase("IfThenElseRule")) {
                this.endIfThenElseRule();
            } else if (string2.equalsIgnoreCase("WhenDoRule")) {
                this.endWhenDoRule();
            } else if (string2.equalsIgnoreCase("WhileDoRule")) {
                this.endWhileDoRule();
            } else if (string2.equalsIgnoreCase("DoWhileRule")) {
                this.endDoWhileRule();
            } else if (string2.equalsIgnoreCase("DoUntilRule")) {
                this.endDoUntilRule();
            } else if (string2.equalsIgnoreCase("ForLoopRule")) {
                this.endForLoopRule();
            } else if (string2.equalsIgnoreCase("PlanRule")) {
                this.endPlanRule();
            } else if (string2.equalsIgnoreCase("SwitchRule")) {
                this.endSwitchRule();
            } else if (string2.equalsIgnoreCase("PredicateRule")) {
                this.endPredicateRule();
            } else if (string2.equalsIgnoreCase("PredicateFact")) {
                this.endPredicateFact();
            }
        }
        catch (AbleParException ableParException) {
            throw new SAXParseException(null, this.myLocator, (Exception)((Object)ableParException));
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        String string2 = string.trim();
        if (string2.length() > 0) {
            this.myTempString = string2;
            this.myTempStringBuf.append(string);
        }
    }

    public void error(SAXParseException sAXParseException) {
        Able.MessageLog.text(4L, (Object)this, this.getLocationString(sAXParseException), sAXParseException.getLocalizedMessage());
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(262144L, "AbleXmlParser: [Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        Able.MessageLog.text(4L, (Object)this, this.getLocationString(sAXParseException), sAXParseException.getLocalizedMessage());
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(262144L, "AbleXmlParser: [Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) {
        Able.MessageLog.text(2L, (Object)this, this.getLocationString(sAXParseException), sAXParseException.getLocalizedMessage());
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(524288L, "AbleXmlParser: [Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    private String formatSAXParseException(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionTitle"));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionLine", (Object[])new Object[]{Integer.toString(sAXParseException.getLineNumber())}));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionColumn", (Object[])new Object[]{Integer.toString(sAXParseException.getColumnNumber())}));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionPublicId", (Object[])new Object[]{sAXParseException.getPublicId()}));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionSystemId", (Object[])new Object[]{sAXParseException.getSystemId()}));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionMessage", (Object[])new Object[]{sAXParseException.getMessage()}));
        stringBuffer.append(Able.NlsMsg((String)"Inf_RsSAXParseExceptionException", (Object[])new Object[]{sAXParseException.getException()}));
        return stringBuffer.toString();
    }

    public void instantiateFrom(String string, AbleRuleSet ableRuleSet, AbleLogger ableLogger, boolean bl) throws AbleParException, ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        this.myRuleSet = ableRuleSet;
        this.myTracer = ableLogger;
        this.myStopOnParException = bl;
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.parse(string);
        }
        catch (SAXParseException sAXParseException) {
            throw new AbleParException(this.formatSAXParseException(sAXParseException), sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new AbleParException(sAXException.getLocalizedMessage(), sAXException);
        }
    }

    public void instantiateFrom(Reader reader, AbleRuleSet ableRuleSet, AbleLogger ableLogger, boolean bl) throws AbleParException, ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        this.myRuleSet = ableRuleSet;
        this.myTracer = ableLogger;
        this.myStopOnParException = bl;
        InputSource inputSource = new InputSource(reader);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            throw new AbleParException(this.formatSAXParseException(sAXParseException), sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new AbleParException(sAXException.getLocalizedMessage(), sAXException);
        }
    }

    public void instantiateFrom(InputSource inputSource, AbleRuleSet ableRuleSet, AbleLogger ableLogger, boolean bl) throws AbleParException, ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        this.myRuleSet = ableRuleSet;
        this.myTracer = ableLogger;
        this.myStopOnParException = bl;
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            throw new AbleParException(this.formatSAXParseException(sAXParseException), sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new AbleParException(sAXException.getLocalizedMessage(), sAXException);
        }
    }

    public void instantiateFrom(InputStream inputStream, AbleRuleSet ableRuleSet, AbleLogger ableLogger, boolean bl) throws AbleParException, ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        this.myRuleSet = ableRuleSet;
        this.myTracer = ableLogger;
        this.myStopOnParException = bl;
        InputSource inputSource = new InputSource(inputStream);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            throw new AbleParException(this.formatSAXParseException(sAXParseException), sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new AbleParException(sAXException.getLocalizedMessage(), sAXException);
        }
    }

    public AbleRuleBlock instantiateRuleBlockFrom(AbleRuleSet ableRuleSet, String string) throws AbleParException {
        this.myRuleSet = ableRuleSet;
        this.myRuleBlock = null;
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        try {
            this.instantiateFrom(inputSource, this.myRuleSet, this.myRuleSet.getLogger(), true);
        }
        catch (AbleParException ableParException) {
            throw ableParException;
        }
        catch (RemoteException remoteException) {
            throw new AbleParException(remoteException.getLocalizedMessage(), remoteException);
        }
        catch (InstantiationException instantiationException) {
            throw new AbleParException(instantiationException.getLocalizedMessage(), instantiationException);
        }
        catch (IOException iOException) {
            throw new AbleParException(iOException.getLocalizedMessage(), iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbleParException(illegalAccessException.getLocalizedMessage(), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AbleParException(classNotFoundException.getLocalizedMessage(), classNotFoundException);
        }
        this.myRuleBlock = this.myRuleSet.getRuleBlock(this.myRuleBlockName);
        return this.myRuleBlock;
    }

    public AbleRule instantiateRuleFrom(AbleRuleSet ableRuleSet, String string, String string2, boolean bl) throws AbleParException {
        this.myRuleSet = ableRuleSet;
        this.myRuleSet.setCurrentRuleBlock(string2);
        this.myRuleBlock = this.myRuleSet.getRuleBlock(string2);
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        try {
            this.myRuleReplacementMode = bl;
            this.instantiateFrom(inputSource, this.myRuleSet, this.myRuleSet.getLogger(), true);
            this.myRuleReplacementMode = false;
        }
        catch (AbleParException ableParException) {
            throw ableParException;
        }
        catch (RemoteException remoteException) {
            throw new AbleParException(remoteException.getLocalizedMessage(), remoteException);
        }
        catch (InstantiationException instantiationException) {
            throw new AbleParException(instantiationException.getLocalizedMessage(), instantiationException);
        }
        catch (IOException iOException) {
            throw new AbleParException(iOException.getLocalizedMessage(), iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbleParException(illegalAccessException.getLocalizedMessage(), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AbleParException(classNotFoundException.getLocalizedMessage(), classNotFoundException);
        }
        return this.myRule;
    }

    public AbleRd instantiateExpressionFrom(AbleRuleSet ableRuleSet, String string) throws AbleParException {
        this.myRuleSet = ableRuleSet;
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        try {
            this.instantiateFrom(inputSource, this.myRuleSet, this.myRuleSet.getLogger(), true);
        }
        catch (AbleParException ableParException) {
            throw ableParException;
        }
        catch (RemoteException remoteException) {
            throw new AbleParException(remoteException.getLocalizedMessage(), remoteException);
        }
        catch (InstantiationException instantiationException) {
            throw new AbleParException(instantiationException.getLocalizedMessage(), instantiationException);
        }
        catch (IOException iOException) {
            throw new AbleParException(iOException.getLocalizedMessage(), iOException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbleParException(illegalAccessException.getLocalizedMessage(), illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AbleParException(classNotFoundException.getLocalizedMessage(), classNotFoundException);
        }
        return this.myExpression;
    }

    public AbleExpression parseExpressionFromARL(String string) throws AbleException {
        this.mySource = string;
        AbleRd ableRd = null;
        AbleExpression ableExpression = null;
        try {
            this.myReader = new StringReader(string);
            this.myLexerState = new LexerSharedInputState((Reader)this.myReader);
            if (this.myLexer == null) {
                this.myLexer = new AbleARLLexer(this.myLexerState);
                this.myARLParser = new AbleARLParser(this.myLexer);
            }
            this.myLexer.setInputState(this.myLexerState);
            this.myARLParser.reset(this.myLexer);
            ableRd = this.myARLParser.parseExpressionInput(this.myRuleSet, true);
            ableExpression = ableRd instanceof AbleExpression ? (AbleExpression)ableRd : new AbleExpression(null, 10, ableRd);
        }
        catch (TokenStreamException tokenStreamException) {
            throw new AbleException(Able.NlsMsg((String)"Ex_Rs_ParseExpressionFromArl", (Object[])new Object[]{this.myRuleSet.getName(), string}), (Throwable)tokenStreamException);
        }
        catch (RecognitionException recognitionException) {
            throw new AbleException(Able.NlsMsg((String)"Ex_Rs_ParseExpressionFromArl", (Object[])new Object[]{this.myRuleSet.getName(), string}), (Throwable)recognitionException);
        }
        return ableExpression;
    }

    public AbleRd testParseExpressionFromARL(AbleRuleSet ableRuleSet, String string) throws AbleException {
        this.myRuleSet = ableRuleSet;
        return this.parseExpressionFromARL(string);
    }

    public AbleExpression parseActionFromARL(String string) throws AbleException {
        this.mySource = string;
        AbleRd ableRd = null;
        AbleExpression ableExpression = null;
        try {
            this.myReader = new StringReader(string);
            this.myLexerState = new LexerSharedInputState((Reader)this.myReader);
            if (this.myLexer == null) {
                this.myLexer = new AbleARLLexer(this.myLexerState);
                this.myARLParser = new AbleARLParser(this.myLexer);
            }
            this.myLexer.setInputState(this.myLexerState);
            this.myARLParser.reset(this.myLexer);
            ableRd = this.myARLParser.parseActionInput(this.myRuleSet, true);
            ableExpression = ableRd instanceof AbleExpression ? (AbleExpression)ableRd : new AbleExpression(null, 10, ableRd);
        }
        catch (TokenStreamException tokenStreamException) {
            throw new AbleException(Able.NlsMsg((String)"Ex_Rs_ParseActionFromArl", (Object[])new Object[]{this.myRuleSet.getName(), string}), (Throwable)tokenStreamException);
        }
        catch (RecognitionException recognitionException) {
            throw new AbleException(Able.NlsMsg((String)"Ex_Rs_ParseActionFromArl", (Object[])new Object[]{this.myRuleSet.getName(), string}), (Throwable)recognitionException);
        }
        return ableExpression;
    }

    public void setTraceActive(boolean bl) {
        if (this.myTracer != null) {
            this.myTracer.setLogging(bl);
        }
    }

    public boolean isTraceActive() {
        if (this.myTracer == null) {
            return false;
        }
        return this.myTracer.isLogging();
    }

    public void setStopOnParException(boolean bl) {
        this.myStopOnParException = bl;
    }

    public boolean isStopOnParException() {
        return this.myStopOnParException;
    }

    private void startRuleSet(Attributes attributes) throws RemoteException {
        if (attributes != null) {
            String string = attributes.getValue("name");
            if (string != null) {
                this.myRuleSetName = string.trim();
                this.myRuleSet.setName(this.myRuleSetName);
            }
            if ((string = attributes.getValue("comment")) != null) {
                this.myRuleSet.setComment(string.trim());
            }
            this.saveTemplateFlag(attributes.getValue("template"));
            this.myRuleSet.setTemplate(this.myTemplateFlag);
        }
        this.myPropertyStack.clear();
        this.myPropertyStack.push(this.myRuleSet);
        this.resetOptInfo();
    }

    private void endRuleSet() {
        this.myPropertyStack.pop();
    }

    private void hndlLibrary(Attributes attributes) throws AbleParException {
        String string;
        this.myImportLibName = "";
        if (attributes != null && (string = attributes.getValue("classDefinition")) != null) {
            this.myImportLibName = string.trim();
            this.myRuleSet.declareUserDefinedFunctionLib(this.myImportLibName);
        }
    }

    private void hndlImport(Attributes attributes) throws AbleParException {
        this.myUserTypeName = "";
        this.myUserTypeClass = "";
        if (attributes != null) {
            int n;
            String string = attributes.getValue("classDefinition");
            if (string != null) {
                this.myUserTypeClass = string.trim();
            }
            this.myUserTypeName = (n = this.myUserTypeClass.lastIndexOf(46)) < 0 ? new String(this.myUserTypeClass) : this.myUserTypeClass.substring(n + 1);
            this.myRuleSet.declareUserDataType(this.myUserTypeName, this.myUserTypeClass);
        }
    }

    private void endDclPredicate(Attributes attributes) throws AbleParException {
        String string;
        String string2 = "";
        if (attributes != null && (string = attributes.getValue("name")) != null) {
            string2 = string.trim();
            this.myRuleSet.declarePredicate(string2);
        }
    }

    private void saveTemplateFlag(String string) {
        if (string != null) {
            String string2 = string.trim();
            if (string2.equalsIgnoreCase("true")) {
                this.myTemplateFlag = true;
            } else if (string2.equalsIgnoreCase("false")) {
                this.myTemplateFlag = false;
            }
        }
    }

    private void saveVariableName(String string) {
        if (string != null) {
            this.myVariableName = string.trim();
        }
    }

    private void saveVariableStaticFlag(String string) {
        if (string != null) {
            String string2 = string.trim();
            if (string2.equalsIgnoreCase("true")) {
                this.myVariableStaticFlag = true;
            } else if (string2.equalsIgnoreCase("false")) {
                this.myVariableStaticFlag = false;
            }
        }
    }

    private void hndlDclInnerClass(Attributes attributes) throws AbleParException {
        String string = null;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        if (attributes != null) {
            this.saveComment(attributes.getValue("comment"));
            if (attributes != null) {
                String string3 = attributes.getValue("className");
                if (string3 != null) {
                    string = string3.trim();
                }
                if ((string3 = attributes.getValue("superClass")) != null) {
                    string2 = string3.trim();
                }
                if ((string3 = attributes.getValue("fieldInfo")) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    while (stringTokenizer.hasMoreTokens()) {
                        vector2.add(stringTokenizer.nextToken());
                        vector.add(stringTokenizer.nextToken());
                    }
                }
            }
            this.myRuleSet.declareInnerClass(string, string2, this.myComment, vector, vector2);
        }
        if (this.myComment != null) {
            this.myComment = null;
        }
    }

    private void startVariable(Attributes attributes) throws AbleParException {
        this.resetVarInfo();
        if (attributes != null) {
            this.saveComment(attributes.getValue("comment"));
            this.saveVariableType(attributes.getValue("dataType"));
            this.saveVariableName(attributes.getValue("varName"));
            this.saveVariableStaticFlag(attributes.getValue("static"));
            this.saveTemplateFlag(attributes.getValue("template"));
            this.saveVariableLength(attributes.getValue("length"));
            if (this.myVariableLength != -1) {
                this.myDclVariable = new AbleArrayVariable(this.myVariableName, this.myVariableStaticFlag, true, this.myVariableType, this.myVariableLength);
                if (this.myVarIsLocal) {
                    this.myRuleBlock.addVariable(this.myDclVariable);
                } else {
                    this.myRuleSet.addVariable(this.myDclVariable);
                }
            } else {
                this.myDclVariable = this.myVarIsLocal ? this.myRuleSet.addRuleBlockVariable(this.myRuleBlock, this.myVariableName, this.myVariableType) : this.myRuleSet.declareGlobalVariable(this.myVariableName, this.myVariableStaticFlag, this.myVariableType);
            }
        }
        if (this.myComment != null) {
            this.myDclVariable.setComment(this.myComment);
            this.myComment = null;
        }
        this.myDclVariable.setTemplate(this.myTemplateFlag);
    }

    private void startFuzzyVariable(Attributes attributes) throws AbleParException {
        this.resetVarInfo();
        if (attributes != null) {
            this.saveComment(attributes.getValue("comment"));
            this.saveVariableType(attributes.getValue("dataType"));
            this.saveVariableName(attributes.getValue("varName"));
            this.saveVariableStaticFlag(attributes.getValue("static"));
            this.saveTemplateFlag(attributes.getValue("template"));
            this.saveVariableLength(attributes.getValue("length"));
            String string = attributes.getValue("from");
            if (string != null) {
                string = string.trim();
                this.myVariableContinuousLo = Double.valueOf(string);
            }
            if ((string = attributes.getValue("to")) != null) {
                string = string.trim();
                this.myVariableContinuousHi = Double.valueOf(string);
            }
            if (!(this.myVariableContinuousLo < this.myVariableContinuousHi)) {
                throw new AbleParException(Able.NlsMsg((String)"Ex_RsXMLLow.gt.HighContinuous", (Object[])new Object[]{this.myVariableName, Double.toString(this.myVariableContinuousLo), Double.toString(this.myVariableContinuousHi)}));
            }
            if (this.myVariableType.equals("Continuous")) {
                this.myDclVariable = new AbleContinuousVariable(this.myVariableName, this.myVariableStaticFlag, true, this.myVariableContinuousLo, this.myVariableContinuousHi);
                this.myRuleSet.addVariable(this.myDclVariable);
            } else if (this.myVariableType.equals("Fuzzy")) {
                this.myFuzzyVariable = new AbleFuzzyVariable(this.myVariableName, this.myVariableStaticFlag, true, this.myVariableContinuousLo, this.myVariableContinuousHi, this.myAlphaCut);
                this.myDclVariable = this.myFuzzyVariable;
                this.myRuleSet.addVariable((AbleVariable)this.myFuzzyVariable);
            }
        }
        if (this.myComment != null) {
            this.myDclVariable.setComment(this.myComment);
            this.myComment = null;
        }
        this.myDclVariable.setTemplate(this.myTemplateFlag);
    }

    private void endVariable() {
    }

    private void startVariableRef(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("varRef")) != null) {
            string = string.trim();
            if (this.inTagPredicateRuleBody) {
                this.myPredClauses.add(this.myRuleSet.getVariable(string));
            }
        }
    }

    private void startSetDefinition() throws AbleParException {
        this.myTempStringBuf = new StringBuffer();
        this.myTempString = null;
    }

    private void endSetDefinition() {
        String string = this.myTempString = this.myTempStringBuf.toString();
        String string2 = null;
        if (this.myTempString == null || this.myTempString.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.myTempString, ";");
        if (stringTokenizer.countTokens() == 2) {
            string = stringTokenizer.nextToken() + ";";
            string2 = stringTokenizer.nextToken() + ";";
        }
        try {
            this.myRuleSet.parseSetDefinitionFromARL(string, this.myFuzzyVariable);
            if (string2 != null) {
                this.myRuleSet.parseSetDefinitionFromARL(string2, this.myFuzzyVariable);
            }
        }
        catch (AbleException ableException) {
            System.out.println("Error" + ableException.toString());
        }
    }

    private void startVarInitializer() throws AbleParException {
        this.myVarInitializerFlag = true;
        this.myVarInitializer = null;
        this.myVarInitializerArgs = new Vector();
        this.myTempStringBuf = new StringBuffer();
    }

    private void endVarInitializer() throws AbleParException {
        this.myVarInitializerFlag = false;
        this.myTempString = this.myTempStringBuf.toString();
        if (this.myTempString.length() != 0) {
            try {
                AbleExpression ableExpression = this.parseExpressionFromARL(this.myTempString);
                this.myVarInitializer = ableExpression.getOp() == 10 ? ableExpression.getRhs() : ableExpression;
            }
            catch (AbleException ableException) {
                System.out.println("Error" + ableException.toString());
            }
        }
        if (this.myVarInitializer != null) {
            try {
                this.myDclVariable.setInitialValue(this.myVarInitializer);
                this.myVarInitializer = null;
            }
            catch (AbleDataException ableDataException) {
                throw new AbleParException(ableDataException.getLocalizedMessage());
            }
        }
    }

    private void saveVariableLength(String string) {
        this.myVariableLength = -1;
        if (string != null) {
            this.myVariableLength = Integer.parseInt(string.trim());
        }
    }

    private void saveComment(String string) {
        if (string != null) {
            this.myComment = string.trim();
        }
    }

    private void saveVariableType(String string) {
        if (string != null) {
            this.myVariableType = string.trim();
        }
    }

    private void startRuleMetaData() throws AbleParException {
        this.myVarInitializerFlag = true;
        this.myVarInitializer = null;
        this.myVarInitializerArgs = new Vector();
    }

    private void endRuleMetaData() throws AbleParException {
        this.myVarInitializerFlag = false;
        if (this.myExpression != null) {
            this.myVarInitializer = this.myExpression;
        }
        if (this.myVarInitializer != null) {
            this.myRulePreConditions = this.myVarInitializerArgs.toArray();
        }
    }

    private void startInputs(Attributes attributes) {
        this.myTempStringBuf = new StringBuffer();
        this.myTempString = null;
    }

    private void endInputs() throws AbleParException {
        this.myTempString = this.myTempStringBuf.toString();
        String string = this.myTempString;
        if (string != null) {
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                this.myVariableName = stringTokenizer.nextToken();
                this.myRuleSet.addVariableToInputSequence(this.myVariableName);
            }
        }
    }

    private void startOutputs(Attributes attributes) {
        this.myTempStringBuf = new StringBuffer();
        this.myTempString = null;
    }

    private void endOutputs() throws AbleParException {
        this.myTempString = this.myTempStringBuf.toString();
        String string = this.myTempString;
        if (string != null) {
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                this.myVariableName = stringTokenizer.nextToken();
                this.myRuleSet.addVariableToOutputSequence(this.myVariableName);
            }
        }
    }

    private void hndlDclFunction(Attributes attributes) throws AbleParException {
        String string;
        if (attributes != null && (string = attributes.getValue("name")) != null) {
            this.myUserDefinedFunctionName = string.trim();
            this.myRuleSet.declareUserDefinedFunction(this.myUserDefinedFunctionName);
        }
    }

    private void hndlProperty(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            String string = attributes.getValue("name");
            String string2 = attributes.getValue("value");
            int n = this.myPropertyStack.size();
            if (n == 1) {
                this.myRuleSet.setProperty(string, string2);
            } else if (n == 2) {
                this.myRuleBlock.setProperty(string, string2);
            } else if (n == 3) {
                this.myRuleProperties.put(string, string2);
            }
        }
    }

    private void startRuleBlock(Attributes attributes) throws AbleParException {
        this.resetRuleBlockInfo();
        if (attributes != null) {
            String string = attributes.getValue("name");
            if (string != null) {
                this.myRuleBlockName = string.trim();
            }
            if ((string = attributes.getValue("returnType")) != null) {
                this.myRuleBlockReturnType = string.trim();
            }
            if ((string = attributes.getValue("comment")) != null) {
                this.myRuleBlockComment = string.trim();
            }
            if ((string = attributes.getValue("engine")) != null) {
                this.myRuleBlockInferenceEngine = string = string.trim();
                this.myRuleSet.validateAndCacheInferenceEngine(this.myRuleBlockInferenceEngine);
            }
            this.myPropertyStack.push(this.myRuleBlock);
        }
    }

    private void endRuleBlock() {
        this.myPropertyStack.pop();
    }

    private void saveRule(Attributes attributes) throws AbleParException {
        this.resetRulInfo();
        if (attributes != null) {
            this.saveRuleLabel(attributes.getValue("label"));
            this.saveComment(attributes.getValue("comment"));
            this.saveTemplateFlag(attributes.getValue("template"));
        }
        this.myPropertyStack.push("rule");
    }

    private void xferRule() throws AbleParException {
        if (this.myRulePreConditions != null) {
            try {
                this.myRule.setPreConditions(this.myRulePreConditions);
            }
            catch (AbleDataException ableDataException) {
                throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
            }
        }
        if (this.myComment != null) {
            this.myRule.setComment(this.myComment);
            this.myComment = null;
        }
        this.myRule.setTemplate(this.myTemplateFlag);
        if (this.myRuleReplacementMode) {
            this.myRuleSet.replaceRule(this.myRule);
        } else {
            this.myRuleSet.addRule(this.myRuleBlock, this.myRule);
        }
        this.myRule.setProperties((Hashtable)this.myRuleProperties.clone());
        this.myPropertyStack.pop();
        this.myRuleSet.clearLocalVarList();
    }

    private void startAssertionRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
    }

    private void endAssertionRule() throws AbleParException {
        this.myRule = new AbleAssertionRule(this.myRuleLabel, this.myRulePriority, this.myAstClause);
        this.xferRule();
    }

    private void startIfThenRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
    }

    private void endIfThenRule() throws AbleParException {
        if (this.myAntClauses.size() == 0) {
            this.myAntClauses = AbleRuleSet.convertToConjunctiveNormalForm(this.myAntExpression, this.myRuleSet);
        }
        this.myAntExpressionList.clear();
        this.myAntExpressionList.add(this.myAntExpression);
        this.myRule = new AbleConditionalRule(this.myRuleLabel, this.myRulePriority, this.myAntExpressionList, this.myAntClauses, this.myThenList);
        this.xferRule();
    }

    private void startIfThenElseRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
    }

    private void endIfThenElseRule() throws AbleParException {
        this.myRule = new AbleIfThenElseRule(this.myRuleLabel, this.myRulePriority, this.myAntExpression, this.myThenList, this.myElseList);
        this.xferRule();
    }

    private void startForLoopRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
        this.myForInitExprList = new Vector();
        this.myForTestExpr = null;
        this.myForIterExprList = new Vector();
    }

    private void endForLoopRule() throws AbleParException {
        this.myRule = new AbleForLoopRule(this.myRuleLabel, this.myRulePriority, this.myForInitExprList, this.myForTestExpr, this.myForIterExprList, this.myDoList);
        this.xferRule();
    }

    private void startWhenDoRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
    }

    private void endWhenDoRule() throws AbleParException {
        this.myRule = new AblePatternMatchRule(this.myRuleLabel, this.myRulePriority, this.myWdWhenList, this.myDoList, this.myRuleSet, this.myRuleBlock);
        this.xferRule();
    }

    private void startWhileDoRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
    }

    private void endWhileDoRule() throws AbleParException {
        this.myRule = new AbleWhileDoRule(this.myRuleLabel, this.myRulePriority, this.myAntExpression, this.myDoList);
        this.xferRule();
    }

    private void startDoWhileRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
    }

    private void endDoWhileRule() throws AbleParException {
        this.myRule = new AbleDoWhileRule(this.myRuleLabel, this.myRulePriority, this.myAntExpression, this.myDoList);
        this.xferRule();
    }

    private void startDoUntilRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
    }

    private void endDoUntilRule() throws AbleParException {
        this.myRule = new AbleDoUntilRule(this.myRuleLabel, this.myRulePriority, this.myAntExpression, this.myDoList);
        this.xferRule();
    }

    private void startPlanRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
        this.myPlanEffectsList = null;
        this.myPlanExpansionList = null;
        this.myDoList.removeAllElements();
    }

    private void endPlanRule() throws AbleParException {
        this.myRule = this.myPlanExpansionList == null ? new AblePlanningRule(this.myRuleLabel, this.myRulePriority, this.myFormalParameterList, this.myPlanPrecondition, this.myPlanEffectsList, this.myRuleSet) : new AbleHierarchicalPlanningRule(this.myRuleLabel, this.myRulePriority, this.myFormalParameterList, this.myPlanPrecondition, this.myPlanEffectsList, this.myPlanExpansionList, this.myRuleSet);
        this.xferRule();
    }

    private void startSwitchRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
    }

    private void endSwitchRule() throws AbleParException {
        this.myRule = new AbleSwitchRule(this.myRuleLabel, this.myRulePriority, this.mySwitchStatement);
        this.xferRule();
    }

    private void startPredicateRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
        this.myPredClauses = new Vector();
    }

    private void endPredicateRule() throws AbleParException {
        this.myRule = new AblePredicateRule(this.myRuleLabel, this.myRulePriority, this.myPredClauses, this.myPredLhs, this.myRuleSet);
        this.xferRule();
    }

    private void startPredicateFact(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
        this.myPredClauses = new Vector();
    }

    private void endPredicateFact() throws AbleParException {
        this.myPredLhs = (AblePredicate)this.myPredClauses.get(0);
        this.myRule = new AblePredicateFact(this.myRuleLabel, this.myRulePriority, this.myPredLhs, this.myRuleSet);
        this.xferRule();
    }

    private void startTreeRule(Attributes attributes) throws AbleParException {
        this.saveRule(attributes);
        this.myDecisionTree = new AbleTree();
    }

    private void endTreeRule() throws AbleParException {
        this.myRule = new AbleTreeRule(this.myRuleLabel, this.myRulePriority, this.myDecisionTree, this.myRuleSet, this.myRuleBlock);
        this.xferRule();
        AbleTreeRule ableTreeRule = (AbleTreeRule)this.myRule;
        ableTreeRule.convertToAbleRules();
        Vector vector = ableTreeRule.getRuleList();
        for (int i = 0; i < vector.size(); ++i) {
            AbleRule ableRule = (AbleRule)vector.get(i);
            System.out.println(ableRule.arlString());
        }
    }

    private void saveRuleLabel(String string) {
        if (string != null) {
            this.myRuleLabel = string.trim();
        }
    }

    private void startRulePriority() {
        this.myTempString = null;
        this.myTempStringBuf = new StringBuffer();
    }

    private void endRulePriority() throws AbleParException {
        try {
            this.myTempString = this.myTempStringBuf.toString();
            this.myRulePriority = this.parseExpressionFromARL(this.myTempString);
        }
        catch (AbleException ableException) {
            throw new AbleParException("priority", ableException);
        }
    }

    private void startAssert() throws AbleParException {
        this.myTempString = null;
        this.myTempStringBuf = new StringBuffer();
    }

    private void endAssert() throws AbleParException {
        AbleExpression ableExpression = null;
        try {
            this.myTempString = this.myTempStringBuf.toString();
            ableExpression = this.parseExpressionFromARL(this.myTempString);
        }
        catch (AbleException ableException) {
            throw new AbleParException("Parsing exception", ableException);
        }
        AbleRd ableRd = ableExpression.getLhs();
        int n = ableExpression.getOp();
        AbleRd ableRd2 = ableExpression.getRhs();
        this.myAstClause = n == 1 ? this.myRuleSet.findOrCreateAssertion((AbleLhs)ableRd, n, ableRd2) : (n == 6 ? this.myRuleSet.findOrCreateAssertion((AbleLhs)ableRd, 2, ableRd2) : this.myRuleSet.findOrCreateAssertion(null, 10, ableRd2));
    }

    private void startThen() throws AbleParException {
        this.myThenList = null;
        this.myDoList.removeAllElements();
    }

    private void endThen() throws AbleParException {
        this.myThenList = (Vector)this.myDoList.clone();
    }

    private void startElse() throws AbleParException {
        this.myElseList = null;
        this.myDoList.removeAllElements();
    }

    private void endElse() throws AbleParException {
        this.myElseList = (Vector)this.myDoList.clone();
    }

    private void startIf() throws AbleParException {
    }

    private void endIf() throws AbleParException {
        try {
            this.myAntExpression = this.parseExpressionFromARL(this.myTempString);
        }
        catch (AbleException ableException) {
            throw new AbleParException("endIf", ableException);
        }
    }

    private void startWhile() throws AbleParException {
    }

    private void endWhile() throws AbleParException {
        try {
            this.myAntExpression = this.parseExpressionFromARL(this.myTempString);
        }
        catch (AbleException ableException) {
            throw new AbleParException("endIf", ableException);
        }
    }

    private void startUntil() throws AbleParException {
    }

    private void endUntil() throws AbleParException {
        try {
            this.myAntExpression = this.parseExpressionFromARL(this.myTempString);
        }
        catch (AbleException ableException) {
            throw new AbleParException("endIf", ableException);
        }
    }

    private void startExpression(Attributes attributes) {
        String string;
        this.myTempStringBuf = new StringBuffer();
        this.myTempString = null;
        if (attributes != null && (string = attributes.getValue("weight")) != null) {
            string = string.trim();
            this.myRuleAntWeight = Double.valueOf(string);
        }
    }

    private void endExpression() throws AbleParException {
        this.myTempString = this.myTempStringBuf.toString();
        String string = this.myTempString;
        if (string == null) {
            Able.MessageLog.message(4L, (Object)this, "xferExpression", "Ex_RsXferExpressionEmptyStack");
        }
        try {
            this.myExpression = this.parseExpressionFromARL(string);
        }
        catch (AbleException ableException) {
            System.out.println("Error" + ableException.toString());
        }
        if (this.inTagPredicateRuleBody) {
            this.myPredClauses.add(this.makeRulAnt(this.myExpression));
        }
    }

    private void startBooleanExpression(Attributes attributes) {
    }

    private void endBooleanExpression() throws AbleParException {
        this.endExpression();
        this.myBooleanExpression = (AbleExpression)this.myExpression;
    }

    private void startLogicalAndExpression(Attributes attributes) {
    }

    private void endLogicalAndExpression() {
        this.myLogicalExpression = this.myLogicalExpression == null ? (AbleExpression)this.myExpression : this.myRuleSet.findOrCreateExpression((AbleRd)this.myLogicalExpression, 16, this.myExpression);
    }

    private void startLogicalOrExpression(Attributes attributes) {
    }

    private void endLogicalOrExpression() {
        this.myLogicalExpression = this.myLogicalExpression == null ? (AbleExpression)this.myExpression : this.myRuleSet.findOrCreateExpression((AbleRd)this.myLogicalExpression, 17, this.myExpression);
    }

    private void startLogicalNotExpression(Attributes attributes) {
    }

    private void endLogicalNotExpression() {
        if (this.myLogicalExpression == null) {
            this.myLogicalExpression = this.myRuleSet.findOrCreateExpression(null, 18, (AbleRd)((AbleExpression)this.myExpression));
        } else {
            this.myExpression = this.myRuleSet.findOrCreateExpression(null, 18, this.myExpression);
            this.myLogicalExpression = this.myRuleSet.findOrCreateExpression((AbleRd)this.myLogicalExpression, 16, this.myExpression);
        }
    }

    private void startPredicate() {
        this.myTempStringBuf = new StringBuffer();
        this.myTempString = null;
    }

    private void endPredicate() {
        AblePredicate ablePredicate = null;
        String string = this.myTempString = this.myTempStringBuf.toString();
        try {
            this.myExpression = this.parseExpressionFromARL(string);
            ablePredicate = (AblePredicate)((AbleLiteral)((AbleExpression)this.myExpression).getRhs()).getGenericValue();
        }
        catch (AbleException ableException) {
            System.out.println("Error" + ableException.toString());
        }
        this.myPredClauses.add(ablePredicate);
    }

    private void startPlanEffects() throws AbleParException {
    }

    private void endPlanEffects() {
        this.myPlanEffectsList = (Vector)this.myDoList.clone();
        this.myDoList.removeAllElements();
    }

    private void startPattern(Attributes attributes) throws AbleParException {
        this.resetWdSelectorInfo();
        if (attributes != null) {
            this.saveWdSelVarName(attributes.getValue("varName"));
            this.saveWdSelVarType(attributes.getValue("varType"));
            this.saveWdSelPosFlag(attributes.getValue("pos"));
        }
    }

    private void saveWdSelVarName(String string) {
        if (string != null) {
            this.myWdSelVarName = string;
        }
    }

    private void saveWdSelVarType(String string) throws AbleParException {
        if (string != null) {
            this.myWdSelVarType = string;
        }
        this.myWdSelVariable = this.myRuleSet.addLocalVariable(this.myWdSelVarName, this.myWdSelVarType);
    }

    private void saveWdSelPosFlag(String string) {
        if (string != null) {
            String string2 = string.trim();
            this.myWdSelPosFlag = !string2.equalsIgnoreCase("false");
        }
    }

    private void endPattern() {
        AbleSelector ableSelector = new AbleSelector(this.myWdSelVariable, this.myAntExpression, this.myWdSelPosFlag);
        this.myWdWhenList.addElement(ableSelector);
    }

    private void startConstraint() throws AbleParException {
    }

    private void endConstraint() throws AbleParException {
        this.myAntExpression = (AbleExpression)this.myExpression;
    }

    private AbleAntecedentClause makeRulAnt(AbleRd ableRd) throws AbleParException {
        AbleAntecedentClause ableAntecedentClause;
        if (ableRd instanceof AbleExpression) {
            if (((AbleExpression)ableRd).getOp() == 16) {
                return null;
            }
            try {
                ableAntecedentClause = new AbleAntecedentClause((AbleExpression)ableRd);
            }
            catch (AbleDataException ableDataException) {
                throw new AbleParException(ableDataException.getLocalizedMessage(), ableDataException);
            }
            ableAntecedentClause = this.myRuleSet.findOrCreateAntecedent(ableAntecedentClause);
        } else {
            AbleRd ableRd2 = ableRd;
            ableAntecedentClause = this.myRuleSet.findOrCreateAntecedent(null, 10, ableRd2, this.myRuleAntWeight);
        }
        return ableAntecedentClause;
    }

    private AbleConsequentClause makeRulCns() throws AbleParException {
        AbleConsequentClause ableConsequentClause;
        this.myRuleCns = this.myExpression;
        if (this.myRuleCns instanceof AbleExpression) {
            AbleExpression ableExpression = (AbleExpression)this.myRuleCns;
            AbleRd ableRd = ableExpression.getLhs();
            int n = ableExpression.getOp();
            AbleRd ableRd2 = ableExpression.getRhs();
            ableConsequentClause = n == 1 ? this.myRuleSet.findOrCreateConsequent((AbleLhs)ableRd, n, ableRd2) : (n == 6 ? this.myRuleSet.findOrCreateConsequent((AbleLhs)ableRd, 2, ableRd2) : (n == 2 ? this.myRuleSet.findOrCreateConsequent((AbleLhs)ableRd, 2, ableRd2) : this.myRuleSet.findOrCreateConsequent(null, 10, ableRd2)));
        } else {
            AbleLhs ableLhs = null;
            int n = 10;
            AbleRd ableRd = this.myRuleCns;
            ableConsequentClause = this.myRuleSet.findOrCreateConsequent(ableLhs, n, ableRd);
        }
        return ableConsequentClause;
    }

    private void startWhen() {
        this.myWdWhenList.removeAllElements();
    }

    private void endWhen() {
    }

    private void startDo() {
        this.myDoList.removeAllElements();
    }

    private void endDo() {
    }

    private void startHead() {
        this.myTempString = null;
        this.myTempStringBuf = new StringBuffer();
    }

    private void endHead() {
        String string = this.myTempString = this.myTempStringBuf.toString();
        try {
            this.myExpression = this.parseExpressionFromARL(string);
            this.myPredLhs = (AblePredicate)((AbleLiteral)((AbleExpression)this.myExpression).getRhs()).getGenericValue();
        }
        catch (AbleException ableException) {
            System.out.println("Error" + ableException.toString());
        }
    }

    private void startBody() {
        this.inTagPredicateRuleBody = true;
    }

    private void endBody() {
        this.inTagPredicateRuleBody = false;
    }

    private void startParameters() throws AbleParException {
        this.myFormalParameterList = new Vector();
    }

    private void endParameters() throws AbleParException {
        if (this.inRuleBlockHeader) {
            String string = "(" + this.myFormalSignature + ")";
            try {
                this.myRuleBlock = this.myRuleSet.addRuleBlock(this.myRuleBlockName, this.myRuleBlockReturnType, string, this.myFormalParameterList, this.myRuleBlockInferenceEngine, this.myRuleBlockComment, new HashMap());
            }
            catch (AbleException ableException) {
                throw new AbleParException(ableException.getMessage());
            }
            finally {
                this.myRuleBlockComment = null;
            }
        }
    }

    private void hndlFormalParameter(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            boolean bl;
            String string = attributes.getValue("type");
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("isArray");
            AbleVariable ableVariable = null;
            ableVariable = string3.equals("true") ? this.myRuleSet.addLocalVariable(string2, string + "[]") : this.myRuleSet.addLocalVariable(string2, string);
            this.myFormalParameterList.add(ableVariable);
            boolean bl2 = bl = this.myFormalSignature.trim().length() == 0;
            if (!bl) {
                this.myFormalSignature = this.myFormalSignature + ",";
            }
            this.myFormalSignature = this.myFormalSignature + string;
        }
    }

    private void startPlanPrecondition() {
    }

    private void endPlanPrecondition() throws AbleParException {
        this.myPlanPrecondition = (AbleExpression)this.myExpression;
    }

    private void startPlanExpansion() {
        this.myDoList.removeAllElements();
        if (this.myPlanExpansionList == null) {
            this.myPlanExpansionList = new Vector();
        }
    }

    private void endPlanExpansion() throws AbleParException {
        this.myPlanExpansionList.add((Vector)this.myDoList.clone());
    }

    private void startConditionNode(Attributes attributes) throws AbleParException {
        this.myTreeConditionNode = new AbleTreeConditionNode();
        this.myTreeStack.push(this.myTreeConditionNode);
        if (this.myDecisionTree.isEmpty()) {
            this.myDecisionTree.setRootNode(this.myTreeConditionNode);
        }
    }

    private void endConditionNode() throws AbleParException {
        this.myTreeStack.pop();
    }

    private void startActionNode(Attributes attributes) throws AbleParException {
        this.myTreeActionNode = new AbleTreeActionNode();
        this.myTreeStack.push(this.myTreeActionNode);
    }

    private void endActionNode() throws AbleParException {
        AbleTreeActionNode ableTreeActionNode = (AbleTreeActionNode)this.myTreeStack.pop();
        if (this.myTreeEdge != null) {
            this.myTreeEdge.setChildNode(ableTreeActionNode);
        }
    }

    private void startTreeAction(Attributes attributes) throws AbleParException {
        this.myTreeTermRef = null;
        this.myTreeTerm = null;
    }

    private void endTreeAction() throws AbleParException {
        AbleTreeAction ableTreeAction = null;
        ableTreeAction = new AbleTreeAction(this.myTreeTermRef, this.myTreeTerm, this.myTreeValue);
        if (!this.myTreeStack.isEmpty() && this.myTreeStack.peek() instanceof AbleTreeActionNode) {
            ((AbleTreeActionNode)this.myTreeStack.peek()).addAction(ableTreeAction);
        }
    }

    private void startSharedActionTerm(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            String string = attributes.getValue("uid");
            String string2 = attributes.getValue("value");
            if (string2 != null) {
                AbleTreePartialExpression ableTreePartialExpression = new AbleTreePartialExpression(string, string2);
                this.myDecisionTree.addSharedActionTerm(ableTreePartialExpression);
            }
        }
    }

    private void endSharedActionTerm() throws AbleParException {
    }

    private void startSharedCondition(Attributes attributes) throws AbleParException {
        this.inTreeSharedCondition = true;
        this.myTreeValues = new Vector();
    }

    private void endSharedCondition() throws AbleParException {
        AbleTreeCondition ableTreeCondition = new AbleTreeCondition(this.myTreeTerm, this.myTreeValues);
        this.myDecisionTree.addSharedCondition(ableTreeCondition);
        this.inTreeSharedCondition = false;
    }

    private void startTerm(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            String string = attributes.getValue("uid");
            String string2 = attributes.getValue("value");
            if (string2 != null) {
                AbleTreePartialExpression ableTreePartialExpression;
                this.myTreeTerm = ableTreePartialExpression = new AbleTreePartialExpression(string, string2);
            }
        }
    }

    private void endTerm() throws AbleParException {
        if (!this.myTreeStack.isEmpty()) {
            ((AbleTreeConditionNode)this.myTreeStack.peek()).setTerm(this.myTreeTerm);
        }
    }

    private void startTermRef(Attributes attributes) throws AbleParException {
    }

    private void endTermRef() throws AbleParException {
        this.myTreeTermRef = this.myTempString;
        this.myTreeTerm = this.myDecisionTree.resolveSharedConditionRef(this.myTreeTermRef);
        if (!this.myTreeStack.isEmpty()) {
            if (this.myTreeStack.peek() instanceof AbleTreeConditionNode) {
                ((AbleTreeConditionNode)this.myTreeStack.peek()).setTermRef(this.myTreeTermRef);
                ((AbleTreeConditionNode)this.myTreeStack.peek()).setTerm(this.myTreeTerm);
            } else if (this.myTreeStack.peek() instanceof AbleTreeActionNode && this.myTreeTerm == null) {
                this.myTreeTerm = this.myDecisionTree.resolveSharedActionTermRef(this.myTreeTermRef);
            }
        }
    }

    private void startValue(Attributes attributes) throws AbleParException {
        if (attributes != null) {
            String string = attributes.getValue("uid");
            String string2 = attributes.getValue("value");
            if (string2 != null) {
                AbleTreePartialExpression ableTreePartialExpression;
                this.myTreeValue = ableTreePartialExpression = new AbleTreePartialExpression(string, string2);
                this.myTreeValues.add(ableTreePartialExpression);
            }
        }
    }

    private void endValue() throws AbleParException {
        if (!this.myTreeStack.isEmpty() && this.myTreeStack.peek() instanceof AbleTreeEdge) {
            ((AbleTreeEdge)this.myTreeStack.peek()).setValue(this.myTreeValue);
        }
    }

    private void startValueRef(Attributes attributes) throws AbleParException {
    }

    private void endValueRef() throws AbleParException {
        this.myTreeValueRef = this.myTempString;
        this.myTreeValue = this.myDecisionTree.resolveSharedConditionRef(this.myTreeValueRef);
        if (!this.myTreeStack.isEmpty() && this.myTreeStack.peek() instanceof AbleTreeEdge) {
            ((AbleTreeEdge)this.myTreeStack.peek()).setValueRef(this.myTreeValueRef);
            ((AbleTreeEdge)this.myTreeStack.peek()).setValue(this.myTreeValue);
        }
    }

    private void startEdge(Attributes attributes) throws AbleParException {
        this.myTreeEdge = new AbleTreeEdge();
        this.myTreeStack.push(this.myTreeEdge);
    }

    private void endEdge() throws AbleParException {
        this.myTreeStack.pop();
        if (!this.myTreeStack.isEmpty() && this.myTreeStack.peek() instanceof AbleTreeConditionNode) {
            ((AbleTreeConditionNode)this.myTreeStack.peek()).addEdge(this.myTreeEdge);
        }
    }

    private void startAction() throws AbleParException {
        this.myTempStringBuf = new StringBuffer();
        this.myTempString = null;
    }

    private void endAction() throws AbleParException {
        this.myTempString = this.myTempStringBuf.toString();
        String string = this.myTempString;
        if (string == null) {
            Able.MessageLog.message(4L, (Object)this, "xferExpression", "Ex_RsXferExpressionEmptyStack");
        }
        try {
            this.myExpression = this.parseActionFromARL(string);
        }
        catch (AbleException ableException) {
            System.out.println("Error" + ableException.toString());
        }
        if (this.inTagPredicateRuleBody) {
            this.myPredClauses.add(this.makeRulCns());
        } else {
            this.myDoList.addElement(this.makeRulCns());
        }
    }

    private void startSwitch() throws AbleParException {
        this.startAction();
    }

    private void endSwitch() throws AbleParException {
        this.myTempString = this.myTempStringBuf.toString();
        String string = this.myTempString;
        if (string == null) {
            Able.MessageLog.message(4L, (Object)this, "xferExpression", "Ex_RsXferExpressionEmptyStack");
        }
        try {
            this.myExpression = this.parseActionFromARL(string);
        }
        catch (AbleException ableException) {
            System.out.println("Error" + ableException.toString());
        }
        AbleRd ableRd = ((AbleExpression)this.myExpression).getRhs();
        if (ableRd instanceof AbleSwitchStatement) {
            this.mySwitchStatement = (AbleSwitchStatement)ableRd;
        }
    }

    private void endForInit() throws AbleParException {
        this.myForInitExprList.add(this.myExpression);
    }

    private void endForTest() throws AbleParException {
        this.myForTestExpr = (AbleExpression)this.myExpression;
    }

    private void endForIter() throws AbleParException {
        this.myForIterExprList.add(this.myExpression);
    }

    private void resetOptInfo() {
        this.myAlphaCut = 0.1;
        this.myEngineType = "Script";
        this.myTemplateFlag = false;
        this.myRuleReplacementMode = false;
    }

    private void resetVarInfo() {
        this.myVariableName = "";
        this.myVariableContinuousLo = 0.0;
        this.myVariableContinuousHi = 0.0;
        this.myVariableStaticFlag = false;
        this.myVariableType = "";
        this.myFuzzyVariable = null;
        this.myTemplateFlag = false;
    }

    private void resetRuleBlockInfo() {
        this.myRuleBlockName = "";
        this.myFormalSignature = "";
        this.inRuleBlockHeader = true;
    }

    private void resetRulInfo() {
        this.myRule = null;
        this.myRulePreConditions = null;
        this.myRuleAntWeight = 1.0;
        this.myRuleHedges = "";
        this.myRuleLabel = "";
        this.myRulePriority = AbleRule.PriorityDefault;
        this.myAntClauses.removeAllElements();
        this.myAntExpressionList.removeAllElements();
        this.myDoList.removeAllElements();
        this.myExpression = null;
        this.myExpressionStack.clear();
        this.myTemplateFlag = false;
        this.myRuleProperties.clear();
        this.myVarIsLocal = true;
        this.inRuleBlockHeader = false;
    }

    private void resetWdSelectorInfo() {
        this.myWdSelVarName = "";
        this.myWdSelVarType = "";
        this.myWdSelPosFlag = true;
        this.myWdSelVariable = null;
        this.myAntClauses.removeAllElements();
        this.myAntExpressionList.removeAllElements();
    }
}

