/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.rules;

import com.ibm.able.Able;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.AbleUserDefinedFunction;
import com.ibm.able.rules.AbleRuleSet;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Random;

public class PolicyDemo
extends AbleObject {
    static final long serialVersionUID = 2003111400100100000L;
    private Random myRandom = new Random();
    private AbleRuleSet myRuleSet = null;
    static /* synthetic */ Class class$java$lang$Integer;

    public PolicyDemo() throws AbleException {
        this("PolicyDemo");
    }

    public PolicyDemo(String string) throws AbleException {
        super(string);
        this.init();
    }

    public void process() throws AbleException {
        this.runDemo();
    }

    public void runDemo() {
        block2: {
            String string = "runDemo";
            try {
                Able.startMessageAndTraceLogging();
                this.myRuleSet = new AbleRuleSet();
                String string2 = Able.ProductDirectory + "examples" + File.separator + "rules" + File.separator;
                this.myRuleSet.parseFromARL(string2 + "PolicyDemo.arl");
                Class<?> clazz = ((Object)((Object)this)).getClass();
                Method method = clazz.getMethod("realTimeNumberOfServersMethod", new Class[0]);
                AbleUserDefinedFunction ableUserDefinedFunction = new AbleUserDefinedFunction("realTimeNumberOfServers", (Object)this, method);
                this.myRuleSet.addUserDefinedFunction(ableUserDefinedFunction);
                method = clazz.getMethod("realTimeNumberOfActiveConnectionsMethod", new Class[0]);
                ableUserDefinedFunction = new AbleUserDefinedFunction("realTimeNumberOfActiveConnections", (Object)this, method);
                this.myRuleSet.addUserDefinedFunction(ableUserDefinedFunction);
                method = clazz.getMethod("realTimeCpuUtiliztionMethod", new Class[0]);
                ableUserDefinedFunction = new AbleUserDefinedFunction("realTimeCpuUtiliztion", (Object)this, method);
                this.myRuleSet.addUserDefinedFunction(ableUserDefinedFunction);
                method = clazz.getMethod("immediatelyAddServersMethod", class$java$lang$Integer == null ? (class$java$lang$Integer = PolicyDemo.class$("java.lang.Integer")) : class$java$lang$Integer);
                ableUserDefinedFunction = new AbleUserDefinedFunction("immediatelyAddServers", (Object)this, method);
                this.myRuleSet.addUserDefinedFunction(ableUserDefinedFunction);
                this.myRuleSet.init();
                this.getAndActOnProvisioningDecision(this.randomInt(), 10, 12);
                this.setUpAndRunPeriodicChecks();
                this.getAndActOnProvisioningDecision(0, 26, 76);
                this.routeProvisioningDecisionEventsToPolicyDoc();
            }
            catch (Exception exception) {
                System.out.println("runDemo exception: " + exception);
                if (!this.trace.isLogging()) break block2;
                this.trace.text(262144L, (Object)this, string, "!! Caught nasty exception: " + exception.getLocalizedMessage());
                this.trace.exception(262144L, (Object)this, string, (Throwable)exception);
            }
        }
        System.out.println("DRVR: done.");
    }

    private void getAndActOnProvisioningDecision(int n, int n2, int n3) throws AbleException {
        Integer n4 = new Integer(0);
        Object[] objectArray = (Object[])this.myRuleSet.getInputBuffer();
        objectArray[0] = new Integer(n);
        objectArray[1] = new Integer(n2);
        objectArray[2] = new Integer(n3);
        this.myRuleSet.process();
        Object[] objectArray2 = (Object[])this.myRuleSet.getOutputBuffer();
        Integer n5 = (Integer)objectArray2[0];
        System.out.println("DRVR: Provisioning Policy indicates <" + n5 + "> servers need to be added.");
        if (n5 > 0 && (n4 = this.immediatelyAddServersMethod(n5)) > 0) {
            System.out.println("DRVR: Alert! <" + n4 + "> not added.");
        }
    }

    private void setUpAndRunPeriodicChecks() {
        this.myRuleSet.setSleepTime(5000L);
        this.myRuleSet.setTimerEventProcessingEnabled(true);
        this.myRuleSet.setAbleEventProcessingEnabled(3);
        this.myRuleSet.startEnabledEventProcessing();
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myRuleSet.suspendEnabledEventProcessing();
        this.myRuleSet.setTimerEventProcessingEnabled(false);
    }

    private void routeProvisioningDecisionEventsToPolicyDoc() throws AbleException {
        this.myRuleSet.resumeEnabledEventProcessing();
        Object[] objectArray = new Object[]{new Integer(this.randomInt()), new Integer(this.randomInt()), new Integer(this.randomInt())};
        this.myRuleSet.handleAbleEvent(new AbleEvent((Object)this, (Object)objectArray));
        objectArray = new Object[]{new Integer(this.randomInt()), new Integer(this.randomInt()), new Integer(this.randomInt())};
        this.myRuleSet.handleAbleEvent(new AbleEvent((Object)this, (Object)objectArray));
        objectArray = new Object[]{new Integer(this.randomInt()), new Integer(this.randomInt()), new Integer(this.randomInt())};
        this.myRuleSet.handleAbleEvent(new AbleEvent((Object)this, (Object)objectArray));
        this.myRuleSet.quitEnabledEventProcessing();
    }

    public Integer realTimeNumberOfServersMethod() {
        System.out.println("** Sensor Determining current number of servers...");
        int n = this.randomInt();
        System.out.println("**   Current number of active servers is <" + n + ">.");
        return new Integer(n);
    }

    public Integer realTimeNumberOfActiveConnectionsMethod() {
        System.out.println("** Sensor determining current number of active connections...");
        int n = this.randomInt();
        System.out.println("**   Current number of active connections is <" + n + ">.");
        return new Integer(n);
    }

    public Integer realTimeCpuUtiliztionMethod() {
        System.out.println("** Sensor determining current CPU utilization...");
        int n = this.randomInt();
        System.out.println("**   Current CPU utilization is <" + n + ">.");
        return new Integer(n);
    }

    public Integer immediatelyAddServersMethod(Integer n) {
        int n2 = n;
        System.out.println("** Effector adding <" + n + "> servers to current server pool.");
        int n3 = this.randomInt(n2 + 1);
        System.out.println("**   <" + n3 + "> Servers added successfully.");
        if (n2 == n3) {
            return new Integer(0);
        }
        return new Integer(n2 - n3);
    }

    private int randomInt() {
        return this.myRandom.nextInt(101);
    }

    private int randomInt(int n) {
        return this.myRandom.nextInt(n);
    }

    public static void main(String[] stringArray) {
        block2: {
            try {
                PolicyDemo policyDemo = new PolicyDemo();
                policyDemo.runDemo();
                System.exit(0);
            }
            catch (Throwable throwable) {
                if (!Able.TraceLog.isLogging()) break block2;
                Able.TraceLog.exception(0x100000L, (Object)"com.ibm.able.examples.rules.PolicyDemo", "main", throwable);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

