/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.rules;

import com.ibm.able.examples.rules.Grocery;
import java.io.Serializable;
import java.util.Vector;

public class GroceryBag
implements Serializable {
    static final long serialVersionUID = 2001100500100300000L;
    private static int nextId = 0;
    private Vector contents = new Vector();
    protected int id = nextId++;
    protected int numSmallItems = 0;
    protected int numMediumItems = 0;
    protected int numLargeItems = 0;
    private boolean full = false;
    private static double[] countLimitsBySize = new double[]{6.0, 12.0, 18.0};

    public void addItem(Grocery grocery) {
        this.contents.add(grocery);
        grocery.setBag(this.id);
        if (grocery.getSize().equals("large")) {
            ++this.numLargeItems;
        } else if (grocery.getSize().equals("medium")) {
            ++this.numMediumItems;
        } else if (grocery.getSize().equals("small")) {
            ++this.numSmallItems;
        }
        this.setFull();
    }

    private void setFull() {
        this.full = this.getSpaceUsed(new int[]{0, 0, 0}) >= 1.0;
    }

    private double getSpaceUsed(int[] nArray) {
        return (double)(this.numLargeItems + nArray[0]) / countLimitsBySize[0] + (double)(this.numMediumItems + nArray[1]) / countLimitsBySize[1] + (double)(this.numSmallItems + nArray[2]) / countLimitsBySize[2];
    }

    public void removeItem(Grocery grocery) {
        if (this.contents.contains(grocery)) {
            this.contents.remove(grocery);
            if (grocery.getSize().equals("large")) {
                --this.numLargeItems;
            } else if (grocery.getSize().equals("medium")) {
                --this.numMediumItems;
            } else if (grocery.getSize().equals("small")) {
                --this.numSmallItems;
            }
            this.setFull();
        }
    }

    public Vector getContents() {
        return this.contents;
    }

    public int getNumLargeItems() {
        return this.numLargeItems;
    }

    public int getNumMediumItems() {
        return this.numMediumItems;
    }

    public int getNumItems() {
        return this.contents.size();
    }

    public int getId() {
        return this.id;
    }

    public boolean hasSpace(String string) {
        double d = "small".equals(string) ? this.getSpaceUsed(new int[]{0, 0, 1}) : ("medium".equals(string) ? this.getSpaceUsed(new int[]{0, 1, 0}) : this.getSpaceUsed(new int[]{1, 0, 0}));
        return d <= 1.0;
    }

    public static void reset() {
        nextId = 0;
    }

    public String toString() {
        String string = this.full ? "is full" : "is not full";
        double d = this.getSpaceUsed(new int[]{0, 0, 0});
        string = string + (d == 1.0 ? "" : "(" + d + ")");
        return "bag id=" + this.id + " " + string + "; contains " + this.numSmallItems + "S+" + this.numMediumItems + "M+" + this.numLargeItems + "L=" + this.contents.size() + " groceries=" + this.contentsAsString();
    }

    protected String contentsAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.contents.size(); ++i) {
            stringBuffer.append(this.contents.get(i).toString() + " ; ");
        }
        return stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

