/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.rules;

import com.ibm.able.AbleException;
import com.ibm.able.data.AbleDoubleLiteral;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleRd;
import com.ibm.able.data.AbleStringLiteral;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleAssertionClause;
import com.ibm.able.rules.AbleAssertionRule;
import com.ibm.able.rules.AbleRule;
import com.ibm.able.rules.AbleRuleBlock;
import com.ibm.able.rules.AbleRuleSet;
import java.util.Hashtable;
import java.util.Vector;

public class AbleRuleSetFromAPI {
    public static void main(String[] stringArray) {
        AbleRuleSetFromAPI ableRuleSetFromAPI = new AbleRuleSetFromAPI();
        try {
            AbleRuleSet ableRuleSet = ableRuleSetFromAPI.test();
            AbleVariable ableVariable = ableRuleSet.getVariable("inVar1");
            AbleVariable ableVariable2 = ableRuleSet.getVariable("outVar1");
            System.out.println("done! input was " + ableVariable.getValueString() + " and the output was " + ableVariable2.getValueString());
            System.out.println("OutputBuffer[0] = " + ableRuleSet.getOutputBuffer(0));
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getLocalizedMessage());
            exception.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }

    private AbleRuleSet test() throws AbleException {
        AbleRuleSet ableRuleSet = new AbleRuleSet();
        this.constructRuleSet1(ableRuleSet);
        System.out.println("Initializing the bean via init() call");
        if (ableRuleSet.isExecutable()) {
            ableRuleSet.init();
            ableRuleSet.process();
        }
        return ableRuleSet;
    }

    private void constructRuleSet1(AbleRuleSet ableRuleSet) throws AbleException {
        ableRuleSet.setName("ruleset1");
        ableRuleSet.setComment("this is a test ruleset");
        ableRuleSet.declareUserDataType("Vector", "java.util.Vector");
        ableRuleSet.declareUserDataType("Math", "java.lang.Math");
        Vector<String> vector = new Vector<String>();
        vector.add("fld1");
        vector.add("fld2");
        Vector<String> vector2 = new Vector<String>();
        vector2.add("int");
        vector2.add("String");
        ableRuleSet.declareInnerClass("innerClass1", null, "inner class comment", vector, vector2);
        AbleVariable ableVariable = null;
        ableVariable = ableRuleSet.declareGlobalVariable("inVar1", false, "String");
        ableVariable.setInitialValue((AbleRd)ableRuleSet.findOrCreateStringLiteral("apples"));
        ableVariable = ableRuleSet.declareGlobalVariable("outVar1", false, "String");
        ableVariable.setInitialValue((AbleRd)ableRuleSet.findOrCreateStringLiteral("sauce"));
        ableRuleSet.addVariableToOutputSequence("outVar1");
        AbleRuleBlock ableRuleBlock = ableRuleSet.addRuleBlock("process", "void", "()", new Vector(), "Script", "rule block comment", new Hashtable());
        Vector<AbleStringLiteral> vector3 = new Vector<AbleStringLiteral>();
        vector3.add(ableRuleSet.findOrCreateStringLiteral("This is a test"));
        AbleRd ableRd = ableRuleSet.createRdObject(5, "println", vector3, null, null, null, null);
        AbleAssertionClause ableAssertionClause = new AbleAssertionClause(null, 10, ableRd);
        AbleAssertionRule ableAssertionRule = new AbleAssertionRule("rule1", (AbleRd)new AbleDoubleLiteral(4.0), ableAssertionClause);
        ableRuleSet.addRule(ableRuleBlock, (AbleRule)ableAssertionRule);
        AbleAssertionRule ableAssertionRule2 = new AbleAssertionRule("rule2", (AbleRd)new AbleDoubleLiteral(4.0), ableAssertionClause);
        ableRuleSet.addRule(ableRuleBlock, (AbleRule)ableAssertionRule2);
        ableAssertionRule.setComment("rule comment");
        String string = "ruleX: if (true) then outVar1 = \"oranges\";";
        String string2 = "process";
        try {
            ableAssertionRule = ableRuleSet.parseRuleFromARL(string, string2, false);
        }
        catch (Exception exception) {
            System.out.println("Error " + exception.toString());
        }
        string = "tstRb1: invokeRuleBlock(\"postProcess\");";
        string2 = "process";
        try {
            ableAssertionRule = ableRuleSet.parseRuleFromARL(string, string2, false);
        }
        catch (Exception exception) {
            System.out.println("Error " + exception.toString());
        }
        string = "tstRb2: invokeRuleBlock(\"postProcessArml\");";
        string2 = "process";
        try {
            ableAssertionRule = ableRuleSet.parseRuleFromARL(string, string2, false);
        }
        catch (Exception exception) {
            System.out.println("Error " + exception.toString());
        }
        String string3 = "/** added via API parseRuleBlockFromARL */ \n void postProcess() using Script { : println(\"in postProcess\"); \n }";
        try {
            ableRuleBlock = ableRuleSet.parseRuleBlockFromARL(string3);
        }
        catch (Exception exception) {
            System.out.println("Error " + exception.toString());
        }
        String string4 = "100.9 - 50 * 10 / 23.4";
        try {
            ableRd = ableRuleSet.parseExpressionFromARL(string4);
        }
        catch (Exception exception) {
            System.out.println("Error " + exception.toString());
        }
        System.out.println("and the answer to " + ((AbleExpression)ableRd).arlCRdString() + " is " + ((AbleExpression)ableRd).getNumericValue());
        System.out.println(ableRuleSet.arlString());
        String string5 = "<IfThenElseRule label=\"ruleY\" comment=\"\">  <if>     <expression>  true</expression>  </if>  <then>    <action>outVar1 = &quot;peaches&quot;</action>  </then>  <else>  </else> </IfThenElseRule>";
        string2 = "process";
        try {
            ableAssertionRule = ableRuleSet.parseRuleFromARML(string5, string2, false);
        }
        catch (Exception exception) {
            System.out.println("Error " + exception.toString());
            exception.printStackTrace();
        }
        String string6 = "<ruleBlock name=\"postProcessArml\" returnType=\"void\" engine=\"Script\" comment=\" added via API\">   <parameters>   </parameters>  <AssertionRule label=\"\" comment=\"\">  <assert>println(&quot;in postProcessArml&quot;)</assert>  </AssertionRule> </ruleBlock>";
        try {
            ableRuleBlock = ableRuleSet.parseRuleBlockFromARML(string6);
        }
        catch (Exception exception) {
            System.out.println("Error " + exception.toString());
        }
        String string7 = "<expression>  outVar1 = \"apples\" </expression>";
        try {
            ableRd = ableRuleSet.parseExpressionFromARML(string7);
        }
        catch (Exception exception) {
            System.out.println("Error " + exception.toString());
        }
        System.out.println("and the answer to " + ((AbleExpression)ableRd).arlCRdString() + " is " + ((AbleExpression)ableRd).getStringValue());
        System.out.println(ableRuleSet.armlString());
    }
}

