/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.genetic;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleUserDefinedFunction;
import com.ibm.able.beans.AbleGeneticObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class TstGeneticFunction2a
extends AbleGeneticObject {
    protected static final long serialVersionUID = 2001100500100300000L;
    private static final double RANGE = 200.0;
    private static final double RANGE_MIN = -100.0;
    private static final double RANGE_MAX = 100.0;
    public static final double factor = 4.768372718899898E-5;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public TstGeneticFunction2a() {
        this.chromosomeLength = 2;
        this.vocabulary = "real";
        this.chromosomeType = array$D == null ? (array$D = TstGeneticFunction2a.class$("[D")) : array$D;
        this.crossoverRate = 0.25;
        this.mutationRate = 0.25;
    }

    public double getFitness() {
        return this.fitness;
    }

    public Object getRandomChromosome() {
        double[] dArray = new double[this.chromosomeLength];
        dArray[0] = 100.0 - Math.random() * 200.0;
        dArray[1] = 100.0 - Math.random() * 200.0;
        return dArray;
    }

    public double computeFitness() {
        if (this.fitnessComputed) {
            return this.fitness;
        }
        double d = ((double[])this.chromosome)[0];
        double d2 = ((double[])this.chromosome)[1];
        this.fitness = this.f6(d, d2);
        this.fitnessComputed = true;
        return this.fitness;
    }

    protected double f6(double d, double d2) {
        double d3 = 0.0;
        double d4 = d * d;
        double d5 = d2 * d2;
        double d6 = d4 + d5;
        double d7 = Math.pow(Math.sin(Math.sqrt(d6)), 2.0) - 0.5;
        double d8 = Math.pow(1.0 + 0.001 * d6, 2.0);
        d3 = 0.5 - d7 / d8;
        return d3;
    }

    public double[] mutateChromosome(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d = Math.random();
            int n2 = 0;
            if (!(d < this.mutationRate)) continue;
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(524288L, (Object)this, "mutateChromosome", "mutate bit position = " + i);
            }
            double d2 = 0.1 * (100.0 - Math.random() * 200.0);
            dArray[n2] = d2 + dArray[n2];
            if (dArray[n2] > 100.0) {
                dArray[n2] = 100.0;
                continue;
            }
            if (!(dArray[n2] < -100.0)) continue;
            dArray[n2] = -100.0;
        }
        return dArray;
    }

    public Object[] onePointCrossoverAndMutate(Object[] objectArray) {
        double d;
        Object[] objectArray2 = new Object[2];
        double[] dArray = (double[])objectArray[0];
        double[] dArray2 = (double[])objectArray[1];
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(524288L, (Object)this, "onePointCrossoverAndMutate", "parent1 chromosome = " + dArray[0] + ", " + dArray[1]);
            Able.TraceLog.text(524288L, (Object)this, "onePointCrossoverAndMutate", "parent2 chromosome = " + dArray2[0] + ", " + dArray2[1]);
        }
        if ((d = Math.random()) < this.crossoverRate) {
            double d2 = dArray[0];
            double d3 = dArray[1];
            double d4 = dArray2[0];
            double d5 = dArray2[1];
            dArray[0] = d2;
            dArray[1] = d5;
            dArray2[0] = d4;
            dArray2[1] = d3;
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(524288L, (Object)this, "onePointCrossoverAndMutate", "c1 crossover chromosome = " + dArray[0] + ", " + dArray[1]);
                Able.TraceLog.text(524288L, (Object)this, "onePointCrossoverAndMutate", "c2 crossover chromosome = " + dArray2[0] + ", " + dArray2[1]);
            }
        }
        dArray = this.mutateChromosome(dArray);
        dArray2 = this.mutateChromosome(dArray2);
        objectArray2[0] = dArray;
        objectArray2[1] = dArray2;
        return objectArray2;
    }

    public Object[] average(Object[] objectArray) {
        Object[] objectArray2 = new Object[2];
        double[] dArray = (double[])objectArray[0];
        double[] dArray2 = (double[])objectArray[1];
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(524288L, (Object)this, "average", "parent1 chromosome = " + dArray[0] + ", " + dArray[1]);
            Able.TraceLog.text(524288L, (Object)this, "average", "parent2 chromosome = " + dArray2[0] + ", " + dArray2[1]);
        }
        Math.random();
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray2[0];
        double d4 = dArray2[1];
        dArray[0] = (d + d3) / 2.0;
        dArray2[1] = (d2 + d4) / 2.0;
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(524288L, (Object)this, "average", "c1 crossover chromosome = " + dArray[0] + ", " + dArray[1]);
            Able.TraceLog.text(524288L, (Object)this, "average", "c2 crossover chromosome = " + dArray2[0] + ", " + dArray2[1]);
        }
        objectArray2[0] = dArray;
        objectArray2[1] = dArray2;
        return objectArray2;
    }

    public Hashtable getOperatorFitness() throws AbleException {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        if (this.searchAgent != null) {
            this.searchAgent.getUserDefinedFunctions();
            Hashtable hashtable2 = this.searchAgent.getUserDefinedFunctions();
            Enumeration enumeration = hashtable2.keys();
            Double d = new Double(100.0 / (double)hashtable2.size());
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                AbleUserDefinedFunction ableUserDefinedFunction = (AbleUserDefinedFunction)hashtable2.get(k);
                hashtable.put(ableUserDefinedFunction.getNameWithArity(), d);
            }
        }
        return hashtable;
    }

    public void registerOperators(AbleAgent ableAgent) {
        this.searchAgent = ableAgent;
        try {
            AbleUserDefinedFunction ableUserDefinedFunction = new AbleUserDefinedFunction("onePointCrossoverAndMutate", (Object)this, "onePointCrossoverAndMutate", new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = TstGeneticFunction2a.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object});
            ableAgent.addUserDefinedFunction(ableUserDefinedFunction);
            ableUserDefinedFunction = new AbleUserDefinedFunction("average", (Object)this, "average", new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = TstGeneticFunction2a.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object});
            ableAgent.addUserDefinedFunction(ableUserDefinedFunction);
        }
        catch (Exception exception) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "registerOperators()", "AbleGeneticObject Error: can't create UserDefinedFunction for operator " + exception.getLocalizedMessage());
                Able.TraceLog.exception(262144L, (Object)this, "registerOperators()", (Throwable)exception);
            }
            Able.MessageLog.text(4L, (Object)this, "registerOperators()", exception.getLocalizedMessage());
        }
    }

    public String toString() {
        return new String(((double[])this.chromosome)[0] + "," + ((double[])this.chromosome)[1] + ": " + String.valueOf(this.fitness));
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

