/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.conversation;

import com.ibm.able.AbleBean;
import com.ibm.able.AbleException;
import com.ibm.able.conversation.AbleConversationManager;
import com.ibm.able.conversation.AblePlatformConversationAgent;
import com.ibm.able.examples.conversation.AbleChat3GuiLogic;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;
import javax.agent.AgentName;
import javax.agent.Locator;
import javax.agent.service.directory.AgentDescription;

public class ChatterboxAgent2
extends AblePlatformConversationAgent {
    public static final String ABLE_AGENT_TYPE = "Chatterbox";
    int totalConversations = 1;
    int conversationCount = 0;
    boolean testMessageEnabled = false;
    boolean conversationEnabled = true;
    AbleChat3GuiLogic chat3DecisionLogic = null;

    public ChatterboxAgent2(String string) throws RemoteException, AbleException {
        super(string);
        this.setAgentType(ABLE_AGENT_TYPE);
        this.chat3DecisionLogic = new AbleChat3GuiLogic((AbleBean)this);
    }

    public int getTotalConversations() {
        return this.totalConversations;
    }

    public void setTotalConversations(int n) {
        this.totalConversations = n;
    }

    public boolean isConversationEnabled() {
        return this.conversationEnabled;
    }

    public boolean isTestMessageEnabled() {
        return this.testMessageEnabled;
    }

    public void setConversationEnabled(boolean bl) {
        this.conversationEnabled = bl;
    }

    public void setTestMessageEnabled(boolean bl) {
        this.testMessageEnabled = bl;
    }

    public void init() throws AbleException {
        super.init();
        this.getLogger().text(1L, (Object)this, "init", "[" + this.getName() + "] CPs loaded: " + this.listKnownCpNames());
        super.installTargetForCp("Chat3", "Role1", (Object)this.chat3DecisionLogic);
        super.installTargetForCp("Chat3", "Role2", (Object)this.chat3DecisionLogic);
    }

    public void process() throws AbleException {
        boolean bl;
        super.process();
        boolean bl2 = this.decideToSendTestMessage();
        boolean bl3 = bl = bl2 ? false : this.decideToStartConversation();
        if (bl) {
            this.logMessage(1L, "process", "decided to start conversation");
        } else if (bl2) {
            this.logMessage(1L, "process", "decided to send test message");
        }
        AgentDescription agentDescription = null;
        if ((bl2 || bl) && (agentDescription = this.selectConversationPartner()) == null) {
            this.logMessage(1L, "process", "no partner found");
        }
        if (bl2 && agentDescription != null) {
            this.logMessage(1L, "process", "sending test message");
            this.sendTestMessage(agentDescription);
        } else if (bl && agentDescription != null) {
            this.logMessage(1L, "process", "starting conversation");
            ++this.conversationCount;
            this.startConversation(agentDescription, "Chat3", "Role1");
        }
    }

    protected boolean decideToSendTestMessage() {
        return this.testMessageEnabled;
    }

    protected boolean decideToStartConversation() {
        if (this.conversationCount < this.totalConversations) {
            return this.conversationEnabled;
        }
        return false;
    }

    protected AgentDescription selectConversationPartner() {
        String string = "com.ibm.able.platform.agent-type";
        String string2 = ABLE_AGENT_TYPE;
        AgentDescription[] agentDescriptionArray = null;
        try {
            agentDescriptionArray = this.lookUpAgent(string, string2);
        }
        catch (Exception exception) {
            this.logException("selectConversationPartner", exception);
        }
        AgentDescription agentDescription = null;
        if (agentDescriptionArray != null && agentDescriptionArray.length > 0) {
            int n;
            Vector<AgentDescription> vector = new Vector<AgentDescription>();
            for (n = 0; n < agentDescriptionArray.length; ++n) {
                if (this.myJasAgentName.equals(agentDescriptionArray[n].getAgentName())) continue;
                vector.add(agentDescriptionArray[n]);
            }
            if (vector.size() > 0) {
                n = (int)(Math.random() * (double)vector.size());
                agentDescription = (AgentDescription)vector.elementAt(n);
            }
        }
        return agentDescription;
    }

    protected void sendTestMessage(AgentDescription agentDescription) {
        AgentName agentName = agentDescription.getAgentName();
        Locator locator = ChatterboxAgent2.getLocatorForType((AgentDescription)agentDescription, (String)"rmi");
        if (locator != null) {
            try {
                this.sendTransportMessage(locator, agentName, "Hello, partner!");
            }
            catch (Exception exception) {
                this.logException("sendTestMessage", exception);
            }
        }
    }

    public String listKnownCpNames() {
        AbleConversationManager ableConversationManager = this.conversationManager;
        Iterator iterator = ableConversationManager.getConversationPolicyHandlerFactory().getPolicyNames().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        String string = " ";
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

