/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.conversation;

import com.ibm.conversation.Conversation;
import com.ibm.conversation.ConversationContext;
import com.ibm.conversation.ConversationException;
import com.ibm.conversation.DecisionDataHandle;
import com.ibm.conversation.base.BasicDecisionDataHandle;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AbleChat3Panel
extends JPanel
implements ActionListener {
    private static final String SEND = "send";
    private static final String QUIT = "quit";
    private static final int PREFERRED_WIDTH = 400;
    private static final int PREFERRED_HEIGHT = 300;
    Conversation conv = null;
    boolean inputEnabled = true;
    JTextArea input = null;
    JTextArea transcript = null;
    JButton send = null;
    JButton quit = null;

    public AbleChat3Panel() {
        this.loadPane();
    }

    public AbleChat3Panel(Conversation conversation) {
        this.conv = conversation;
        this.loadPane();
    }

    protected void loadPane() {
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new BoxLayout(this, 1));
        this.transcript = new JTextArea();
        this.transcript.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.transcript);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Transcript"));
        this.add(jScrollPane);
        this.input = new JTextArea();
        JScrollPane jScrollPane2 = new JScrollPane(this.input);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("Type your messages here"));
        this.add(jScrollPane2);
        this.send = new JButton("Send");
        this.send.setActionCommand(SEND);
        this.send.addActionListener(this);
        this.quit = new JButton("Quit");
        this.quit.setActionCommand(QUIT);
        this.quit.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.send);
        jPanel.add(this.quit);
        this.add(jPanel);
    }

    public boolean isInputEnabled() {
        return this.inputEnabled;
    }

    public void setInputEnabled(boolean bl) {
        this.inputEnabled = bl;
        this.send.setEnabled(this.inputEnabled);
        this.quit.setEnabled(this.inputEnabled);
        this.input.setEnabled(this.inputEnabled);
    }

    public String getSelfAlias() {
        return "<self>";
    }

    public String getPartnerAlias() {
        return "<partner>";
    }

    public void appendSelfMessage(String string) {
        this.transcript.append(this.getSelfAlias() + string.trim() + "\n");
    }

    public void appendPartnerMessage(String string) {
        this.transcript.append(this.getPartnerAlias() + string.trim() + "\n");
    }

    public void clear() {
        this.transcript.setText("");
    }

    public void ensureVisible() {
        this.printDebug("ensureVisible");
        Container container = this.getTopLevelAncestor();
        if (container == null) {
            this.printDebug("unable to show Frame. top level ancestor is null.");
            this.setVisible(true);
        } else if (container instanceof Window) {
            Window window = (Window)container;
            window.toFront();
            window.setVisible(true);
        } else {
            this.printDebug("unable to show Frame. top level ancestor is a " + container.getClass().getName());
            this.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null) {
            if (string.equals(SEND)) {
                this.send();
            } else if (string.equals(QUIT)) {
                this.quit();
            }
        }
    }

    public void send() {
        if (this.conv == null) {
            return;
        }
        ConversationContext conversationContext = this.conv.getContext();
        String string = conversationContext.getActiveSelfRole();
        String string2 = conversationContext.getActiveStateName();
        String string3 = this.input.getText();
        if (string2 == null || string == null) {
            return;
        }
        if (string2.equals("start") && string.equals("Role1")) {
            this.begin(string3);
            this.appendSelfMessage(string3);
            this.input.setText("");
        } else if (string2.equals("role1Active") && string.equals("Role1")) {
            this.continue1(string3);
            this.appendSelfMessage(string3);
            this.input.setText("");
        } else if (string2.equals("role2Active") && string.equals("Role2")) {
            this.continue2(string3);
            this.appendSelfMessage(string3);
            this.input.setText("");
        } else {
            this.printDebug("send: illegal state.");
        }
    }

    public void quit() {
        if (this.conv == null) {
            return;
        }
        ConversationContext conversationContext = this.conv.getContext();
        String string = conversationContext.getActiveSelfRole();
        String string2 = conversationContext.getActiveStateName();
        if (string2 == null || string == null) {
            this.printDebug("quit: null pointers.");
            return;
        }
        if (string2.equals("role1Active") && string.equals("Role1")) {
            this.halt1();
            this.input.setText("");
            this.setInputEnabled(false);
        } else if (string2.equals("role2Active") && string.equals("Role2")) {
            this.halt2();
            this.input.setText("");
            this.setInputEnabled(false);
        } else {
            this.printDebug("quit: illegal state.");
        }
    }

    protected void begin(String string) {
        String string2 = "begin";
        Object[] objectArray = new Object[]{string};
        BasicDecisionDataHandle basicDecisionDataHandle = new BasicDecisionDataHandle(string2, objectArray);
        try {
            this.conv.processDecision((DecisionDataHandle)basicDecisionDataHandle);
        }
        catch (ConversationException conversationException) {
            this.printDebug(conversationException.getMessage());
        }
    }

    protected void continue1(String string) {
        String string2 = null;
        Object[] objectArray = null;
        string2 = "continue1";
        objectArray = new Object[]{string};
        BasicDecisionDataHandle basicDecisionDataHandle = new BasicDecisionDataHandle(string2, objectArray);
        try {
            this.conv.processDecision((DecisionDataHandle)basicDecisionDataHandle);
        }
        catch (ConversationException conversationException) {
            this.printDebug(conversationException.getMessage());
        }
    }

    protected void halt1() {
        String string = null;
        Object[] objectArray = null;
        string = "halt1";
        String string2 = "bye for now";
        objectArray = new Object[]{string2};
        BasicDecisionDataHandle basicDecisionDataHandle = new BasicDecisionDataHandle(string, objectArray);
        try {
            this.conv.processDecision((DecisionDataHandle)basicDecisionDataHandle);
        }
        catch (ConversationException conversationException) {
            this.printDebug(conversationException.getMessage());
        }
    }

    protected void continue2(String string) {
        String string2 = null;
        Object[] objectArray = null;
        string2 = "continue2";
        objectArray = new Object[]{string};
        BasicDecisionDataHandle basicDecisionDataHandle = new BasicDecisionDataHandle(string2, objectArray);
        try {
            this.conv.processDecision((DecisionDataHandle)basicDecisionDataHandle);
        }
        catch (ConversationException conversationException) {
            this.printDebug(conversationException.getMessage());
        }
    }

    protected void halt2() {
        String string = null;
        Object[] objectArray = null;
        string = "halt2";
        String string2 = "bye for now";
        objectArray = new Object[]{string2};
        BasicDecisionDataHandle basicDecisionDataHandle = new BasicDecisionDataHandle(string, objectArray);
        try {
            this.conv.processDecision((DecisionDataHandle)basicDecisionDataHandle);
        }
        catch (ConversationException conversationException) {
            this.printDebug(conversationException.getMessage());
        }
    }

    public void printDebug(String string) {
        System.out.println("AbleChat3Panel: " + string);
    }

    public static void main(String[] stringArray) {
        AbleChat3Panel ableChat3Panel = new AbleChat3Panel();
        JFrame jFrame = new JFrame("AbleChatPane");
        jFrame.setContentPane(ableChat3Panel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

