/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.ablebean;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizer;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.examples.ablebean.SimpleAbleBean;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class SimpleAbleBeanCustomizer
extends JPanel
implements AbleCustomizer,
AbleCustomizerPanel {
    private SimpleAbleBean myBean = null;
    private JTextField myTextField = null;
    private PropertyChangeSupport myChgSupport = null;

    public SimpleAbleBeanCustomizer() {
        this.initializePanel();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SimpleAbleBean simpleAbleBean = new SimpleAbleBean();
            SimpleAbleBeanCustomizer simpleAbleBeanCustomizer = new SimpleAbleBeanCustomizer();
            simpleAbleBeanCustomizer.setObject((Object)simpleAbleBean);
            AbleObjectCustomizer ableObjectCustomizer = new AbleObjectCustomizer();
            ableObjectCustomizer.addPanel((AbleCustomizerPanel)simpleAbleBeanCustomizer);
            ableObjectCustomizer.setVisible(true);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getLocalizedMessage(), "SimpleAbleBeanCustomizer()", 0);
        }
    }

    public void setObject(Object object) {
        if (this.myChgSupport == null) {
            this.myChgSupport = new PropertyChangeSupport(object);
        }
        this.myBean = (SimpleAbleBean)((Object)object);
        this.myTextField.setText(this.myBean.getSimpleBeanColor());
    }

    public void updateObject() throws RemoteException {
        try {
            String string = this.myTextField.getText().trim();
            if (string.length() == 0) {
                throw new RemoteException("Blank input provided on Simple Bean panel.");
            }
            this.myBean.setSimpleBeanColor(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Error on Simple Bean panel." + Able.LS + nullPointerException.getLocalizedMessage());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myChgSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myChgSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "examples/ablebean/doc-files/SimpleAbleBeanHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private void initializePanel() {
        this.add(new JLabel("Color:"));
        this.myTextField = new JTextField(10);
        this.add(this.myTextField);
        JButton jButton = new JButton("Reset");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleAbleBeanCustomizer.this.ResetButton_actionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText("Reset color to magenta");
        this.add(jButton);
    }

    void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.updateObject();
            this.myBean.reset();
            this.setObject((Object)this.myBean);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "SimpleAbleBeanCustomizer Error: ResetButton()", 0);
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

