/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.ablebean;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleEventListener;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.examples.ableagent.SimpleAbleAgent;
import com.ibm.able.examples.ablebean.SimpleAbleBean;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class SimpleAbleApp
implements AbleEventListener,
PropertyChangeListener {
    private SimpleAbleBean myBean = null;
    private SimpleAbleAgent myAgent = null;

    private SimpleAbleApp() {
    }

    public static void main(String[] stringArray) {
        Able.startMessageAndTraceLogging();
        SimpleAbleApp simpleAbleApp = new SimpleAbleApp();
        Able.MessageLog.text(4L, "Starting test");
        simpleAbleApp.test();
    }

    private void test() {
        block2: {
            try {
                this.myBean = new SimpleAbleBean("bean1");
                this.myAgent = new SimpleAbleAgent("agent");
                new AbleBufferConnection((AbleBean)this.myAgent, (AbleBean)this.myBean);
                this.myAgent.addAbleEventListener(this);
                this.myBean.addPropertyChangeListener(this);
                Object[] objectArray = (String[])this.myAgent.getOutputBuffer();
                Able.MessageLog.text(4L, "initial Agent color property   = " + this.myAgent.getSimpleBeanColor());
                Able.MessageLog.text(4L, "initial Agent output Buffer = " + SimpleAbleApp.displayBuffer(objectArray));
                Object[] objectArray2 = (String[])this.myBean.getOutputBuffer();
                Able.MessageLog.text(4L, "initial Bean color property   = " + this.myBean.getSimpleBeanColor());
                Able.MessageLog.text(4L, "initial Bean output Buffer = " + SimpleAbleApp.displayBuffer(objectArray2));
                Able.MessageLog.text(4L, "Let agent autonomous thread drive processing from this point. ");
                this.delay(30);
                this.myAgent.quitAll();
                this.myBean.removePropertyChangeListener(this);
                this.myAgent.removeAbleEventListener(this);
            }
            catch (AbleException ableException) {
                Able.MessageLog.text(4L, ableException.getLocalizedMessage());
                if (!Able.TraceLog.isLogging()) break block2;
                Able.TraceLog.exception(262144L, (Object)this, "test", (Throwable)ableException);
            }
        }
        Able.MessageLog.text(4L, "Done!");
    }

    protected static String displayBuffer(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("Buffer: ");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i] + " ");
        }
        stringBuffer.append(Able.LS);
        return stringBuffer.toString();
    }

    protected static String displayBuffer(Object object) {
        if (object instanceof Object[]) {
            return SimpleAbleApp.displayBuffer((Object[])object);
        }
        return object.toString();
    }

    public void processAbleEvent(AbleEvent ableEvent) throws AbleException {
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.entry(524288L, (Object)this, "processAbleEvent");
        }
        if (ableEvent.getId() == 2) {
            Able.MessageLog.text(4L, "received AbleEvent " + ableEvent);
        } else if (ableEvent.getId() == 1) {
            Able.MessageLog.text(4L, "received DataChanged AbleEvent ");
            AbleObject ableObject = (AbleObject)ableEvent.getGenSource();
            Able.MessageLog.text(4L, ableObject.getClass().getName() + ": OutputBuffer = " + SimpleAbleApp.displayBuffer(ableObject.getOutputBufferAsStringArray()));
            Able.MessageLog.text(4L, ableObject.getClass().getName() + ": Event argObject = " + SimpleAbleApp.displayBuffer(ableEvent.getArgObject()));
            if (ableObject == this.myAgent) {
                this.myBean.process();
            }
        }
    }

    public void handleAbleEvent(AbleEvent ableEvent) throws AbleException {
        this.processAbleEvent(ableEvent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        AbleObject ableObject = (AbleObject)propertyChangeEvent.getSource();
        Able.MessageLog.text(4L, "received PropertyChangeEvent ");
        Able.MessageLog.text(4L, ableObject.getClass().getName() + ": Property '" + propertyChangeEvent.getPropertyName() + "' changed from '" + propertyChangeEvent.getOldValue() + "' to '" + propertyChangeEvent.getNewValue() + "'");
    }

    private void delay(int n) {
        try {
            Able.MessageLog.text(4L, "Test case pause for " + n + " seconds");
            Thread.sleep(n * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

