/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.ablebean;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.editor.AbleGridBagConstraints;
import com.ibm.able.examples.ablebean.AbleFileWatcher;
import com.ibm.able.examples.ablebean.AbleFileWatcherCustomizer;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AbleFileWatcherPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleFileWatcher myFileWatcher = null;
    private AbleFileWatcherCustomizer myCustomizer = null;
    private String myFileName = null;
    private JTextField myFileNameTextField = null;
    private JRadioButton myConditionModifiedRadioButton = null;
    private JRadioButton myConditionDeletedRadioButton = null;
    private JRadioButton myConditionThresholdRadioButton = null;
    private JTextField myThresholdTextField = null;
    private JLabel myFileSizeLabel = null;
    private JRadioButton myActionNoneRadioButton = null;
    private JRadioButton myActionAlertRadioButton = null;
    private JRadioButton myActionExecuteRadioButton = null;
    private JTextField myCommandTextField = null;
    private JRadioButton myActionNotifyRadioButton = null;
    private JButton myInitializeButton = null;
    private TextListener myTextListener = null;

    private AbleFileWatcherPanel() {
    }

    public AbleFileWatcherPanel(AbleFileWatcherCustomizer ableFileWatcherCustomizer) {
        this.myCustomizer = ableFileWatcherCustomizer;
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myFileWatcher == null) {
            this.myFileWatcher = (AbleFileWatcher)((Object)object);
        }
        this.myFileNameTextField.setText(this.myFileWatcher.getWatchFileName());
        switch (this.myFileWatcher.getCondition()) {
            case 0: {
                this.myConditionModifiedRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.myConditionDeletedRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.myConditionThresholdRadioButton.setSelected(true);
                break;
            }
        }
        this.myThresholdTextField.setText(String.valueOf(this.myFileWatcher.getThreshold()));
        this.myFileSizeLabel.setText("current length: " + this.myFileWatcher.length());
        switch (this.myFileWatcher.getAction()) {
            case 1: {
                this.myActionAlertRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.myActionExecuteRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.myActionNotifyRadioButton.setSelected(true);
                break;
            }
            case 0: {
                this.myActionNoneRadioButton.setSelected(true);
                break;
            }
        }
        this.myCommandTextField.setText(this.myFileWatcher.getCommand());
        this.setButtonStates();
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myFileWatcher.setWatchFileName(this.myFileNameTextField.getText().trim());
            if (this.myConditionModifiedRadioButton.isSelected()) {
                this.myFileWatcher.setCondition(0);
            } else if (this.myConditionDeletedRadioButton.isSelected()) {
                this.myFileWatcher.setCondition(1);
            } else if (this.myConditionThresholdRadioButton.isSelected()) {
                this.myFileWatcher.setCondition(2);
            }
            this.myFileWatcher.setThreshold(Long.parseLong(this.myThresholdTextField.getText().trim()));
            if (this.myActionAlertRadioButton.isSelected()) {
                this.myFileWatcher.setAction(1);
            } else if (this.myActionExecuteRadioButton.isSelected()) {
                this.myFileWatcher.setAction(2);
            } else if (this.myActionNotifyRadioButton.isSelected()) {
                this.myFileWatcher.setAction(3);
            } else {
                this.myFileWatcher.setAction(0);
            }
            this.myFileWatcher.setCommand(this.myCommandTextField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on File Watcher panel." + Able.LS + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on File Watcher panel." + Able.LS + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)new JLabel("File Name:"), new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.myFileNameTextField = new JTextField();
        this.myFileNameTextField.setToolTipText("Path and name of file to watch");
        this.add((Component)this.myFileNameTextField, new AbleGridBagConstraints(1, n, 2, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        JButton jButton = new JButton("Browse...");
        jButton.setToolTipText("Select a file or directory to watch");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleFileWatcherPanel.this.BrowseFileButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)jButton, new AbleGridBagConstraints(3, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        ++n;
        this.myTextListener = new TextListener();
        this.myFileNameTextField.getDocument().addDocumentListener(this.myTextListener);
        this.myInitializeButton = new JButton("Initialize");
        this.myInitializeButton.setToolTipText("Initialize the bean");
        this.myInitializeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleFileWatcherPanel.this.InitializeButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.myInitializeButton, new AbleGridBagConstraints(1, ++n, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 50, 10, 50), 100, 0));
        this.add((Component)this.getWatchPanel(), new AbleGridBagConstraints(0, ++n, 4, 4, 0.5, 0.5, 17, 1, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)this.getActionPanel(), new AbleGridBagConstraints(0, n += 4, 4, 4, 0.5, 0.5, 17, 1, new Insets(10, 5, 10, 5), 0, 0));
    }

    private JPanel getWatchPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Watch condition"));
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = -1;
        this.myConditionModifiedRadioButton = new JRadioButton("Modified");
        jPanel.add((Component)this.myConditionModifiedRadioButton, new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 50, 0));
        buttonGroup.add(this.myConditionModifiedRadioButton);
        this.myConditionDeletedRadioButton = new JRadioButton("Deleted");
        jPanel.add((Component)this.myConditionDeletedRadioButton, new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 50, 0));
        buttonGroup.add(this.myConditionDeletedRadioButton);
        this.myConditionThresholdRadioButton = new JRadioButton("Size threshold");
        jPanel.add((Component)this.myConditionThresholdRadioButton, new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 50, 0));
        buttonGroup.add(this.myConditionThresholdRadioButton);
        this.myThresholdTextField = new JTextField();
        jPanel.add((Component)this.myThresholdTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 5), 70, 0));
        this.myConditionThresholdRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AbleFileWatcherPanel.this.setButtonStates();
            }
        });
        this.myFileSizeLabel = new JLabel();
        jPanel.add((Component)this.myFileSizeLabel, new AbleGridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 70, 0));
        return jPanel;
    }

    private JPanel getActionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Action"));
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = -1;
        this.myActionNotifyRadioButton = new JRadioButton("Notify listeners");
        jPanel.add((Component)this.myActionNotifyRadioButton, new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        buttonGroup.add(this.myActionNotifyRadioButton);
        this.myActionAlertRadioButton = new JRadioButton("Show alert dialog");
        jPanel.add((Component)this.myActionAlertRadioButton, new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        buttonGroup.add(this.myActionAlertRadioButton);
        this.myActionExecuteRadioButton = new JRadioButton("Execute command");
        jPanel.add((Component)this.myActionExecuteRadioButton, new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        buttonGroup.add(this.myActionExecuteRadioButton);
        this.myCommandTextField = new JTextField();
        jPanel.add((Component)this.myCommandTextField, new AbleGridBagConstraints(1, n, 2, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.myActionNoneRadioButton = new JRadioButton("None");
        jPanel.add((Component)this.myActionNoneRadioButton, new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        buttonGroup.add(this.myActionNoneRadioButton);
        return jPanel;
    }

    private void addPropertyListeners() {
        this.myCustomizer.addPropertyChangeMethod("ableEventProcessingEnabled", this, "refreshPanel");
    }

    private void setButtonStates() {
        boolean bl = this.myFileNameTextField.getText().trim().length() > 0;
        this.myInitializeButton.setEnabled(bl);
    }

    private void BrowseFileButton_actionPerformed(ActionEvent actionEvent) {
        String string = AblePanelHelper.setTextFieldFromFileDialog((JTextField)this.myFileNameTextField, (String)this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void InitializeButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.updateProperties();
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myFileWatcher.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject((Object)this.myFileWatcher);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleFileWatcherPanel Error: InitializeButton()", 0);
        }
    }

    private void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.updateProperties();
            this.myFileWatcher.reset();
            this.myCustomizer.setObject((Object)this.myFileWatcher);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleFileWatcherPanel Error: ResetButton()", 0);
        }
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.getDataFromBean((Object)this.myFileWatcher);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog((Component)((Object)this.myCustomizer), "Panel values for training changed, but were not updated." + Able.LS + remoteException.toString(), "AbleFileWatcherPanel Warning: refreshPanel()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "examples/ablebean/doc-files/AbleFileWatcherHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class TextListener
    implements DocumentListener {
        TextListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AbleFileWatcherPanel.this.setButtonStates();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbleFileWatcherPanel.this.setButtonStates();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbleFileWatcherPanel.this.setButtonStates();
        }
    }
}

