/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.ablebean;

import com.ibm.able.Able;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import java.awt.Dialog;
import java.io.File;
import javax.swing.JOptionPane;

public class AbleFileWatcher
extends AbleObject {
    protected static final long serialVersionUID = 2001100500100300000L;
    public static final int FILE_MODIFIED = 0;
    public static final int FILE_DELETED = 1;
    public static final int FILE_THRESHOLD = 2;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_ALERT = 1;
    public static final int ACTION_EXECUTE = 2;
    public static final int ACTION_EVENT = 3;
    private int action = 3;
    private String command = "";
    private int condition = 0;
    private Dialog dialog = null;
    private File watchFile = null;
    private String watchFileName = null;
    private long lastModified = 0L;
    private long threshold = Long.MAX_VALUE;

    public AbleFileWatcher() throws AbleException {
        this("FileWatcher");
    }

    public AbleFileWatcher(String string) throws AbleException {
        super(string);
        this.reset();
        this.init();
    }

    public AbleFileWatcher(String string, String string2) throws AbleException {
        super(string);
        this.setWatchFileName(string2, false);
        this.reset();
        this.init();
    }

    public void setAction(int n) throws AbleException {
        this.firePropertyChange("fileWatcherAction", new Integer(this.action), new Integer(n));
        this.action = n;
    }

    public int getAction() {
        return this.action;
    }

    public void setCommand(String string) throws AbleException {
        this.firePropertyChange("fileWatcherCommand", this.command, string);
        string = this.command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCondition(int n) throws AbleException {
        this.firePropertyChange("fileWatcherCondition", new Integer(this.condition), new Integer(n));
        this.condition = n;
    }

    public int getCondition() {
        return this.condition;
    }

    public void setDialog(Dialog dialog) throws AbleException {
        this.firePropertyChange("fileWatcherDialog", this.dialog, dialog);
        this.dialog = dialog;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setWatchFileName(String string) throws AbleException {
        this.setWatchFileName(string, true);
    }

    private void setWatchFileName(String string, boolean bl) throws AbleException {
        this.watchFileName = string;
        this.watchFile = new File(string);
        this.lastModified = this.watchFile.lastModified();
        if (bl) {
            this.firePropertyChange("fileWatcherFileName", this.watchFileName, string);
        }
    }

    public String getWatchFileName() {
        return this.watchFileName;
    }

    public long getFileSize() {
        if (this.watchFile == null) {
            return 0L;
        }
        return this.watchFile.length();
    }

    public void setThreshold(long l) throws AbleException {
        this.firePropertyChange("fileWatcherThreshold", new Long(this.threshold), new Long(l));
        this.threshold = l;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public void reset() throws AbleException {
        this.action = 1;
        this.command = "";
        this.condition = 2;
        this.lastModified = this.watchFile == null ? 0L : this.watchFile.lastModified();
        this.threshold = Long.MAX_VALUE;
        this.setTimerEventProcessingEnabled(true);
        this.setSleepTime(5000L);
        this.setAbleEventProcessingEnabled(0);
        this.setDataFlowEnabled(false);
    }

    public void process() throws AbleException {
        if (this.checkCondition()) {
            this.performAction();
        }
    }

    public void processTimerEvent() throws AbleException {
        this.process();
    }

    public boolean checkCondition() {
        boolean bl = false;
        if (this.watchFile == null) {
            return bl;
        }
        switch (this.condition) {
            case 0: {
                bl = this.changed();
                break;
            }
            case 1: {
                bl = !this.exists();
                break;
            }
            case 2: {
                bl = this.watchFile.length() > this.threshold;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private void performAction() throws AbleException {
        switch (this.action) {
            case 0: {
                break;
            }
            case 1: {
                System.out.println(this.name + ": Alert fired " + Able.LS);
                if (this.dialog == null) {
                    Object[] objectArray = new Object[]{"Continue", "Quit"};
                    int n = JOptionPane.showOptionDialog(null, "Continue watching '" + this.watchFileName + "'?", "Continue?", 0, 3, null, objectArray, objectArray[1]);
                    if (n != 1) break;
                    this.quitEnabledEventProcessing();
                    break;
                }
                this.dialog.setVisible(true);
                break;
            }
            case 2: {
                System.out.println(this.name + ": Executing command " + Able.LS);
                try {
                    if (this.command.length() <= 0) break;
                    Able.run((String)this.command);
                }
                catch (Exception exception) {
                    System.out.println("Error: EXEC failed, " + exception.toString());
                    exception.printStackTrace();
                }
                break;
            }
            case 3: {
                this.notifyAbleEventListeners(new AbleEvent((Object)this, (Object)"watcher"));
                System.out.println(this.name + ": Event sent " + Able.LS);
                break;
            }
            default: {
                System.out.println("Invalid action specified.");
            }
        }
    }

    public String getDisplayString() {
        String string = new String();
        string = this.name + " fileName='" + this.watchFileName + "' cond='" + this.condition + "'";
        return string;
    }

    public boolean changed() {
        if (this.watchFile == null) {
            return false;
        }
        long l = this.lastModified;
        this.lastModified = this.watchFile.lastModified();
        return this.lastModified != l;
    }

    public boolean exists() {
        if (this.watchFile == null) {
            return false;
        }
        return this.watchFile.exists();
    }

    public boolean isDirectory() {
        if (this.watchFile == null) {
            return false;
        }
        return this.watchFile.isDirectory();
    }

    public long lastModified() {
        if (this.watchFile == null) {
            return 0L;
        }
        return this.watchFile.lastModified();
    }

    public long length() {
        if (this.watchFile == null) {
            return 0L;
        }
        return this.watchFile.length();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

