/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.ableagent;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizer;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleDefaultAgentCustomizer;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.examples.ableagent.SimpleAbleAgent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SimpleAbleAgentCustomizer
extends AbleDefaultAgentCustomizer {
    private SimpleAbleAgentPanel myAgentPanel = null;

    public SimpleAbleAgentCustomizer(JFrame jFrame, String string) {
        super(jFrame, string, false);
        this.setCustomizer((AbleCustomizer)this);
        this.myAgentPanel = new SimpleAbleAgentPanel(this);
        this.insertTab("Simple Able Agent", this.myAgentPanel, 1);
    }

    public SimpleAbleAgentCustomizer() {
        this(new JFrame(), "Simple Able Agent Customizer");
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SimpleAbleAgentCustomizer simpleAbleAgentCustomizer = new SimpleAbleAgentCustomizer();
            simpleAbleAgentCustomizer.setObject((Object)new SimpleAbleAgent());
            simpleAbleAgentCustomizer.setVisible(true);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), "SimpleAbleAgentCustomizer()", 0);
        }
    }

    public void setObject(Object object) {
        super.setObject(object);
        try {
            this.myAgentPanel.getDataFromBean((Object)((SimpleAbleAgent)((Object)object)));
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog((Component)((Object)this), remoteException.toString(), "SimpleAbleAgentCustomizer Error: setObject()", 0);
        }
    }

    public void updateObject() throws RemoteException {
        super.updateObject();
        this.myAgentPanel.setDataOnBean();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public class SimpleAbleAgentPanel
    extends JPanel
    implements AbleCustomizerPanel {
        private SimpleAbleAgent myAgent = null;
        private SimpleAbleAgentCustomizer myCustomizer = null;
        private JComboBox myColorComboBox = null;

        public SimpleAbleAgentPanel() {
        }

        public SimpleAbleAgentPanel(SimpleAbleAgentCustomizer simpleAbleAgentCustomizer2) {
            this.myCustomizer = simpleAbleAgentCustomizer2;
            this.setLayout(null);
            this.initializePanel();
            this.addPropertyListeners();
        }

        public void getDataFromBean(Object object) throws RemoteException {
            if (this.myAgent == null) {
                this.myAgent = (SimpleAbleAgent)((Object)object);
            }
            this.myColorComboBox.setSelectedItem(this.myAgent.getSimpleBeanColor());
        }

        public void setDataOnBean() throws RemoteException {
            try {
                this.myAgent.setSimpleBeanColor((String)this.myColorComboBox.getSelectedItem());
            }
            catch (NumberFormatException numberFormatException) {
                throw new RemoteException("Non-numeric input provided on Simple Agent panel." + Able.LS + numberFormatException.toString());
            }
            catch (NullPointerException nullPointerException) {
                throw new RemoteException("Blank input provided on Simple Agent panel." + Able.LS + nullPointerException.toString());
            }
        }

        private void initializePanel() {
            this.setLayout(new BorderLayout(0, 0));
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Color:"));
            JPanel jPanel2 = new JPanel();
            this.myColorComboBox = new JComboBox();
            for (int i = 0; i < SimpleAbleAgent.colors.length; ++i) {
                this.myColorComboBox.addItem(SimpleAbleAgent.colors[i]);
            }
            jPanel2.add(this.myColorComboBox);
            JPanel jPanel3 = new JPanel();
            jPanel3.add((Component)jPanel, "East");
            jPanel3.add((Component)jPanel2, "West");
            this.add((Component)jPanel3, "North");
            JPanel jPanel4 = new JPanel();
            AblePanelHelper.addButton((JPanel)jPanel4, (String)"Reset", (ActionListener)new ActionListener(this){
                private final /* synthetic */ SimpleAbleAgentPanel this$1;
                {
                    this.this$1 = simpleAbleAgentPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.ResetButton_actionPerformed(actionEvent);
                }
            }, (String)"Reset the simple agent");
            this.add((Component)jPanel4, "South");
        }

        private void addPropertyListeners() {
            this.myCustomizer.addPropertyChangeMethod("simpleBeanColor", this, "refreshPanel");
        }

        public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
            try {
                this.getDataFromBean((Object)this.myAgent);
            }
            catch (RemoteException remoteException) {
                JOptionPane.showMessageDialog((Component)((Object)this.myCustomizer), "Panel values for training changed, but were not updated." + Able.LS + remoteException.toString(), "AbleNeuralClassifierAgentPanel Warning: refreshPanel()", 2);
            }
        }

        void ResetButton_actionPerformed(ActionEvent actionEvent) {
            try {
                this.myCustomizer.updateProperties();
                this.myCustomizer.setIgnoreAnyPropertyChanges(true);
                this.myAgent.reset();
                this.myCustomizer.setIgnoreAnyPropertyChanges(false);
                this.myCustomizer.setObject((Object)this.myAgent);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.toString(), "SimpleAbleAgentCustomizer Error: ResetButton()", 0);
            }
        }

        public String getHelpFileName() {
            return AbleHelp.helpFilesPath + "examples/ableagent/doc-files/SimpleAbleAgentHelp.html";
        }

        public URL getHelpContext() {
            return Able.HomeUrl;
        }

        class ObjectPropertyChangeListener
        implements PropertyChangeListener {
            ObjectPropertyChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName().equals("simpleBeanColor")) {
                        SimpleAbleAgentPanel.this.getDataFromBean((Object)SimpleAbleAgentPanel.this.myAgent);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }
}

