/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.examples.ableagent;

import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;

public class SimpleAbleAgent
extends AbleDefaultAgent {
    protected static final long serialVersionUID = 2001100500100300000L;
    public static final String[] colors = new String[]{"red", "orange", "yellow", "green", "blue", "indigo", "violet"};
    private int colorIndex = 0;
    private String simpleBeanColor;

    public SimpleAbleAgent() throws AbleException {
        this("SimpleAgent");
    }

    public SimpleAbleAgent(String string) throws AbleException {
        super(string);
        this.inputBuffer = new String[1];
        this.outputBuffer = new String[1];
        this.reset();
        this.init();
    }

    public void init() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(262144L, (Object)this, "init", "Color = " + this.simpleBeanColor);
        }
        super.init();
    }

    public void reset() throws AbleException {
        this.setDataFlowEnabled(true);
        this.setSleepTime(5000L);
        this.setTimerEventProcessingEnabled(true);
        this.setAbleEventProcessingEnabled(0);
        this.colorIndex = 0;
        this.simpleBeanColor = colors[this.colorIndex];
    }

    public void process() throws AbleException {
        this.processBufferConnections();
        Object object = this.getInputBuffer(0);
        if (object != null) {
            this.setSimpleBeanColor((String)this.getInputBuffer(0));
        } else {
            this.colorIndex %= colors.length;
            this.setSimpleBeanColor(colors[this.colorIndex++]);
        }
        this.setOutputBuffer(0, this.simpleBeanColor);
        this.dataChanged(this.outputBuffer);
    }

    public void processTimerEvent() throws AbleException {
        this.process();
    }

    public void setSimpleBeanColor(String string) {
        String string2 = this.simpleBeanColor;
        this.simpleBeanColor = string;
        this.chgSupport.firePropertyChange("simpleBeanColor", string2, string);
    }

    public String getSimpleBeanColor() {
        return this.simpleBeanColor;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

