/*
 * DAML_S_Profile_Client.java
 *
 * Created on 02 October 2002, 12:46
 *
 */

package zeus.ontology.service;
import java.util.*;
import com.hp.hpl.jena.daml.*;
import com.hp.hpl.jena.daml.common.*;
import com.hp.hpl.jena.rdf.arp.*;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.lang.*;
import com.hp.hpl.mesa.rdf.jena.model.*;
import com.ibm.icu.text.*;

/**
 *DAML_S_Profile_Client is a datatype that contains the structures into which 
 *a service description is loaded and the code that loads it from a URI.
 *The motivation for writing this class was to provide a very easy and 
 *convienient way to access the information required about a service description 
 *of the sort generated by Zeus for the purpose of using it in matchmaking and 
 *service composition, so the functionality is rather limited, but it should be 
 *easy to use.
 * @author Simon Thompson
 */
public class DAML_S_Profile_Client {
    
    private Hashtable inputs = new Hashtable ();  
    private Hashtable outputs = new Hashtable ();  
    private Hashtable preconditions = new Hashtable ();   
    private Hashtable effects = new Hashtable () ;   
    
    private DAMLModel m; 
    
    /** 
     *included an anonymous init method to allow for easier extension / subclassing
     **/
    public DAML_S_Profile_Client () { 
        ;
    }
    
    
    /**
     * intialise with a uri and the class will load up the resource for you
     */
    public DAML_S_Profile_Client( String uri ) {
            try {
            m = new DAMLModelImpl();
            m.read( uri );
            if (! m.getLoadSuccessful()) {
                System.out.println( "Failed to load DAML document!" );
            }
            else {
                System.out.println("Parsed happily!!!!");
               // handleModel(m);
            }
            }
            catch (Throwable t) { 
                // has to be throwable because they have extended that rather than exception 
                // I don't think they mean that execution should be halted though!!
                
            }
    
    }
    
}
