/*
 * InformationPanel.java
 *
 * Created on 20 September 2002, 13:52
 */

package zeus.generator.task;
import zeus.concepts.*; 
/**
 *
 * @author  thompss
 */
public class InformationPanel extends javax.swing.JPanel {
    
    AbstractTask task; 
    /** Creates new form InformationPanel */
    public InformationPanel(AbstractTask task) {
        initComponents();
        this.task = task; 
        taskInfoArea.setText(task.getTextInfo());
        phoneTextArea.setText (task.getPhoneInfo());
        faxTextArea.setText (task.getFaxInfo());
        emailTextArea.setText (task.getEmailInfo());
        physicalTextArea.setText (task.getPhysicalInfo());
        geoTextArea.setText (task.getGeoInfo());
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        PanelLabel = new java.awt.Label();
        taskInfoLabel = new java.awt.Label();
        taskInfoArea = new javax.swing.JTextArea();
        saveButton = new javax.swing.JButton();
        phoneLabel = new java.awt.Label();
        phoneTextArea = new javax.swing.JTextArea();
        faxLabel = new java.awt.Label();
        faxTextArea = new javax.swing.JTextArea();
        emailLabel = new java.awt.Label();
        emailTextArea = new javax.swing.JTextArea();
        physicalLabel = new java.awt.Label();
        physicalTextArea = new javax.swing.JTextArea();
        geoTextArea = new javax.swing.JTextArea();
        geoLabel = new java.awt.Label();
        jSeparator1 = new javax.swing.JSeparator();
        jSeparator2 = new javax.swing.JSeparator();
        jSeparator3 = new javax.swing.JSeparator();

        setLayout(new java.awt.GridBagLayout());

        PanelLabel.setFont(new java.awt.Font("Arial Black", 0, 18));
        PanelLabel.setText("Service Description");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 12, 0);
        add(PanelLabel, gridBagConstraints);

        taskInfoLabel.setText("profile:textDescription");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(taskInfoLabel, gridBagConstraints);

        taskInfoArea.setColumns(20);
        taskInfoArea.setRows(1);
        taskInfoArea.setToolTipText("Enter textual task description");
        taskInfoArea.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                taskInfoAreaKeyTyped(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(taskInfoArea, gridBagConstraints);

        saveButton.setText("Save");
        saveButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                saveButtonMousePressed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(saveButton, gridBagConstraints);

        phoneLabel.setText("profile:phone");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(phoneLabel, gridBagConstraints);

        phoneTextArea.setColumns(20);
        phoneTextArea.setRows(1);
        phoneTextArea.setToolTipText("enter the phone number for your service (could be null)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(phoneTextArea, gridBagConstraints);

        faxLabel.setText("profile:fax");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(faxLabel, gridBagConstraints);

        faxTextArea.setColumns(20);
        faxTextArea.setRows(1);
        faxTextArea.setToolTipText(" (could be null)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(faxTextArea, gridBagConstraints);

        emailLabel.setText("profile:email");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(emailLabel, gridBagConstraints);

        emailTextArea.setColumns(20);
        emailTextArea.setRows(1);
        emailTextArea.setToolTipText("insert the services email@address");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(emailTextArea, gridBagConstraints);

        physicalLabel.setText("profile:physicalAddress");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(physicalLabel, gridBagConstraints);

        physicalTextArea.setColumns(20);
        physicalTextArea.setRows(1);
        physicalTextArea.setToolTipText("Enter the physical address of the service");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(physicalTextArea, gridBagConstraints);

        geoTextArea.setColumns(20);
        geoTextArea.setRows(1);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(geoTextArea, gridBagConstraints);

        geoLabel.setText("profile:geographicRadius");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(geoLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(18, 0, 16, 0);
        add(jSeparator1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 36;
        gridBagConstraints.insets = new java.awt.Insets(15, 0, 15, 0);
        add(jSeparator2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(31, 0, 31, 0);
        add(jSeparator3, gridBagConstraints);

    }//GEN-END:initComponents

    private void saveButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_saveButtonMousePressed
        task.setTextInfo(taskInfoArea.getText());
        task.setPhoneInfo(phoneTextArea.getText());
        task.setFaxInfo(faxTextArea.getText());
        task.setEmailInfo(emailTextArea.getText());
        task.setPhysicalInfo(physicalTextArea.getText());
        task.setGeoInfo(geoTextArea.getText());
    }//GEN-LAST:event_saveButtonMousePressed

    private void taskInfoAreaKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_taskInfoAreaKeyTyped
        // Add your handling code here:
    }//GEN-LAST:event_taskInfoAreaKeyTyped
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSeparator jSeparator3;
    private java.awt.Label emailLabel;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator1;
    private java.awt.Label PanelLabel;
    private javax.swing.JTextArea phoneTextArea;
    private java.awt.Label phoneLabel;
    private java.awt.Label geoLabel;
    private java.awt.Label taskInfoLabel;
    private java.awt.Label physicalLabel;
    private javax.swing.JTextArea faxTextArea;
    private java.awt.Label faxLabel;
    private javax.swing.JTextArea emailTextArea;
    private javax.swing.JTextArea physicalTextArea;
    private javax.swing.JButton saveButton;
    private javax.swing.JTextArea geoTextArea;
    private javax.swing.JTextArea taskInfoArea;
    // End of variables declaration//GEN-END:variables
    
}
