/*
 * The contents of this file are subject to the BT "ZEUS" Open Source
 * Licence (L77741), Version 1.0 (the "Licence"); you may not use this file
 * except in compliance with the Licence. You may obtain a copy of the Licence
 * from $ZEUS_INSTALL/licence.html or alternatively from
 * http://www.labs.bt.com/projects/agents/zeus/licence.htm
 *
 * Except as stated in Clause 7 of the Licence, software distributed under the
 * Licence is distributed WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the Licence for the specific language governing rights and
 * limitations under the Licence.
 *
 * The Original Code is within the package zeus.*.
 * The Initial Developer of the Original Code is British Telecommunications
 * public limited company, whose registered office is at 81 Newgate Street,
 * London, EC1A 7AJ, England. Portions created by British Telecommunications
 * public limited company are Copyright 1996-9. All Rights Reserved.
 *
 * THIS NOTICE MUST BE INCLUDED ON ANY COPY OF THIS FILE
 */



package zeus.generator.code;

import java.util.*;
import javax.swing.JTextArea;
import java.io.*;

import zeus.concepts.*;
import zeus.util.*;
import zeus.generator.GeneratorModel;

/** 
 *  TaskWriter is used to emit the code for either a primitive task or a rule based
 * task. Agents are then equiped with this task code. 
 * Since 1.3 there is an addition of a service description field, which is used to 
 * deploy a service description in the Agentcities (or other) infrastructure. 
 *@see zeus.ontology.services.DAML_S_Service; 
 */
public class TaskWriter extends Writer {
    public static final String CH = "_";
    
    public TaskWriter(GenerationPlan genplan, GeneratorModel genmodel,
    String directory, JTextArea textArea) {
        super(genplan,genmodel,directory,textArea);
    }
    
    public void write() {
        TaskInfo[] taskInfo = genplan.getSelectedTasks();
        if ( taskInfo.length == 0 ) return;
        textArea.append("\n*** Task code generation started ***\n\n");
        
        for(int i = 0; i < taskInfo.length; i++ ) {
            AbstractTask task = genmodel.getTask(taskInfo[i].id);
            String name = genmodel.getTaskName(taskInfo[i].id);
            textArea.append("Generating code for task " + name + "\n");
            if ( !task.isValid() )
                textArea.append("Task " + name + "is improperly specified\n");
            try {
                switch( task.getType() ) {
                    case AbstractTask.PRIMITIVE:
                        if (!taskInfo[i].task_external.equals( "null")) {
                            writePrimitiveTask(name,taskInfo[i].task_external,
                            (PrimitiveTask)task);}
                        else {
                            writePrimitiveTask (name,(PrimitiveTask)task); }
                        break;
                    case AbstractTask.BEHAVIOUR:
                        if (!taskInfo[i].task_external.equals( "null")) {
                            System.out.println("Externals ignored for Rulebased tasks...");
                            System.out.println("Continuing generation of rulebase task :" + name);
                            writeReteKB(name,(ReteKB)task);}
                        else {
                            writeReteKB (name,(ReteKB) task); }
                        break;
                }
                taskInfo[i].status = GenerationPlan.NO_SAVE_NEEDED;
                taskInfo[i].generate = false;
            }
            catch(IOException e) {
                System.err.println(e);
            }
        }
        textArea.append("\n*** Task code generation completed ***\n");
    }
    
    protected void writeReteKB(String name, ReteKB task)
    throws IOException {
        PrintWriter out = createFile(name + ".clp");
        out.println(standard_disclaimer);
        String old_name = task.getName();
        task.setName(name);
        out.println(task.pprint());
        task.setName(old_name);
        out.flush();
        out.close();
    }
    
    protected void writePrimitiveTask(String name, PrimitiveTask task)
    throws IOException {
        PrintWriter out = createFile(name + ".java");
        out.println(standard_disclaimer);
        out.println("/*");
        out.println("This stub file was automatically generated by " +
        "ZeusAgentGenerator version " +
        SystemProps.getProperty("version.id"));
        out.println("*/\n");
        out.println("import java.util.*;");
        out.println("import zeus.util.*;");
        out.println("import zeus.concepts.*;");
        out.println("import zeus.actors.TaskContext;");
        out.println("import zeus.actors.ZeusTask;");
        out.println();
        out.println("public class " + name + " extends ZeusTask {");
        out.println("   protected void exec() {");
        out.println("      /*");
        out.println("      Add the task execution code here. " +
        "The following variables are defined:");
        out.println("         protected Fact[][]  inputArgs; ");
        out.println("         protected Fact[][]  outputArgs; ");
        out.println("      Before exec() is called inputArgs will " +
        "contain the input");
        out.println("      Facts consumed by the task. After execution, " +
        "set outputArgs to ");
        out.println("      contain the output Facts produced by the task.");
        out.println("      */");
        out.println();
        out.println("      // The Input Facts:");
        out.println();
        
        Fact[] input = task.getPreconditions();
        for(int k = 0; k < input.length; k++ )
            out.println("      Fact[] " + CH + input[k].ID() + " = inputArgs[" +
            k + "];\t// " + input[k].getType());
        
        out.println();
        out.println("      // The Output Facts:");
        out.println();
        
        Fact[] output = task.getPostconditions();
        for(int k = 0; k < output.length; k++ )
            out.println("      Fact[] " + CH + output[k].ID() + ";\t// " +
            output[k].getType());
        out.println();
        out.println("      /* USER CODE STARTS */");
        out.println();
        out.println("      System.out.println(\"-Expected Input-\");");
        out.println("      for(int i = 0; i < expInputArgs.length; i++ )");
        out.println("         System.out.println(expInputArgs[i].pprint());");
        out.println();
        out.println("      System.out.println(\"-Input-\");");
        out.println("      for(int j = 0; j < inputArgs.length; j++) {");
        out.println("         System.out.println(\"Input Fact[\"+j+\"]\");");
        out.println("         for(int i = 0; i < inputArgs[j].length; i++)");
        out.println("            System.out.println(inputArgs[j][i].pprint());");
        out.println("      }");
        out.println();
        out.println("      System.out.println(\"-Expected Output-\");");
        out.println("      for(int i = 0; i < expOutputArgs.length; i++ )");
        out.println("         System.out.println(expOutputArgs[i].pprint());");
        out.println();
        out.println("      System.out.println(\"-Output-\");");
        
        for(int k = 0; k < output.length; k++ ) {
            out.println("      " + CH + output[k].ID() + " = new Fact[1];");
            out.println("      " + CH + output[k].ID() + "[0] = new Fact(Fact.FACT,expOutputArgs[" + k + "]);");
            out.println("      System.out.println(" + CH + output[k].ID() + "[0].pprint());");
        }
        out.println();
        out.println("      /* USER CODE ENDS */");
        out.println("      outputArgs = new Fact[" + output.length + "][];");
        for(int k = 0; k < output.length; k++ )
            out.println("      outputArgs[" + k + "] = " + CH + output[k].ID() + ";");
        out.println("   }");
        out.println("}");
        out.flush();
        out.close();
    }
    
    
    protected void writePrimitiveTask(String name, String task_external,
				      PrimitiveTask task) throws IOException {

        PrintWriter out = createFile(name + ".java");
        out.println(standard_disclaimer);
        out.println("/*");
        out.println("This stub file was automatically generated by " +
        "ZeusAgentGenerator version " +
        SystemProps.getProperty("version.id"));
        out.println("*/\n");
        out.println(" /* Do not edit this class, it has a TaskExternal : " + task_external);
        out.println (" which it will call when it is executed. Add the code that you want ");
        out.println (" to be executed when this task is run there instead. */");
        out.println ();
        out.println("import java.util.*;");
        out.println("import zeus.util.*;");
        out.println("import zeus.concepts.*;");
        out.println("import zeus.actors.ZeusTask;");
        out.println("import zeus.actors.TaskContext;");
	out.println("import zeus.actors.TaskExternal;");
	out.println("import zeus.ontology.service.*;");
        
        out.println();
        out.println("public class " + name + " extends ZeusTask {\n");

	out.println("   protected TaskExternal taskExternal;\n");

        out.println("   protected void exec() {");
        out.println();
        out.println("      // The Input Facts:");
        out.println();
        
        Fact[] input = task.getPreconditions();
        for(int k = 0; k < input.length; k++ )
            out.println("      Fact[] " + CH + input[k].ID() + " = inputArgs[" +
            k + "];\t// " + input[k].getType());
        
        out.println();
        out.println("      // The Output Facts:");
        out.println();
        
        Fact[] output = task.getPostconditions();
        for(int k = 0; k < output.length; k++ )
            out.println("      Fact[] " + CH + output[k].ID() + ";\t// " +
            output[k].getType());
        
        out.println("      System.out.println(\"-Expected Input-\");");
        out.println("      for(int i = 0; i < expInputArgs.length; i++ )");
        out.println("         System.out.println(expInputArgs[i].pprint());");
        out.println();
        out.println("      System.out.println(\"-Input-\");");
        out.println("      for(int j = 0; j < inputArgs.length; j++) {");
        out.println("         System.out.println(\"Input Fact[\"+j+\"]\");");
        out.println("         for(int i = 0; i < inputArgs[j].length; i++)");
        out.println("            System.out.println(inputArgs[j][i].pprint());");
        out.println("      }");
        out.println();
        out.println("     // calling user defined zeus.concepts.TaskExternal");
        out.println ("    // first set the TaskContext object up ");
        out.println("     TaskContext taskContext = new TaskContext(); ");
        out.println("     taskContext.setAgentContext (this.context);");
        out.println("     taskContext.setExpInputArgs (expInputArgs); ");
        out.println("     taskContext.setInputArgs (inputArgs); ");
        out.println("     taskContext.setExpOutputArgs (expOutputArgs); ");
        // insertion MS 170101 v1.05
        out.println();
        out.println("     outputArgs = new Fact [expOutputArgs.length][];");
        out.println();
        out.println("     for (int k=0; k<expOutputArgs.length; k++) {");
        out.println("         outputArgs[k] = new Fact[1];");
        out.println("         outputArgs[k][0] = new Fact(Fact.FACT, expOutputArgs[k]);");
        out.println("     }");
        out.println();
        // end of insertion
        out.println("     taskContext.setOutputArgs (outputArgs); ");
        
        out.println("     // now initialise the external object ") ;
	out.println("     if(taskExternal == null) {");
	out.println("       taskExternal = new " + task_external + "();");
	out.println("     }");
        out.println("     // now call the TaskExternal implementation specified for this task");
        out.println("     taskExternal.exec(taskContext); ");
        out.println();
        
        out.println("     System.out.println(\"-Expected Output-\");");
        out.println("     for(int i = 0; i < expOutputArgs.length; i++ )");
        out.println("        System.out.println(expOutputArgs[i].pprint());");
        out.println();
        // inserted MS 160101 v1.05
        out.println("     outputArgs = taskContext.getOutputArgs();");
        out.println();
        // end of insertion
        out.println("     System.out.println(\"-Output-\");");
        
        //following changes by MS 160101 v1.05
        out.println("     for(int k = 0; k < outputArgs.length; k++ ) ");
        //         out.println("      " + CH + output[k].ID() + " = new Fact[1];");
        //         out.println("      " + CH + output[k].ID() + "[0] = new Fact(Fact.FACT,expOutputArgs[" + k + "]);");
        //  	 out.println("      System.out.println(" + CH + output[k].ID() + "[0].pprint());");
        out.println("         System.out.println(outputArgs[k][0].pprint());");
        
        
        //      out.println("      outputArgs = new Fact[" + output.length + "][];");
        //      for(int k = 0; k < output.length; k++ )
        //         out.println("      outputArgs[" + k + "] = " + CH + output[k].ID() + ";");
        
        out.println("   }\n");

        out.println("}");
        out.flush();
        out.close();
    }
}
