/*
* The contents of this file are subject to the BT "ZEUS" Open Source 
* Licence (L77741), Version 1.0 (the "Licence"); you may not use this file 
* except in compliance with the Licence. You may obtain a copy of the Licence
* from $ZEUS_INSTALL/licence.html or alternatively from
* http://www.labs.bt.com/projects/agents/zeus/licence.htm
* 
* Except as stated in Clause 7 of the Licence, software distributed under the
* Licence is distributed WITHOUT WARRANTY OF ANY KIND, either express or 
* implied. See the Licence for the specific language governing rights and 
* limitations under the Licence.
* 
* The Original Code is within the package zeus.*.
* The Initial Developer of the Original Code is British Telecommunications
* public limited company, whose registered office is at 81 Newgate Street, 
* London, EC1A 7AJ, England. Portions created by British Telecommunications 
* public limited company are Copyright 1996-9. All Rights Reserved.
* 
* THIS NOTICE MUST BE INCLUDED ON ANY COPY OF THIS FILE
*/

/** 
Change log
-----------
Simon 22/08/00 added an exception catcher as part of work for fix #109719
Simon 24/08/00 added code that puts a -name option into the option list, and then
        sets the agents name if it is used
      */



package zeus.generator.code;

import java.util.*;
import javax.swing.JTextArea;
import java.io.*;

import zeus.concepts.*;
import zeus.util.*;
import zeus.generator.GeneratorModel;

/**
    AgentWriter is the class that is called by the generator to produce the Java code 
    which is compiled into the agents
    */
public class AgentWriter extends Writer {
  public AgentWriter(GenerationPlan genplan, GeneratorModel genmodel,
                     String directory, JTextArea textArea) {
    super(genplan,genmodel,directory,textArea);
  }


  private boolean hasTasks(AgentDescription agent)
  {
    String[] tasks = agent.getTasks();
    if (tasks.length == 0) return false;

    for(int j = 0; j < tasks.length; j++ )
    {
      AbstractTask t = genmodel.getTask(tasks[j]);
      switch( t.getType() )
      {
        case AbstractTask.PRIMITIVE:
          return true;
        case AbstractTask.SUMMARY:
          return true;
        case AbstractTask.SCRIPT:
          return true;
      }
    }
    return false;
  }

  public boolean hasRules(AgentDescription agent)
  {
    String[] tasks = agent.getTasks();
    if (tasks.length == 0) return false;

    for(int j = 0; j < tasks.length; j++ )
    {
      AbstractTask t = genmodel.getTask(tasks[j]);
      switch( t.getType() )
      {
        case AbstractTask.BEHAVIOUR:
          return true;
        case AbstractTask.SCRIPT:
          return true;
      }
    }
    return false;
  }


  public void write()
  {
      PrintWriter out;
      AgentInfo[] agentInfo = genplan.getSelectedAgents();
      if ( agentInfo.length == 0 ) return;

      textArea.append("\n*** Agent code generation started ***\n\n");
      for(int i = 0; i < agentInfo.length; i++ ) {
         AgentDescription agent = genmodel.getAgent(agentInfo[i].id);

         String name = genmodel.getAgentName(agentInfo[i].id);
         textArea.append("Generating code for agent " + name + "\n");
         try {
            out = createFile(name + ".java");
            out.println(standard_disclaimer);
            out.println("/*");
            out.println("This code was automatically generated by " +
                        "ZeusAgentGenerator version " +
                        SystemProps.getProperty("version.id"));
            out.println("                           DO NOT MODIFY!!");
            out.println("*/\n");

            out.println("import java.util.*;");
            out.println("import java.io.*;");
            out.println("import zeus.util.*;");
            out.println("import zeus.concepts.*;");
            out.println("import zeus.actors.*;");
            out.println("import zeus.agents.*;");
            out.println();

            out.println("public class " + name + " {");

            out.println("   protected static void version() {");
            out.println("      System.err.println(\"ZeusAgent - " + name +
                        " version: " + SystemProps.getProperty("version.id") +
                        "\");");
            out.println("      System.exit(0);");
            out.println("   }");
            out.println();

            out.println("   protected static void usage() {");
            out.println("      System.err.println(\"Usage: java " +
                        name + " -s <dns_file> -o <ontology_file> " +
                        "[-gui ViewerProg] [-e <ExternalProg>] " +
                        "[-r ResourceProg] [-name <AgentName>] [-debug] [-h] [-v]\");");
            out.println("      System.exit(0);");
            out.println("   }");
            out.println();

            out.println("   public static void main(String[] arg) {");
            // added by Simon 21/08/00 for #109719 (1.04)
            out.println("   try { ");
            out.println("      ZeusAgent agent;");
            out.println("      String external = null;");
            out.println("      String dns_file = null;");
            out.println("      String resource = null;");
            out.println("      String gui = null;");
            out.println("      String ontology_file = null;");
            out.println("      Vector nameservers = null;");
            out.println("      String name = new String (\"" + name + "\");"); 
            out.println("      Bindings b = new Bindings(\"" + name + "\");");
            out.println("      FileInputStream stream = null;");
            out.println("      ZeusExternal user_prog = null;");
            out.println();
            out.println();
            out.println("      for( int j = 0; j < arg.length; j++ ) {");
            out.println("         if ( arg[j].equals(\"-s\") && " +
                        " ++j < arg.length )");
            out.println("            dns_file = arg[j];");
            out.println("         else if ( arg[j].equals(\"-e\") && " +
                        " ++j < arg.length )");
            out.println("            external = arg[j];");
            out.println("         else if ( arg[j].equals(\"-r\") && " +
                        " ++j < arg.length )");
            out.println("            resource = arg[j];");
            out.println("         else if ( arg[j].equals(\"-o\") && " +
                        " ++j < arg.length )");
            out.println("            ontology_file = arg[j];");
            out.println("         else if ( arg[j].equals(\"-gui\") && " +
                        " ++j < arg.length )");
            out.println("            gui = arg[j];");
            out.println("         else if ( arg[j].equals(\"-debug\") ) {");
            out.println("            Core.debug = true;");
            out.println("            Core.setDebuggerOutputFile(\"" + name + ".log" + "\");");
            out.println("         }");
            out.println("         else if ( arg[j].equals(\"-v\") )");
            out.println("            version();");
            // added by Simon 24/08/00, frankly @ way past my bedtime
            out.println("         else if ( arg[j].equals(\"-name\")  &&" + 
                        " ++j < arg.length )"); 
            out.println("             name = name  + arg[j];"); // altered to remove '_'
            //zzzzz
            out.println("         else if ( arg[j].equals(\"-h\") )");
            out.println("            usage();");
            out.println("         else");
            out.println("            usage();");
            out.println("      }");
            out.println();
            // added by Simon 24/08/00
            out.println("       b = new Bindings(name);"); 
            out.println("      if ( ontology_file == null ) {");
            out.println("         System.err.println(\"Ontology Database " +
                        "file must be specified with -o option\");");
            out.println("         usage();");
            out.println("      }");
            out.println("      if ( dns_file == null ) {");
            out.println("         System.err.println(\"Domain nameserver " +
                        "file must be specified with -s option\");");
            out.println("         usage();");
            out.println("      }");
            out.println();

            out.println("         nameservers = ZeusParser.addressList(" +
                        "new FileInputStream(dns_file));");
            out.println("         if ( nameservers == null || " +
                        "nameservers.isEmpty() ) ");
            out.println("            throw new IOException();");
            out.println();

            out.println("         agent = new ZeusAgent(name,ontology_file,nameservers," +
                        agent.getPlannerWidth() + "," + agent.getPlannerLength() + "," +
                        hasTasks(agent) + "," + hasRules(agent) + ");" );
            out.println();
            out.println("         AgentContext context = agent.getAgentContext();");
            out.println("         OntologyDb db = context.OntologyDb();");
            out.println();

            out.println();
            out.println("/*\n         Initialising Extensions\n*/");
            out.println("         Class c;");
            out.println();
            out.println("         if ( resource != null ) {");
            out.println("            c = Class.forName(resource);");
            out.println("            ExternalDb oracle = (ExternalDb) c.newInstance();");
            out.println("            context.set(oracle);");
            out.println("            oracle.set(context);");
            out.println("         }");
            out.println("         if ( gui != null ) {");
            out.println("            c = Class.forName(gui);");
            out.println("            ZeusAgentUI ui = (ZeusAgentUI)c.newInstance();");
            out.println("            context.set(ui);");
            out.println("            ui.set(context);");
            out.println("         }");
            out.println();

            ProtocolInfo[] protocol = agent.getProtocols();
            out.println("/*\n         Initialising ProtocolDb\n*/");
            out.println("         ProtocolInfo info;");
            for(int j = 0; j < protocol.length; j++ ) {
               StrategyInfo[] strategy = protocol[j].getConstraints();
               for(int k = 0; k < strategy.length; k++ ) {
                  String[] array = strategy[k].getAgents();
                  Vector stringVector = new Vector();
                  for(int l = 0; l < array.length; l++ ) {
                     String a_name = genmodel.getAgentName(array[l]);
                     if ( a_name == null )
                        textArea.append("Warning: agent " + name +
                           " refers to an undefined agent\n");
                     else
                        stringVector.addElement(a_name);
                  }
                  array = Misc.stringArray(stringVector);
                  strategy[k].setAgents(array);
               }
               protocol[j].setConstraints(strategy);

               out.println("         info = ZeusParser.protocolInfo(db,\"" +
                     Misc.escape(protocol[j].toString()) + "\");");
               out.println("         if ( info.resolve(b) )");
               out.println("            agent.addProtocol(info);");
            }
            out.println();

            String[] tasks = agent.getTasks();
            if (tasks.length != 0) {
               out.println("/*\n         Initialising TaskDb\n*/");
               out.println("         AbstractTask t;");
               for(int j = 0; j < tasks.length; j++ ) {
                  String a_name = genmodel.getTaskName(tasks[j]);
                  if ( a_name == null )
                     textArea.append("Warning: agent " + name + " refers to an undefined task\n");
                  else {
                     AbstractTask t = genmodel.getTask(tasks[j]);
                     switch( t.getType() ) {
                        case AbstractTask.PRIMITIVE:
                             t = new PrimitiveTask((PrimitiveTask)t);
                             t.setName(a_name);
                             out.println("         t = ZeusParser.primitiveTask(db,\"" +
                                Misc.escape(t.toString()) + "\");");
                             break;
                        case AbstractTask.SUMMARY:
                             t = new SummaryTask((SummaryTask)t);
                             t.setName(a_name);
                             out.println("         t = ZeusParser.summaryTask(db,\"" +
                                Misc.escape(t.toString()) + "\");");
                             break;
                        case AbstractTask.BEHAVIOUR:
                             out.println("         stream = new FileInputStream(\"" +
                                a_name + ".clp" + "\");");
                             out.println("         t = ZeusParser.reteKB(db,stream);");
                             out.println("         stream.close();");
                             break;
                        case AbstractTask.SCRIPT:
                             // t = new Script((Script)t);
                             t.setName(a_name);
                             out.println("         t = ZeusParser.script(db,\"" +
                                Misc.escape(t.toString()) + "\");");
                             break;
                        default:
                             Core.ERROR(null,1,this);
                     }
                     out.println("         if ( t.resolve(b) )");
                     out.println("            agent.addTask(t);");

		     //Add restrictions
		     List restrictions = agent.getRestrictions();
		     for(Iterator r = restrictions.iterator() ; r.hasNext() ;){
		       Restriction item = (Restriction)r.next();
		       if(item.getTaskName().equals(a_name)) {
			 out.println("         t.addRestriction(\"" +
				     item.getFactName() + "\", \"" +
				     item.getAttributeName() + "\", \"" +
				     item.getRestriction() + "\");");
		       }
		     }
                  }
               }
            }

            Acquaintance[] others = agent.getAcquaintances();
            out.println("/*\n         Initialising OrganisationalDb\n*/");
            out.println("         AbilityDbItem item;");
            for(int j = 0; j < others.length; j++ ) {
               String a_name = genmodel.getAgentName(others[j].getName());
               if ( a_name == null )
                  textArea.append("Warning: agent " + name +
                     " refers to an undefined acquaintance\n");
               else {
                  out.println("         agent.addRelation(\"" + a_name +
                     "\",\"" + others[j].getRelation() + "\");");

                  AbilitySpec[] List = others[j].getAbilities();
                  AbilityDbItem dbItem;
                  for(int k = 0; k < List.length; k++ ) {
                     dbItem = new AbilityDbItem(a_name,List[k]);
                     out.println("         item = ZeusParser.abilityDbItem(db,\"" +
                        Misc.escape(dbItem.toString()) + "\");");
                     out.println("         if ( item.resolve(b) )");
                     out.println("            agent.addAbility(item);");
                  }
               }
               out.println();
            }

            Fact[] facts = agent.getInitialFacts();
            out.println("/*\n         Initialising ResourceDb\n*/");
            out.println("         Fact f1;");
            for(int j = 0; j < facts.length; j++ ) {
               if ( !facts[j].isDeterminate() )
                  textArea.append("Warning: " + facts[j].getId() +
                         " is not grounded");
                  out.println("         f1 = ZeusParser.fact(db,\"" +
                              Misc.escape(facts[j].toString()) + "\");");
                  out.println("         if ( f1.resolve(b) )");
                  out.println("            agent.addFact(f1);");
            }
            out.println();

            out.println();
            out.println("/*\n         Initialising External User Program\n*/");
            out.println();
            out.println("         if ( external != null ) {");
            out.println("            c = Class.forName(external);");
            out.println("            user_prog = (ZeusExternal) c.newInstance();");
            out.println("            context.set(user_prog);");
            out.println("         }");
            out.println();

            if (hasRules(agent)) {
               out.println("/*\n         Activating Rete Engine\n*/");
               out.println("         context.ReteEngine().run();");
            }

            out.println();
            out.println("/*\n         Activating External User Program\n*/");
            out.println();
            out.println("         if ( user_prog != null )");
            out.println("            user_prog.exec(context);");
            out.println();
            out.println("      }");
            // added by simon 21/08/00 
            // catch for ClassNotFoundeException to give a nice error message
            out.println(" catch (ClassNotFoundException cnfe) { "); 
            out.print("     System.out.println(\"Java cannot find some of the classes that "); 
            out.print("are needed to run this agent. Please ensure that you have the following"); 
            out.print ("in your classpath : zeus_install_dir\\\\lib\\\\zeus.jar, "); 
          out.print ("zeus_install_dir\\\\lib\\\\gnu-regexp.jar, "); 
            out.print ("java_install_dir\\\\jre\\\\rt.jar "); 
            out.print (" Where zeus_install_dir is the directory that you have installed "); 
            out.print (" Zeus in , and java_install_dir is the directory that you have ");
            out.println (" installed Java in\");"); 
            out.println("   cnfe.printStackTrace();}");
            out.println("      catch(Exception e) {");
            out.println("         e.printStackTrace();");
            // line removed by simon 21/08/00. 
            // if the agent is brought down with a exit(0) the whole jvm will close 
            // further work - deregister instead, and finalise objects.
            //out.println("         System.exit(0);");
            out.println("      }");
          
                        
            out.println("   }");
            out.println("}");
            out.flush();
            out.close();

            agentInfo[i].status = GenerationPlan.NO_SAVE_NEEDED;
            agentInfo[i].generate = false;
         }
         catch(IOException e) {
            textArea.append("Error generating agent " + name);
         }
      }
      textArea.append("Generating " +
         SystemProps.getProperty("application.gif") + " file\n");
      try {
         out = createFile(SystemProps.getProperty("application.gif"));

         String name, filename;
         char sys_char = File.separatorChar;
         char zeus_char = SystemProps.getProperty("file.separator").charAt(0);

         String[] identifiers = genmodel.getAgentIds();

         for(int i = 0; i < identifiers.length; i++ ) {
            name = genmodel.getAgentName(identifiers[i]);
            filename = genmodel.getAgentIcon(identifiers[i]);
            filename = Misc.relativePath(directory,filename);
            filename = filename.replace(sys_char,zeus_char);
            out.println(name + " = " + Misc.escape(filename));
         }
         out.flush();
         out.close();
      }
      catch(IOException e) {
         textArea.append("Error generating " +
            SystemProps.getProperty("application.gif") + " file\n");
      }
      textArea.append("\n*** Agent Code generation completed ***\n");
   }
}
