/*
* The contents of this file are subject to the BT "ZEUS" Open Source 
* Licence (L77741), Version 1.0 (the "Licence"); you may not use this file 
* except in compliance with the Licence. You may obtain a copy of the Licence
* from $ZEUS_INSTALL/licence.html or alternatively from
* http://www.labs.bt.com/projects/agents/zeus/licence.htm
* 
* Except as stated in Clause 7 of the Licence, software distributed under the
* Licence is distributed WITHOUT WARRANTY OF ANY KIND, either express or 
* implied. See the Licence for the specific language governing rights and 
* limitations under the Licence.
* 
* The Original Code is within the package zeus.*.
* The Initial Developer of the Original Code is British Telecommunications
* public limited company, whose registered office is at 81 Newgate Street, 
* London, EC1A 7AJ, England. Portions created by British Telecommunications 
* public limited company are Copyright 1996-9. All Rights Reserved.
* 
* THIS NOTICE MUST BE INCLUDED ON ANY COPY OF THIS FILE
*/



/* Generated By:JavaCC: Do not edit this line. RestrictionParser.java */
package zeus.concepts;

import java.util.*;
import java.io.*;
import zeus.util.*;
import zeus.concepts.fn.*;

public class RestrictionParser implements RestrictionParserConstants {

/*
   String Expression syntax follows.
*/
  final public ValueFunction StringExpression() throws ParseException {
  ValueFunction fn = null;
    fn = OrString();
    jj_consume_token(0);
    {if (true) return fn;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction OrString() throws ParseException {
  ValueFunction x, y;
    x = AndString();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UOR:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(UOR);
      y = AndString();
        x =  new OrFn(x,y);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction AndString() throws ParseException {
  ValueFunction x, y;
    x = UnaryString();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UAND:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      jj_consume_token(UAND);
      y = UnaryString();
        x = new AndFn(x,y);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction UnaryString() throws ParseException {
  Token t;
  ValueFunction x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LE:
    case GE:
    case NE:
    case GT:
    case LT:
    case UNOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LE:
        t = jj_consume_token(LE);
        break;
      case GE:
        t = jj_consume_token(GE);
        break;
      case NE:
        t = jj_consume_token(NE);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LT:
        t = jj_consume_token(LT);
        break;
      case UNOT:
        t = jj_consume_token(UNOT);
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      x = UnaryString();
     x = new ConstraintFn(t.image,x);
      break;
    case ID:
    case LITERAL:
      x = StringLiteral();
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      x = OrString();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction StringLiteral() throws ParseException {
  Token t;
  ValueFunction x = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LITERAL:
      t = jj_consume_token(LITERAL);
     x = new IdFn(Misc.literalToString(t.image));
      break;
    default:
      jj_la1[4] = jj_gen;
      if (jj_2_1(2)) {
        x = Function();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
          t = jj_consume_token(ID);
     x = new IdFn(t.image);
          break;
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/*
   Boolean Expression syntax follows.
*/
  final public ValueFunction BooleanLiteral() throws ParseException {
  Token t;
  ValueFunction x = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
      t = jj_consume_token(BOOLEAN);
    x = BoolFn.newBoolFn(t.image);
      break;
    case ID:
      x = Function();
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/*
   Date Expression syntax follows.
*/
  final public ValueFunction DateExpression() throws ParseException {
  ValueFunction x = null;
    x = OrDate();
    jj_consume_token(0);
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction OrDate() throws ParseException {
  ValueFunction x = null, y = null;
    x = AndDate();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UOR:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_3;
      }
      jj_consume_token(UOR);
      y = AndDate();
        x = new OrFn(x,y);
    }
     {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction AndDate() throws ParseException {
  ValueFunction x = null, y = null;
    x = UnaryDate();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UAND:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_4;
      }
      jj_consume_token(UAND);
      y = UnaryDate();
        x = new AndFn(x,y);
    }
     {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction UnaryDate() throws ParseException {
  Token t;
  ValueFunction x = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LE:
    case GE:
    case NE:
    case GT:
    case LT:
    case UNOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LE:
        t = jj_consume_token(LE);
        break;
      case GE:
        t = jj_consume_token(GE);
        break;
      case NE:
        t = jj_consume_token(NE);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LT:
        t = jj_consume_token(LT);
        break;
      case UNOT:
        t = jj_consume_token(UNOT);
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      x = UnaryDate();
     x =  new ConstraintFn(t.image,x);
      break;
    case ID:
    case DATE:
      x = DateLiteral();
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      x = OrDate();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction DateLiteral() throws ParseException {
  Token t;
  ValueFunction x = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
      t = jj_consume_token(DATE);
     x = new DateFn(t.image);
      break;
    case ID:
      x = Function();
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/*
   Time Expression syntax follows.
*/
  final public ValueFunction TimeExpression() throws ParseException {
  ValueFunction x = null;
    x = OrTime();
    jj_consume_token(0);
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction OrTime() throws ParseException {
  ValueFunction x = null, y = null;
    x = AndTime();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UOR:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_5;
      }
      jj_consume_token(UOR);
      y = AndTime();
        x = new OrFn(x,y);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction AndTime() throws ParseException {
  ValueFunction x = null, y = null;
    x = UnaryTime();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UAND:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_6;
      }
      jj_consume_token(UAND);
      y = UnaryTime();
        x = new AndFn(x,y);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction UnaryTime() throws ParseException {
  Token t;
  ValueFunction x = null, y = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LE:
    case GE:
    case NE:
    case GT:
    case LT:
    case UNOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LE:
        t = jj_consume_token(LE);
        break;
      case GE:
        t = jj_consume_token(GE);
        break;
      case NE:
        t = jj_consume_token(NE);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LT:
        t = jj_consume_token(LT);
        break;
      case UNOT:
        t = jj_consume_token(UNOT);
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      x = UnaryTime();
     x =  new ConstraintFn(t.image,x);
      break;
    case ID:
    case TIME:
      x = TimeLiteral();
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      x = OrTime();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction TimeLiteral() throws ParseException {
  Token t;
  ValueFunction x = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIME:
      t = jj_consume_token(TIME);
     x = new TimeFn(t.image);
      break;
    case ID:
      x = Function();
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/*
   Integer Expression syntax follows.
*/
  final public ValueFunction IntegerExpression() throws ParseException {
  ValueFunction x = null;
    x = OrInteger();
    jj_consume_token(0);
     {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction OrInteger() throws ParseException {
  ValueFunction x = null, y = null;
    x = AndInteger();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UOR:
        ;
        break;
      default:
        jj_la1[17] = jj_gen;
        break label_7;
      }
      jj_consume_token(UOR);
      y = AndInteger();
        x = new OrFn(x,y);
    }
     {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction AndInteger() throws ParseException {
  ValueFunction x = null, y = null;
    x = AdditiveInteger();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UAND:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_8;
      }
      jj_consume_token(UAND);
      y = AdditiveInteger();
        x = new AndFn(x,y);
    }
     {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction AdditiveInteger() throws ParseException {
  Token t;
  ValueFunction x = null, y = null;
    x = MultiplicativeInteger();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      y = MultiplicativeInteger();
        x = new ArithmeticFn(x,y,t.image);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction MultiplicativeInteger() throws ParseException {
  Token t;
  ValueFunction x = null, y = null;
    x = UnaryInteger();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case REMAINDER:
        ;
        break;
      default:
        jj_la1[21] = jj_gen;
        break label_10;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
        t = jj_consume_token(MULTIPLY);
        break;
      case DIVIDE:
        t = jj_consume_token(DIVIDE);
        break;
      case REMAINDER:
        t = jj_consume_token(REMAINDER);
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      y = UnaryInteger();
        x = new ArithmeticFn(x,y,t.image);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction UnaryInteger() throws ParseException {
  Token t;
  ValueFunction x = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      x = UnaryInteger();
     x =  new ArithmeticFn(new IntFn("0"),x,t.image);
      break;
    case LE:
    case GE:
    case NE:
    case GT:
    case LT:
    case UNOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LE:
        t = jj_consume_token(LE);
        break;
      case GE:
        t = jj_consume_token(GE);
        break;
      case NE:
        t = jj_consume_token(NE);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LT:
        t = jj_consume_token(LT);
        break;
      case UNOT:
        t = jj_consume_token(UNOT);
        break;
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      x = UnaryInteger();
     x =  new ConstraintFn(t.image,x);
      break;
    case INTEGER:
      t = jj_consume_token(INTEGER);
     x = new IntFn(t.image);
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      x = OrInteger();
      jj_consume_token(RBRACKET);
      break;
    case ID:
      x = Function();
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/*
   Real Expression syntax follows.
*/
  final public ValueFunction RealExpression() throws ParseException {
  ValueFunction x = null, y = null;
    x = OrReal();
    jj_consume_token(0);
     {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction OrReal() throws ParseException {
  ValueFunction x = null, y = null;
    x = AndReal();
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UOR:
        ;
        break;
      default:
        jj_la1[26] = jj_gen;
        break label_11;
      }
      jj_consume_token(UOR);
      y = AndReal();
        x = new OrFn(x,y);
    }
     {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction AndReal() throws ParseException {
  ValueFunction x = null, y = null;
    x = AdditiveReal();
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UAND:
        ;
        break;
      default:
        jj_la1[27] = jj_gen;
        break label_12;
      }
      jj_consume_token(UAND);
      y = AdditiveReal();
        x = new AndFn(x,y);
    }
     {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction AdditiveReal() throws ParseException {
  Token t;
  ValueFunction x = null, y = null;
    x = MultiplicativeReal();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[28] = jj_gen;
        break label_13;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      y = MultiplicativeReal();
        x = new ArithmeticFn(x,y,t.image);
    }
     {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction MultiplicativeReal() throws ParseException {
  Token t;
  ValueFunction x = null, y = null;
    x = UnaryReal();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case REMAINDER:
        ;
        break;
      default:
        jj_la1[30] = jj_gen;
        break label_14;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
        t = jj_consume_token(MULTIPLY);
        break;
      case DIVIDE:
        t = jj_consume_token(DIVIDE);
        break;
      case REMAINDER:
        t = jj_consume_token(REMAINDER);
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      y = UnaryReal();
        x = new ArithmeticFn(x,y,t.image);
    }
     {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction UnaryReal() throws ParseException {
  Token t;
  ValueFunction x = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      x = UnaryReal();
     x =  new ArithmeticFn(new IntFn("0"),x,t.image);
      break;
    case LE:
    case GE:
    case NE:
    case GT:
    case LT:
    case UNOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LE:
        t = jj_consume_token(LE);
        break;
      case GE:
        t = jj_consume_token(GE);
        break;
      case NE:
        t = jj_consume_token(NE);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LT:
        t = jj_consume_token(LT);
        break;
      case UNOT:
        t = jj_consume_token(UNOT);
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      x = UnaryReal();
     x = new ConstraintFn(t.image,x);
      break;
    case INTEGER:
      t = jj_consume_token(INTEGER);
     x = new RealFn(t.image);
      break;
    case REAL:
      t = jj_consume_token(REAL);
     x = new RealFn(t.image);
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      x = OrReal();
      jj_consume_token(RBRACKET);
      break;
    case ID:
      x = Function();
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/*
   Vector Expression syntax follows.
*/
  final public ValueFunction VectorLiteral() throws ParseException {
  Vector data = new Vector();
  ValueFunction x = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LCURLY:
      jj_consume_token(LCURLY);
      data = ExpressionList();
      jj_consume_token(RCURLY);
    x = new VectorFn(data);
      break;
    case ID:
      x = Function();
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

/*
   Functions
*/
  final public Vector ExpressionList() throws ParseException {
Vector data = new Vector();
ValueFunction fn = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LE:
    case GE:
    case NE:
    case GT:
    case LT:
    case PLUS:
    case MINUS:
    case NOT:
    case UNOT:
    case LBRACKET:
    case LCURLY:
    case IF:
    case ID:
    case BOOLEAN:
    case INTEGER:
    case REAL:
    case DATE:
    case TIME:
    case LITERAL:
      fn = Expression();
      data.addElement(fn);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[36] = jj_gen;
          break label_15;
        }
        jj_consume_token(COMMA);
        fn = Expression();
        data.addElement(fn);
      }
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    {if (true) return data;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction Function() throws ParseException {
Vector data = null;
Token t;
    t = jj_consume_token(ID);
    jj_consume_token(LBRACKET);
    data = ExpressionList();
    jj_consume_token(RBRACKET);
     {if (true) return new DefinedFn(t.image,data);}
    throw new Error("Missing return statement in function");
  }

/*
   Expression syntax
*/
  final public ValueFunction Expression() throws ParseException {
ValueFunction fn = null;
    fn = ConditionalOrExpression();
    {if (true) return fn;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction ConditionalOrExpression() throws ParseException {
ValueFunction x = null, y = null;
    x = ConditionalAndExpression();
    label_16:
    while (true) {
      if (jj_2_2(2147483647)) {
        ;
      } else {
        break label_16;
      }
      jj_consume_token(OR);
      y = ConditionalAndExpression();
        x = new LogicalOrFn(x,y);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction ConditionalAndExpression() throws ParseException {
ValueFunction x = null, y = null;
    x = InclusiveOrExpression();
    label_17:
    while (true) {
      if (jj_2_3(2147483647)) {
        ;
      } else {
        break label_17;
      }
      jj_consume_token(AND);
      y = InclusiveOrExpression();
        x = new LogicalAndFn(x,y);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction InclusiveOrExpression() throws ParseException {
ValueFunction x = null, y = null;
    x = AndExpression();
    label_18:
    while (true) {
      if (jj_2_4(2147483647)) {
        ;
      } else {
        break label_18;
      }
      jj_consume_token(UOR);
      y = AndExpression();
        x = new OrFn(x,y);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction AndExpression() throws ParseException {
ValueFunction x = null, y = null;
    x = RelationalExpression();
    label_19:
    while (true) {
      if (jj_2_5(2147483647)) {
        ;
      } else {
        break label_19;
      }
      jj_consume_token(UAND);
      y = RelationalExpression();
        x = new AndFn(x,y);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction RelationalExpression() throws ParseException {
ValueFunction x = null, y = null;
Token t;
    x = AdditiveExpression();
    label_20:
    while (true) {
      if (jj_2_6(2)) {
        ;
      } else {
        break label_20;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        t = jj_consume_token(EQ);
        break;
      case NE:
        t = jj_consume_token(NE);
        break;
      case LT:
        t = jj_consume_token(LT);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LE:
        t = jj_consume_token(LE);
        break;
      case GE:
        t = jj_consume_token(GE);
        break;
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      y = AdditiveExpression();
        x= new ComparisonFn(x,y,t.image);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction AdditiveExpression() throws ParseException {
ValueFunction x = null, y = null;
Token t;
    x = MultiplicativeExpression();
    label_21:
    while (true) {
      if (jj_2_7(2147483647)) {
        ;
      } else {
        break label_21;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      y = MultiplicativeExpression();
        x = new ArithmeticFn(x,y,t.image);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction MultiplicativeExpression() throws ParseException {
ValueFunction x = null, y = null;
Token t;
    x = UnaryExpression();
    label_22:
    while (true) {
      if (jj_2_8(2147483647)) {
        ;
      } else {
        break label_22;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
        t = jj_consume_token(MULTIPLY);
        break;
      case DIVIDE:
        t = jj_consume_token(DIVIDE);
        break;
      case REMAINDER:
        t = jj_consume_token(REMAINDER);
        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      y = UnaryExpression();
        x = new ArithmeticFn(x,y,t.image);
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction UnaryExpression() throws ParseException {
ValueFunction x = null, y = null;
Token t;
Fact f;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      x = UnaryExpression();
     x = new ArithmeticFn(new IntFn("0"),x,t.image);
      break;
    case NOT:
      jj_consume_token(NOT);
      x = UnaryExpression();
     x = new LogicalNotFn(x);
      break;
    case LE:
    case GE:
    case NE:
    case GT:
    case LT:
    case UNOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LE:
        t = jj_consume_token(LE);
        break;
      case GE:
        t = jj_consume_token(GE);
        break;
      case NE:
        t = jj_consume_token(NE);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LT:
        t = jj_consume_token(LT);
        break;
      case UNOT:
        t = jj_consume_token(UNOT);
        break;
      default:
        jj_la1[42] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      x = UnaryExpression();
     x = new ConstraintFn(t.image,x);
      break;
    case LCURLY:
    case ID:
    case BOOLEAN:
    case INTEGER:
    case REAL:
    case DATE:
    case TIME:
    case LITERAL:
      x = Literal();
      break;
    case IF:
      jj_consume_token(IF);
      x = ConditionalOrExpression();
      jj_consume_token(THEN);
      y = Expression();
     x = new ImplyFn(x,y);
      if (jj_2_9(2147483647)) {
        jj_consume_token(ELSE);
        y = Expression();
        x = new ElseFn(x,y);
      } else {
        ;
      }
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      x = Expression();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public ValueFunction Literal() throws ParseException {
Token t;
ValueFunction x = null;
Vector data = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER:
      t = jj_consume_token(INTEGER);
    x = new IntFn(t.image);
      break;
    case REAL:
      t = jj_consume_token(REAL);
    x = new RealFn(t.image);
      break;
    case DATE:
      t = jj_consume_token(DATE);
    x = new DateFn(t.image);
      break;
    case TIME:
      t = jj_consume_token(TIME);
    x = new TimeFn(t.image);
      break;
    case LITERAL:
      t = jj_consume_token(LITERAL);
    x = new IdFn(Misc.literalToString(t.image));
      break;
    case BOOLEAN:
      t = jj_consume_token(BOOLEAN);
    x = BoolFn.newBoolFn(t.image);
      break;
    case LCURLY:
      jj_consume_token(LCURLY);
      data = ExpressionList();
      jj_consume_token(RCURLY);
    x = new VectorFn(data);
      break;
    default:
      jj_la1[44] = jj_gen;
      if (jj_2_10(2)) {
        x = Function();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
          t = jj_consume_token(ID);
    x = new IdFn(t.image);
          break;
        default:
          jj_la1[45] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_6();
    jj_save(5, xla);
    return retval;
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_7();
    jj_save(6, xla);
    return retval;
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_8();
    jj_save(7, xla);
    return retval;
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_9();
    jj_save(8, xla);
    return retval;
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_10();
    jj_save(9, xla);
    return retval;
  }

  final private boolean jj_3R_23() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(NE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_3R_36()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(UNOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(EQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(UAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(LT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(LCURLY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(BOOLEAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_scan_token(GT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_scan_token(TIME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(UOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_scan_token(DATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(REAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_scan_token(INTEGER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_52() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(NE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(REMAINDER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(IF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_scan_token(OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_3R_52()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_scan_token(LE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_scan_token(LE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(MULTIPLY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_8() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_scan_token(GT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_scan_token(LT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_3R_37()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public RestrictionParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[46];
  final private int[] jj_la1_0 = {0x800000,0x400000,0x200f80,0x1200f80,0x0,0x0,0x0,0x800000,0x400000,0x200f80,0x1200f80,0x0,0x800000,0x400000,0x200f80,0x1200f80,0x0,0x800000,0x400000,0x3000,0x3000,0x1c000,0x1c000,0x3000,0x200f80,0x1203f80,0x800000,0x400000,0x3000,0x3000,0x1c000,0x1c000,0x3000,0x200f80,0x1203f80,0x4000000,0x10000000,0x25303f80,0xfc0,0x3000,0x1c000,0x3000,0x200f80,0x25303f80,0x4000000,0x0,};
  final private int[] jj_la1_1 = {0x0,0x0,0x0,0x41,0x40,0x1,0x3,0x0,0x0,0x0,0x11,0x11,0x0,0x0,0x0,0x21,0x21,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd,0x1,0x0,0x7f,0x0,0x0,0x0,0x0,0x0,0x7f,0x7e,0x1,};
  final private JJCalls[] jj_2_rtns = new JJCalls[10];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public RestrictionParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new RestrictionParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public RestrictionParser(RestrictionParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(RestrictionParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[43];
    for (int i = 0; i < 43; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 46; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 43; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 10; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}

interface RestrictionParserConstants {

  int EOF = 0;
  int EQ = 6;
  int LE = 7;
  int GE = 8;
  int NE = 9;
  int GT = 10;
  int LT = 11;
  int PLUS = 12;
  int MINUS = 13;
  int MULTIPLY = 14;
  int DIVIDE = 15;
  int REMAINDER = 16;
  int POWER = 17;
  int AND = 18;
  int OR = 19;
  int NOT = 20;
  int UNOT = 21;
  int UAND = 22;
  int UOR = 23;
  int LBRACKET = 24;
  int RBRACKET = 25;
  int LCURLY = 26;
  int RCURLY = 27;
  int COMMA = 28;
  int IF = 29;
  int THEN = 30;
  int ELSE = 31;
  int ID = 32;
  int BOOLEAN = 33;
  int INTEGER = 34;
  int REAL = 35;
  int DATE = 36;
  int TIME = 37;
  int LITERAL = 38;
  int EXPONENT = 39;
  int LETTER = 40;
  int DIGIT = 41;
  int DECIMAL = 42;

  int DEFAULT = 0;

  String[] tokenImage = {
    "<EOF>",
    "\" \"",
    "\"\\t\"",
    "\"\\n\"",
    "\"\\r\"",
    "\"\\f\"",
    "\"==\"",
    "\"<=\"",
    "\">=\"",
    "\"!=\"",
    "\">\"",
    "\"<\"",
    "\"+\"",
    "\"-\"",
    "\"*\"",
    "\"/\"",
    "\"%\"",
    "\"^\"",
    "\"&&\"",
    "\"||\"",
    "\"!\"",
    "\"~\"",
    "\"&\"",
    "\"|\"",
    "\"(\"",
    "\")\"",
    "\"{\"",
    "\"}\"",
    "\",\"",
    "\"if\"",
    "\"then\"",
    "\"else\"",
    "<ID>",
    "<BOOLEAN>",
    "<INTEGER>",
    "<REAL>",
    "<DATE>",
    "<TIME>",
    "<LITERAL>",
    "<EXPONENT>",
    "<LETTER>",
    "<DIGIT>",
    "<DECIMAL>",
  };

}

class RestrictionParserTokenManager implements RestrictionParserConstants
{
private final int jjStopStringLiteralDfa_0(int pos, long active0)
{
   switch (pos)
   {
      case 0:
         if ((active0 & 0x40000000L) != 0L)
         {
            jjmatchedKind = 32;
            return 4;
         }
         if ((active0 & 0xa0000000L) != 0L)
         {
            jjmatchedKind = 32;
            return 1;
         }
         return -1;
      case 1:
         if ((active0 & 0xc0000000L) != 0L)
         {
            jjmatchedKind = 32;
            jjmatchedPos = 1;
            return 1;
         }
         if ((active0 & 0x20000000L) != 0L)
            return 1;
         return -1;
      case 2:
         if ((active0 & 0xc0000000L) != 0L)
         {
            jjmatchedKind = 32;
            jjmatchedPos = 2;
            return 1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_0(int pos, long active0)
{
   return jjMoveNfa_0(jjStopStringLiteralDfa_0(pos, active0), pos + 1);
}
private final int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private final int jjStartNfaWithStates_0(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_0(state, pos + 1);
}
private final int jjMoveStringLiteralDfa0_0()
{
   switch(curChar)
   {
      case 33:
         jjmatchedKind = 20;
         return jjMoveStringLiteralDfa1_0(0x200L);
      case 37:
         return jjStopAtPos(0, 16);
      case 38:
         jjmatchedKind = 22;
         return jjMoveStringLiteralDfa1_0(0x40000L);
      case 40:
         return jjStopAtPos(0, 24);
      case 41:
         return jjStopAtPos(0, 25);
      case 42:
         return jjStopAtPos(0, 14);
      case 43:
         return jjStopAtPos(0, 12);
      case 44:
         return jjStopAtPos(0, 28);
      case 45:
         return jjStopAtPos(0, 13);
      case 47:
         return jjStopAtPos(0, 15);
      case 60:
         jjmatchedKind = 11;
         return jjMoveStringLiteralDfa1_0(0x80L);
      case 61:
         return jjMoveStringLiteralDfa1_0(0x40L);
      case 62:
         jjmatchedKind = 10;
         return jjMoveStringLiteralDfa1_0(0x100L);
      case 94:
         return jjStopAtPos(0, 17);
      case 101:
         return jjMoveStringLiteralDfa1_0(0x80000000L);
      case 105:
         return jjMoveStringLiteralDfa1_0(0x20000000L);
      case 116:
         return jjMoveStringLiteralDfa1_0(0x40000000L);
      case 123:
         return jjStopAtPos(0, 26);
      case 124:
         jjmatchedKind = 23;
         return jjMoveStringLiteralDfa1_0(0x80000L);
      case 125:
         return jjStopAtPos(0, 27);
      case 126:
         return jjStopAtPos(0, 21);
      default :
         return jjMoveNfa_0(0, 0);
   }
}
private final int jjMoveStringLiteralDfa1_0(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(0, active0);
      return 1;
   }
   switch(curChar)
   {
      case 38:
         if ((active0 & 0x40000L) != 0L)
            return jjStopAtPos(1, 18);
         break;
      case 61:
         if ((active0 & 0x40L) != 0L)
            return jjStopAtPos(1, 6);
         else if ((active0 & 0x80L) != 0L)
            return jjStopAtPos(1, 7);
         else if ((active0 & 0x100L) != 0L)
            return jjStopAtPos(1, 8);
         else if ((active0 & 0x200L) != 0L)
            return jjStopAtPos(1, 9);
         break;
      case 102:
         if ((active0 & 0x20000000L) != 0L)
            return jjStartNfaWithStates_0(1, 29, 1);
         break;
      case 104:
         return jjMoveStringLiteralDfa2_0(active0, 0x40000000L);
      case 108:
         return jjMoveStringLiteralDfa2_0(active0, 0x80000000L);
      case 124:
         if ((active0 & 0x80000L) != 0L)
            return jjStopAtPos(1, 19);
         break;
      default :
         break;
   }
   return jjStartNfa_0(0, active0);
}
private final int jjMoveStringLiteralDfa2_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(0, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(1, active0);
      return 2;
   }
   switch(curChar)
   {
      case 101:
         return jjMoveStringLiteralDfa3_0(active0, 0x40000000L);
      case 115:
         return jjMoveStringLiteralDfa3_0(active0, 0x80000000L);
      default :
         break;
   }
   return jjStartNfa_0(1, active0);
}
private final int jjMoveStringLiteralDfa3_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(1, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(2, active0);
      return 3;
   }
   switch(curChar)
   {
      case 101:
         if ((active0 & 0x80000000L) != 0L)
            return jjStartNfaWithStates_0(3, 31, 1);
         break;
      case 110:
         if ((active0 & 0x40000000L) != 0L)
            return jjStartNfaWithStates_0(3, 30, 1);
         break;
      default :
         break;
   }
   return jjStartNfa_0(2, active0);
}
private final void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private final void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private final void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}
private final void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}
private final void jjCheckNAddStates(int start)
{
   jjCheckNAdd(jjnextStates[start]);
   jjCheckNAdd(jjnextStates[start + 1]);
}
static final long[] jjbitVec0 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
private final int jjMoveNfa_0(int startState, int curPos)
{
   int[] nextStates;
   int startsAt = 0;
   jjnewStateCnt = 70;
   int i = 1;
   jjstateSet[0] = startState;
   int j, kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(0, 7);
                  else if (curChar == 34)
                     jjCheckNAddStates(8, 10);
                  else if (curChar == 46)
                     jjCheckNAdd(11);
                  if ((0x3fe000000000000L & l) != 0L)
                  {
                     if (kind > 34)
                        kind = 34;
                     jjCheckNAddStates(11, 13);
                  }
                  else if (curChar == 48)
                  {
                     if (kind > 34)
                        kind = 34;
                     jjCheckNAddStates(14, 16);
                  }
                  if ((0x6000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 17;
                  else if (curChar == 51)
                     jjAddStates(17, 18);
                  if (curChar == 50)
                     jjstateSet[jjnewStateCnt++] = 37;
                  else if (curChar == 49)
                     jjCheckNAdd(29);
                  break;
               case 4:
               case 1:
                  if ((0x3ff001000000000L & l) == 0L)
                     break;
                  if (kind > 32)
                     kind = 32;
                  jjCheckNAdd(1);
                  break;
               case 10:
                  if (curChar == 46)
                     jjCheckNAdd(11);
                  break;
               case 11:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 35)
                     kind = 35;
                  jjCheckNAddStates(19, 21);
                  break;
               case 13:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(14);
                  break;
               case 14:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 35)
                     kind = 35;
                  jjCheckNAddTwoStates(14, 15);
                  break;
               case 16:
                  if ((0x6000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 17;
                  break;
               case 17:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAdd(18);
                  break;
               case 18:
                  if ((0xa00000000000L & l) != 0L)
                     jjCheckNAddStates(22, 24);
                  break;
               case 19:
                  if (curChar == 48)
                     jjCheckNAdd(20);
                  break;
               case 20:
                  if ((0x3fe000000000000L & l) != 0L)
                     jjCheckNAdd(21);
                  break;
               case 21:
                  if ((0xa00000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 22;
                  break;
               case 22:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 23;
                  break;
               case 23:
                  if ((0x3ff000000000000L & l) != 0L && kind > 36)
                     kind = 36;
                  break;
               case 24:
                  if (curChar == 49)
                     jjAddStates(25, 27);
                  break;
               case 25:
                  if (curChar == 48)
                     jjCheckNAdd(21);
                  break;
               case 26:
                  if (curChar == 49)
                     jjCheckNAdd(21);
                  break;
               case 27:
                  if (curChar == 50)
                     jjCheckNAdd(21);
                  break;
               case 28:
                  if (curChar == 49)
                     jjCheckNAdd(29);
                  break;
               case 29:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAdd(30);
                  break;
               case 30:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 31:
                  if ((0x3f000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 32;
                  break;
               case 32:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 37)
                     kind = 37;
                  jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 33:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 34;
                  break;
               case 34:
                  if ((0x3f000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 35:
                  if ((0x3ff000000000000L & l) != 0L && kind > 37)
                     kind = 37;
                  break;
               case 36:
                  if (curChar == 50)
                     jjstateSet[jjnewStateCnt++] = 37;
                  break;
               case 37:
                  if ((0xf000000000000L & l) != 0L)
                     jjCheckNAdd(30);
                  break;
               case 38:
                  if (curChar == 34)
                     jjCheckNAddStates(8, 10);
                  break;
               case 39:
                  if ((0xfffffffbffffdbffL & l) != 0L)
                     jjCheckNAddStates(8, 10);
                  break;
               case 41:
                  if ((0x8400000000L & l) != 0L)
                     jjCheckNAddStates(8, 10);
                  break;
               case 42:
                  if (curChar == 34 && kind > 38)
                     kind = 38;
                  break;
               case 43:
                  if ((0xff000000000000L & l) != 0L)
                     jjCheckNAddStates(28, 31);
                  break;
               case 44:
                  if ((0xff000000000000L & l) != 0L)
                     jjCheckNAddStates(8, 10);
                  break;
               case 45:
                  if ((0xf000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 46;
                  break;
               case 46:
                  if ((0xff000000000000L & l) != 0L)
                     jjCheckNAdd(44);
                  break;
               case 47:
                  if (curChar == 51)
                     jjAddStates(17, 18);
                  break;
               case 48:
                  if (curChar == 48)
                     jjCheckNAdd(18);
                  break;
               case 49:
                  if (curChar == 49)
                     jjCheckNAdd(18);
                  break;
               case 50:
                  if (curChar != 48)
                     break;
                  if (kind > 34)
                     kind = 34;
                  jjCheckNAddStates(14, 16);
                  break;
               case 52:
                  if ((0x3fe000000000000L & l) != 0L)
                     jjCheckNAdd(18);
                  break;
               case 53:
                  if ((0x3fe000000000000L & l) == 0L)
                     break;
                  if (kind > 34)
                     kind = 34;
                  jjCheckNAddStates(11, 13);
                  break;
               case 54:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 34)
                     kind = 34;
                  jjCheckNAddTwoStates(54, 51);
                  break;
               case 55:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(0, 7);
                  break;
               case 56:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(56, 57);
                  break;
               case 57:
                  if (curChar != 46)
                     break;
                  if (kind > 35)
                     kind = 35;
                  jjCheckNAddStates(32, 34);
                  break;
               case 58:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 35)
                     kind = 35;
                  jjCheckNAddStates(32, 34);
                  break;
               case 60:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(61);
                  break;
               case 61:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 35)
                     kind = 35;
                  jjCheckNAddTwoStates(61, 15);
                  break;
               case 62:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(62, 63);
                  break;
               case 64:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(65);
                  break;
               case 65:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 35)
                     kind = 35;
                  jjCheckNAddTwoStates(65, 15);
                  break;
               case 66:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(35, 37);
                  break;
               case 68:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(69);
                  break;
               case 69:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(69, 15);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 32)
                        kind = 32;
                     jjCheckNAdd(1);
                  }
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 8;
                  else if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 4:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 32)
                        kind = 32;
                     jjCheckNAdd(1);
                  }
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 1:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 32)
                     kind = 32;
                  jjCheckNAdd(1);
                  break;
               case 2:
                  if (curChar == 101 && kind > 33)
                     kind = 33;
                  break;
               case 3:
                  if (curChar == 117)
                     jjCheckNAdd(2);
                  break;
               case 5:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 6:
                  if (curChar == 115)
                     jjCheckNAdd(2);
                  break;
               case 7:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               case 8:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 9:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 8;
                  break;
               case 12:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(38, 39);
                  break;
               case 15:
                  if ((0x5000000050L & l) != 0L && kind > 35)
                     kind = 35;
                  break;
               case 39:
                  if ((0xffffffffefffffffL & l) != 0L)
                     jjCheckNAddStates(8, 10);
                  break;
               case 40:
                  if (curChar == 92)
                     jjAddStates(40, 42);
                  break;
               case 41:
                  if ((0x14404410000000L & l) != 0L)
                     jjCheckNAddStates(8, 10);
                  break;
               case 51:
                  if ((0x100000001000L & l) != 0L && kind > 34)
                     kind = 34;
                  break;
               case 59:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(43, 44);
                  break;
               case 63:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(45, 46);
                  break;
               case 67:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(47, 48);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               case 39:
                  if ((jjbitVec0[i2] & l2) != 0L)
                     jjAddStates(8, 10);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 70 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
static final int[] jjnextStates = {
   56, 57, 62, 63, 66, 67, 15, 30, 39, 40, 42, 54, 51, 18, 51, 52, 
   29, 48, 49, 11, 12, 15, 19, 20, 24, 25, 26, 27, 39, 40, 44, 42, 
   58, 59, 15, 66, 67, 15, 13, 14, 41, 43, 45, 60, 61, 64, 65, 68, 
   69, 
};
public static final String[] jjstrLiteralImages = {
"", null, null, null, null, null, "\75\75", "\74\75", "\76\75", "\41\75", 
"\76", "\74", "\53", "\55", "\52", "\57", "\45", "\136", "\46\46", "\174\174", "\41", 
"\176", "\46", "\174", "\50", "\51", "\173", "\175", "\54", "\151\146", 
"\164\150\145\156", "\145\154\163\145", null, null, null, null, null, null, null, null, null, null, 
null, };
public static final String[] lexStateNames = {
   "DEFAULT", 
};
static final long[] jjtoToken = {
   0x7fffffffc1L, 
};
static final long[] jjtoSkip = {
   0x3eL, 
};
private ASCII_CharStream input_stream;
private final int[] jjrounds = new int[70];
private final int[] jjstateSet = new int[140];
protected char curChar;
public RestrictionParserTokenManager(ASCII_CharStream stream)
{
   if (ASCII_CharStream.staticFlag)
      throw new Error("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");
   input_stream = stream;
}
public RestrictionParserTokenManager(ASCII_CharStream stream, int lexState)
{
   this(stream);
   SwitchTo(lexState);
}
public void ReInit(ASCII_CharStream stream)
{
   jjmatchedPos = jjnewStateCnt = 0;
   curLexState = defaultLexState;
   input_stream = stream;
   ReInitRounds();
}
private final void ReInitRounds()
{
   int i;
   jjround = 0x80000001;
   for (i = 70; i-- > 0;)
      jjrounds[i] = 0x80000000;
}
public void ReInit(ASCII_CharStream stream, int lexState)
{
   ReInit(stream);
   SwitchTo(lexState);
}
public void SwitchTo(int lexState)
{
   if (lexState >= 1 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
   else
      curLexState = lexState;
}

private final Token jjFillToken()
{
   Token t = Token.newToken(jjmatchedKind);
   t.kind = jjmatchedKind;
   String im = jjstrLiteralImages[jjmatchedKind];
   t.image = (im == null) ? input_stream.GetImage() : im;
   t.beginLine = input_stream.getBeginLine();
   t.beginColumn = input_stream.getBeginColumn();
   t.endLine = input_stream.getEndLine();
   t.endColumn = input_stream.getEndColumn();
   return t;
}

int curLexState = 0;
int defaultLexState = 0;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

public final Token getNextToken() 
{
  int kind;
  Token specialToken = null;
  Token matchedToken;
  int curPos = 0;

/* BEGIN: BUG FIX for JDK1.2 on Windows */
try {
/* END: BUG FIX for JDK1.2 on Windows */
  EOFLoop :
  for (;;)
  {   
   try   
   {     
      curChar = input_stream.BeginToken();
   }     
   catch(java.io.IOException e)
   {        
      jjmatchedKind = 0;
      matchedToken = jjFillToken();
      return matchedToken;
   }

   try { 
      while (curChar <= 32 && (0x100003600L & (1L << curChar)) != 0L)
         curChar = input_stream.BeginToken();
   }
/* BEGIN: BUG FIX for JDK1.2 on Windows */
         catch(java.io.IOException e1) {
            jjmatchedKind = 0;
            matchedToken = new Token();
            matchedToken.kind = 0;
            matchedToken.image = "<EOF>";
            matchedToken.specialToken = specialToken;
            matchedToken.next = null;
            return matchedToken;
         }
/* END: BUG FIX for JDK1.2 on Windows */
   jjmatchedKind = 0x7fffffff;
   jjmatchedPos = 0;
   curPos = jjMoveStringLiteralDfa0_0();
   if (jjmatchedKind != 0x7fffffff)
   {
      if (jjmatchedPos + 1 < curPos)
         input_stream.backup(curPos - jjmatchedPos - 1);
      if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
      {
         matchedToken = jjFillToken();
         return matchedToken;
      }
      else
      {
         continue EOFLoop;
      }
   }
   int error_line = input_stream.getEndLine();
   int error_column = input_stream.getEndColumn();
   String error_after = null;
   boolean EOFSeen = false;
   try { input_stream.readChar(); input_stream.backup(1); }
   catch (java.io.IOException e1) {
      EOFSeen = true;
      error_after = curPos <= 1 ? "" : input_stream.GetImage();
      if (curChar == '\n' || curChar == '\r') {
         error_line++;
         error_column = 0;
      }
      else
         error_column++;
   }
   if (!EOFSeen) {
      input_stream.backup(1);
      error_after = curPos <= 1 ? "" : input_stream.GetImage();
   }
   throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
  }
/* BEGIN: BUG FIX for JDK1.2 on Windows */
}
catch(Exception x) {
   jjmatchedKind = 0;
   matchedToken = new Token();
   matchedToken.kind = 0;
   matchedToken.image = "<EOF>";
   matchedToken.specialToken = specialToken;
   matchedToken.next = null;
   return matchedToken;
}
/* END: BUG FIX for JDK1.2 on Windows */
}

}
