/*
* The contents of this file are subject to the BT "ZEUS" Open Source 
* Licence (L77741), Version 1.0 (the "Licence"); you may not use this file 
* except in compliance with the Licence. You may obtain a copy of the Licence
* from $ZEUS_INSTALL/licence.html or alternatively from
* http://www.labs.bt.com/projects/agents/zeus/licence.htm
* 
* Except as stated in Clause 7 of the Licence, software distributed under the
* Licence is distributed WITHOUT WARRANTY OF ANY KIND, either express or 
* implied. See the Licence for the specific language governing rights and 
* limitations under the Licence.
* 
* The Original Code is within the package zeus.*.
* The Initial Developer of the Original Code is British Telecommunications
* public limited company, whose registered office is at 81 Newgate Street, 
* London, EC1A 7AJ, England. Portions created by British Telecommunications 
* public limited company are Copyright 1996-9. All Rights Reserved.
* 
* THIS NOTICE MUST BE INCLUDED ON ANY COPY OF THIS FILE
*/



/* Generated By:JavaCC: Do not edit this line. OntologyParser.java */
package zeus.concepts;

import java.util.*;
import java.io.*;
import zeus.util.*;

public class OntologyParser implements OntologyParserConstants {

  final public void parse(OntologyDb model) throws ParseException {
   Token version, system, count, name = null, type = null, value = null;
   Token parent, fact, restriction, default_token;
    jj_consume_token(BEGIN_ONTOLOGY);
    jj_consume_token(BEGIN_PREAMBLE);
    jj_consume_token(SYSTEM);
    system = jj_consume_token(SYSTEM_NAME);
    jj_consume_token(VERSION);
    version = jj_consume_token(LITERAL);
    jj_consume_token(END_PREAMBLE);
        String ver = Misc.literalToString(version.image);
        if ( !ver.equals(SystemProps.getProperty("version.id")) )
           model.__setWarning("File and system versions are different");
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEGIN_RESTRICTIONS:
      jj_consume_token(BEGIN_RESTRICTIONS);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BEGIN_RESTRICTION_ITEM:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        jj_consume_token(BEGIN_RESTRICTION_ITEM);
        jj_consume_token(NAME);
        name = jj_consume_token(ID);
        jj_consume_token(TYPE);
        type = jj_consume_token(ID);
        jj_consume_token(VALUE);
        value = jj_consume_token(LITERAL);
        jj_consume_token(END_RESTRICTION_ITEM);
              String s = Misc.literalToString(value.image);
              model.__addRestriction(name.image,type.image,s);
      }
      jj_consume_token(END_RESTRICTIONS);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEGIN_FACTS:
      jj_consume_token(BEGIN_FACTS);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BEGIN_FACT_ITEM:
          ;
          break;
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        jj_consume_token(BEGIN_FACT_ITEM);
        jj_consume_token(NAME);
        fact = jj_consume_token(ID);
        jj_consume_token(PARENT);
        parent = jj_consume_token(ID);
                 model.__addChildFact(parent.image,fact.image);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BEGIN_ATTRIBUTE_LIST:
          jj_consume_token(BEGIN_ATTRIBUTE_LIST);
          label_3:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BEGIN_ATTRIBUTE_ITEM:
              ;
              break;
            default:
              jj_la1[3] = jj_gen;
              break label_3;
            }
            jj_consume_token(BEGIN_ATTRIBUTE_ITEM);
            jj_consume_token(NAME);
            name = jj_consume_token(ID);
            jj_consume_token(TYPE);
            type = jj_consume_token(ID);
            jj_consume_token(RESTRICTION);
            restriction = jj_consume_token(LITERAL);
            jj_consume_token(DEFAULT_TAG);
            default_token = jj_consume_token(LITERAL);
            jj_consume_token(END_ATTRIBUTE_ITEM);
                       String s1, s2;
                       s1 = Misc.literalToString(restriction.image);
                       s2 = Misc.literalToString(default_token.image);
                       model.__addNewAttributeRow(fact.image,name.image,
                                                  type.image,s1,s2);
          }
          jj_consume_token(END_ATTRIBUTE_LIST);
          break;
        default:
          jj_la1[4] = jj_gen;
          ;
        }
        jj_consume_token(END_FACT_ITEM);
      }
      jj_consume_token(END_FACTS);
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    jj_consume_token(END_ONTOLOGY);
  }

  public OntologyParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[6];
  final private int[] jj_la1_0 = {0x10000,0x8000,0x40000,0x100000,0x80000,0x20000,};
  final private int[] jj_la1_1 = {0x0,0x0,0x0,0x0,0x0,0x0,};

  public OntologyParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new OntologyParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 6; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 6; i++) jj_la1[i] = -1;
  }

  public OntologyParser(OntologyParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 6; i++) jj_la1[i] = -1;
  }

  public void ReInit(OntologyParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 6; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[46];
    for (int i = 0; i < 46; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 6; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 46; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}

interface OntologyParserConstants {

  int EOF = 0;
  int SINGLE_LINE_COMMENT = 9;
  int FORMAL_COMMENT = 10;
  int MULTI_LINE_COMMENT = 11;
  int BEGIN_ONTOLOGY = 13;
  int BEGIN_PREAMBLE = 14;
  int BEGIN_RESTRICTIONS = 15;
  int BEGIN_RESTRICTION_ITEM = 16;
  int BEGIN_FACTS = 17;
  int BEGIN_FACT_ITEM = 18;
  int BEGIN_ATTRIBUTE_LIST = 19;
  int BEGIN_ATTRIBUTE_ITEM = 20;
  int END_PREAMBLE = 21;
  int END_RESTRICTION_ITEM = 22;
  int END_RESTRICTIONS = 23;
  int END_ATTRIBUTE_ITEM = 24;
  int END_ATTRIBUTE_LIST = 25;
  int END_FACT_ITEM = 26;
  int END_FACTS = 27;
  int END_ONTOLOGY = 28;
  int SYSTEM_NAME = 29;
  int SYSTEM = 30;
  int VERSION = 31;
  int NAME = 32;
  int PARENT = 33;
  int TYPE = 34;
  int VALUE = 35;
  int RESTRICTION = 36;
  int DEFAULT_TAG = 37;
  int ID = 38;
  int INTEGER = 39;
  int REAL = 40;
  int LITERAL = 41;
  int EXPONENT = 42;
  int LETTER = 43;
  int DIGIT = 44;
  int DECIMAL = 45;

  int DEFAULT = 0;
  int IN_SINGLE_LINE_COMMENT = 1;
  int IN_FORMAL_COMMENT = 2;
  int IN_MULTI_LINE_COMMENT = 3;

  String[] tokenImage = {
    "<EOF>",
    "\" \"",
    "\"\\t\"",
    "\"\\n\"",
    "\"\\r\"",
    "\"\\f\"",
    "\"//\"",
    "<token of kind 7>",
    "\"/*\"",
    "<SINGLE_LINE_COMMENT>",
    "\"*/\"",
    "\"*/\"",
    "<token of kind 12>",
    "\"BEGIN_ONTOLOGY\"",
    "\"BEGIN_PREAMBLE\"",
    "\"BEGIN_RESTRICTIONS\"",
    "\"BEGIN_RESTRICTION_ITEM\"",
    "\"BEGIN_FACTS\"",
    "\"BEGIN_FACT_ITEM\"",
    "\"BEGIN_ATTRIBUTE_LIST\"",
    "\"BEGIN_ATTRIBUTE_ITEM\"",
    "\"END_PREAMBLE\"",
    "\"END_RESTRICTION_ITEM\"",
    "\"END_RESTRICTIONS\"",
    "\"END_ATTRIBUTE_ITEM\"",
    "\"END_ATTRIBUTE_LIST\"",
    "\"END_FACT_ITEM\"",
    "\"END_FACTS\"",
    "\"END_ONTOLOGY\"",
    "\"ZEUS-Ontology-Editor\"",
    "\":system\"",
    "\":version\"",
    "\":name\"",
    "\":parent\"",
    "\":type\"",
    "\":value\"",
    "\":restriction\"",
    "\":default\"",
    "<ID>",
    "<INTEGER>",
    "<REAL>",
    "<LITERAL>",
    "<EXPONENT>",
    "<LETTER>",
    "<DIGIT>",
    "<DECIMAL>",
  };

}

class OntologyParserTokenManager implements OntologyParserConstants
{
private final int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private final int jjMoveStringLiteralDfa0_3()
{
   switch(curChar)
   {
      case 42:
         return jjMoveStringLiteralDfa1_3(0x800L);
      default :
         return 1;
   }
}
private final int jjMoveStringLiteralDfa1_3(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 1;
   }
   switch(curChar)
   {
      case 47:
         if ((active0 & 0x800L) != 0L)
            return jjStopAtPos(1, 11);
         break;
      default :
         return 2;
   }
   return 2;
}
private final int jjMoveStringLiteralDfa0_2()
{
   switch(curChar)
   {
      case 42:
         return jjMoveStringLiteralDfa1_2(0x400L);
      default :
         return 1;
   }
}
private final int jjMoveStringLiteralDfa1_2(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 1;
   }
   switch(curChar)
   {
      case 47:
         if ((active0 & 0x400L) != 0L)
            return jjStopAtPos(1, 10);
         break;
      default :
         return 2;
   }
   return 2;
}
private final int jjMoveStringLiteralDfa0_1()
{
   return jjMoveNfa_1(0, 0);
}
private final void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private final void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private final void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}
private final void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}
private final void jjCheckNAddStates(int start)
{
   jjCheckNAdd(jjnextStates[start]);
   jjCheckNAdd(jjnextStates[start + 1]);
}
private final int jjMoveNfa_1(int startState, int curPos)
{
   int[] nextStates;
   int startsAt = 0;
   jjnewStateCnt = 3;
   int i = 1;
   jjstateSet[0] = startState;
   int j, kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x2400L & l) != 0L)
                  {
                     if (kind > 9)
                        kind = 9;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
                  if (curChar == 10 && kind > 9)
                     kind = 9;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 3 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_0(int pos, long active0)
{
   switch (pos)
   {
      case 0:
         if ((active0 & 0x3fffe000L) != 0L)
         {
            jjmatchedKind = 38;
            return 5;
         }
         if ((active0 & 0x140L) != 0L)
            return 2;
         return -1;
      case 1:
         if ((active0 & 0x100L) != 0L)
            return 0;
         if ((active0 & 0x3fffe000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 1;
            return 5;
         }
         return -1;
      case 2:
         if ((active0 & 0x3fffe000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 2;
            return 5;
         }
         return -1;
      case 3:
         if ((active0 & 0x3fffe000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 3;
            return 5;
         }
         return -1;
      case 4:
         if ((active0 & 0x1fffe000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 4;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 5:
         if ((active0 & 0x1fffe000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 5;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 6:
         if ((active0 & 0x1fffe000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 6;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 7:
         if ((active0 & 0x1fffe000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 7;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 8:
         if ((active0 & 0x8000000L) != 0L)
            return 5;
         if ((active0 & 0x17ffe000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 8;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 9:
         if ((active0 & 0x17ffe000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 9;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 10:
         if ((active0 & 0x20000L) != 0L)
            return 5;
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         if ((active0 & 0x17fde000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 10;
            return 5;
         }
         return -1;
      case 11:
         if ((active0 & 0x7dde000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 11;
            return 5;
         }
         if ((active0 & 0x10200000L) != 0L)
            return 5;
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 12:
         if ((active0 & 0x4000000L) != 0L)
            return 5;
         if ((active0 & 0x3dde000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 12;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 13:
         if ((active0 & 0x6000L) != 0L)
            return 5;
         if ((active0 & 0x3dd8000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 13;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 14:
         if ((active0 & 0x40000L) != 0L)
            return 5;
         if ((active0 & 0x3d98000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 14;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 15:
         if ((active0 & 0x800000L) != 0L)
            return 5;
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         if ((active0 & 0x3598000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 15;
            return 5;
         }
         return -1;
      case 16:
         if ((active0 & 0x3598000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 16;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 17:
         if ((active0 & 0x3008000L) != 0L)
            return 5;
         if ((active0 & 0x590000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 17;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 18:
         if ((active0 & 0x590000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 18;
            return 5;
         }
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         return -1;
      case 19:
         if ((active0 & 0x580000L) != 0L)
            return 5;
         if ((active0 & 0x20000000L) != 0L)
         {
            if (jjmatchedPos < 3)
            {
               jjmatchedKind = 38;
               jjmatchedPos = 3;
            }
            return -1;
         }
         if ((active0 & 0x10000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 19;
            return 5;
         }
         return -1;
      case 20:
         if ((active0 & 0x10000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 20;
            return 5;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_0(int pos, long active0)
{
   return jjMoveNfa_0(jjStopStringLiteralDfa_0(pos, active0), pos + 1);
}
private final int jjStartNfaWithStates_0(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_0(state, pos + 1);
}
private final int jjMoveStringLiteralDfa0_0()
{
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa1_0(0x140L);
      case 58:
         return jjMoveStringLiteralDfa1_0(0x3fc0000000L);
      case 66:
         return jjMoveStringLiteralDfa1_0(0x1fe000L);
      case 69:
         return jjMoveStringLiteralDfa1_0(0x1fe00000L);
      case 90:
         return jjMoveStringLiteralDfa1_0(0x20000000L);
      default :
         return jjMoveNfa_0(3, 0);
   }
}
private final int jjMoveStringLiteralDfa1_0(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(0, active0);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x100L) != 0L)
            return jjStartNfaWithStates_0(1, 8, 0);
         break;
      case 47:
         if ((active0 & 0x40L) != 0L)
            return jjStopAtPos(1, 6);
         break;
      case 69:
         return jjMoveStringLiteralDfa2_0(active0, 0x201fe000L);
      case 78:
         return jjMoveStringLiteralDfa2_0(active0, 0x1fe00000L);
      case 100:
         return jjMoveStringLiteralDfa2_0(active0, 0x2000000000L);
      case 110:
         return jjMoveStringLiteralDfa2_0(active0, 0x100000000L);
      case 112:
         return jjMoveStringLiteralDfa2_0(active0, 0x200000000L);
      case 114:
         return jjMoveStringLiteralDfa2_0(active0, 0x1000000000L);
      case 115:
         return jjMoveStringLiteralDfa2_0(active0, 0x40000000L);
      case 116:
         return jjMoveStringLiteralDfa2_0(active0, 0x400000000L);
      case 118:
         return jjMoveStringLiteralDfa2_0(active0, 0x880000000L);
      default :
         break;
   }
   return jjStartNfa_0(0, active0);
}
private final int jjMoveStringLiteralDfa2_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(0, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(1, active0);
      return 2;
   }
   switch(curChar)
   {
      case 68:
         return jjMoveStringLiteralDfa3_0(active0, 0x1fe00000L);
      case 71:
         return jjMoveStringLiteralDfa3_0(active0, 0x1fe000L);
      case 85:
         return jjMoveStringLiteralDfa3_0(active0, 0x20000000L);
      case 97:
         return jjMoveStringLiteralDfa3_0(active0, 0xb00000000L);
      case 101:
         return jjMoveStringLiteralDfa3_0(active0, 0x3080000000L);
      case 121:
         return jjMoveStringLiteralDfa3_0(active0, 0x440000000L);
      default :
         break;
   }
   return jjStartNfa_0(1, active0);
}
private final int jjMoveStringLiteralDfa3_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(1, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(2, active0);
      return 3;
   }
   switch(curChar)
   {
      case 73:
         return jjMoveStringLiteralDfa4_0(active0, 0x1fe000L);
      case 83:
         return jjMoveStringLiteralDfa4_0(active0, 0x20000000L);
      case 95:
         return jjMoveStringLiteralDfa4_0(active0, 0x1fe00000L);
      case 102:
         return jjMoveStringLiteralDfa4_0(active0, 0x2000000000L);
      case 108:
         return jjMoveStringLiteralDfa4_0(active0, 0x800000000L);
      case 109:
         return jjMoveStringLiteralDfa4_0(active0, 0x100000000L);
      case 112:
         return jjMoveStringLiteralDfa4_0(active0, 0x400000000L);
      case 114:
         return jjMoveStringLiteralDfa4_0(active0, 0x280000000L);
      case 115:
         return jjMoveStringLiteralDfa4_0(active0, 0x1040000000L);
      default :
         break;
   }
   return jjStartNfa_0(2, active0);
}
private final int jjMoveStringLiteralDfa4_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(2, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(3, active0);
      return 4;
   }
   switch(curChar)
   {
      case 45:
         return jjMoveStringLiteralDfa5_0(active0, 0x20000000L);
      case 65:
         return jjMoveStringLiteralDfa5_0(active0, 0x3000000L);
      case 70:
         return jjMoveStringLiteralDfa5_0(active0, 0xc000000L);
      case 78:
         return jjMoveStringLiteralDfa5_0(active0, 0x1fe000L);
      case 79:
         return jjMoveStringLiteralDfa5_0(active0, 0x10000000L);
      case 80:
         return jjMoveStringLiteralDfa5_0(active0, 0x200000L);
      case 82:
         return jjMoveStringLiteralDfa5_0(active0, 0xc00000L);
      case 97:
         return jjMoveStringLiteralDfa5_0(active0, 0x2000000000L);
      case 101:
         if ((active0 & 0x100000000L) != 0L)
            return jjStopAtPos(4, 32);
         else if ((active0 & 0x400000000L) != 0L)
            return jjStopAtPos(4, 34);
         return jjMoveStringLiteralDfa5_0(active0, 0x200000000L);
      case 115:
         return jjMoveStringLiteralDfa5_0(active0, 0x80000000L);
      case 116:
         return jjMoveStringLiteralDfa5_0(active0, 0x1040000000L);
      case 117:
         return jjMoveStringLiteralDfa5_0(active0, 0x800000000L);
      default :
         break;
   }
   return jjStartNfa_0(3, active0);
}
private final int jjMoveStringLiteralDfa5_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(3, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(4, active0);
      return 5;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa6_0(active0, 0xc000000L);
      case 69:
         return jjMoveStringLiteralDfa6_0(active0, 0xc00000L);
      case 78:
         return jjMoveStringLiteralDfa6_0(active0, 0x10000000L);
      case 79:
         return jjMoveStringLiteralDfa6_0(active0, 0x20000000L);
      case 82:
         return jjMoveStringLiteralDfa6_0(active0, 0x200000L);
      case 84:
         return jjMoveStringLiteralDfa6_0(active0, 0x3000000L);
      case 95:
         return jjMoveStringLiteralDfa6_0(active0, 0x1fe000L);
      case 101:
         if ((active0 & 0x800000000L) != 0L)
            return jjStopAtPos(5, 35);
         return jjMoveStringLiteralDfa6_0(active0, 0x40000000L);
      case 105:
         return jjMoveStringLiteralDfa6_0(active0, 0x80000000L);
      case 110:
         return jjMoveStringLiteralDfa6_0(active0, 0x200000000L);
      case 114:
         return jjMoveStringLiteralDfa6_0(active0, 0x1000000000L);
      case 117:
         return jjMoveStringLiteralDfa6_0(active0, 0x2000000000L);
      default :
         break;
   }
   return jjStartNfa_0(4, active0);
}
private final int jjMoveStringLiteralDfa6_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(4, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(5, active0);
      return 6;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa7_0(active0, 0x180000L);
      case 67:
         return jjMoveStringLiteralDfa7_0(active0, 0xc000000L);
      case 69:
         return jjMoveStringLiteralDfa7_0(active0, 0x200000L);
      case 70:
         return jjMoveStringLiteralDfa7_0(active0, 0x60000L);
      case 79:
         return jjMoveStringLiteralDfa7_0(active0, 0x2000L);
      case 80:
         return jjMoveStringLiteralDfa7_0(active0, 0x4000L);
      case 82:
         return jjMoveStringLiteralDfa7_0(active0, 0x18000L);
      case 83:
         return jjMoveStringLiteralDfa7_0(active0, 0xc00000L);
      case 84:
         return jjMoveStringLiteralDfa7_0(active0, 0x13000000L);
      case 105:
         return jjMoveStringLiteralDfa7_0(active0, 0x1000000000L);
      case 108:
         return jjMoveStringLiteralDfa7_0(active0, 0x2000000000L);
      case 109:
         if ((active0 & 0x40000000L) != 0L)
            return jjStopAtPos(6, 30);
         break;
      case 110:
         return jjMoveStringLiteralDfa7_0(active0, 0x20000000L);
      case 111:
         return jjMoveStringLiteralDfa7_0(active0, 0x80000000L);
      case 116:
         if ((active0 & 0x200000000L) != 0L)
            return jjStopAtPos(6, 33);
         break;
      default :
         break;
   }
   return jjStartNfa_0(5, active0);
}
private final int jjMoveStringLiteralDfa7_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(5, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(6, active0);
      return 7;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa8_0(active0, 0x260000L);
      case 69:
         return jjMoveStringLiteralDfa8_0(active0, 0x18000L);
      case 78:
         return jjMoveStringLiteralDfa8_0(active0, 0x2000L);
      case 79:
         return jjMoveStringLiteralDfa8_0(active0, 0x10000000L);
      case 82:
         return jjMoveStringLiteralDfa8_0(active0, 0x3004000L);
      case 84:
         return jjMoveStringLiteralDfa8_0(active0, 0xcd80000L);
      case 99:
         return jjMoveStringLiteralDfa8_0(active0, 0x1000000000L);
      case 110:
         if ((active0 & 0x80000000L) != 0L)
            return jjStopAtPos(7, 31);
         break;
      case 116:
         if ((active0 & 0x2000000000L) != 0L)
            return jjStopAtPos(7, 37);
         return jjMoveStringLiteralDfa8_0(active0, 0x20000000L);
      default :
         break;
   }
   return jjStartNfa_0(6, active0);
}
private final int jjMoveStringLiteralDfa8_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(6, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(7, active0);
      return 8;
   }
   switch(curChar)
   {
      case 67:
         return jjMoveStringLiteralDfa9_0(active0, 0x60000L);
      case 69:
         return jjMoveStringLiteralDfa9_0(active0, 0x4000L);
      case 73:
         return jjMoveStringLiteralDfa9_0(active0, 0x3000000L);
      case 76:
         return jjMoveStringLiteralDfa9_0(active0, 0x10000000L);
      case 77:
         return jjMoveStringLiteralDfa9_0(active0, 0x200000L);
      case 82:
         return jjMoveStringLiteralDfa9_0(active0, 0xc00000L);
      case 83:
         if ((active0 & 0x8000000L) != 0L)
            return jjStartNfaWithStates_0(8, 27, 5);
         return jjMoveStringLiteralDfa9_0(active0, 0x18000L);
      case 84:
         return jjMoveStringLiteralDfa9_0(active0, 0x182000L);
      case 95:
         return jjMoveStringLiteralDfa9_0(active0, 0x4000000L);
      case 111:
         return jjMoveStringLiteralDfa9_0(active0, 0x20000000L);
      case 116:
         return jjMoveStringLiteralDfa9_0(active0, 0x1000000000L);
      default :
         break;
   }
   return jjStartNfa_0(7, active0);
}
private final int jjMoveStringLiteralDfa9_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(7, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(8, active0);
      return 9;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa10_0(active0, 0x4000L);
      case 66:
         return jjMoveStringLiteralDfa10_0(active0, 0x3200000L);
      case 73:
         return jjMoveStringLiteralDfa10_0(active0, 0x4c00000L);
      case 79:
         return jjMoveStringLiteralDfa10_0(active0, 0x10002000L);
      case 82:
         return jjMoveStringLiteralDfa10_0(active0, 0x180000L);
      case 84:
         return jjMoveStringLiteralDfa10_0(active0, 0x78000L);
      case 105:
         return jjMoveStringLiteralDfa10_0(active0, 0x1000000000L);
      case 108:
         return jjMoveStringLiteralDfa10_0(active0, 0x20000000L);
      default :
         break;
   }
   return jjStartNfa_0(8, active0);
}
private final int jjMoveStringLiteralDfa10_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(8, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(9, active0);
      return 10;
   }
   switch(curChar)
   {
      case 67:
         return jjMoveStringLiteralDfa11_0(active0, 0xc00000L);
      case 71:
         return jjMoveStringLiteralDfa11_0(active0, 0x10000000L);
      case 73:
         return jjMoveStringLiteralDfa11_0(active0, 0x180000L);
      case 76:
         return jjMoveStringLiteralDfa11_0(active0, 0x202000L);
      case 77:
         return jjMoveStringLiteralDfa11_0(active0, 0x4000L);
      case 82:
         return jjMoveStringLiteralDfa11_0(active0, 0x18000L);
      case 83:
         if ((active0 & 0x20000L) != 0L)
            return jjStartNfaWithStates_0(10, 17, 5);
         break;
      case 84:
         return jjMoveStringLiteralDfa11_0(active0, 0x4000000L);
      case 85:
         return jjMoveStringLiteralDfa11_0(active0, 0x3000000L);
      case 95:
         return jjMoveStringLiteralDfa11_0(active0, 0x40000L);
      case 111:
         return jjMoveStringLiteralDfa11_0(active0, 0x1020000000L);
      default :
         break;
   }
   return jjStartNfa_0(9, active0);
}
private final int jjMoveStringLiteralDfa11_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(9, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(10, active0);
      return 11;
   }
   switch(curChar)
   {
      case 66:
         return jjMoveStringLiteralDfa12_0(active0, 0x184000L);
      case 69:
         if ((active0 & 0x200000L) != 0L)
            return jjStartNfaWithStates_0(11, 21, 5);
         return jjMoveStringLiteralDfa12_0(active0, 0x4000000L);
      case 73:
         return jjMoveStringLiteralDfa12_0(active0, 0x58000L);
      case 79:
         return jjMoveStringLiteralDfa12_0(active0, 0x2000L);
      case 84:
         return jjMoveStringLiteralDfa12_0(active0, 0x3c00000L);
      case 89:
         if ((active0 & 0x10000000L) != 0L)
            return jjStartNfaWithStates_0(11, 28, 5);
         break;
      case 103:
         return jjMoveStringLiteralDfa12_0(active0, 0x20000000L);
      case 110:
         if ((active0 & 0x1000000000L) != 0L)
            return jjStopAtPos(11, 36);
         break;
      default :
         break;
   }
   return jjStartNfa_0(10, active0);
}
private final int jjMoveStringLiteralDfa12_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(10, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(11, active0);
      return 12;
   }
   switch(curChar)
   {
      case 67:
         return jjMoveStringLiteralDfa13_0(active0, 0x18000L);
      case 69:
         return jjMoveStringLiteralDfa13_0(active0, 0x3000000L);
      case 71:
         return jjMoveStringLiteralDfa13_0(active0, 0x2000L);
      case 73:
         return jjMoveStringLiteralDfa13_0(active0, 0xc00000L);
      case 76:
         return jjMoveStringLiteralDfa13_0(active0, 0x4000L);
      case 77:
         if ((active0 & 0x4000000L) != 0L)
            return jjStartNfaWithStates_0(12, 26, 5);
         break;
      case 84:
         return jjMoveStringLiteralDfa13_0(active0, 0x40000L);
      case 85:
         return jjMoveStringLiteralDfa13_0(active0, 0x180000L);
      case 121:
         return jjMoveStringLiteralDfa13_0(active0, 0x20000000L);
      default :
         break;
   }
   return jjStartNfa_0(11, active0);
}
private final int jjMoveStringLiteralDfa13_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(11, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(12, active0);
      return 13;
   }
   switch(curChar)
   {
      case 45:
         return jjMoveStringLiteralDfa14_0(active0, 0x20000000L);
      case 69:
         if ((active0 & 0x4000L) != 0L)
            return jjStartNfaWithStates_0(13, 14, 5);
         return jjMoveStringLiteralDfa14_0(active0, 0x40000L);
      case 79:
         return jjMoveStringLiteralDfa14_0(active0, 0xc00000L);
      case 84:
         return jjMoveStringLiteralDfa14_0(active0, 0x198000L);
      case 89:
         if ((active0 & 0x2000L) != 0L)
            return jjStartNfaWithStates_0(13, 13, 5);
         break;
      case 95:
         return jjMoveStringLiteralDfa14_0(active0, 0x3000000L);
      default :
         break;
   }
   return jjStartNfa_0(12, active0);
}
private final int jjMoveStringLiteralDfa14_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(12, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(13, active0);
      return 14;
   }
   switch(curChar)
   {
      case 69:
         return jjMoveStringLiteralDfa15_0(active0, 0x20180000L);
      case 73:
         return jjMoveStringLiteralDfa15_0(active0, 0x1018000L);
      case 76:
         return jjMoveStringLiteralDfa15_0(active0, 0x2000000L);
      case 77:
         if ((active0 & 0x40000L) != 0L)
            return jjStartNfaWithStates_0(14, 18, 5);
         break;
      case 78:
         return jjMoveStringLiteralDfa15_0(active0, 0xc00000L);
      default :
         break;
   }
   return jjStartNfa_0(13, active0);
}
private final int jjMoveStringLiteralDfa15_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(13, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(14, active0);
      return 15;
   }
   switch(curChar)
   {
      case 73:
         return jjMoveStringLiteralDfa16_0(active0, 0x2000000L);
      case 79:
         return jjMoveStringLiteralDfa16_0(active0, 0x18000L);
      case 83:
         if ((active0 & 0x800000L) != 0L)
            return jjStartNfaWithStates_0(15, 23, 5);
         break;
      case 84:
         return jjMoveStringLiteralDfa16_0(active0, 0x1000000L);
      case 95:
         return jjMoveStringLiteralDfa16_0(active0, 0x580000L);
      case 100:
         return jjMoveStringLiteralDfa16_0(active0, 0x20000000L);
      default :
         break;
   }
   return jjStartNfa_0(14, active0);
}
private final int jjMoveStringLiteralDfa16_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(14, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(15, active0);
      return 16;
   }
   switch(curChar)
   {
      case 69:
         return jjMoveStringLiteralDfa17_0(active0, 0x1000000L);
      case 73:
         return jjMoveStringLiteralDfa17_0(active0, 0x500000L);
      case 76:
         return jjMoveStringLiteralDfa17_0(active0, 0x80000L);
      case 78:
         return jjMoveStringLiteralDfa17_0(active0, 0x18000L);
      case 83:
         return jjMoveStringLiteralDfa17_0(active0, 0x2000000L);
      case 105:
         return jjMoveStringLiteralDfa17_0(active0, 0x20000000L);
      default :
         break;
   }
   return jjStartNfa_0(15, active0);
}
private final int jjMoveStringLiteralDfa17_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(15, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(16, active0);
      return 17;
   }
   switch(curChar)
   {
      case 73:
         return jjMoveStringLiteralDfa18_0(active0, 0x80000L);
      case 77:
         if ((active0 & 0x1000000L) != 0L)
            return jjStartNfaWithStates_0(17, 24, 5);
         break;
      case 83:
         if ((active0 & 0x8000L) != 0L)
            return jjStartNfaWithStates_0(17, 15, 5);
         break;
      case 84:
         if ((active0 & 0x2000000L) != 0L)
            return jjStartNfaWithStates_0(17, 25, 5);
         return jjMoveStringLiteralDfa18_0(active0, 0x500000L);
      case 95:
         return jjMoveStringLiteralDfa18_0(active0, 0x10000L);
      case 116:
         return jjMoveStringLiteralDfa18_0(active0, 0x20000000L);
      default :
         break;
   }
   return jjStartNfa_0(16, active0);
}
private final int jjMoveStringLiteralDfa18_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(16, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(17, active0);
      return 18;
   }
   switch(curChar)
   {
      case 69:
         return jjMoveStringLiteralDfa19_0(active0, 0x500000L);
      case 73:
         return jjMoveStringLiteralDfa19_0(active0, 0x10000L);
      case 83:
         return jjMoveStringLiteralDfa19_0(active0, 0x80000L);
      case 111:
         return jjMoveStringLiteralDfa19_0(active0, 0x20000000L);
      default :
         break;
   }
   return jjStartNfa_0(17, active0);
}
private final int jjMoveStringLiteralDfa19_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(17, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(18, active0);
      return 19;
   }
   switch(curChar)
   {
      case 77:
         if ((active0 & 0x100000L) != 0L)
            return jjStartNfaWithStates_0(19, 20, 5);
         else if ((active0 & 0x400000L) != 0L)
            return jjStartNfaWithStates_0(19, 22, 5);
         break;
      case 84:
         if ((active0 & 0x80000L) != 0L)
            return jjStartNfaWithStates_0(19, 19, 5);
         return jjMoveStringLiteralDfa20_0(active0, 0x10000L);
      case 114:
         if ((active0 & 0x20000000L) != 0L)
            return jjStopAtPos(19, 29);
         break;
      default :
         break;
   }
   return jjStartNfa_0(18, active0);
}
private final int jjMoveStringLiteralDfa20_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(18, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(19, active0);
      return 20;
   }
   switch(curChar)
   {
      case 69:
         return jjMoveStringLiteralDfa21_0(active0, 0x10000L);
      default :
         break;
   }
   return jjStartNfa_0(19, active0);
}
private final int jjMoveStringLiteralDfa21_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(19, old0); 
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(20, active0);
      return 21;
   }
   switch(curChar)
   {
      case 77:
         if ((active0 & 0x10000L) != 0L)
            return jjStartNfaWithStates_0(21, 16, 5);
         break;
      default :
         break;
   }
   return jjStartNfa_0(20, active0);
}
static final long[] jjbitVec0 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
private final int jjMoveNfa_0(int startState, int curPos)
{
   int[] nextStates;
   int startsAt = 0;
   jjnewStateCnt = 40;
   int i = 1;
   jjstateSet[0] = startState;
   int j, kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               case 3:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(0, 6);
                  else if (curChar == 34)
                     jjCheckNAddStates(7, 9);
                  else if (curChar == 46)
                     jjCheckNAdd(11);
                  else if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 2;
                  if ((0x3fe000000000000L & l) != 0L)
                  {
                     if (kind > 39)
                        kind = 39;
                     jjCheckNAddTwoStates(9, 7);
                  }
                  else if (curChar == 48)
                  {
                     if (kind > 39)
                        kind = 39;
                     jjCheckNAdd(7);
                  }
                  break;
               case 0:
                  if (curChar == 42)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
                  if ((0xffff7fffffffffffL & l) != 0L && kind > 7)
                     kind = 7;
                  break;
               case 2:
                  if (curChar == 42)
                     jjstateSet[jjnewStateCnt++] = 0;
                  break;
               case 5:
                  if ((0x3ff001000000000L & l) == 0L)
                     break;
                  if (kind > 38)
                     kind = 38;
                  jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 6:
                  if (curChar != 48)
                     break;
                  if (kind > 39)
                     kind = 39;
                  jjCheckNAdd(7);
                  break;
               case 8:
                  if ((0x3fe000000000000L & l) == 0L)
                     break;
                  if (kind > 39)
                     kind = 39;
                  jjCheckNAddTwoStates(9, 7);
                  break;
               case 9:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 39)
                     kind = 39;
                  jjCheckNAddTwoStates(9, 7);
                  break;
               case 10:
                  if (curChar == 46)
                     jjCheckNAdd(11);
                  break;
               case 11:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 40)
                     kind = 40;
                  jjCheckNAddStates(10, 12);
                  break;
               case 13:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(14);
                  break;
               case 14:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 40)
                     kind = 40;
                  jjCheckNAddTwoStates(14, 15);
                  break;
               case 16:
                  if (curChar == 34)
                     jjCheckNAddStates(7, 9);
                  break;
               case 17:
                  if ((0xfffffffbffffdbffL & l) != 0L)
                     jjCheckNAddStates(7, 9);
                  break;
               case 19:
                  if ((0x8400000000L & l) != 0L)
                     jjCheckNAddStates(7, 9);
                  break;
               case 20:
                  if (curChar == 34 && kind > 41)
                     kind = 41;
                  break;
               case 21:
                  if ((0xff000000000000L & l) != 0L)
                     jjCheckNAddStates(13, 16);
                  break;
               case 22:
                  if ((0xff000000000000L & l) != 0L)
                     jjCheckNAddStates(7, 9);
                  break;
               case 23:
                  if ((0xf000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 24:
                  if ((0xff000000000000L & l) != 0L)
                     jjCheckNAdd(22);
                  break;
               case 25:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(0, 6);
                  break;
               case 26:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(26, 27);
                  break;
               case 27:
                  if (curChar != 46)
                     break;
                  if (kind > 40)
                     kind = 40;
                  jjCheckNAddStates(17, 19);
                  break;
               case 28:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 40)
                     kind = 40;
                  jjCheckNAddStates(17, 19);
                  break;
               case 30:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(31);
                  break;
               case 31:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 40)
                     kind = 40;
                  jjCheckNAddTwoStates(31, 15);
                  break;
               case 32:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(32, 33);
                  break;
               case 34:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(35);
                  break;
               case 35:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 40)
                     kind = 40;
                  jjCheckNAddTwoStates(35, 15);
                  break;
               case 36:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(20, 22);
                  break;
               case 38:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(39);
                  break;
               case 39:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(39, 15);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               case 3:
               case 5:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 38)
                     kind = 38;
                  jjCheckNAdd(5);
                  break;
               case 1:
                  if (kind > 7)
                     kind = 7;
                  break;
               case 7:
                  if ((0x100000001000L & l) != 0L && kind > 39)
                     kind = 39;
                  break;
               case 12:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(23, 24);
                  break;
               case 15:
                  if ((0x5000000050L & l) != 0L && kind > 40)
                     kind = 40;
                  break;
               case 17:
                  if ((0xffffffffefffffffL & l) != 0L)
                     jjCheckNAddStates(7, 9);
                  break;
               case 18:
                  if (curChar == 92)
                     jjAddStates(25, 27);
                  break;
               case 19:
                  if ((0x14404410000000L & l) != 0L)
                     jjCheckNAddStates(7, 9);
                  break;
               case 29:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(28, 29);
                  break;
               case 33:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(30, 31);
                  break;
               case 37:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(32, 33);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         MatchLoop: do
         {
            switch(jjstateSet[--i])
            {
               case 1:
                  if ((jjbitVec0[i2] & l2) != 0L && kind > 7)
                     kind = 7;
                  break;
               case 17:
                  if ((jjbitVec0[i2] & l2) != 0L)
                     jjAddStates(7, 9);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 40 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
static final int[] jjnextStates = {
   26, 27, 32, 33, 36, 37, 15, 17, 18, 20, 11, 12, 15, 17, 18, 22, 
   20, 28, 29, 15, 36, 37, 15, 13, 14, 19, 21, 23, 30, 31, 34, 35, 
   38, 39, 
};
public static final String[] jjstrLiteralImages = {
"", null, null, null, null, null, null, null, null, null, null, null, null, 
"\102\105\107\111\116\137\117\116\124\117\114\117\107\131", "\102\105\107\111\116\137\120\122\105\101\115\102\114\105", 
"\102\105\107\111\116\137\122\105\123\124\122\111\103\124\111\117\116\123", 
"\102\105\107\111\116\137\122\105\123\124\122\111\103\124\111\117\116\137\111\124\105\115", "\102\105\107\111\116\137\106\101\103\124\123", 
"\102\105\107\111\116\137\106\101\103\124\137\111\124\105\115", 
"\102\105\107\111\116\137\101\124\124\122\111\102\125\124\105\137\114\111\123\124", 
"\102\105\107\111\116\137\101\124\124\122\111\102\125\124\105\137\111\124\105\115", "\105\116\104\137\120\122\105\101\115\102\114\105", 
"\105\116\104\137\122\105\123\124\122\111\103\124\111\117\116\137\111\124\105\115", "\105\116\104\137\122\105\123\124\122\111\103\124\111\117\116\123", 
"\105\116\104\137\101\124\124\122\111\102\125\124\105\137\111\124\105\115", "\105\116\104\137\101\124\124\122\111\102\125\124\105\137\114\111\123\124", 
"\105\116\104\137\106\101\103\124\137\111\124\105\115", "\105\116\104\137\106\101\103\124\123", 
"\105\116\104\137\117\116\124\117\114\117\107\131", 
"\132\105\125\123\55\117\156\164\157\154\157\147\171\55\105\144\151\164\157\162", "\72\163\171\163\164\145\155", "\72\166\145\162\163\151\157\156", 
"\72\156\141\155\145", "\72\160\141\162\145\156\164", "\72\164\171\160\145", 
"\72\166\141\154\165\145", "\72\162\145\163\164\162\151\143\164\151\157\156", 
"\72\144\145\146\141\165\154\164", null, null, null, null, null, null, null, null, };
public static final String[] lexStateNames = {
   "DEFAULT", 
   "IN_SINGLE_LINE_COMMENT", 
   "IN_FORMAL_COMMENT", 
   "IN_MULTI_LINE_COMMENT", 
};
public static final int[] jjnewLexState = {
   -1, -1, -1, -1, -1, -1, 1, 2, 3, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
};
static final long[] jjtoToken = {
   0x3ffffffe001L, 
};
static final long[] jjtoSkip = {
   0xe3eL, 
};
static final long[] jjtoSpecial = {
   0xe00L, 
};
static final long[] jjtoMore = {
   0x11c0L, 
};
private ASCII_CharStream input_stream;
private final int[] jjrounds = new int[40];
private final int[] jjstateSet = new int[80];
StringBuffer image;
int jjimageLen;
int lengthOfMatch;
protected char curChar;
public OntologyParserTokenManager(ASCII_CharStream stream)
{
   if (ASCII_CharStream.staticFlag)
      throw new Error("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");
   input_stream = stream;
}
public OntologyParserTokenManager(ASCII_CharStream stream, int lexState)
{
   this(stream);
   SwitchTo(lexState);
}
public void ReInit(ASCII_CharStream stream)
{
   jjmatchedPos = jjnewStateCnt = 0;
   curLexState = defaultLexState;
   input_stream = stream;
   ReInitRounds();
}
private final void ReInitRounds()
{
   int i;
   jjround = 0x80000001;
   for (i = 40; i-- > 0;)
      jjrounds[i] = 0x80000000;
}
public void ReInit(ASCII_CharStream stream, int lexState)
{
   ReInit(stream);
   SwitchTo(lexState);
}
public void SwitchTo(int lexState)
{
   if (lexState >= 4 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
   else
      curLexState = lexState;
}

private final Token jjFillToken()
{
   Token t = Token.newToken(jjmatchedKind);
   t.kind = jjmatchedKind;
   String im = jjstrLiteralImages[jjmatchedKind];
   t.image = (im == null) ? input_stream.GetImage() : im;
   t.beginLine = input_stream.getBeginLine();
   t.beginColumn = input_stream.getBeginColumn();
   t.endLine = input_stream.getEndLine();
   t.endColumn = input_stream.getEndColumn();
   return t;
}

int curLexState = 0;
int defaultLexState = 0;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

public final Token getNextToken() 
{
  int kind;
  Token specialToken = null;
  Token matchedToken;
  int curPos = 0;

/* BEGIN: BUG FIX for JDK1.2 on Windows */
try {
/* END: BUG FIX for JDK1.2 on Windows */
  EOFLoop :
  for (;;)
  {   
   try   
   {     
      curChar = input_stream.BeginToken();
   }     
   catch(java.io.IOException e)
   {        
      jjmatchedKind = 0;
      matchedToken = jjFillToken();
      matchedToken.specialToken = specialToken;
      return matchedToken;
   }
   image = null;
   jjimageLen = 0;

   for (;;)
   {
     switch(curLexState)
     {
       case 0:
         try { 
            while (curChar <= 32 && (0x100003600L & (1L << curChar)) != 0L)
               curChar = input_stream.BeginToken();
         }
/* BEGIN: BUG FIX for JDK1.2 on Windows */
         catch(java.io.IOException e1) {
            jjmatchedKind = 0;
            matchedToken = new Token();
            matchedToken.kind = 0;
            matchedToken.image = "<EOF>";
            matchedToken.specialToken = specialToken;
            matchedToken.next = null;
            return matchedToken;
         }
/* END: BUG FIX for JDK1.2 on Windows */
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_0();
         break;
       case 1:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_1();
         if (jjmatchedPos == 0 && jjmatchedKind > 12)
         {
            jjmatchedKind = 12;
         }
         break;
       case 2:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_2();
         if (jjmatchedPos == 0 && jjmatchedKind > 12)
         {
            jjmatchedKind = 12;
         }
         break;
       case 3:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_3();
         if (jjmatchedPos == 0 && jjmatchedKind > 12)
         {
            jjmatchedKind = 12;
         }
         break;
     }
     if (jjmatchedKind != 0x7fffffff)
     {
        if (jjmatchedPos + 1 < curPos)
           input_stream.backup(curPos - jjmatchedPos - 1);
        if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           matchedToken = jjFillToken();
           matchedToken.specialToken = specialToken;
       if (jjnewLexState[jjmatchedKind] != -1)
         curLexState = jjnewLexState[jjmatchedKind];
           return matchedToken;
        }
        else if ((jjtoSkip[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           if ((jjtoSpecial[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
           {
              matchedToken = jjFillToken();
              if (specialToken == null)
                 specialToken = matchedToken;
              else
              {
                 matchedToken.specialToken = specialToken;
                 specialToken = (specialToken.next = matchedToken);
              }
              SkipLexicalActions(matchedToken);
           }
           else 
              SkipLexicalActions(null);
         if (jjnewLexState[jjmatchedKind] != -1)
           curLexState = jjnewLexState[jjmatchedKind];
           continue EOFLoop;
        }
        MoreLexicalActions();
      if (jjnewLexState[jjmatchedKind] != -1)
        curLexState = jjnewLexState[jjmatchedKind];
        curPos = 0;
        jjmatchedKind = 0x7fffffff;
        try {
           curChar = input_stream.readChar();
           continue;
        }
        catch (java.io.IOException e1) { }
     }
     int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
   }
  }
/* BEGIN: BUG FIX for JDK1.2 on Windows */
}
catch(Exception x) {
   jjmatchedKind = 0;
   matchedToken = new Token();
   matchedToken.kind = 0;
   matchedToken.image = "<EOF>";
   matchedToken.specialToken = specialToken;
   matchedToken.next = null;
   return matchedToken;
}
/* END: BUG FIX for JDK1.2 on Windows */
}

final void SkipLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      default :
         break;
   }
}
final void MoreLexicalActions()
{
   jjimageLen += (lengthOfMatch = jjmatchedPos + 1);
   switch(jjmatchedKind)
   {
      case 7 :
         if (image == null)
              image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen)));
         else
            image.append(new String(input_stream.GetSuffix(jjimageLen)));
         jjimageLen = 0;
                   input_stream.backup(1);
         break;
      default : 
         break;
   }
}
}
