/*
* The contents of this file are subject to the BT "ZEUS" Open Source 
* Licence (L77741), Version 1.0 (the "Licence"); you may not use this file 
* except in compliance with the Licence. You may obtain a copy of the Licence
* from $ZEUS_INSTALL/licence.html or alternatively from
* http://www.labs.bt.com/projects/agents/zeus/licence.htm
* 
* Except as stated in Clause 7 of the Licence, software distributed under the
* Licence is distributed WITHOUT WARRANTY OF ANY KIND, either express or 
* implied. See the Licence for the specific language governing rights and 
* limitations under the Licence.
* 
* The Original Code is within the package zeus.*.
* The Initial Developer of the Original Code is British Telecommunications
* public limited company, whose registered office is at 81 Newgate Street, 
* London, EC1A 7AJ, England. Portions created by British Telecommunications 
* public limited company are Copyright 1996-2001. All Rights Reserved.
* 
* THIS NOTICE MUST BE INCLUDED ON ANY COPY OF THIS FILE
*/



package zeus.concepts;

import java.util.*;
import zeus.util.*;

public class MessageActionImpl implements MessageAction {
   public static final int EXECUTE_ONCE = 0;
   public static final int EXECUTE_MANY = 1;
 
   


   protected Object object = null;
   protected String method = null;
   protected int    type;


   public MessageActionImpl(int type, Object object, String method) {
      Assert.notFalse(type == EXECUTE_ONCE || type == EXECUTE_MANY);
      Assert.notNull(object);
      Assert.notNull(method);
      this.type = type;
      this.object = object;
      this.method = method;
   }
   
   
   public MessageActionImpl(Object object, String method) {
      Assert.notNull(object);
      Assert.notNull(method);
      this.type = EXECUTE_MANY;
      this.object = object;
      this.method = method;
   }
   
   
   public Object getObject() { return object; }
   public String getMethod() { return method; }
   public int    getType()   { return type; }

   public String toString() {
      Class c = object.getClass();
      String s = c.getName();
      return s + "$" + method;
   }
}
