/*
* The contents of this file are subject to the BT "ZEUS" Open Source 
* Licence (L77741), Version 1.0 (the "Licence"); you may not use this file 
* except in compliance with the Licence. You may obtain a copy of the Licence
* from $ZEUS_INSTALL/licence.html or alternatively from
* http://www.labs.bt.com/projects/agents/zeus/licence.htm
* 
* Except as stated in Clause 7 of the Licence, software distributed under the
* Licence is distributed WITHOUT WARRANTY OF ANY KIND, either express or 
* implied. See the Licence for the specific language governing rights and 
* limitations under the Licence.
* 
* The Original Code is within the package zeus.*.
* The Initial Developer of the Original Code is British Telecommunications
* public limited company, whose registered office is at 81 Newgate Street, 
* London, EC1A 7AJ, England. Portions created by British Telecommunications 
* public limited company are Copyright 1996-2001. All Rights Reserved.
* 
* THIS NOTICE MUST BE INCLUDED ON ANY COPY OF THIS FILE
*/
package zeus.actors.outtrays;

import javax.agent.service.*; 
import javax.agent.*; 
import zeus.actors.*;
import FIPA.*; 

/** 
    Class that provides a MTS that implements the FIPA 2000 spec (XC00075)
    @author Simon Thompson
    @since 1.1
    */
public class FIPA_2000_IIOP_Transport implements OutTray { 
    
    /** 
        mts used to internally implement transport functionality
        */
    private FIPA.MTS mts = null; 

    
    
    /** 
        this transport must be implemented with a valid FIPA.MTS object. <p> 
        The FIPA.MTS in question should have been generated by calling a 
        CORBA orb and retreiving a reference to a FIPA.MTS that had been 
        bound there by a third party. <p> 
        The recommeneded way of doing this is to use zeus.actors.service.TransportMethod to 
        generate a TransportFactory (probably the IIOP_Z_TransportFactory, but 
        possibly another one depending on what version of zeus or other related 
        product you are using). Once you have the TransportFactory reference you must 
        then call getTransport which will return an instance of this class. 
        <p> Alternatively, you must venture into the realms of corba coding and 
        sort this out yourself!
        <p> 
        @see zeus.actors.service.TransportMethod*/
    public FIPA_2000_IIOP_Transport (FIPA.MTS mts) { 
        this.mts = mts; 
    }
    
   
    public void send  (Object obj) throws UnsuitableMessageException { 
        try { 
            javax.agent.Envelope env = (javax.agent.Envelope) obj; 
            send (env); 
        } catch (ClassCastException cce) { 
            throw new UnsuitableMessageException ("Must be javax.agent.envelope to work with this transport"); 
        }catch (Exception e) { 
            e.printStackTrace(); 
            throw new UnsuitableMessageException ("Bad message in send() - unknown problem, Excepiton printed to sout"); 
         
        }
     }
     
    
    public void send (javax.agent.Envelope envelope) { 
        Identifier sender = envelope.getSender(); 
        Identifier receiver = envelope.getReceiver(); 
        Object payload = envelope.getObject();
        try { 
            zeus.concepts.FIPAPerformative fperf = (zeus.concepts.FIPAPerformative) payload;       
            debug ("Performative is : \n" + fperf.toFIPAString()); 
            FIPA.Envelope fenv = new FIPA.Envelope(); 
           
            try { 
            fenv.to = fperf.getReceiversAgentID(); 

                   } catch (NullPointerException npe) { ;}
            try { 
            fenv.from = fperf.getSenderAgentID(); 
                   } catch (NullPointerException npe) { 
                    fenv.from = new FIPA.AgentID[0];}
                    //("null",new String[0], new FIPA.AgentID[0], new FIPA.Property[0]);}
            try { 
            fenv.comments = new String ("Zeus Agent Building Environment v1.1"); 
                   } catch (NullPointerException npe) { ;}

            fenv.payloadLength = -1; // indicates that it is up to the ACC to work this out. 

            fenv.payloadEncoding = new String ("String"); 

            fenv.aclRepresentation = new String ("fipa.acl.rep.string.std"); 

            fenv.date = new FIPA.DateTime[0];
   
            fenv.encrypted = new String [1]; 

            fenv.encrypted[0] = fperf.getEncryptionScheme(); 

            fenv.intendedReceiver = fperf.getReceiversAgentID (); 
      
          //  fenv.intendedReceiver[0].getAddress
      
            fenv.received = new FIPA.ReceivedObject[0];

            fenv.transportBehaviour = new FIPA.Property[0][0];

            fenv.userDefinedProperties = new FIPA.Property[0]; 

            FIPA.Envelope envelopes[]  = {fenv}; 
            
            FIPA.FipaMessage message = new FIPA.FipaMessage(envelopes,fperf.toFIPAString().getBytes());
            debug ("Sending message "+message.toString()); 
            mts.message (message); 
            debug ("message sent"); 
            
            
         }        
         catch (ClassCastException cce) {            
                    // I know that this is a bit grim.... 
                    // let's not bring everything down for one mistake...
                    cce.printStackTrace(); 
                    return; 
                } 
    }
    
    
   
    private void debug (String str) { 
            System.out.println("FIPA_2000_IIOP_Transport >>" + str); 
    }
    
}