/*
 * Licence (L77741), Version 1.0 (the "Licence"); you may not use this file
 * except in compliance with the Licence. You may obtain a copy of the Licence
 * from $ZEUS_INSTALL/licence.html or alternatively from
 * http://www.labs.bt.com/projects/agents/zeus/licence.htm
 *
 * Except as stated in Clause 7 of the Licence, software distributed under the
 * Licence is distributed WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the Licence for the specific language governing rights and
 * limitations under the Licence.
 *
 * The Original Code is within the package zeus.*.
 * The Initial Developer of the Original Code is British Telecommunications
 * public limited company, whose registered office is at 81 Newgate Street,
 * London, EC1A 7AJ, England. Portions created by British Telecommunications
 * public limited company are Copyright 1996-9. All Rights Reserved.
 *
 * THIS NOTICE MUST BE INCLUDED ON ANY COPY OF THIS FILE
 */
package zeus.actors;
import zeus.concepts.*;
import zeus.agents.*;
/**
 * TaskContext is a API which should make it easy for the agent developer (you!) to
 * access the parts of the system and agent that you need to develop code which
 * changes the system state when an agents deliberative engine (it's planner)
 * decides to execute some code <p>
 * You use TaskContext is a little like AgentContext in ZeusExternals. However whereas the
 * AgentContext object is used to store the AgentState, TaskContext is nowhere near as important
 * to the system - it just acts as a bag of refereneces for you to access and use. These
 * references are loaded into the class by task generated by  TaskWriter when it has a primative
 * class with a TaskExternal defined.
 * <p>
 * Useful methods are : <br>
 * <li> <i> AgentContext getAgentContext (); </i>  which returns the context object for the
 * agent that is executing this task
 * <li> <i> Fact [][] getInputArgs (); </i> which returns the input facts (preconditions) for
 * this task
 * <li> <i> Fact [][] getOutputArgs (); </i> which gives you the output arguements (postconditions
 * for this task. Obviously one use of the task exteranl is to change these so that they
 * are dependent on the decisions that are made by the user code here
 * <li> <i> ZeusExteranl getExternal (); </i> which gives you a referenece back to the external
 * program that you have given to the agent - but you will have to cast the reference to the
 * external manually, which is why we put in...
 * <li> <i> String getExternalClassName(); </i> which you can use to get the name of the
 * external in case the task is used by many agents that have different externals.
 * @see AgentContext
 * @see zeus.concepts.PrimativeTask
 * @see zeus.generator.code.TaskWriter;
 * @author Simon Thompson
 * @version 1.04
 */
public class TaskContext {
    
    private AgentContext context = null;
    private Fact[][] inputArgs = null;
    private Fact[][] outputArgs = null;
    private Fact[] expInputArgs = null; // MS 160101 v1.05
    private Fact[] expOutputArgs = null; // MS 160101 v1.05
    
    public TaskContext() {;}
    
    
    public void setAgentContext (AgentContext context) {
        this.context = context; }
        
        
        public void setInputArgs (Fact [][] inputArgs) {
            this.inputArgs = inputArgs;
        }
        
        
        public void setOutputArgs (Fact [][] outputArgs) {
            this.outputArgs = outputArgs;
        }
        
        // MS 160101 v1.05
        public void setExpInputArgs (Fact [] expInputArgs) {
            this.expInputArgs = expInputArgs;
        }
        
        // MS 160101 v1.05
        public void setExpOutputArgs (Fact [] expOutputArgs) {
            this.expOutputArgs = expOutputArgs;
        }
        
        public AgentContext getAgentContext () {
            return this.context;}
            
            
            public Fact [][] getOutputArgs () {
                return this.outputArgs;
            }
            
            
            public Fact [][] getInputArgs () {
                return this.inputArgs;
            }
            
            public Fact [] getExpOutputArgs () {   // MS 160101 v1.05
                return this.expOutputArgs;
            }
            
            
            public Fact [] getExpInputArgs () {   // MS 160101 v1.05
                return this.expInputArgs;
            }
            
            public ZeusExternal getZeusExternal () {
                if (context== null) {
                    return null; }
                return (context.ZeusExternal());
            }
            
            
            public String getExternalClassName () {
                if (context== null) {
                    return null; }
                ZeusExternal zExtern = context.ZeusExternal();
                Class zeClass = zExtern.getClass();
                return (zeClass.getName());
            }
            
            
}