/*
* The contents of this file are subject to the BT "ZEUS" Open Source 
* Licence (L77741), Version 1.0 (the "Licence"); you may not use this file 
* except in compliance with the Licence. You may obtain a copy of the Licence
* from $ZEUS_INSTALL/licence.html or alternatively from
* http://www.labs.bt.com/projects/agents/zeus/licence.htm
* 
* Except as stated in Clause 7 of the Licence, software distributed under the
* Licence is distributed WITHOUT WARRANTY OF ANY KIND, either express or 
* implied. See the Licence for the specific language governing rights and 
* limitations under the Licence.
* 
* The Original Code is within the package zeus.*.
* The Initial Developer of the Original Code is British Telecommunications
* public limited company, whose registered office is at 81 Newgate Street, 
* London, EC1A 7AJ, England. Portions created by British Telecommunications 
* public limited company are Copyright 1996-9. All Rights Reserved.
* 
* THIS NOTICE MUST BE INCLUDED ON ANY COPY OF THIS FILE
*/



package zeus.actors;

import java.util.*;
import zeus.util.*;
import zeus.concepts.*;


public abstract class MsgNode {
   Hashtable  successors = new Hashtable();
   MsgHandler engine = null;
   int use_count = 0;

   // meaningless init  to allow rearch
   // this one may be tricky...
  public MsgNode () {
  ;
  }

   MsgNode(MsgHandler engine) {
      this.engine = engine;
   }

   void addSuccessor(String path, MsgNode node) {
      //System.out.println("path = " + path + " node = " + node);
      Assert.notFalse( successors.put(path,node) == null );
   }

   void propagate(String path, Performative input) {
      StringBuffer err = new StringBuffer (40); 
      err.append ("\nMsgHandler Propagate: "); 
      err.append (path); 
      err.append (" MsgNode"); 
      //err.append (this); 
      Core.DEBUG(5,err);
      MsgNode node = (MsgNode)successors.get(path);
      node.evaluate(path,input);
   }

   abstract void evaluate(String path, Performative input);

   void remove(String path) {
      Core.DEBUG(5,"\nMsgHandler Remove: " + path + " " + this);
      MsgNode node = (MsgNode)successors.remove(path);
      if ( node != null ) {
         use_count--;
         node.remove(path);
      }
   }
}
