/* Generated By:JavaCC: Do not edit this line. SL0Parser.java */
package sl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.StringReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import java.util.List;
import java.util.ArrayList;

public class SL0Parser implements SL0ParserConstants {


  /**
  * @return a List of Frame, each Frame represents an element of a t-uple
  */
  public List parse(String s) throws ParseException, TokenMgrError {
    ReInit(new StringReader(s));
    return SL0Content();
  }


  public static void main(String[] args) {
    System.out.println("SL0 Parser started...");
    SL0Parser theParser = new SL0Parser(new BufferedReader(new InputStreamReader(System.in)));
    SL0Codec codec = new SL0Codec();
    Ontology o = new DefaultOntology();

    while (true) {
        System.out.println("insert an SL0 expression to parse: ");
      try {
        List result = theParser.SL0Content();
        System.out.println("AFTER ENCODING: "+codec.encode(result,o));
      }
      catch(ParseException pe) {
        pe.printStackTrace();
        System.exit(1);
      }
      catch(TokenMgrError tme) {
        tme.printStackTrace();
      }
    }
  }

/* 

   The following grammar productions try to match as closely as
   possible the SL0 grammar given in FIPA 2000 (document no. 8) 
   The differences are as follows:

   1) In order to keep single lookahead, braces have been factored out
      whenever possible. So, the parser methods corresponding to
      ActionExpression and to FunctionalTerm don't expect
      neither opening nor closing brace. Braces are explicitly
      indicated in the calling methods/productions.

   2) Identical productions have been merged into one; these are:
      - PropositionSymbol, "true" and "false", that all result in a single String.

   3) Due to the production merging of the previous point, the
      AtomicFormula production is no more needed. 
      The
      only difference with the original grammar is that here "result"
      is no more a reserved word.
*/



/*   P R O D U C T I O N    R U L E S  */

/**
* This production rule represents the more general expression that can
* serve as content for an ACL message. Since different communicative
* acts have different content (action expressions for
* <code>request</code>, predicate for <code>inform</code>, etc.), any
* allowed SL content expression can be parsed from here.
*/
  final public List SL0Content() throws ParseException {
  Frame result;
  List tuple = new ArrayList();
    jj_consume_token(LBRACE);
    label_1:
    while (true) {
      result = ContentExpression();
                                         tuple.add(result);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
      case WORD:
      case STRING_LITERAL:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
    }
    jj_consume_token(RBRACE);
  {if (true) return tuple;}
    throw new Error("Missing return statement in function");
  }

  final public Frame ContentExpression() throws ParseException {
  Frame result;
  String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WORD:
    case STRING_LITERAL:
      s = String();
                 result = new Frame(s);
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ACTION:
        result = ActionExpression();
        break;
      case WORD:
      case STRING_LITERAL:
        result = Wff();
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
   {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public Frame Wff() throws ParseException {
  Frame result;
  String s;
  Object obj;
    s = String();
               result = new Frame(s);
    label_2:
    while (true) {
      obj = Term();
                 result.putSlot(obj);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
      case INTEGER:
      case HEXINTEGER:
      case FLOATONE:
      case FLOATTWO:
      case WORD:
      case STRING_LITERAL:
      case DATETIME:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
    }
   {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public Object Term() throws ParseException {
 Object obj;
 Token  t;
 String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WORD:
    case STRING_LITERAL:
      obj = String();
        // if it is true or false, then converts the String into a Boolean
                  if (obj.toString().equalsIgnoreCase("true") ||
                      obj.toString().equalsIgnoreCase("false") )
                    obj = new Boolean(obj.toString());
      break;
    case INTEGER:
    case HEXINTEGER:
    case FLOATONE:
    case FLOATTWO:
      obj = Number();
      break;
    case DATETIME:
      t = jj_consume_token(DATETIME);
                    try { obj=ISO8601.toDate(t.image);}
                    catch (Exception e) { obj = new String(t.image); }
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WORD:
      case STRING_LITERAL:
        s = String();
                          obj = new Frame(s);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case INTEGER:
        case HEXINTEGER:
        case FLOATONE:
        case FLOATTWO:
        case WORD:
        case STRING_LITERAL:
        case PARAMETERNAME:
        case DATETIME:
          FunctionalTermParams((Frame)obj);
          break;
        default:
          jj_la1[4] = jj_gen;
          ;
        }
        break;
      case ACTION:
        obj = ActionExpression();
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Frame ActionExpression() throws ParseException {
  Frame result;
  Object agentID;
  Object action;
    jj_consume_token(ACTION);
    agentID = Term();
    action = Term();
    result = new Frame(SL0Codec.NAME_OF_ACTION_FRAME);
    result.putSlot(SL0Codec.NAME_OF_ACTOR_SLOT, agentID);
    result.putSlot(SL0Codec.NAME_OF_ACTION_SLOT, action);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public void FunctionalTermParams(Frame result) throws ParseException {
  Object obj;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
    case INTEGER:
    case HEXINTEGER:
    case FLOATONE:
    case FLOATTWO:
    case WORD:
    case STRING_LITERAL:
    case DATETIME:
      label_3:
      while (true) {
        obj = Term();
                 result.putSlot(obj);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case INTEGER:
        case HEXINTEGER:
        case FLOATONE:
        case FLOATTWO:
        case WORD:
        case STRING_LITERAL:
        case DATETIME:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_3;
        }
      }
      break;
    case PARAMETERNAME:
      label_4:
      while (true) {
        Parameter(result);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PARAMETERNAME:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_4;
        }
      }
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
Notice that this production, as a side effect, also adds a slot to result.
The initial char ':' is removed from the slotName
**/
  final public void Parameter(Frame result) throws ParseException {
  Token name;
  Object value;
    name = jj_consume_token(PARAMETERNAME);
    value = Term();
    result.putSlot(name.image.substring(1), value);
  }

/**
* <p> <code> String = WORD | STRING_LITERAL  </code>
*/
  final public String String() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WORD:
      t = jj_consume_token(WORD);
                         {if (true) return t.image;}
      break;
    case STRING_LITERAL:
      t = jj_consume_token(STRING_LITERAL);
                         {if (true) return (t.image.equalsIgnoreCase("\"action\"")?"action":t.image);}
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Object Number() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER:
      t = jj_consume_token(INTEGER);
                  {if (true) return new Long(t.image);}
      break;
    case HEXINTEGER:
      t = jj_consume_token(HEXINTEGER);
                     {if (true) return new String(t.image);}
      break;
    case FLOATONE:
      t = jj_consume_token(FLOATONE);
                   {if (true) return new Double(t.image);}
      break;
    case FLOATTWO:
      t = jj_consume_token(FLOATTWO);
                   {if (true) return new Double(t.image);}
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  public SL0ParserTokenManager token_source;
  ASCII_UCodeESC_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[12];
  final private int[] jj_la1_0 = {0x3020,0x3080,0x3020,0xbf20,0xff20,0x3080,0xbf20,0xbf20,0x4000,0xff20,0x3000,0xf00,};

  public SL0Parser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_UCodeESC_CharStream(stream, 1, 1);
    token_source = new SL0ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
  }

  public SL0Parser(java.io.Reader stream) {
    jj_input_stream = new ASCII_UCodeESC_CharStream(stream, 1, 1);
    token_source = new SL0ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
  }

  public SL0Parser(SL0ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
  }

  public void ReInit(SL0ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[16];
    for (int i = 0; i < 16; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 12; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 16; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
