# SQL driver file tweaks for postgres
#-------------------------------------------------------------------
# Initialize a blank database - create tables and indexes - compound statement group
initDBtables
CREATE TABLE RDF_LAYOUT_INFO (
   NAME VARCHAR(120) NOT NULL PRIMARY KEY,
   VAL VARCHAR(250)
);;
CREATE TABLE RDF_RESOURCES (
   ID ${id} NOT NULL PRIMARY KEY,
   NAMESPACE ${id} NOT NULL,
   STATEMENT ${id},			/* used if the resource points to a reified statement */
   LOCALNAME VARCHAR(250) NOT NULL
);;
CREATE INDEX RDF_IDX_RESOURCES_NAME ON RDF_RESOURCES(NAMESPACE, LOCALNAME);;
CREATE TABLE RDF_NAMESPACES (
    ID ${id} NOT NULL PRIMARY KEY,
    URI varchar(250) NOT NULL
);;
CREATE INDEX RDF_IDX_NAMESPACES ON RDF_NAMESPACES(URI);;
CREATE TABLE RDF_LITERALS (
    ID ${id} NOT NULL PRIMARY KEY,
    LANGUAGE VARCHAR(250),
# The biggest subset of the literal that the database can index
    LITERAL_IDX VARCHAR(32000) NOT NULL,
# The full literal, null if the LITERAL_IDX covers the whole literal
    LITERAL OID,
    INT_OK SMALLINT,            /* flag that literal is interpetable as an int */
    INT_LITERAL INT,
    WELL_FORMED SMALLINT
);;
CREATE INDEX RDF_IDX_LITERALS ON RDF_LITERALS(LITERAL_IDX);;
CREATE INDEX RDF_IDX_INT_LITERALS ON RDF_LITERALS(INT_LITERAL);;
CREATE TABLE RDF_STATEMENTS (
    STATEMENT_ID ${id} NOT NULL PRIMARY KEY,
    SUBJECT ${id} NOT NULL,
    PREDICATE ${id} NOT NULL,
    OBJECT ${id},
    OBJECT_ISLITERAL SMALLINT,
    MODEL ${id},
    REIFICATION ${id},		/* points to resource entry if available */
    IS_REIFIED SMALLINT		/* if true the statement is only reified, not really present */
);;
CREATE INDEX RDF_IDX_SP ON RDF_STATEMENTS(SUBJECT, PREDICATE);;
CREATE INDEX RDF_IDX_O ON RDF_STATEMENTS(OBJECT, OBJECT_ISLITERAL);;
CREATE TABLE RDF_MODELS (
   NAME VARCHAR(120) NOT NULL PRIMARY KEY,
   ID ${id}
);;

#-------------------------------------------------------------------
# Initialize a blank database - create any generators needed - compound statement group
initDBgenerators
# Generators to index the main tables
CREATE SEQUENCE RDF_RESOURCES_GEN;;
CREATE SEQUENCE RDF_NAMESPACE_GEN START 2;;
CREATE SEQUENCE RDF_LITERALS_GEN;;
CREATE SEQUENCE RDF_MODELS_GEN;;
CREATE SEQUENCE RDF_STATEMENTS_GEN;;
# Preallocate the anonymous namespace ID
INSERT INTO RDF_NAMESPACES (ID, URI) VALUES (0, '_');;

#-------------------------------------------------------------------
# Initialize a blank database - create any stored procedures - compound statement group
initDBprocedures
# Database specific ... not implemented here

#-------------------------------------------------------------------
# Find reified statement
getReifiedStatement
SELECT S.SUBJECT, RS.LOCALNAME, RS.NAMESPACE, RS.STATEMENT,
       S.PREDICATE, RP.LOCALNAME, RP.NAMESPACE,
       S.OBJECT, S.OBJECT_ISLITERAL, STATEMENT_ID, IS_REIFIED, REIFICATION
FROM RDF_RESOURCES AS RS INNER JOIN (RDF_RESOURCES  RP INNER JOIN RDF_STATEMENTS AS S ON PREDICATE = RP.ID) ON SUBJECT = RS.ID
WHERE STATEMENT_ID = ? AND S.MODEL = ?

#-------------------------------------------------------------------
# Insert a reified statement
insertReifiedStatement
INSERT INTO RDF_STATEMENTS(SUBJECT, PREDICATE, OBJECT, OBJECT_ISLITERAL, MODEL, STATEMENT_ID, IS_REIFIED, REIFICATION) VALUES(?,?,?,?,?,?,?,?)

#-------------------------------------------------------------------
# Insert a statement
insertStatement
INSERT INTO RDF_STATEMENTS(SUBJECT, PREDICATE, OBJECT, OBJECT_ISLITERAL, MODEL, STATEMENT_ID, IS_REIFIED) VALUES(?,?,?,?,?,?,0)

#-------------------------------------------------------------------
# Insert a new/duplicate resource
insertResourceAsStatement
INSERT INTO RDF_RESOURCES(ID, LOCALNAME, NAMESPACE, STATEMENT) VALUES(?,?,?,?)

#-------------------------------------------------------------------
# Return the namespace ID and local name of a resource
getResource
SELECT LOCALNAME, NAMESPACE, STATEMENT FROM RDF_RESOURCES WHERE ID = ?

#-------------------------------------------------------------------
# Return the details of a reified statement
listReifiedStatements
SELECT S.SUBJECT, RS.LOCALNAME, RS.NAMESPACE, RS.STATEMENT,
       S.PREDICATE, RP.LOCALNAME, RP.NAMESPACE,
       S.OBJECT, S.OBJECT_ISLITERAL, STATEMENT_ID, IS_REIFIED, REIFICATION
FROM RDF_RESOURCES AS RS INNER JOIN (RDF_RESOURCES  RP INNER JOIN RDF_STATEMENTS AS S ON PREDICATE = RP.ID) ON SUBJECT = RS.ID
WHERE SUBJECT = RS.ID AND PREDICATE = RP.ID AND REIFICATION IS NOT NULL AND S.MODEL = ?

#-------------------------------------------------------------------
# List all the statements in the database
list
SELECT S.SUBJECT, RS.LOCALNAME, RS.NAMESPACE, RS.STATEMENT,
       S.PREDICATE, RP.LOCALNAME, RP.NAMESPACE,
       S.OBJECT, S.OBJECT_ISLITERAL, STATEMENT_ID, IS_REIFIED, REIFICATION
FROM RDF_RESOURCES AS RS INNER JOIN (RDF_RESOURCES  RP INNER JOIN RDF_STATEMENTS AS S ON PREDICATE = RP.ID) ON SUBJECT = RS.ID
WHERE SUBJECT = RS.ID AND PREDICATE = RP.ID AND IS_REIFIED = 0 AND S.MODEL = ?

#-------------------------------------------------------------------
# List all the statements in the database matching a given subject
listS
SELECT S.SUBJECT, RS.LOCALNAME, RS.NAMESPACE, RS.STATEMENT,
       S.PREDICATE, RP.LOCALNAME, RP.NAMESPACE,
       S.OBJECT, S.OBJECT_ISLITERAL, STATEMENT_ID, IS_REIFIED, REIFICATION
FROM RDF_RESOURCES AS RS INNER JOIN (RDF_RESOURCES AS RP INNER JOIN RDF_STATEMENTS AS S ON PREDICATE = RP.ID) ON SUBJECT = RS.ID
WHERE SUBJECT = RS.ID AND PREDICATE = RP.ID AND S.SUBJECT = ? AND S.SUBJECT = RS.ID AND S.PREDICATE = RP.ID AND IS_REIFIED = 0 AND S.MODEL = ?

#-------------------------------------------------------------------
# List all the statements in the database matching a given predicate
listP
SELECT S.SUBJECT, RS.LOCALNAME, RS.NAMESPACE, RS.STATEMENT,
       S.PREDICATE, RP.LOCALNAME, RP.NAMESPACE,
       S.OBJECT, S.OBJECT_ISLITERAL, STATEMENT_ID, IS_REIFIED, REIFICATION
FROM RDF_RESOURCES AS RS INNER JOIN (RDF_RESOURCES AS RP INNER JOIN RDF_STATEMENTS AS S ON PREDICATE = RP.ID) ON SUBJECT = RS.ID
WHERE SUBJECT = RS.ID AND PREDICATE = RP.ID AND S.PREDICATE = ? AND IS_REIFIED = 0 AND S.MODEL = ?

#-------------------------------------------------------------------
# List all the statements in the database matching a given predicate and subject
listSP
SELECT S.SUBJECT, RS.LOCALNAME, RS.NAMESPACE, RS.STATEMENT,
       S.PREDICATE, RP.LOCALNAME, RP.NAMESPACE,
       S.OBJECT, S.OBJECT_ISLITERAL, STATEMENT_ID, IS_REIFIED, REIFICATION
FROM RDF_RESOURCES AS RS INNER JOIN (RDF_RESOURCES AS RP INNER JOIN RDF_STATEMENTS AS S ON PREDICATE = RP.ID) ON SUBJECT = RS.ID
WHERE SUBJECT = RS.ID AND PREDICATE = RP.ID AND S.SUBJECT = ? AND S.PREDICATE = ? AND IS_REIFIED = 0 AND S.MODEL = ?

#-------------------------------------------------------------------
# List all the statements in the database matching a given object
listO
SELECT S.SUBJECT, RS.LOCALNAME, RS.NAMESPACE, RS.STATEMENT,
       S.PREDICATE, RP.LOCALNAME, RP.NAMESPACE,
       S.OBJECT, S.OBJECT_ISLITERAL, STATEMENT_ID, IS_REIFIED, REIFICATION
FROM RDF_RESOURCES AS RS INNER JOIN (RDF_RESOURCES AS RP INNER JOIN RDF_STATEMENTS AS S ON PREDICATE = RP.ID) ON SUBJECT = RS.ID
WHERE SUBJECT = RS.ID AND PREDICATE = RP.ID AND S.OBJECT = ? AND S.OBJECT_ISLITERAL = ? AND IS_REIFIED = 0 AND S.MODEL = ?

#-------------------------------------------------------------------
# List all the statements in the database matching a given subject and object
listSO
SELECT S.SUBJECT, RS.LOCALNAME, RS.NAMESPACE, RS.STATEMENT,
       S.PREDICATE, RP.LOCALNAME, RP.NAMESPACE,
       S.OBJECT, S.OBJECT_ISLITERAL, STATEMENT_ID, IS_REIFIED, REIFICATION
FROM RDF_RESOURCES AS RS INNER JOIN (RDF_RESOURCES AS RP INNER JOIN RDF_STATEMENTS AS S ON PREDICATE = RP.ID) ON SUBJECT = RS.ID
WHERE SUBJECT = RS.ID AND PREDICATE = RP.ID AND S.SUBJECT = ? AND S.OBJECT = ? AND S.OBJECT_ISLITERAL = ? AND IS_REIFIED = 0 AND S.MODEL = ?

#-------------------------------------------------------------------
# List all the statements in the database matching a given predicate and object
listPO
SELECT S.SUBJECT, RS.LOCALNAME, RS.NAMESPACE, RS.STATEMENT,
       S.PREDICATE, RP.LOCALNAME, RP.NAMESPACE,
       S.OBJECT, S.OBJECT_ISLITERAL, STATEMENT_ID, IS_REIFIED, REIFICATION
FROM RDF_RESOURCES AS RS INNER JOIN (RDF_RESOURCES AS RP INNER JOIN RDF_STATEMENTS AS S ON PREDICATE = RP.ID) ON SUBJECT = RS.ID
WHERE SUBJECT = RS.ID AND PREDICATE = RP.ID AND S.PREDICATE = ? AND S.OBJECT = ? AND S.OBJECT_ISLITERAL = ? AND IS_REIFIED = 0 AND S.MODEL = ?

#-------------------------------------------------------------------
# List all the statements in the database matching a given subject, predicate and object
listSPO
SELECT S.SUBJECT, RS.LOCALNAME, RS.NAMESPACE, RS.STATEMENT,
       S.PREDICATE, RP.LOCALNAME, RP.NAMESPACE,
       S.OBJECT, S.OBJECT_ISLITERAL, STATEMENT_ID, IS_REIFIED, REIFICATION
FROM RDF_RESOURCES AS RS INNER JOIN (RDF_RESOURCES AS RP INNER JOIN RDF_STATEMENTS AS S ON PREDICATE = RP.ID) ON SUBJECT = RS.ID
WHERE SUBJECT = RS.ID AND PREDICATE = RP.ID AND S.SUBJECT = ? AND S.PREDICATE = ? AND S.OBJECT = ? AND S.OBJECT_ISLITERAL = ? AND IS_REIFIED = 0 AND S.MODEL = ?

#-------------------------------------------------------------------
# List all statements in the model
listSubjects
SELECT DISTINCT ID, LOCALNAME, NAMESPACE, STATEMENT  FROM RDF_RESOURCES INNER JOIN RDF_STATEMENTS ON SUBJECT=ID WHERE MODEL = ? 

#-------------------------------------------------------------------
# List all the statements in the database matching a given subject, predicate and object
# but just used for testing if the statement is there so only returns a token item
checkStatement
SELECT IS_REIFIED, STATEMENT_ID, REIFICATION FROM RDF_STATEMENTS WHERE SUBJECT = ? AND PREDICATE = ? AND OBJECT = ? AND OBJECT_ISLITERAL = ? AND MODEL = ?

#-------------------------------------------------------------------
# Switch the isReified flag of a statement to false so it becomes visible
assertReifiedStatement
UPDATE RDF_STATEMENTS SET IS_REIFIED = 0 WHERE STATEMENT_ID = ?

#-------------------------------------------------------------------
# Switch the Reification field of a statement to point to the corresponding resource
setStatementReification
UPDATE RDF_STATEMENTS SET REIFICATION = ? WHERE STATEMENT_ID = ?

#-------------------------------------------------------------------
# Allocate an id for a resource
allocateResourceID
SELECT NEXTVAL('RDF_RESOURCES_GEN')

#-------------------------------------------------------------------
# Allocate an id for a NAMESPACE
allocateNamespaceID
SELECT NEXTVAL('RDF_NAMESPACE_GEN')

#-------------------------------------------------------------------
# Allocate an id for a literal
allocateLiteralID
SELECT NEXTVAL('RDF_LITERALS_GEN')

#-------------------------------------------------------------------
# Allocate an id for a model
allocateModelID
SELECT NEXTVAL('RDF_MODELS_GEN')

#-------------------------------------------------------------------
# Allocate an id for a statement
allocateStatementID
SELECT NEXTVAL('RDF_STATEMENTS_GEN')

#-------------------------------------------------------------------
# List all resources
listResources
SELECT ID, LOCALNAME, NAMESPACE, STATEMENT FROM RDF_RESOURCES, RDF_STATEMENTS 
   WHERE (SUBJECT=ID OR PREDICATE=ID OR (OBJECT=ID AND OBJECT_ISLITERAL = 0)) AND (MODEL=?)

#-------------------------------------------------------------------
# Drop all RDF procedures from a database
cleanDBprocedures
# Database specific ... not implemented here

#-------------------------------------------------------------------
# Drop all RDF tables from a database
cleanDBtables
DROP TABLE RDF_RESOURCES;;
DROP TABLE RDF_NAMESPACES;;
DROP TABLE RDF_LITERALS;;
DROP TABLE RDF_STATEMENTS;;
DROP TABLE RDF_LAYOUT_INFO;;
DROP TABLE RDF_MODELS;;
DROP TABLE RDF_REIFIED_STATEMENTS;;

#-------------------------------------------------------------------
# Drop all RDF generators from a database
cleanDBgenerators
DROP SEQUENCE RDF_RESOURCES_GEN;;
DROP SEQUENCE RDF_NAMESPACE_GEN;;
DROP SEQUENCE RDF_LITERALS_GEN;;
DROP SEQUENCE RDF_MODELS_GEN;;
DROP SEQUENCE RDF_STATEMENTS_GEN;;



