/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.marshal;

import javax.xml.marshal.ScanPosition;

public final class StreamScanPosition
extends ScanPosition {
    private int line;
    private int column = 0;
    private String uri = null;

    public StreamScanPosition(int n, int n2, String string) {
        if (n <= 0) {
            throw new IllegalArgumentException("Non-positive line number: " + n);
        }
        this.line = n;
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal column number: " + n2);
        }
        this.column = n2;
        this.uri = string;
    }

    public StreamScanPosition(int n, int n2) {
        this(n, n2, null);
    }

    public StreamScanPosition(int n) {
        this(n, 0, null);
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public String uriString() {
        return this.uri;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.uriString() != null) {
            stringBuffer.append(this.uriString());
            stringBuffer.append(": ");
        }
        stringBuffer.append("line ");
        stringBuffer.append(this.line());
        if (this.column() != 0) {
            stringBuffer.append(", column ");
            stringBuffer.append(this.column);
        }
        return stringBuffer.toString();
    }
}

