/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.sp;

import com.sun.xml.sp.ParseException;
import com.sun.xml.sp.Parser;
import com.sun.xml.sp.StreamingParser;
import com.sun.xml.sp.StreamingParserFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class StreamingParserImpl
extends StreamingParser {
    private Parser parser = null;
    private static final int DOC_END = -1;
    private static final int DOC_START = -2;
    private static final int EMPTY = -3;
    private static final int EXCEPTION = -4;
    private int cur = -3;
    private String curName = null;
    private String curValue = null;
    private String curURI = null;
    private boolean validating;
    private boolean coalescing;
    private boolean namespaceAware;
    private int curLine = -1;
    private int curCol = -1;
    private String publicId = null;
    private String systemId = null;

    private StreamingParserImpl(StreamingParserFactory streamingParserFactory) {
        this.validating = streamingParserFactory.isValidating();
        this.coalescing = streamingParserFactory.isCoalescing();
        this.namespaceAware = streamingParserFactory.isNamespaceAware();
    }

    StreamingParserImpl(StreamingParserFactory streamingParserFactory, InputStream inputStream) {
        this(streamingParserFactory);
        this.parser = new Parser(inputStream, this.coalescing, this.namespaceAware);
    }

    StreamingParserImpl(StreamingParserFactory streamingParserFactory, File file) throws IOException {
        this(streamingParserFactory);
        this.parser = new Parser(file, this.coalescing, this.namespaceAware);
    }

    public int parse() throws ParseException, IOException {
        if (this.cur == -1) {
            return -1;
        }
        this.cur = this.parser.parse();
        this.curName = this.parser.getCurName();
        this.curValue = this.parser.getCurValue();
        this.curURI = this.parser.getCurURI();
        this.curLine = this.parser.getLineNumber();
        this.curCol = this.parser.getColumnNumber();
        return this.cur;
    }

    public int state() {
        if (this.cur == -3) {
            throw new IllegalStateException("Parser not started");
        }
        if (this.cur < -1) {
            throw new InternalError();
        }
        return this.cur;
    }

    public String name() {
        if (this.curName == null) {
            throw new IllegalStateException("Name not defined in this state");
        }
        return this.curName;
    }

    public String value() {
        if (this.curValue == null) {
            throw new IllegalStateException("Value not defined in this state");
        }
        return this.curValue;
    }

    public String uriString() {
        if (!this.namespaceAware) {
            return null;
        }
        if (this.curURI == null) {
            throw new IllegalStateException("Value not defined in this state");
        }
        return this.curURI;
    }

    public int line() {
        return this.curLine;
    }

    public int column() {
        return this.curCol;
    }

    public String publicId() {
        return this.publicId;
    }

    public String systemId() {
        return this.systemId;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public String describe(boolean bl) {
        return StreamingParser.describe(this.cur, this.curName, this.curValue, bl);
    }
}

