/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.sp;

import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NamespaceSupport {
    public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private static final Enumeration EMPTY_ENUMERATION = new Vector().elements();
    private Context[] contexts;
    private Context currentContext;
    private int contextPos;

    public NamespaceSupport() {
        this.reset();
    }

    public void reset() {
        this.contexts = new Context[32];
        this.contextPos = 0;
        this.contexts[this.contextPos] = this.currentContext = new Context();
        this.currentContext.declarePrefix("xml", XMLNS);
    }

    public void pushContext() {
        int n = this.contexts.length;
        ++this.contextPos;
        if (this.contextPos >= n) {
            Context[] contextArray = new Context[n * 2];
            System.arraycopy(this.contexts, 0, contextArray, 0, n);
            n *= 2;
            this.contexts = contextArray;
        }
        this.currentContext = this.contexts[this.contextPos];
        if (this.currentContext == null) {
            this.contexts[this.contextPos] = this.currentContext = new Context();
        }
        if (this.contextPos > 0) {
            this.currentContext.setParent(this.contexts[this.contextPos - 1]);
        }
    }

    public void popContext() {
        --this.contextPos;
        if (this.contextPos < 0) {
            throw new EmptyStackException();
        }
        this.currentContext = this.contexts[this.contextPos];
    }

    public boolean declarePrefix(String string, String string2) {
        if (string.equals("xml") || string.equals("xmlns")) {
            return false;
        }
        this.currentContext.declarePrefix(string, string2);
        return true;
    }

    public String[] processName(String string, String[] stringArray, boolean bl) {
        String[] stringArray2 = this.currentContext.processName(string, bl);
        if (stringArray2 == null) {
            stringArray[0] = "";
            stringArray[1] = "";
            stringArray[2] = string.intern();
        } else {
            stringArray[0] = stringArray2[0];
            stringArray[1] = stringArray2[1];
            stringArray[2] = stringArray2[2];
        }
        return stringArray;
    }

    public String getURI(String string) {
        return this.currentContext.getURI(string);
    }

    public Enumeration getPrefixes() {
        return this.currentContext.getPrefixes();
    }

    public Enumeration getDeclaredPrefixes() {
        return this.currentContext.getDeclaredPrefixes();
    }

    final class Context {
        Hashtable prefixTable;
        Hashtable elementNameTable;
        Hashtable attributeNameTable;
        String defaultNS = null;
        private Vector declarations = null;
        private boolean tablesDirty = false;
        private Context parent = null;

        Context() {
            this.copyTables();
        }

        void setParent(Context context) {
            this.parent = context;
            this.declarations = null;
            this.prefixTable = context.prefixTable;
            this.elementNameTable = context.elementNameTable;
            this.attributeNameTable = context.attributeNameTable;
            this.defaultNS = context.defaultNS;
            this.tablesDirty = false;
        }

        void declarePrefix(String string, String string2) {
            if (!this.tablesDirty) {
                this.copyTables();
            }
            if (this.declarations == null) {
                this.declarations = new Vector();
            }
            string = string.intern();
            string2 = string2.intern();
            if (string.equals("")) {
                this.defaultNS = string2;
            }
            this.prefixTable.put(string, string2);
            this.declarations.addElement(string);
        }

        String[] processName(String string, boolean bl) {
            Hashtable hashtable = bl ? this.attributeNameTable : this.elementNameTable;
            String[] stringArray = (String[])hashtable.get(string);
            if (stringArray != null) {
                return stringArray;
            }
            stringArray = new String[3];
            int n = string.indexOf(58);
            if (n == -1) {
                stringArray[0] = bl || this.defaultNS == null ? "" : this.defaultNS;
                stringArray[1] = string.intern();
                stringArray[2] = stringArray[1];
            } else {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                String string4 = (String)this.prefixTable.get(string2);
                if (string4 == null) {
                    return null;
                }
                stringArray[0] = string4;
                stringArray[1] = string3.intern();
                stringArray[2] = string.intern();
            }
            hashtable.put(stringArray[2], stringArray);
            this.tablesDirty = true;
            return stringArray;
        }

        String getURI(String string) {
            if (this.prefixTable == null) {
                return null;
            }
            return (String)this.prefixTable.get(string);
        }

        Enumeration getDeclaredPrefixes() {
            if (this.declarations == null) {
                return EMPTY_ENUMERATION;
            }
            return this.declarations.elements();
        }

        Enumeration getPrefixes() {
            return this.prefixTable.keys();
        }

        private void copyTables() {
            this.prefixTable = this.prefixTable != null ? new Hashtable(this.prefixTable) : new Hashtable();
            this.elementNameTable = new Hashtable();
            this.attributeNameTable = new Hashtable();
            this.tablesDirty = true;
        }
    }
}

