/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.statistics.charts;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import zeus.gui.ColorManager;
import zeus.util.Misc;
import zeus.visualiser.statistics.charts.DrawObject;
import zeus.visualiser.statistics.charts.GraphicsSymbol;

public class XYGraph
implements DrawObject {
    protected static final int TYPE1 = 0;
    protected static final int TYPE2 = 1;
    protected static double TINY = 1.0E-6;
    protected static int LEFT = 100;
    protected static int STEP = 5;
    protected static int KEY_LINE_LENGTH = 15;
    protected String title;
    protected int x;
    protected int y = 0;
    protected FontMetrics fm;
    protected Font font;
    protected int gap = 10;
    protected double max_x = 0.0;
    protected double min_x = 0.0;
    protected double max_y = 0.0;
    protected double min_y = 0.0;
    protected double[][] x_values;
    protected double[][] y_values;
    protected String[] keys;
    protected int type = -1;

    public XYGraph() {
    }

    public XYGraph(double[] dArray, double[] dArray2, String string) {
        this.setData(dArray, dArray2, string);
    }

    public XYGraph(double[][] dArray, double[][] dArray2, String[] stringArray, String string) {
        this.setData(dArray, dArray2, stringArray, string);
    }

    public void setData(double[] dArray, double[] dArray2, String string) {
        this.type = 0;
        this.title = string;
        this.y_values = new double[1][];
        this.y_values[0] = dArray;
        this.x_values = new double[1][];
        this.x_values[0] = dArray2;
        this.computeMinMax();
    }

    public void setData(double[][] dArray, double[][] dArray2, String[] stringArray, String string) {
        this.type = 1;
        this.title = string;
        this.keys = stringArray;
        this.y_values = dArray;
        this.x_values = dArray2;
        this.computeMinMax();
    }

    protected void computeMinMax() {
        this.min_x = 0.0;
        this.max_x = 0.0;
        this.min_y = 0.0;
        this.max_y = 0.0;
        int n = 0;
        while (n < this.y_values.length) {
            int n2 = 0;
            while (n2 < this.y_values[n].length) {
                this.max_y = Math.max(this.max_y, this.y_values[n][n2]);
                this.min_y = Math.min(this.min_y, this.y_values[n][n2]);
                this.max_x = Math.max(this.max_x, this.x_values[n][n2]);
                this.min_x = Math.min(this.min_x, this.x_values[n][n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void drawYourSelf(Graphics graphics) {
        int n;
        int n2;
        double d;
        this.font = new Font("Arial", 1, 14);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        int n3 = this.fm.stringWidth(this.title);
        int n4 = this.fm.getHeight();
        graphics.drawString(this.title, (this.x - n3) / 2, n4);
        if (this.min_x == 0.0 && this.max_x == 0.0 && this.min_y == 0.0 && this.max_y == 0.0) {
            return;
        }
        this.font = new Font("Arial", 0, 12);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        double d3 = this.min_x > 0.0 ? this.max_x : Math.abs(this.max_x - this.min_x);
        double d4 = d = this.min_y > 0.0 ? this.max_y : Math.abs(this.max_y - this.min_y);
        if (this.isZero(d3)) {
            d3 = 1.0E-6;
        }
        if (this.isZero(d)) {
            d = 1.0E-6;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.type == 1) {
            int n10 = 0;
            while (n10 < this.keys.length) {
                n7 = Math.max(n7, this.fm.stringWidth(this.keys[n10]));
                ++n10;
            }
        }
        n8 = this.x - LEFT - (n7 += 30 + KEY_LINE_LENGTH + 10);
        n9 = this.y - 5 * n4;
        graphics.drawLine(LEFT, 3 * n4, LEFT, this.y - 2 * n4);
        n5 = LEFT;
        int n11 = n5 + n8;
        int n12 = n6 = (int)((double)(3 * n4 + n9) - (0.0 - this.min_y) * (double)n9 / d);
        graphics.drawLine(n5, n6, n11, n12);
        int n13 = 0;
        while (n13 < this.y_values.length) {
            if (this.y_values[n13].length > 0) {
                n5 = (int)((this.x_values[n13][0] - this.min_x) * (double)n8 / d3 + (double)LEFT);
                n6 = (int)((double)n9 - (this.y_values[n13][0] - this.min_y) * (double)n9 / d + (double)(3 * n4));
                graphics.setColor(ColorManager.getColor(n13));
                GraphicsSymbol.drawSymbol(graphics, n13, 10, n5, n6);
                int n14 = 1;
                while (n14 < this.y_values[n13].length) {
                    n11 = (int)((this.x_values[n13][n14] - this.min_x) * (double)n8 / d3 + (double)LEFT);
                    n12 = (int)((double)(3 * n4 + n9) - (this.y_values[n13][n14] - this.min_y) * (double)n9 / d);
                    GraphicsSymbol.drawSymbol(graphics, n13, 10, n11, n12);
                    graphics.drawLine(n5, n6, n11, n12);
                    n5 = n11;
                    n6 = n12;
                    ++n14;
                }
            }
            ++n13;
        }
        n5 = (int)((double)LEFT + (0.0 - this.min_x) * (double)n8 / d3);
        n6 = (int)(3.0 * (double)n4 + (double)n9 - (0.0 - this.min_y) * (double)n9 / d);
        double d5 = Math.max(Math.abs(this.max_y), Math.abs(this.min_y)) / (double)STEP;
        if (d5 + 0.51 > 1.0) {
            d5 = (int)(d5 + 0.51);
        }
        int n15 = (int)(d5 * (double)n9 / d);
        graphics.setColor(Color.black);
        double d6 = 0.0;
        int n16 = 0;
        while ((!this.isZero(d5) || n16 == 0) && d6 + d5 <= this.max_y) {
            d6 = (double)n16 * d5;
            String string = Misc.decimalPlaces(d6, 2);
            n2 = n5;
            n = n6 - n16 * n15;
            graphics.drawLine(n2, n, n2 - 10, n);
            n3 = this.fm.stringWidth(string);
            graphics.drawString(string, n2 - 10 - n3 - 5, n);
            ++n16;
        }
        if (this.min_y < 0.0) {
            d6 = -1.0 * d5;
            int n17 = 1;
            while (!this.isZero(d5) && d6 - d5 >= this.min_y) {
                d6 = (double)(-1 * n17) * d5;
                String string = Misc.decimalPlaces(d6, 2);
                n2 = n5;
                n = n6 + n17 * n15;
                graphics.drawLine(n2, n, n2 - 10, n);
                n3 = this.fm.stringWidth(string);
                graphics.drawString(string, n2 - 10 - n3 - 5, n);
                ++n17;
            }
        }
        n5 = (int)((double)LEFT + (0.0 - this.min_x) * (double)n8 / d3);
        n6 = (int)(3.0 * (double)n4 + (double)n9 - (0.0 - this.min_y) * (double)n9 / d);
        double d7 = Math.max(Math.abs(this.max_x), Math.abs(this.min_x)) / (double)STEP;
        if (d7 + 0.51 > 1.0) {
            d7 = (int)(d7 + 0.51);
        }
        n15 = (int)(d7 * (double)n8 / d3);
        graphics.setColor(Color.black);
        d6 = 0.0;
        int n18 = 0;
        while ((!this.isZero(d7) || n18 == 0) && d6 + d7 <= this.max_x) {
            d6 = (double)n18 * d7;
            String string = Misc.decimalPlaces(d6, 2);
            n = n6;
            n2 = n5 + n18 * n15;
            graphics.drawLine(n2, n, n2, n + 10);
            n3 = this.fm.stringWidth(string);
            graphics.drawString(string, n2 - n3 / 2, n + 10 + n4);
            ++n18;
        }
        if (this.min_x < 0.0) {
            d6 = -1.0 * d7;
            int n19 = 1;
            while (!this.isZero(d7) && d6 - d7 >= this.min_x) {
                d6 = (double)(-1 * n19) * d7;
                String string = Misc.decimalPlaces(d6, 2);
                n = n6;
                n2 = n5 - n19 * n15;
                graphics.drawLine(n2, n, n2, n - 10);
                n3 = this.fm.stringWidth(string);
                graphics.drawString(string, n2 - n3 / 2, n - 10 - n4);
                ++n19;
            }
        }
        if (this.type == 1) {
            n11 = LEFT + n8 + 20;
            n12 = 3 * n4;
            int n20 = Math.max(n4 + 10, 20);
            graphics.setColor(Color.black);
            graphics.drawString("Key", n11, n12);
            int n21 = 0;
            while (n21 < this.keys.length) {
                graphics.setColor(ColorManager.getColor(n21));
                graphics.drawLine(n11, n12 += n20, n11 + KEY_LINE_LENGTH, n12);
                graphics.setColor(Color.black);
                graphics.drawString(this.keys[n21], n11 + KEY_LINE_LENGTH + 10, n12);
                ++n21;
            }
        }
    }

    void TEST(int n) {
        if (this.y_values[0].length == 0 || this.y_values[1].length == 0) {
            System.err.println("drawYourSelf position" + n);
        }
    }

    boolean isZero(double d) {
        return Math.abs(d) < TINY;
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }
}

