/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.statistics.charts;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import zeus.util.Misc;
import zeus.visualiser.statistics.charts.DrawObject;

public class TabularGraph
implements DrawObject {
    protected static final double TINY = 1.0E-6;
    protected static final int LEFT = 30;
    protected String title;
    protected Vector bars = new Vector();
    protected int x;
    protected int y = 0;
    protected FontMetrics fm;
    protected Font font;
    protected int gap = 10;

    public TabularGraph() {
    }

    public TabularGraph(double[][] dArray, String[] stringArray, String string) {
        this.setData(dArray, stringArray, string);
    }

    public void setData(double[][] dArray, String[] stringArray, String string) {
        this.title = string;
        this.bars.removeAllElements();
        int n = 0;
        while (n < dArray.length) {
            Bar bar = new Bar();
            bar.values = new double[dArray[n].length];
            int n2 = 0;
            while (n2 < bar.values.length) {
                bar.values[n2] = dArray[n][n2];
                ++n2;
            }
            bar.label = stringArray[n];
            this.bars.addElement(bar);
            ++n;
        }
    }

    public void drawYourSelf(Graphics graphics) {
        int n;
        int n2;
        String string;
        int n3;
        Bar bar;
        this.font = new Font("Arial", 1, 14);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        int n4 = this.fm.stringWidth(this.title);
        int n5 = this.fm.getHeight();
        graphics.drawString(this.title, (this.x - n4) / 2, n5);
        if (this.bars.isEmpty()) {
            return;
        }
        int n6 = 0;
        this.font = new Font("Arial", 0, 12);
        this.fm = graphics.getFontMetrics(this.font);
        int n7 = this.fm.getHeight() + this.gap;
        graphics.setFont(this.font);
        int n8 = 0;
        while (n8 < this.bars.size()) {
            bar = (Bar)this.bars.elementAt(n8);
            n6 = Math.max(n6, this.fm.stringWidth(bar.label));
            n3 = 0;
            while (n3 < bar.values.length) {
                string = Misc.decimalPlaces(bar.values[n3], 2);
                n6 = Math.max(n6, this.fm.stringWidth(string));
                ++n3;
            }
            ++n8;
        }
        graphics.drawLine(30 + (n6 += this.gap), 3 * n5, 30 + n6, 3 * n5 + (this.bars.size() + 1) * n7);
        graphics.drawLine(30, 3 * n5 + n7, 30 + (this.bars.size() + 1) * n6, 3 * n5 + n7);
        n3 = 30 + n6 + this.gap / 2;
        int n9 = n2 = 3 * n5 + n7 - this.gap / 2;
        int n10 = 0;
        while (n10 < this.bars.size()) {
            bar = (Bar)this.bars.elementAt(n10);
            n = n3 + n10 * n6;
            graphics.drawString(bar.label, n, n9);
            ++n10;
        }
        n3 = 30 + this.gap / 2;
        n2 = 3 * n5 + n7 + n7 - this.gap / 2;
        n = n3;
        int n11 = 0;
        while (n11 < this.bars.size()) {
            bar = (Bar)this.bars.elementAt(n11);
            n9 = n2 + n11 * n7;
            graphics.drawString(bar.label, n, n9);
            int n12 = n9;
            int n13 = 0;
            while (n13 < bar.values.length) {
                string = Misc.decimalPlaces(bar.values[n13], 2);
                int n14 = n + n6 + n13 * n6;
                graphics.drawString(string, n14, n12);
                ++n13;
            }
            ++n11;
        }
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    class Bar {
        String label;
        double[] values;

        Bar() {
        }
    }
}

