/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.statistics.charts;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import zeus.gui.ColorManager;
import zeus.util.Misc;
import zeus.visualiser.statistics.charts.DrawObject;
import zeus.visualiser.statistics.charts.GraphicsSymbol;

public class LineGraph
implements DrawObject {
    protected static final int TYPE1 = 0;
    protected static final int TYPE2 = 1;
    protected static final double TINY = 1.0E-6;
    protected static final int LEFT = 100;
    protected static final int STEP = 5;
    protected static final int TICK_SIZE = 10;
    protected static final int KEY_DEPTH = 20;
    protected String title;
    protected Vector bars = new Vector();
    protected int x;
    protected int y = 0;
    protected FontMetrics fm;
    protected Font font;
    protected int gap = 10;
    protected double max = 0.0;
    protected double min = 0.0;
    protected double sum = 0.0;
    protected int type = -1;
    protected boolean[] is_valid;
    protected String[] keys;

    public LineGraph() {
    }

    public LineGraph(double[] dArray, String[] stringArray, String string) {
        this.setData(dArray, stringArray, string);
    }

    public LineGraph(double[][] dArray, String[] stringArray, String[] stringArray2, String string) {
        this.setData(dArray, stringArray, stringArray2, string);
    }

    public void setData(double[] dArray, String[] stringArray, String string) {
        this.type = 0;
        this.title = string;
        int n = 0;
        this.bars.removeAllElements();
        this.sum = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (Math.abs(dArray[n2] - 0.0) > 1.0E-6) {
                this.max = Math.max(this.max, dArray[n2]);
                this.min = Math.min(this.min, dArray[n2]);
                Bar bar = new Bar();
                bar.value = dArray[n2];
                bar.label = stringArray[n2];
                bar.color = ColorManager.getColor(n++);
                this.bars.addElement(bar);
            }
            ++n2;
        }
    }

    public void setData(double[][] dArray, String[] stringArray, String[] stringArray2, String string) {
        this.type = 1;
        this.title = string;
        this.bars.removeAllElements();
        this.sum = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        this.is_valid = new boolean[stringArray2.length];
        this.keys = new String[stringArray2.length];
        int n = 0;
        while (n < stringArray2.length) {
            this.keys[n] = stringArray2[n];
            this.is_valid[n] = false;
            ++n;
        }
        int n2 = 0;
        while (n2 < dArray.length) {
            double d = 0.0;
            int n3 = 0;
            while (n3 < dArray[n2].length) {
                if (Math.abs(dArray[n2][n3] - 0.0) > 1.0E-6) {
                    this.is_valid[n3] = true;
                    d += dArray[n2][n3];
                    this.max = Math.max(this.max, dArray[n2][n3]);
                    this.min = Math.min(this.min, dArray[n2][n3]);
                }
                ++n3;
            }
            if (Math.abs(d - 0.0) > 1.0E-6) {
                Bar bar = new Bar();
                bar.values = new double[dArray[n2].length];
                int n4 = 0;
                while (n4 < bar.values.length) {
                    bar.values[n4] = dArray[n2][n4];
                    ++n4;
                }
                bar.label = stringArray[n2];
                this.bars.addElement(bar);
            }
            ++n2;
        }
    }

    public void drawYourSelf(Graphics graphics) {
        String string;
        int n;
        int n2;
        Bar bar;
        this.font = new Font("Arial", 1, 14);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        int n3 = this.fm.stringWidth(this.title);
        int n4 = this.fm.getHeight();
        graphics.drawString(this.title, (this.x - n3) / 2, n4);
        if (this.bars.isEmpty()) {
            return;
        }
        int n5 = 0;
        this.font = new Font("Arial", 0, 12);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        int n6 = 0;
        while (n6 < this.bars.size()) {
            bar = (Bar)this.bars.elementAt(n6);
            n5 = Math.max(n5, this.fm.stringWidth(bar.label));
            ++n6;
        }
        int n7 = ((n5 += 10) + this.gap) * this.bars.size();
        double d = this.min > 0.0 ? this.max : Math.abs(this.max - this.min);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        switch (this.type) {
            case 0: {
                graphics.drawLine(100, 3 * n4, 100, this.y - 2 * n4);
                n8 = 100;
                n9 = (int)(3.0 * (double)n4 + this.max / d * ((double)this.y - 5.0 * (double)n4));
                n2 = n8 + n7;
                n = n9;
                graphics.drawLine(n8, n9, n2, n);
                graphics.setColor(Color.black);
                int n12 = 0;
                while (n12 < this.bars.size()) {
                    bar = (Bar)this.bars.elementAt(n12);
                    n2 = n8 + (n5 + this.gap) * n12 + (n5 + this.gap) / 2;
                    n = (int)((double)n9 - bar.value / this.max * ((double)n9 - 3.0 * (double)n4));
                    GraphicsSymbol.drawSymbol(graphics, 0, 10, n2, n);
                    if (n12 != 0) {
                        graphics.drawLine(n10, n11, n2, n);
                    }
                    n10 = n2;
                    n11 = n;
                    n3 = this.fm.stringWidth(bar.label);
                    graphics.drawString(bar.label, n2 - n3 / 2, n9 + n4);
                    ++n12;
                }
                break;
            }
            case 1: {
                int n13;
                graphics.drawLine(100, 3 * n4, 100, this.y - 2 * n4);
                n8 = 100;
                n9 = (int)(3.0 * (double)n4 + this.max / d * ((double)this.y - 5.0 * (double)n4));
                n2 = n8 + n7;
                n = n9;
                graphics.drawLine(n8, n9, n2, n);
                int n14 = 0;
                while (n14 < this.keys.length) {
                    n13 = 0;
                    while (n13 < this.bars.size()) {
                        bar = (Bar)this.bars.elementAt(n13);
                        n2 = n8 + (n5 + this.gap) * n13 + (n5 + this.gap) / 2;
                        n = (int)((double)n9 - bar.values[n14] / this.max * ((double)n9 - 3.0 * (double)n4));
                        graphics.setColor(ColorManager.getColor(n14));
                        GraphicsSymbol.drawSymbol(graphics, n14, 10, n2, n);
                        if (n13 != 0) {
                            graphics.drawLine(n10, n11, n2, n);
                        }
                        n10 = n2;
                        n11 = n;
                        ++n13;
                    }
                    ++n14;
                }
                n13 = 0;
                while (n13 < this.bars.size()) {
                    bar = (Bar)this.bars.elementAt(n13);
                    n2 = n8 + (n5 + this.gap) * n13 + (n5 + this.gap) / 2;
                    n3 = this.fm.stringWidth(bar.label);
                    graphics.setColor(Color.black);
                    graphics.drawString(bar.label, n2 - n3 / 2, n9 + n4);
                    ++n13;
                }
                break;
            }
            default: {
                return;
            }
        }
        double d3 = this.max / 5.0;
        d3 = (int)(d3 + 0.51) == 0 ? d3 : (double)((int)(d3 + 0.51));
        int n15 = (int)(((double)n9 - 3.0 * (double)n4) * d3 / this.max);
        graphics.setColor(Color.black);
        double d4 = 0.0;
        int n16 = n8;
        int n17 = n9;
        while (d4 - 1.0E-6 <= this.max) {
            string = Misc.decimalPlaces(d4, 2);
            graphics.drawLine(n16, n17, n16 - 10, n17);
            n3 = this.fm.stringWidth(string);
            graphics.drawString(string, n16 - 10 - n3 - 5, n17);
            d4 += d3;
            n17 -= n15;
        }
        if (this.min < 0.0) {
            d4 = -d3;
            n16 = n8;
            n17 = n9 + n15;
            while (d4 > this.min) {
                string = Misc.decimalPlaces(d4, 2);
                graphics.drawLine(n16, n17, n16 - 10, n17);
                n3 = this.fm.stringWidth(string);
                graphics.drawString(string, n16 - 10 - n3 - 5, n17);
                d4 -= d3;
                n17 += n15;
            }
        }
        if (this.type == 1) {
            n2 = n8 + n7 + 100;
            n = 3 * n4;
            n4 = this.fm.getHeight();
            int n18 = Math.max(n4 + 10, 20);
            graphics.setColor(Color.black);
            graphics.drawString("Key", n2, n);
            int n19 = 0;
            while (n19 < this.keys.length) {
                if (this.is_valid[n19]) {
                    graphics.setColor(ColorManager.getColor(n19));
                    GraphicsSymbol.drawSymbol(graphics, n19, 10, n2 + (n18 - 3) / 2, (n += n18) + (n18 - 3) / 2);
                    graphics.setColor(Color.black);
                    graphics.drawString(this.keys[n19], n2 + n18, n + (n18 - 3) / 2);
                }
                ++n19;
            }
        }
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    class Bar {
        double value;
        String label;
        Color color;
        double[] values;

        Bar() {
        }
    }
}

