/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.statistics.charts;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import zeus.gui.ColorManager;
import zeus.util.Misc;
import zeus.visualiser.statistics.charts.DrawObject;

public class Histogram
implements DrawObject {
    protected static final int TYPE1 = 0;
    protected static final int TYPE2 = 1;
    protected static final double TINY = 1.0E-6;
    protected static final int LEFT = 100;
    protected static final int STEP = 5;
    protected static final int TICK_SIZE = 10;
    protected static final int KEY_DEPTH = 20;
    protected String title;
    protected Vector bars = new Vector();
    protected int x;
    protected int y = 0;
    protected FontMetrics fm;
    protected Font font;
    protected int gap = 10;
    protected double max = 0.0;
    protected double min = 0.0;
    protected double sum = 0.0;
    protected int type = -1;
    protected boolean[] is_valid;
    protected String[] keys;

    public Histogram() {
    }

    public Histogram(double[] dArray, String[] stringArray, String string) {
        this.setData(dArray, stringArray, string);
    }

    public Histogram(double[][] dArray, String[] stringArray, String[] stringArray2, String string) {
        this.setData(dArray, stringArray, stringArray2, string);
    }

    public void setData(double[] dArray, String[] stringArray, String string) {
        this.type = 0;
        this.title = string;
        int n = 0;
        this.bars.removeAllElements();
        this.sum = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (Math.abs(dArray[n2] - 0.0) > 1.0E-6) {
                this.max = Math.max(this.max, dArray[n2]);
                this.min = Math.min(this.min, dArray[n2]);
                Bar bar = new Bar();
                bar.value = dArray[n2];
                bar.label = stringArray[n2];
                bar.color = ColorManager.getColor(n++);
                this.bars.addElement(bar);
            }
            ++n2;
        }
    }

    public void setData(double[][] dArray, String[] stringArray, String[] stringArray2, String string) {
        this.type = 1;
        this.title = string;
        this.bars.removeAllElements();
        this.sum = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        this.is_valid = new boolean[stringArray2.length];
        this.keys = new String[stringArray2.length];
        int n = 0;
        while (n < stringArray2.length) {
            this.keys[n] = stringArray2[n];
            this.is_valid[n] = false;
            ++n;
        }
        int n2 = 0;
        while (n2 < dArray.length) {
            double d = 0.0;
            int n3 = 0;
            while (n3 < dArray[n2].length) {
                if (Math.abs(dArray[n2][n3] - 0.0) > 1.0E-6) {
                    this.is_valid[n3] = true;
                    d += dArray[n2][n3];
                }
                ++n3;
            }
            this.max = Math.max(this.max, d);
            this.min = Math.min(this.min, d);
            if (Math.abs(d - 0.0) > 1.0E-6) {
                Bar bar = new Bar();
                bar.values = new double[dArray[n2].length];
                int n4 = 0;
                while (n4 < bar.values.length) {
                    bar.values[n4] = dArray[n2][n4];
                    ++n4;
                }
                bar.label = stringArray[n2];
                this.bars.addElement(bar);
            }
            ++n2;
        }
    }

    public void drawYourSelf(Graphics graphics) {
        String string;
        double d;
        int n;
        int n2;
        int n3;
        Bar bar;
        this.font = new Font("Arial", 1, 14);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        int n4 = this.fm.stringWidth(this.title);
        int n5 = this.fm.getHeight();
        graphics.drawString(this.title, (this.x - n4) / 2, n5);
        if (this.bars.isEmpty()) {
            return;
        }
        int n6 = 0;
        this.font = new Font("Arial", 0, 12);
        this.fm = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        int n7 = 0;
        while (n7 < this.bars.size()) {
            bar = (Bar)this.bars.elementAt(n7);
            n6 = Math.max(n6, this.fm.stringWidth(bar.label));
            ++n7;
        }
        int n8 = ((n6 += 10) + this.gap) * this.bars.size();
        double d3 = this.min > 0.0 ? this.max : Math.abs(this.max - this.min);
        int n9 = 0;
        int n10 = 0;
        switch (this.type) {
            case 0: {
                int n11;
                int n12;
                graphics.drawLine(100, 3 * n5, 100, this.y - 2 * n5);
                n9 = 100;
                n10 = (int)(3.0 * (double)n5 + this.max / d3 * ((double)this.y - 5.0 * (double)n5));
                n3 = n9 + n8;
                n2 = n10;
                graphics.drawLine(n9, n10, n3, n2);
                n2 = n10;
                int n13 = 0;
                while (n13 < this.bars.size()) {
                    bar = (Bar)this.bars.elementAt(n13);
                    n3 = n9 + (n6 + this.gap) * n13 + this.gap / 2;
                    n12 = n3 + (n6 + this.gap) - this.gap / 2;
                    n11 = (int)((double)n10 - bar.value / this.max * ((double)n10 - 3.0 * (double)n5));
                    graphics.setColor(bar.color);
                    graphics.fillRect(Math.min(n3, n12), Math.min(n2, n11), Math.abs(n12 - n3), Math.abs(n11 - n2));
                    n4 = this.fm.stringWidth(bar.label);
                    n = bar.value > 0.0 ? n2 + n5 : n2 - n5;
                    graphics.setColor(Color.black);
                    graphics.drawString(bar.label, n3 + (n6 + this.gap - n4) / 2, n);
                    ++n13;
                }
                break;
            }
            case 1: {
                int n11;
                int n12;
                graphics.drawLine(100, 3 * n5, 100, this.y - 2 * n5);
                n9 = 100;
                n10 = (int)(3.0 * (double)n5 + this.max / d3 * ((double)this.y - 5.0 * (double)n5));
                n3 = n9 + n8;
                n2 = n10;
                graphics.drawLine(n9, n10, n3, n2);
                int n14 = 0;
                while (n14 < this.bars.size()) {
                    bar = (Bar)this.bars.elementAt(n14);
                    n3 = n9 + (n6 + this.gap) * n14 + this.gap / 2;
                    n12 = n3 + (n6 + this.gap) - this.gap / 2;
                    d = 0.0;
                    n11 = n2 = n10;
                    int n15 = 0;
                    while (n15 < bar.values.length) {
                        n2 = n11;
                        n11 = (int)((double)n10 - (d += bar.values[n15]) / this.max * ((double)n10 - 3.0 * (double)n5));
                        graphics.setColor(ColorManager.getColor(n15));
                        graphics.fillRect(Math.min(n3, n12), Math.min(n2, n11), Math.abs(n12 - n3), Math.abs(n11 - n2));
                        ++n15;
                    }
                    n4 = this.fm.stringWidth(bar.label);
                    n = d > 0.0 ? n10 + n5 : n10 - n5;
                    graphics.setColor(Color.black);
                    graphics.drawString(bar.label, n3 + (n6 + this.gap - n4) / 2, n);
                    ++n14;
                }
                break;
            }
            default: {
                return;
            }
        }
        double d4 = this.max / 5.0;
        d4 = (int)(d4 + 0.51) == 0 ? d4 : (double)((int)(d4 + 0.51));
        int n16 = (int)(((double)n10 - 3.0 * (double)n5) * d4 / this.max);
        graphics.setColor(Color.black);
        d = 0.0;
        int n17 = n9;
        n = n10;
        while (d - 1.0E-6 <= this.max) {
            string = Double.toString(d);
            string = Misc.decimalPlaces(string, 2);
            graphics.drawLine(n17, n, n17 - 10, n);
            n4 = this.fm.stringWidth(string);
            graphics.drawString(string, n17 - 10 - n4 - 5, n);
            d += d4;
            n -= n16;
        }
        if (this.min < 0.0) {
            d = -d4;
            n17 = n9;
            n = n10 + n16;
            while (d > this.min) {
                string = Double.toString(d);
                string = Misc.decimalPlaces(string, 2);
                graphics.drawLine(n17, n, n17 - 10, n);
                n4 = this.fm.stringWidth(string);
                graphics.drawString(string, n17 - 10 - n4 - 5, n);
                d -= d4;
                n += n16;
            }
        }
        if (this.type == 1) {
            n3 = n9 + n8 + 100;
            n2 = 3 * n5;
            n5 = this.fm.getHeight();
            int n18 = Math.max(n5 + 10, 20);
            graphics.setColor(Color.black);
            graphics.drawString("Key", n3, n2);
            int n19 = 0;
            while (n19 < this.keys.length) {
                if (this.is_valid[n19]) {
                    graphics.setColor(ColorManager.getColor(n19));
                    graphics.fillRect(n3, n2 += n18, n18 - 3, n18 - 3);
                    graphics.setColor(Color.black);
                    graphics.drawString(this.keys[n19], n3 + n18, n2 + (n18 - 3) / 2);
                }
                ++n19;
            }
        }
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    class Bar {
        double value;
        String label;
        Color color;
        double[] values;

        Bar() {
        }
    }
}

