/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.statistics;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.rtn.Engine;
import zeus.concepts.Goal;
import zeus.concepts.OntologyDb;
import zeus.concepts.Performative;
import zeus.concepts.ZeusParser;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Misc;
import zeus.util.MsgContentHandler;

public class TrafficVolume {
    protected Hashtable goalTraffic = new Hashtable();
    protected Hashtable negotiationTraffic = new Hashtable();
    protected Hashtable allTraffic = new Hashtable();
    protected Hashtable referenceTable = new Hashtable();
    protected boolean updatingGoalTraffic = true;
    protected OntologyDb ontology;

    public TrafficVolume(OntologyDb ontologyDb) {
        this.ontology = ontologyDb;
    }

    public synchronized void clear() {
        this.allTraffic.clear();
        this.clearGoalTraffic();
    }

    public synchronized void clearGoalTraffic() {
        this.goalTraffic.clear();
        this.negotiationTraffic.clear();
        this.referenceTable.clear();
    }

    public boolean isUpdatingGoalTraffic() {
        return this.updatingGoalTraffic;
    }

    public synchronized void setUpdatingGoalTraffic(boolean bl) {
        this.updatingGoalTraffic = bl;
    }

    public synchronized void update(Performative performative) {
        this.updateTraffic(performative);
        this.updateGoalTraffic(performative);
    }

    protected void updateTraffic(Performative performative) {
        int n;
        int[] nArray;
        String string = performative.getSender();
        String string2 = performative.getReceiver();
        String string3 = performative.getType();
        Hashtable<String, int[]> hashtable = (Hashtable<String, int[]>)this.allTraffic.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, int[]>();
            this.allTraffic.put(string, hashtable);
        }
        if ((nArray = (int[])hashtable.get(string2)) == null) {
            nArray = new int[Performative.MESSAGE_TYPES.length];
            n = 0;
            while (n < nArray.length) {
                nArray[n] = 0;
                ++n;
            }
            hashtable.put(string2, nArray);
        }
        Core.ERROR((n = Misc.whichPosition(string3, Performative.MESSAGE_TYPES)) != -1, 1, (Object)this);
        int n2 = n;
        nArray[n2] = nArray[n2] + 1;
    }

    protected void updateGoalTraffic(Performative performative) {
        String string;
        if (!this.updatingGoalTraffic) {
            return;
        }
        String string2 = performative.getSender();
        String string3 = performative.getReceiver();
        String string4 = performative.getType();
        String string5 = performative.getReplyWith();
        String string6 = performative.getInReplyTo();
        String string7 = performative.getContent();
        String string8 = string = string5 != null ? string5 : string6;
        if (string4.equals("cfp") || string4.equals("propose") || string4.equals("accept-proposal") || string4.equals("reject-proposal")) {
            Goal goal = ZeusParser.goal(this.ontology, string7);
            String string9 = goal.getRootId();
            this.updateGoalTraffic(string2, string3, string4, string9, string);
            this.updateNegotiationTraffic(string2, string3, string4, string, goal);
        } else if (this.referenceTable.containsKey(string)) {
            if (string4.equals("cancel") || string4.equals("failure")) {
                Goal goal = ZeusParser.goal(this.ontology, string7);
                String string10 = goal.getRootId();
                this.updateGoalTraffic(string2, string3, string4, string10, string);
            } else if (string4.equals("inform")) {
                MsgContentHandler msgContentHandler = new MsgContentHandler(string7);
                this.updateGoalTraffic(string2, string3, msgContentHandler.tag(), null, string);
            }
        }
    }

    protected void updateGoalTraffic(String string, String string2, String string3, String string4, String string5) {
        int n;
        int[] nArray;
        Hashtable<String, int[]> hashtable;
        if (string4 == null && (string4 = (String)this.referenceTable.get(string5)) == null) {
            string4 = "--UnknownId--";
        }
        this.referenceTable.put(string5, string4);
        Hashtable hashtable2 = (Hashtable)this.goalTraffic.get(string4);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            this.goalTraffic.put(string4, hashtable2);
        }
        if ((hashtable = (Hashtable<String, int[]>)hashtable2.get(string)) == null) {
            hashtable = new Hashtable<String, int[]>();
            hashtable2.put(string, hashtable);
        }
        if ((nArray = (int[])hashtable.get(string2)) == null) {
            nArray = new int[Engine.COORDINATION_MESSAGE_TYPES.length];
            n = 0;
            while (n < nArray.length) {
                nArray[n] = 0;
                ++n;
            }
            hashtable.put(string2, nArray);
        }
        Core.ERROR((n = Misc.whichPosition(string3, Engine.COORDINATION_MESSAGE_TYPES)) != -1, 2, (Object)this);
        int n2 = n;
        nArray[n2] = nArray[n2] + 1;
    }

    protected void updateNegotiationTraffic(String string, String string2, String string3, String string4, Goal goal) {
        Vector<Double> vector;
        String string5;
        Hashtable<String, Vector<Double>> hashtable;
        Hashtable hashtable2;
        String string6 = goal.getRootId();
        String string7 = goal.getId() + "[" + goal.getFactType() + "]";
        double d = goal.getCost();
        if (Math.abs(d) < 1.0E-12) {
            return;
        }
        if (string6 == null && (string6 = (String)this.referenceTable.get(string4)) == null) {
            string6 = "--UnknownId--";
        }
        this.referenceTable.put(string4, string6);
        Hashtable hashtable3 = (Hashtable)this.negotiationTraffic.get(string6);
        if (hashtable3 == null) {
            hashtable3 = new Hashtable();
            this.negotiationTraffic.put(string6, hashtable3);
        }
        if ((hashtable2 = (Hashtable)hashtable3.get(string7)) == null) {
            hashtable2 = new Hashtable();
            hashtable3.put(string7, hashtable2);
        }
        if ((hashtable = (Hashtable<String, Vector<Double>>)hashtable2.get(string5 = string.compareTo(string2) > 0 ? string + " " + string2 : string2 + " " + string)) == null) {
            hashtable = new Hashtable<String, Vector<Double>>();
            hashtable2.put(string5, hashtable);
        }
        if ((vector = (Vector<Double>)hashtable.get(string)) == null) {
            vector = new Vector<Double>();
            hashtable.put(string, vector);
        }
        vector.addElement(new Double(d));
    }

    public String[] getDistributionByTypeLabels() {
        return Performative.MESSAGE_TYPES;
    }

    public synchronized double[] getDistributionByTypeData() {
        double[] dArray = new double[Performative.MESSAGE_TYPES.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = 0.0;
            ++n;
        }
        Enumeration enumeration = this.allTraffic.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                int[] nArray = (int[])enumeration2.nextElement();
                int n2 = 0;
                while (n2 < dArray.length) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + (double)nArray[n2];
                    ++n2;
                }
            }
        }
        return dArray;
    }

    public synchronized String[] getDistributionByAgentLabels() {
        String[] stringArray = new String[this.allTraffic.size()];
        Enumeration enumeration = this.allTraffic.keys();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String[] getDistributionByAgentKeys() {
        return Performative.MESSAGE_TYPES;
    }

    public synchronized double[][] getDistributionByAgentData() {
        if (this.allTraffic.isEmpty()) {
            return null;
        }
        double[][] dArray = new double[this.allTraffic.size()][Performative.MESSAGE_TYPES.length];
        int n = 0;
        while (n < dArray.length) {
            int n2 = 0;
            while (n2 < dArray[n].length) {
                dArray[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
        Enumeration enumeration = this.allTraffic.elements();
        int n3 = 0;
        while (n3 < dArray.length) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                int[] nArray = (int[])enumeration2.nextElement();
                int n4 = 0;
                while (n4 < dArray[n3].length) {
                    double[] dArray2 = dArray[n3];
                    int n5 = n4;
                    dArray2[n5] = dArray2[n5] + (double)nArray[n4];
                    ++n4;
                }
            }
            ++n3;
        }
        return dArray;
    }

    public synchronized String[] getCurrentGoals() {
        String[] stringArray = new String[this.goalTraffic.size()];
        Enumeration enumeration = this.goalTraffic.keys();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String[] getDistributionByGoalKeys() {
        return Engine.COORDINATION_MESSAGE_TYPES;
    }

    public synchronized String[] getDistributionByGoalLabels(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            Hashtable hashtable = (Hashtable)this.goalTraffic.get(stringArray[n]);
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (vector.contains(string)) continue;
                    vector.addElement(string);
                }
            }
            ++n;
        }
        return Misc.stringArray(vector);
    }

    public synchronized Hashtable getNegotiationGoals() {
        Hashtable<String, HSet> hashtable = new Hashtable<String, HSet>();
        Enumeration enumeration = this.negotiationTraffic.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)this.negotiationTraffic.get(string);
            Enumeration enumeration2 = hashtable2.keys();
            HSet hSet = new HSet();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                Hashtable hashtable3 = (Hashtable)hashtable2.get(string2);
                Enumeration enumeration3 = hashtable3.keys();
                while (enumeration3.hasMoreElements()) {
                    String string3 = (String)enumeration3.nextElement();
                    hSet.add(string2 + " " + string3);
                }
            }
            hashtable.put(string, hSet);
        }
        return hashtable;
    }

    public synchronized double[][] getDistributionByNegotiationDialogueXData(String[] stringArray) {
        Vector vector;
        int n;
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        MsgContentHandler msgContentHandler = new MsgContentHandler(stringArray[1]);
        String string = msgContentHandler.tag();
        String string2 = msgContentHandler.data();
        String string3 = msgContentHandler.data(0);
        String string4 = msgContentHandler.data(1);
        Hashtable hashtable = (Hashtable)this.negotiationTraffic.get(stringArray[0]);
        Hashtable hashtable2 = (Hashtable)hashtable.get(string);
        Hashtable hashtable3 = (Hashtable)hashtable2.get(string2);
        Vector vector2 = (Vector)hashtable3.get(string3);
        int n2 = vector2 != null ? vector2.size() : 0;
        int n3 = Math.max(n2, n = (vector = (Vector)hashtable3.get(string4)) != null ? vector.size() : 0);
        if (n3 == 0) {
            return null;
        }
        double[][] dArray = new double[2][n3];
        int n4 = 0;
        while (n4 < dArray.length) {
            int n5 = 0;
            while (n5 < dArray[n4].length) {
                dArray[n4][n5] = n5;
                ++n5;
            }
            ++n4;
        }
        return dArray;
    }

    public synchronized String[] getDistributionByNegotiationDialogueKeys(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        MsgContentHandler msgContentHandler = new MsgContentHandler(stringArray[1]);
        String string = msgContentHandler.data(0);
        String string2 = msgContentHandler.data(1);
        String[] stringArray2 = new String[]{string, string2};
        return stringArray2;
    }

    public synchronized double[][] getDistributionByNegotiationDialogueData(String[] stringArray) {
        Double d;
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        MsgContentHandler msgContentHandler = new MsgContentHandler(stringArray[1]);
        String string = msgContentHandler.tag();
        String string2 = msgContentHandler.data();
        String string3 = msgContentHandler.data(0);
        String string4 = msgContentHandler.data(1);
        Hashtable hashtable = (Hashtable)this.negotiationTraffic.get(stringArray[0]);
        Hashtable hashtable2 = (Hashtable)hashtable.get(string);
        Hashtable hashtable3 = (Hashtable)hashtable2.get(string2);
        Vector vector = (Vector)hashtable3.get(string3);
        Vector vector2 = (Vector)hashtable3.get(string4);
        double[][] dArrayArray = new double[2][];
        int n = vector != null ? vector.size() : 0;
        dArrayArray[0] = new double[n];
        int n2 = 0;
        while (vector != null && n2 < n) {
            d = (Double)vector.elementAt(n2);
            dArrayArray[0][n2] = d;
            ++n2;
        }
        int n3 = vector2 != null ? vector2.size() : 0;
        dArrayArray[1] = new double[n3];
        int n4 = 0;
        while (vector2 != null && n4 < n3) {
            d = (Double)vector2.elementAt(n4);
            dArrayArray[1][n4] = d;
            ++n4;
        }
        return dArrayArray;
    }

    public synchronized double[][] getDistributionByGoalData(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String[] stringArray2 = this.getDistributionByGoalLabels(stringArray);
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        double[][] dArray = new double[stringArray2.length][Engine.COORDINATION_MESSAGE_TYPES.length];
        int n = 0;
        while (n < dArray.length) {
            int n2 = 0;
            while (n2 < dArray[n].length) {
                dArray[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            Hashtable hashtable = (Hashtable)this.goalTraffic.get(stringArray[n3]);
            if (hashtable != null) {
                int n4 = 0;
                while (n4 < stringArray2.length) {
                    Hashtable hashtable2 = (Hashtable)hashtable.get(stringArray2[n4]);
                    if (hashtable2 != null) {
                        Enumeration enumeration = hashtable2.elements();
                        while (enumeration.hasMoreElements()) {
                            int[] nArray = (int[])enumeration.nextElement();
                            int n5 = 0;
                            while (n5 < nArray.length) {
                                double[] dArray2 = dArray[n4];
                                int n6 = n5;
                                dArray2[n6] = dArray2[n6] + (double)nArray[n5];
                                ++n5;
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return dArray;
    }

    public synchronized String[] getInterAgentTrafficLabels() {
        String[] stringArray = new String[this.allTraffic.size()];
        Enumeration enumeration = this.allTraffic.keys();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public synchronized double[][] getInterAgentTrafficData() {
        if (this.allTraffic.isEmpty()) {
            return null;
        }
        String[] stringArray = this.getInterAgentTrafficLabels();
        double[][] dArray = new double[stringArray.length][stringArray.length];
        int n = 0;
        while (n < dArray.length) {
            int n2 = 0;
            while (n2 < dArray[n].length) {
                dArray[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            Hashtable hashtable = (Hashtable)this.allTraffic.get(stringArray[n3]);
            int n4 = 0;
            while (n4 < dArray[n3].length) {
                int n5 = 0;
                int[] nArray = (int[])hashtable.get(stringArray[n4]);
                if (nArray != null) {
                    int n6 = 0;
                    while (n6 < nArray.length) {
                        n5 += nArray[n6];
                        ++n6;
                    }
                }
                dArray[n3][n4] = n5;
                ++n4;
            }
            ++n3;
        }
        return dArray;
    }
}

