/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.statistics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import zeus.actors.AgentContext;
import zeus.concepts.Performative;
import zeus.concepts.ZeusParser;
import zeus.gui.DoubleSelectionDialog;
import zeus.gui.EditableMultipleSelectionDialog;
import zeus.gui.MultipleSelectionDialog;
import zeus.gui.NumberDialog;
import zeus.gui.help.HelpWindow;
import zeus.util.Misc;
import zeus.util.SystemProps;
import zeus.visualiser.VisualiserModel;
import zeus.visualiser.basic.VideoTool;
import zeus.visualiser.statistics.TrafficVolume;
import zeus.visualiser.statistics.charts.DrawCanvas;
import zeus.visualiser.statistics.charts.Histogram;
import zeus.visualiser.statistics.charts.LineGraph;
import zeus.visualiser.statistics.charts.PieChart;
import zeus.visualiser.statistics.charts.TabularGraph;
import zeus.visualiser.statistics.charts.XYGraph;

public class StatisticsTool
extends VideoTool {
    private static int count = 0;
    static final int NIL = 0;
    static final int BAT = 1;
    static final int TVT = 2;
    static final int TVA = 4;
    static final int IAT = 8;
    static final int MPG = 16;
    static final int NEG = 32;
    static final int GCS = 64;
    static final int AEM = 128;
    static final int AMS = 256;
    static final int CRR = 512;
    static final int GLT = 1024;
    static final int TAL = 2048;
    static final int PIE = 1;
    static final int BAR = 2;
    static final int LIN = 4;
    static final int XYG = 8;
    static final int TAB = 16;
    static String[] STATS_MENU_ITEMS = new String[]{"Breakdown of agent types", "Traffic volume by type", "Traffic volume by agent", "Inter agent traffic volume", "Messages per goal", "Inter agent negotiation graphs", "Goal completion status", "Agent efficiency measure", "Agent monetary statement", "Plan/Resources ratio", "Average goal lapse times", "Task activity level"};
    protected StatisticsMenuBar menubar;
    protected StatisticsToolBar statisticsToolBar;
    protected EditableMultipleSelectionDialog message_dialog = null;
    protected DoubleSelectionDialog neg_dialog = null;
    protected NumberDialog as_dialog = null;
    protected JScrollPane scrollpane;
    protected DrawCanvas canvas;
    private int chart_type = 1;
    private int statistics_type = 0;
    protected TrafficVolume offlineQueue;
    protected TrafficVolume onlineQueue;
    protected TrafficVolume msgQueue = null;
    protected Grapher grapher = null;
    protected MultipleSelectionDialog ms_dialog = null;

    public StatisticsTool(AgentContext agentContext, VisualiserModel visualiserModel) {
        super(agentContext, visualiserModel);
        this.setTitle(agentContext.whoami() + " - Statistics Tool:" + count++);
        this.setBackground(Color.lightGray);
        ImageIcon imageIcon = new ImageIcon(SystemProps.getProperty("gif.dir") + File.separator + "visualiser" + File.separator + "stats-icon.gif");
        this.setIconImage(imageIcon.getImage());
        this.offlineQueue = new TrafficVolume(agentContext.OntologyDb());
        this.onlineQueue = new TrafficVolume(agentContext.OntologyDb());
        this.getContentPane().setLayout(new BorderLayout());
        this.canvas = new DrawCanvas();
        this.canvas.setBackground(new Color(245, 230, 145));
        this.scrollpane = new JScrollPane(this.canvas);
        this.scrollpane.setPreferredSize(new Dimension(460, 460));
        this.scrollpane.setMaximumSize(new Dimension(1600, 1600));
        this.canvas.setPreferredSize(new Dimension(1600, 1600));
        this.statisticsToolBar = new StatisticsToolBar();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(this.statisticsToolBar);
        jPanel.add(this.videoToolbar);
        this.getContentPane().add("North", jPanel);
        this.getContentPane().add("Center", this.scrollpane);
        this.msgQueue = this.onlineQueue;
        this.grapher = new Grapher();
        this.menubar = new StatisticsMenuBar();
        this.setJMenuBar(this.menubar);
        this.pack();
        this.setVisible(true);
        this.setMode(1);
    }

    public void Exit() {
        if (this.grapher != null) {
            this.grapher.terminate();
        }
        this.grapher = null;
        super.Exit();
    }

    public Dimension getViewportSize() {
        return this.scrollpane.getViewport().getExtentSize();
    }

    public void SaveGoalTraffic(boolean bl) {
        this.msgQueue.setUpdatingGoalTraffic(bl);
    }

    public void ClearGoalTraffic() {
        this.msgQueue.clearGoalTraffic();
    }

    public void StreamMessages(boolean bl) {
        Object[] objectArray;
        if (!this.hubOK()) {
            return;
        }
        if (!this.stopPlayback()) {
            return;
        }
        Object[] objectArray2 = this.model.getAgents();
        if (this.message_dialog == null) {
            this.message_dialog = new EditableMultipleSelectionDialog((Frame)this, "Select Agents", objectArray2);
            this.message_dialog.setLocationRelativeTo(this);
        } else {
            objectArray = this.message_dialog.getPriorSelection();
            this.message_dialog.setListData(objectArray2);
            this.message_dialog.setSelection(objectArray);
        }
        objectArray = this.message_dialog.getSelection();
        this.model.addAgents(Misc.stringArray(this.message_dialog.getListData()));
        this.subscribe(bl, this.model.keys[1], Misc.stringArray(objectArray), "log_message");
    }

    protected void setMode(int n) {
        if (n == 1) {
            this.menubar.update(1);
            this.videoToolbar.setStatus(false);
            this.offlineQueue.clear();
            this.msgQueue = this.onlineQueue;
        } else {
            this.menubar.update(0);
            this.videoToolbar.setStatus(true);
            this.offlineQueue.clear();
            this.msgQueue = this.offlineQueue;
        }
    }

    protected void registerAgent(String string, String string2) {
    }

    protected void registerListOfPlaybackAgents(Vector vector) {
    }

    protected void visualiseVideoData(int n, Performative performative) {
        if (this.state.mode == 0 && this.filterMsg(performative)) {
            this.offlineQueue.update(performative);
        }
    }

    public void log_message(Performative performative) {
        try {
            Performative performative2 = ZeusParser.performative(performative.getContent());
            if (this.filterMsg(performative2)) {
                this.onlineQueue.update(performative2);
            }
            this.record_item(performative2);
        }
        catch (Exception exception) {}
    }

    public void AnimationSpeed() {
        if (!this.hubOK()) {
            return;
        }
        long l = this.grapher.getSpeed();
        if (this.as_dialog == null) {
            this.as_dialog = new NumberDialog((Frame)this, "Set Animation Speed", "Enter speed:");
            this.as_dialog.setLocationRelativeTo(this);
        }
        this.as_dialog.setValue(l);
        Long l2 = this.as_dialog.getValue();
        if (l2 != null) {
            this.grapher.setSpeed(l2);
        }
    }

    protected boolean statisticIsOneOf(int n) {
        if (this.statistics_type != 0 && (this.statistics_type & n) == 0) {
            JOptionPane.showMessageDialog(this, "Invalid chart type for current statistic");
            return false;
        }
        return true;
    }

    public void RedrawGraph() {
        if (this.grapher != null) {
            this.grapher.drawChart();
        }
    }

    public void DrawPieGraph() {
        if (!this.statisticIsOneOf(3)) {
            return;
        }
        this.chart_type = 1;
        if (this.grapher != null) {
            this.grapher.drawChart();
        }
    }

    public void DrawBarGraph() {
        if (!this.statisticIsOneOf(23)) {
            return;
        }
        this.chart_type = 2;
        if (this.grapher != null) {
            this.grapher.drawChart();
        }
    }

    public void DrawLineGraph() {
        if (!this.statisticIsOneOf(23)) {
            return;
        }
        this.chart_type = 4;
        if (this.grapher != null) {
            this.grapher.drawChart();
        }
    }

    public void DrawXYGraph() {
        if (!this.statisticIsOneOf(32)) {
            return;
        }
        this.chart_type = 8;
        if (this.grapher != null) {
            this.grapher.drawChart();
        }
    }

    public void DrawTabularGraph() {
        if (!this.statisticIsOneOf(8)) {
            return;
        }
        this.chart_type = 16;
        if (this.grapher != null) {
            this.grapher.drawChart();
        }
    }

    public void setStatisticsType(int n) {
        if (this.grapher == null) {
            return;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                if ((this.chart_type & 7) == 0) {
                    this.chart_type = 1;
                }
                this.statistics_type = n;
                this.grapher.drawChart();
                break;
            }
            case 2: {
                if ((this.chart_type & 7) == 0) {
                    this.chart_type = 2;
                }
                this.statistics_type = n;
                this.grapher.drawChart();
                break;
            }
            case 4: {
                if ((this.chart_type & 6) == 0) {
                    this.chart_type = 2;
                }
                this.statistics_type = n;
                this.grapher.drawChart();
                break;
            }
            case 8: {
                if ((this.chart_type & 0x10) == 0) {
                    this.chart_type = 16;
                }
                this.statistics_type = n;
                this.grapher.drawChart();
                break;
            }
            case 16: {
                Object[] objectArray = this.msgQueue.getCurrentGoals();
                if (objectArray.length == 0) {
                    JOptionPane.showMessageDialog(this, "No goals currently available");
                    this.menubar.setStatisticsType(this.statistics_type);
                    return;
                }
                if (this.ms_dialog == null) {
                    this.ms_dialog = new MultipleSelectionDialog((Frame)this, "Select Required Goals");
                    this.ms_dialog.setLocationRelativeTo(this);
                }
                Object[] objectArray2 = this.ms_dialog.getPriorSelection();
                this.ms_dialog.setListData(objectArray);
                this.ms_dialog.setSelection(objectArray2);
                Object[] objectArray3 = this.ms_dialog.getSelection();
                if (objectArray3 == null) {
                    return;
                }
                if ((this.chart_type & 6) == 0) {
                    this.chart_type = 2;
                }
                this.statistics_type = n;
                this.grapher.setUserGoals(Misc.stringArray(objectArray3));
                this.grapher.drawChart();
                break;
            }
            case 32: {
                String[] stringArray = this.msgQueue.getCurrentGoals();
                if (stringArray.length == 0) {
                    JOptionPane.showMessageDialog(this, "No goals currently available");
                    this.menubar.setStatisticsType(this.statistics_type);
                    return;
                }
                Hashtable hashtable = this.msgQueue.getNegotiationGoals();
                if (this.neg_dialog == null) {
                    this.neg_dialog = new DoubleSelectionDialog((Frame)this, "Goal & Negotiation Partners", "Goal", "Negotiation Partners");
                    this.neg_dialog.setLocationRelativeTo(this);
                }
                Object[] objectArray = this.neg_dialog.getPriorSelection();
                this.neg_dialog.setListData(hashtable);
                this.neg_dialog.setSelection(objectArray[0], objectArray[1]);
                Object[] objectArray4 = this.neg_dialog.getSelection();
                if (objectArray4 == null) {
                    return;
                }
                if ((this.chart_type & 8) == 0) {
                    this.chart_type = 8;
                }
                this.statistics_type = n;
                this.grapher.setUserGoals(Misc.stringArray(objectArray4));
                this.grapher.drawChart();
                break;
            }
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 2048: {
                this.statistics_type = n;
                this.grapher.drawChart();
                break;
            }
        }
    }

    public void Help() {
        Point point = this.getLocation();
        HelpWindow helpWindow = new HelpWindow(this, point, "visualiser", "Statistics Tool");
        helpWindow.setSize(new Dimension(this.getWidth(), 440));
        helpWindow.setLocation(point.x + 24, point.y + 24);
        helpWindow.validate();
    }

    class Grapher
    extends Thread {
        protected long speed = 3000L;
        protected boolean running = true;
        protected PieChart pie = new PieChart();
        protected Histogram bar = new Histogram();
        protected LineGraph line = new LineGraph();
        protected XYGraph xy = new XYGraph();
        protected TabularGraph tabular = new TabularGraph();
        protected String[] user_goals;
        public String[] AGENT_TYPES = new String[]{SystemProps.getProperty("agent.names.nameserver"), SystemProps.getProperty("agent.names.facilitator"), SystemProps.getProperty("agent.names.visualiser"), SystemProps.getProperty("agent.names.dbProxy"), SystemProps.getProperty("agent.names.agent")};

        public Grapher() {
            this.setPriority(2);
            this.start();
        }

        public void setSpeed(long l) {
            this.speed = l;
        }

        public long getSpeed() {
            return this.speed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = 0L;
            while (this.running) {
                Grapher grapher = this;
                synchronized (grapher) {
                    try {
                        while (!((StatisticsTool)StatisticsTool.this).state.animating || StatisticsTool.this.chart_type == 0 || StatisticsTool.this.statistics_type == 0) {
                            this.wait(this.speed);
                        }
                        this.drawChart();
                        this.wait(this.speed);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        public void terminate() {
            this.running = false;
        }

        public void wakeup() {
            this.notifyAll();
        }

        public void setUserGoals(String[] stringArray) {
            this.user_goals = stringArray;
        }

        public String[] getUserGoals() {
            return this.user_goals;
        }

        public void drawChart() {
            double[][] dArray = null;
            double[][] dArray2 = null;
            double[] dArray3 = null;
            double[] dArray4 = null;
            String[] stringArray = null;
            String[] stringArray2 = null;
            String string = null;
            switch (StatisticsTool.this.statistics_type) {
                case 0: {
                    return;
                }
                case 1: {
                    string = "Breakdown of Agent Types";
                    stringArray = this.AGENT_TYPES;
                    dArray3 = new double[this.AGENT_TYPES.length];
                    int n = 0;
                    while (n < dArray3.length) {
                        String[] stringArray3 = StatisticsTool.this.model.getAgents(this.AGENT_TYPES[n]);
                        dArray3[n] = stringArray3 == null ? 0.0 : (double)stringArray3.length;
                        ++n;
                    }
                    break;
                }
                case 2: {
                    string = "Traffic Volume: Distribution by Type";
                    stringArray = StatisticsTool.this.msgQueue.getDistributionByTypeLabels();
                    dArray3 = StatisticsTool.this.msgQueue.getDistributionByTypeData();
                    break;
                }
                case 4: {
                    string = "Traffic Volume: Distribution by Agent";
                    stringArray = StatisticsTool.this.msgQueue.getDistributionByAgentLabels();
                    dArray = StatisticsTool.this.msgQueue.getDistributionByAgentData();
                    stringArray2 = StatisticsTool.this.msgQueue.getDistributionByAgentKeys();
                    if (dArray != null) break;
                    return;
                }
                case 8: {
                    string = "Inter-Agent Traffic Volume";
                    stringArray = StatisticsTool.this.msgQueue.getInterAgentTrafficLabels();
                    dArray = StatisticsTool.this.msgQueue.getInterAgentTrafficData();
                    if (dArray != null) break;
                    return;
                }
                case 16: {
                    string = "Traffic Volume for Selected Goals: Distribution by Agent";
                    stringArray = StatisticsTool.this.msgQueue.getDistributionByGoalLabels(this.user_goals);
                    dArray = StatisticsTool.this.msgQueue.getDistributionByGoalData(this.user_goals);
                    stringArray2 = StatisticsTool.this.msgQueue.getDistributionByGoalKeys();
                    if (dArray != null) break;
                    return;
                }
                case 32: {
                    string = "Negotiation Graph for " + this.user_goals[1];
                    dArray = StatisticsTool.this.msgQueue.getDistributionByNegotiationDialogueData(this.user_goals);
                    dArray2 = StatisticsTool.this.msgQueue.getDistributionByNegotiationDialogueXData(this.user_goals);
                    stringArray2 = StatisticsTool.this.msgQueue.getDistributionByNegotiationDialogueKeys(this.user_goals);
                    if (dArray2 != null) break;
                    return;
                }
                case 64: 
                case 128: 
                case 256: 
                case 512: 
                case 1024: 
                case 2048: {
                    return;
                }
                default: {
                    return;
                }
            }
            switch (StatisticsTool.this.chart_type) {
                case 0: {
                    return;
                }
                case 1: {
                    this.pie.setData(dArray3, stringArray, string);
                    Dimension dimension = StatisticsTool.this.getViewportSize();
                    this.pie.setXY(dimension.width, dimension.height);
                    StatisticsTool.this.canvas.setDrawType(this.pie);
                    StatisticsTool.this.canvas.repaint();
                    return;
                }
                case 2: {
                    if (stringArray2 != null) {
                        this.bar.setData(dArray, stringArray, stringArray2, string);
                    } else {
                        this.bar.setData(dArray3, stringArray, string);
                    }
                    Dimension dimension = StatisticsTool.this.getViewportSize();
                    this.bar.setXY(dimension.width, dimension.height);
                    StatisticsTool.this.canvas.setDrawType(this.bar);
                    StatisticsTool.this.canvas.repaint();
                    return;
                }
                case 4: {
                    if (stringArray2 != null) {
                        this.line.setData(dArray, stringArray, stringArray2, string);
                    } else {
                        this.line.setData(dArray3, stringArray, string);
                    }
                    Dimension dimension = StatisticsTool.this.getViewportSize();
                    this.line.setXY(dimension.width, dimension.height);
                    StatisticsTool.this.canvas.setDrawType(this.line);
                    StatisticsTool.this.canvas.repaint();
                    return;
                }
                case 16: {
                    this.tabular.setData(dArray, stringArray, string);
                    Dimension dimension = StatisticsTool.this.getViewportSize();
                    this.tabular.setXY(dimension.width, dimension.height);
                    StatisticsTool.this.canvas.setDrawType(this.tabular);
                    StatisticsTool.this.canvas.repaint();
                    return;
                }
                case 8: {
                    if (stringArray2 != null) {
                        this.xy.setData(dArray, dArray2, stringArray2, string);
                    } else {
                        this.xy.setData(dArray3, dArray4, string);
                    }
                    Dimension dimension = StatisticsTool.this.getViewportSize();
                    this.xy.setXY(dimension.width, dimension.height);
                    StatisticsTool.this.canvas.setDrawType(this.xy);
                    StatisticsTool.this.canvas.repaint();
                    return;
                }
            }
        }
    }

    protected class StatisticsToolBar
    extends JToolBar
    implements ActionListener {
        protected JButton barBtn;
        protected JButton pieBtn;
        protected JButton lineBtn;
        protected JButton xyBtn;
        protected JButton tabularBtn;

        public StatisticsToolBar() {
            this.setFloatable(false);
            String string = SystemProps.getProperty("gif.dir") + File.separator + "visualiser" + File.separator;
            this.addSeparator();
            this.barBtn = new JButton(new ImageIcon(string + "bar.gif"));
            this.add(this.barBtn);
            this.barBtn.setPreferredSize(new Dimension(24, 24));
            this.barBtn.setToolTipText("Show as Bar Chart");
            this.barBtn.setMargin(new Insets(0, 0, 0, 0));
            this.addSeparator();
            this.pieBtn = new JButton(new ImageIcon(string + "pie.gif"));
            this.add(this.pieBtn);
            this.pieBtn.setPreferredSize(new Dimension(24, 24));
            this.pieBtn.setToolTipText("Show as Pie Chart");
            this.pieBtn.setMargin(new Insets(0, 0, 0, 0));
            this.addSeparator();
            this.lineBtn = new JButton(new ImageIcon(string + "line.gif"));
            this.add(this.lineBtn);
            this.lineBtn.setPreferredSize(new Dimension(24, 24));
            this.lineBtn.setToolTipText("Show as Line Chart");
            this.lineBtn.setMargin(new Insets(0, 0, 0, 0));
            this.addSeparator();
            this.xyBtn = new JButton(new ImageIcon(string + "xy.gif"));
            this.add(this.xyBtn);
            this.xyBtn.setPreferredSize(new Dimension(24, 24));
            this.xyBtn.setToolTipText("Show as XY Chart");
            this.xyBtn.setMargin(new Insets(0, 0, 0, 0));
            this.addSeparator();
            this.tabularBtn = new JButton(new ImageIcon(string + "table.gif"));
            this.add(this.tabularBtn);
            this.tabularBtn.setPreferredSize(new Dimension(24, 24));
            this.tabularBtn.setToolTipText("Show as Tabular Chart");
            this.tabularBtn.setMargin(new Insets(0, 0, 0, 0));
            this.addSeparator();
            this.setPreferredSize(new Dimension(300, 32));
            this.barBtn.addActionListener(this);
            this.pieBtn.addActionListener(this);
            this.lineBtn.addActionListener(this);
            this.xyBtn.addActionListener(this);
            this.tabularBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.xyBtn) {
                StatisticsTool.this.DrawXYGraph();
            } else if (object == this.tabularBtn) {
                StatisticsTool.this.DrawTabularGraph();
            } else if (object == this.barBtn) {
                StatisticsTool.this.DrawBarGraph();
            } else if (object == this.pieBtn) {
                StatisticsTool.this.DrawPieGraph();
            } else if (object == this.lineBtn) {
                StatisticsTool.this.DrawLineGraph();
            }
        }
    }

    class StatisticsMenuBar
    extends JMenuBar
    implements ActionListener,
    ItemListener {
        protected static final int CHECKITEM = 0;
        protected static final int PLAINITEM = 1;
        protected static final int RADIOITEM = 2;
        protected JMenu fileMenu;
        protected JMenu onLineMenu;
        protected JMenu replayMenu;
        protected JMenu optionsMenu;
        protected JMenu viewMenu;
        protected JMenu helpMenu;
        protected JMenu animationMenu;
        protected JMenu doMenu;
        protected JMenuItem sessions;
        protected JMenuItem load;
        protected JMenuItem save;
        protected JMenuItem close;
        protected JMenuItem forward;
        protected JMenuItem rewind;
        protected JMenuItem fforward;
        protected JMenuItem frewind;
        protected JMenuItem stop;
        protected JMenuItem forward_step;
        protected JMenuItem rewind_step;
        protected JMenuItem forward_last;
        protected JMenuItem rewind_first;
        protected JMenuItem delete;
        protected JMenuItem purge;
        protected JMenuItem connect;
        protected JMenuItem disconnect;
        protected JMenuItem exit;
        protected JMenuItem cc;
        protected JMenuItem un_cc;
        protected JMenuItem filter;
        protected JMenuItem animation_speed;
        protected JMenuItem player_speed;
        protected JMenuItem clear_goal;
        protected JMenuItem redraw;
        protected JMenuItem line;
        protected JMenuItem bar;
        protected JMenuItem pie;
        protected JMenuItem xy;
        protected JMenuItem table;
        protected JMenuItem help;
        protected JMenuItem about;
        protected JCheckBoxMenuItem save_goal;
        protected JRadioButtonMenuItem[] statsRadioBox;

        public StatisticsMenuBar() {
            this.add(this.fileMenu());
            this.add(this.onlineMenu());
            this.add(this.playbackMenu());
            this.add(this.optionsMenu());
            this.add(this.doMenu());
            this.add(this.viewMenu());
            this.add(this.helpMenu());
        }

        private JMenu fileMenu() {
            JMenu jMenu = new JMenu("File");
            jMenu.setMnemonic('F');
            this.connect = this.createMenuItem(jMenu, 1, "Connect to namservers", 67);
            this.disconnect = this.createMenuItem(jMenu, 1, "Disconnect from nameservers", 68);
            this.exit = this.createMenuItem(jMenu, 1, "Quit", 81);
            return jMenu;
        }

        private JMenu onlineMenu() {
            JMenu jMenu = new JMenu("Online");
            jMenu.setMnemonic('O');
            this.cc = this.createMenuItem(jMenu, 1, "Request messages...", 82);
            this.un_cc = this.createMenuItem(jMenu, 1, "Unrequest messages...", 85);
            return jMenu;
        }

        private JMenu playbackMenu() {
            JMenu jMenu = new JMenu("Playback");
            jMenu.setMnemonic('P');
            this.sessions = this.createMenuItem(jMenu, 1, "Request saved sessions", 0);
            this.delete = this.createMenuItem(jMenu, 1, "Delete session", 0);
            this.purge = this.createMenuItem(jMenu, 1, "Purge database", 0);
            jMenu.addSeparator();
            this.load = this.createMenuItem(jMenu, 1, "Load session", 0);
            this.save = this.createMenuItem(jMenu, 1, "Save session", 0);
            this.close = this.createMenuItem(jMenu, 1, "Close session", 0);
            jMenu.addSeparator();
            this.forward = this.createMenuItem(jMenu, 1, "Forward", 0);
            this.rewind = this.createMenuItem(jMenu, 1, "Rewind", 0);
            this.fforward = this.createMenuItem(jMenu, 1, "Fast forward", 0);
            this.frewind = this.createMenuItem(jMenu, 1, "Fast rewind", 0);
            this.forward_step = this.createMenuItem(jMenu, 1, "Step forward", 0);
            this.rewind_step = this.createMenuItem(jMenu, 1, "Step backward", 0);
            this.forward_last = this.createMenuItem(jMenu, 1, "Forward to end", 0);
            this.rewind_first = this.createMenuItem(jMenu, 1, "Rewind to beginning", 0);
            this.stop = this.createMenuItem(jMenu, 1, "Stop", 0);
            return jMenu;
        }

        private JMenu optionsMenu() {
            JMenu jMenu = new JMenu("Options");
            jMenu.setMnemonic('O');
            this.filter = this.createMenuItem(jMenu, 1, "Filter messages...", 0);
            this.player_speed = this.createMenuItem(jMenu, 1, "Player speed...", 0);
            this.animation_speed = this.createMenuItem(jMenu, 1, "Animation speed...", 0);
            this.save_goal = (JCheckBoxMenuItem)this.createMenuItem(jMenu, 0, "Save goal traffic data", 0);
            this.clear_goal = this.createMenuItem(jMenu, 1, "Clear goal traffic data", 0);
            this.save_goal.setState(StatisticsTool.this.msgQueue.isUpdatingGoalTraffic());
            return jMenu;
        }

        private JMenu doMenu() {
            JMenu jMenu = new JMenu("Statistics");
            ButtonGroup buttonGroup = new ButtonGroup();
            jMenu.setMnemonic('S');
            this.statsRadioBox = new JRadioButtonMenuItem[STATS_MENU_ITEMS.length];
            int n = 0;
            while (n < STATS_MENU_ITEMS.length) {
                this.statsRadioBox[n] = new JRadioButtonMenuItem(STATS_MENU_ITEMS[n]);
                this.statsRadioBox[n].addActionListener(this);
                if (n >= 6) {
                    this.statsRadioBox[n].setEnabled(false);
                }
                jMenu.add(this.statsRadioBox[n]);
                buttonGroup.add(this.statsRadioBox[n]);
                ++n;
            }
            return jMenu;
        }

        private JMenu viewMenu() {
            JMenu jMenu = new JMenu("View");
            jMenu.setMnemonic('V');
            this.redraw = this.createMenuItem(jMenu, 1, "Redraw current", 82);
            this.pie = this.createMenuItem(jMenu, 1, "Pie chart", 80);
            this.line = this.createMenuItem(jMenu, 1, "Line graph", 0);
            this.xy = this.createMenuItem(jMenu, 1, "XY graph", 88);
            this.table = this.createMenuItem(jMenu, 1, "Table", 84);
            this.bar = this.createMenuItem(jMenu, 1, "Bar chart", 66);
            return jMenu;
        }

        private JMenu helpMenu() {
            JMenu jMenu = new JMenu("Help");
            jMenu.setMnemonic('H');
            this.help = this.createMenuItem(jMenu, 1, "Using the statistics tool", 85);
            this.about = this.createMenuItem(jMenu, 1, "About ZEUS...", 65);
            return jMenu;
        }

        private JMenuItem createMenuItem(JMenu jMenu, int n, String string, int n2) {
            JMenuItem jMenuItem;
            switch (n) {
                case 0: {
                    jMenuItem = new JCheckBoxMenuItem(string);
                    ((JCheckBoxMenuItem)jMenuItem).setState(false);
                    jMenuItem.addItemListener(this);
                    break;
                }
                case 2: {
                    jMenuItem = new JRadioButtonMenuItem(string, false);
                    jMenuItem.addActionListener(this);
                }
                default: {
                    jMenuItem = new JMenuItem(string);
                    jMenuItem.addActionListener(this);
                }
            }
            if (n2 > 0) {
                jMenuItem.setMnemonic(n2);
            }
            jMenu.add(jMenuItem);
            return jMenuItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.connect) {
                StatisticsTool.this.Connect(true);
            }
            if (object == this.disconnect) {
                StatisticsTool.this.Connect(false);
            } else if (object == this.exit) {
                StatisticsTool.this.Exit();
            } else if (object == this.cc) {
                StatisticsTool.this.StreamMessages(true);
            } else if (object == this.un_cc) {
                StatisticsTool.this.StreamMessages(false);
            } else if (object == this.sessions) {
                StatisticsTool.this.Sessions();
            } else if (object == this.delete) {
                StatisticsTool.this.Delete();
            } else if (object == this.purge) {
                StatisticsTool.this.Purge();
            } else if (object == this.load) {
                StatisticsTool.this.Load();
            } else if (object == this.save) {
                StatisticsTool.this.Record();
            } else if (object == this.close) {
                StatisticsTool.this.Close();
            } else if (object == this.forward) {
                StatisticsTool.this.Forward();
            } else if (object == this.rewind) {
                StatisticsTool.this.Rewind();
            } else if (object == this.fforward) {
                StatisticsTool.this.FForward();
            } else if (object == this.frewind) {
                StatisticsTool.this.FRewind();
            } else if (object == this.stop) {
                StatisticsTool.this.Stop();
            } else if (object == this.forward_step) {
                StatisticsTool.this.StepForward();
            } else if (object == this.forward_last) {
                StatisticsTool.this.ForwardEnd();
            } else if (object == this.rewind_step) {
                StatisticsTool.this.StepRewind();
            } else if (object == this.rewind_first) {
                StatisticsTool.this.RewindBegin();
            } else if (object == this.clear_goal) {
                StatisticsTool.this.ClearGoalTraffic();
            } else if (object == this.filter) {
                StatisticsTool.this.Filter();
            } else if (object == this.player_speed) {
                StatisticsTool.this.PlayerSpeed();
            } else if (object == this.animation_speed) {
                StatisticsTool.this.AnimationSpeed();
            } else if (object == this.redraw) {
                StatisticsTool.this.RedrawGraph();
            } else if (object == this.xy) {
                StatisticsTool.this.DrawXYGraph();
            } else if (object == this.table) {
                StatisticsTool.this.DrawTabularGraph();
            } else if (object == this.line) {
                StatisticsTool.this.DrawLineGraph();
            } else if (object == this.pie) {
                StatisticsTool.this.DrawPieGraph();
            } else if (object == this.bar) {
                StatisticsTool.this.DrawBarGraph();
            } else if (object == this.help) {
                StatisticsTool.this.Help();
            } else if (object == this.about) {
                StatisticsTool.this.About();
            } else {
                int n = 0;
                while (n < STATS_MENU_ITEMS.length) {
                    if (this.statsRadioBox[n] == object) {
                        StatisticsTool.this.setStatisticsType((int)(Math.pow(2.0, n) + 0.51));
                    }
                    ++n;
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == this.save_goal) {
                boolean bl = this.save_goal.getState();
                StatisticsTool.this.SaveGoalTraffic(bl);
                return;
            }
        }

        public void setStatisticsType(int n) {
            if (n == 0) {
                int n2 = 0;
                while (n2 < STATS_MENU_ITEMS.length) {
                    this.statsRadioBox[n2].setSelected(false);
                    ++n2;
                }
                return;
            }
            int n3 = (int)(Math.log(n) / Math.log(2.0) + 0.51);
            this.statsRadioBox[n3].setSelected(true);
        }

        public void update(int n) {
            boolean bl = n == 0;
            this.cc.setEnabled(!bl);
            this.forward.setEnabled(bl);
            this.rewind.setEnabled(bl);
            this.fforward.setEnabled(bl);
            this.frewind.setEnabled(bl);
            this.stop.setEnabled(bl);
            this.forward_step.setEnabled(bl);
            this.rewind_step.setEnabled(bl);
            this.forward_last.setEnabled(bl);
            this.rewind_first.setEnabled(bl);
        }
    }
}

