/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.society;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import zeus.concepts.Relationship;
import zeus.generator.agent.AcquaintanceModel;
import zeus.gui.ColorManager;
import zeus.gui.graph.AbstractGraphModel;
import zeus.gui.graph.GraphNode;
import zeus.util.Misc;
import zeus.util.SystemProps;
import zeus.visualiser.society.SocietyModelEntry;

public class SocietyModel
extends AbstractGraphModel {
    static final int SUPERIORS = 0;
    static final int SUBORDINATES = 1;
    static final int PEERS = 2;
    static final int COWORKERS = 3;
    protected boolean isNodeEditable = true;
    protected Hashtable nodeTable = new Hashtable();
    protected Properties imageTable = new Properties();
    protected EventListenerList listeners = new EventListenerList();
    protected int view = 0;
    protected BitSet links = new BitSet(AcquaintanceModel.RELATIONS_LIST.size());
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public SocietyModel() {
        try {
            this.imageTable.load(new FileInputStream(SystemProps.getProperty("application.gif")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reset();
    }

    public void reset() {
        this.nodeTable.clear();
        int n = 0;
        while (n < this.links.size()) {
            this.links.set(n);
            ++n;
        }
        this.fireGraphStructureChanged();
    }

    public Enumeration nodes() {
        return this.nodeTable.elements();
    }

    public void setValue(GraphNode graphNode, Object object) {
        SocietyModelEntry societyModelEntry = (SocietyModelEntry)graphNode.getUserObject();
        if (object == null) {
            societyModelEntry.icon = null;
        } else {
            societyModelEntry.setIcon((String)object);
        }
        this.fireGraphNodeStateChanged(graphNode);
        this.fireChanged();
    }

    public boolean isNodeEditable(GraphNode graphNode) {
        return this.isNodeEditable;
    }

    public Color getLinkColor(GraphNode graphNode, GraphNode graphNode2) {
        int n = this.getLinkType(graphNode, graphNode2);
        if (n != -1) {
            return this.getColor(n);
        }
        return Color.black;
    }

    public boolean isLinkVisible(GraphNode graphNode, GraphNode graphNode2) {
        int n = this.getLinkType(graphNode, graphNode2);
        if (n != -1) {
            return this.links.get(n);
        }
        return false;
    }

    public Vector getViewRelations(GraphNode graphNode) {
        Vector<Object> vector = new Vector<Object>();
        SocietyModelEntry societyModelEntry = (SocietyModelEntry)graphNode.getUserObject();
        String string = societyModelEntry.getName();
        Relationship[] relationshipArray = societyModelEntry.getRelations();
        int n = 0;
        while (n < relationshipArray.length) {
            if (Misc.whichPosition(relationshipArray[n].getRelation(), AcquaintanceModel.RELATIONS_LIST) == this.view) {
                vector.addElement(this.nodeTable.get(relationshipArray[n].getName()));
            }
            ++n;
        }
        Enumeration enumeration = this.nodeTable.elements();
        while (enumeration.hasMoreElements()) {
            GraphNode graphNode2 = (GraphNode)enumeration.nextElement();
            if (graphNode2 == graphNode || vector.contains(graphNode2)) continue;
            societyModelEntry = (SocietyModelEntry)graphNode2.getUserObject();
            relationshipArray = societyModelEntry.getRelations();
            int n2 = 0;
            while (n2 < relationshipArray.length) {
                if (relationshipArray[n2].getName().equals(string) && Misc.whichPosition(relationshipArray[n2].getRelation(), AcquaintanceModel.RELATIONS_LIST) == this.view) {
                    vector.addElement(graphNode2);
                }
                ++n2;
            }
        }
        return vector;
    }

    protected int getLinkType(GraphNode graphNode, GraphNode graphNode2) {
        SocietyModelEntry societyModelEntry = (SocietyModelEntry)graphNode.getUserObject();
        SocietyModelEntry societyModelEntry2 = (SocietyModelEntry)graphNode2.getUserObject();
        String string = societyModelEntry2.getName();
        Relationship[] relationshipArray = societyModelEntry.getRelations();
        int n = 0;
        while (n < relationshipArray.length) {
            if (relationshipArray[n].getName().equals(string)) {
                return Misc.whichPosition(relationshipArray[n].getRelation(), AcquaintanceModel.RELATIONS_LIST);
            }
            ++n;
        }
        return -1;
    }

    public Color getColor(int n) {
        return ColorManager.getColor(n);
    }

    public boolean isLinkVisible(int n) {
        return this.links.get(n);
    }

    public void setView(int n) {
        this.view = n;
    }

    public int getView() {
        return this.view;
    }

    public void showLinks(int n, boolean bl) {
        if (bl) {
            this.links.set(n);
        } else {
            this.links.clear(n);
        }
    }

    public void removeNodes(GraphNode[] graphNodeArray) {
        int n = 0;
        while (n < graphNodeArray.length) {
            SocietyModelEntry societyModelEntry = (SocietyModelEntry)graphNodeArray[n].getUserObject();
            String string = societyModelEntry.getName();
            this.nodeTable.remove(string);
            this.fireGraphNodeRemoved(graphNodeArray[n]);
            ++n;
        }
        this.fireChanged();
    }

    public GraphNode getNode(String string) {
        GraphNode graphNode = (GraphNode)this.nodeTable.get(string);
        if (graphNode == null) {
            graphNode = (GraphNode)this.nodeTable.get(string.toLowerCase());
        }
        if (graphNode == null) {
            graphNode = (GraphNode)this.nodeTable.get(string.toUpperCase());
        }
        return graphNode;
    }

    public GraphNode addAgent(String string, String string2) {
        GraphNode graphNode;
        String string3 = this.imageTable.getProperty(string);
        if (string3 == null) {
            string3 = SystemProps.getProperty("gif.dir");
            string3 = string3 + File.separator + "visualiser" + File.separator + string2.toLowerCase() + ".gif";
        } else {
            char c = File.separatorChar;
            char c2 = SystemProps.getProperty("file.separator").charAt(0);
            string3 = string3.replace(c2, c);
        }
        if (this.nodeTable.containsKey(string)) {
            graphNode = (GraphNode)this.nodeTable.get(string);
            SocietyModelEntry societyModelEntry = (SocietyModelEntry)graphNode.getUserObject();
            if (societyModelEntry.getIcon().equals(string3)) {
                societyModelEntry.setIcon(string3);
                this.fireGraphNodeStateChanged(graphNode);
            }
        } else {
            SocietyModelEntry societyModelEntry = new SocietyModelEntry(string, string3);
            graphNode = new GraphNode(societyModelEntry);
            this.nodeTable.put(string.toLowerCase(), graphNode);
            this.fireGraphNodeAdded(graphNode);
        }
        return graphNode;
    }

    public void addAgents(Vector vector) {
        String string = SystemProps.getProperty("agent.names.agent");
        int n = 0;
        while (n < vector.size()) {
            this.addAgent((String)vector.elementAt(n), string);
            ++n;
        }
    }

    public GraphNode addAgent(String string) {
        String string2 = SystemProps.getProperty("agent.names.agent");
        return this.addAgent(string, string2);
    }

    public void addRelations(String string, Vector vector) {
        GraphNode graphNode = (GraphNode)this.nodeTable.get(string);
        if (graphNode == null) {
            graphNode = this.addAgent(string);
        }
        SocietyModelEntry societyModelEntry = (SocietyModelEntry)graphNode.getUserObject();
        societyModelEntry.addRelations(vector);
        int n = 0;
        while (n < vector.size()) {
            Relationship relationship = (Relationship)vector.elementAt(n);
            GraphNode graphNode2 = (GraphNode)this.nodeTable.get(relationship.getName());
            if (graphNode2 != null) {
                int n2 = Misc.whichPosition(relationship.getRelation(), AcquaintanceModel.RELATIONS_LIST);
                switch (n2) {
                    case 0: {
                        graphNode2.addChild(graphNode);
                        graphNode.addParent(graphNode2);
                        this.fireGraphNodeStateChanged(graphNode2);
                        break;
                    }
                    case 1: {
                        graphNode.addChild(graphNode2);
                        graphNode2.addParent(graphNode);
                        this.fireGraphNodeStateChanged(graphNode2);
                        break;
                    }
                    default: {
                        graphNode.addSibling(graphNode2);
                        graphNode2.addSibling(graphNode);
                        this.fireGraphNodeStateChanged(graphNode2);
                    }
                }
            }
            ++n;
        }
        this.fireGraphNodeStateChanged(graphNode);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = SocietyModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = SocietyModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? SocietyModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                changeListener.stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

