/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.report;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import zeus.actors.AgentContext;
import zeus.actors.PlanRecord;
import zeus.concepts.Fact;
import zeus.concepts.Performative;
import zeus.concepts.ReportRec;
import zeus.concepts.ZeusParser;
import zeus.gui.EditableMultipleSelectionDialog;
import zeus.gui.graph.Graph;
import zeus.gui.help.HelpWindow;
import zeus.util.Core;
import zeus.util.Misc;
import zeus.util.SystemProps;
import zeus.visualiser.VisualiserModel;
import zeus.visualiser.basic.VideoTool;
import zeus.visualiser.report.DeleteReportDialog;
import zeus.visualiser.report.ReportGraph;
import zeus.visualiser.report.ReportModel;

public class ReportTool
extends VideoTool
implements ListSelectionListener {
    private static int count = 0;
    protected ReportMenuBar menubar;
    protected EditableMultipleSelectionDialog report_dialog = null;
    protected DeleteReportDialog del_report = null;
    protected Graph graph = null;
    protected JList agentList;
    protected JList taskList;
    protected ReportModel onlineModel;
    protected ReportModel offlineModel;

    public ReportTool(AgentContext agentContext, VisualiserModel visualiserModel) {
        super(agentContext, visualiserModel);
        this.setTitle(agentContext.whoami() + " - Reports Tool:" + count++);
        ImageIcon imageIcon = new ImageIcon(SystemProps.getProperty("gif.dir") + File.separator + "visualiser" + File.separator + "report-icon.gif");
        this.setIconImage(imageIcon.getImage());
        this.setBackground(Color.lightGray);
        this.onlineModel = new ReportModel();
        this.offlineModel = new ReportModel();
        ReportGraph reportGraph = new ReportGraph(this.onlineModel);
        this.graph = reportGraph.getGraph();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.videoToolbar, "North");
        this.getContentPane().add((Component)reportGraph, "Center");
        this.agentList = new JList(this.onlineModel.getAgentListModel());
        this.taskList = new JList(this.onlineModel.getTaskListModel());
        this.agentList.setSelectionMode(0);
        this.taskList.setSelectionMode(0);
        this.agentList.addListSelectionListener(this);
        this.taskList.addListSelectionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createBevelBorder(1));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        JScrollPane jScrollPane = new JScrollPane(this.agentList);
        jScrollPane.setPreferredSize(new Dimension(80, 180));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Agents");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder.setTitleColor(Color.blue);
        jScrollPane.setBorder(titledBorder);
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        jScrollPane = new JScrollPane(this.taskList);
        jScrollPane.setPreferredSize(new Dimension(80, 180));
        titledBorder = BorderFactory.createTitledBorder("Current Tasks");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder.setTitleColor(Color.blue);
        jScrollPane.setBorder(titledBorder);
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel();
        titledBorder = BorderFactory.createTitledBorder("Task Codes");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder.setTitleColor(Color.blue);
        jPanel2.setBorder(titledBorder);
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel2.setBackground(Color.lightGray);
        jPanel2.setLayout(gridBagLayout);
        int n = 3;
        while (n < PlanRecord.state_string.length) {
            JLabel jLabel = new JLabel(PlanRecord.state_string[n], 2);
            gridBagConstraints.insets = new Insets(4, 4, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            JPanel jPanel3 = new JPanel();
            jPanel3.setSize(10, 10);
            jPanel3.setBackground(PlanRecord.color[n]);
            gridBagConstraints.insets = new Insets(4, 4, 0, 4);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel2.add(jPanel3);
            ++n;
        }
        this.getContentPane().add((Component)jPanel, "West");
        this.menubar = new ReportMenuBar();
        this.setJMenuBar(this.menubar);
        this.pack();
        this.setVisible(true);
        this.setMode(1);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        String string = (String)jList.getSelectedValue();
        if (string == null) {
            return;
        }
        if (jList == this.agentList) {
            ((ReportModel)this.graph.getModel()).showAgent(string);
        } else if (jList == this.taskList) {
            ((ReportModel)this.graph.getModel()).showTask(string);
        }
    }

    public void StreamReports(boolean bl) {
        Object[] objectArray;
        if (!this.hubOK()) {
            return;
        }
        if (!this.stopPlayback()) {
            return;
        }
        String string = SystemProps.getProperty("agent.names.agent");
        Object[] objectArray2 = this.model.getAgents(string);
        if (this.report_dialog == null) {
            this.report_dialog = new EditableMultipleSelectionDialog((Frame)this, "Select Agents", objectArray2);
            this.report_dialog.setLocationRelativeTo(this);
        } else {
            objectArray = this.report_dialog.getPriorSelection();
            this.report_dialog.setListData(objectArray2);
            this.report_dialog.setSelection(objectArray);
        }
        objectArray = this.report_dialog.getSelection();
        this.model.addAgents(Misc.stringArray(this.report_dialog.getListData()));
        objectArray2 = Misc.stringArray(objectArray);
        this.subscribe(bl, this.model.keys[2], (String[])objectArray2, "log_report");
        if (bl) {
            this.onlineModel.addAgents((String[])objectArray2);
        } else {
            this.onlineModel.removeAgents((String[])objectArray2);
        }
    }

    public void registerAgent(String string, String string2) {
    }

    public void log_report(Performative performative) {
        try {
            ReportRec reportRec = ZeusParser.reportRec(this.context.OntologyDb(), performative.getContent());
            Core.DEBUG(2, "log_report\n" + reportRec);
            if (this.filterMsg(performative)) {
                Fact[] factArray = null;
                reportRec.setPreconditions(factArray);
                reportRec.setPostconditions(factArray);
                this.onlineModel.addReport(reportRec);
            }
            this.record_item(performative);
        }
        catch (Exception exception) {}
    }

    public void Help() {
        Point point = this.getLocation();
        HelpWindow helpWindow = new HelpWindow(this, point, "visualiser", "Report Tool");
        helpWindow.setSize(new Dimension(this.getWidth(), 440));
        helpWindow.setLocation(point.x + 24, point.y + 24);
        helpWindow.validate();
    }

    public void DeleteReport() {
        String string = (String)this.taskList.getSelectedValue();
        String string2 = (String)this.agentList.getSelectedValue();
        if (string == null) {
            JOptionPane.showMessageDialog(this, "Select a task from the task list before calling this function", "Error", 0);
        } else {
            ((ReportModel)this.graph.getModel()).removeTask(string2, string);
        }
    }

    public void DeleteReports() {
        if (this.del_report == null) {
            this.del_report = new DeleteReportDialog(this, "Delete Reports");
            this.del_report.setLocationRelativeTo(this);
        }
        if (this.del_report.isShowing()) {
            this.del_report.toFront();
        } else {
            this.del_report.display((ReportModel)this.graph.getModel());
        }
    }

    public void setAutoDeleteReport(boolean bl) {
        this.onlineModel.setAutoDelete(bl);
        this.offlineModel.setAutoDelete(bl);
    }

    public void setShowJointGraphs(boolean bl) {
        this.onlineModel.setShowJointGraphs(bl);
        this.offlineModel.setShowJointGraphs(bl);
    }

    protected void setMode(int n) {
        this.agentList.clearSelection();
        this.taskList.clearSelection();
        if (n == 1) {
            this.menubar.update(1);
            this.videoToolbar.setStatus(false);
            this.graph.setModel(this.onlineModel);
            this.agentList.setModel(this.onlineModel.getAgentListModel());
            this.taskList.setModel(this.onlineModel.getTaskListModel());
            String string = this.onlineModel.getCurrentAgent();
            String string2 = this.onlineModel.getCurrentTask();
            if (string != null) {
                this.agentList.setSelectedValue(string, true);
            }
            if (string2 != null) {
                this.taskList.setSelectedValue(string2, true);
            }
        } else {
            this.menubar.update(0);
            this.videoToolbar.setStatus(true);
            this.offlineModel.reset();
            this.graph.setModel(this.offlineModel);
            this.agentList.setModel(this.offlineModel.getAgentListModel());
            this.taskList.setModel(this.offlineModel.getTaskListModel());
            String string = this.onlineModel.getCurrentAgent();
            String string3 = this.onlineModel.getCurrentTask();
            if (string != null) {
                this.agentList.setSelectedValue(string, true);
            }
            if (string3 != null) {
                this.taskList.setSelectedValue(string3, true);
            }
        }
    }

    protected void registerListOfPlaybackAgents(Vector vector) {
        this.offlineModel.addAgents(vector);
    }

    protected void visualiseVideoData(int n, Performative performative) {
        if (this.state.mode == 0) {
            ReportRec reportRec = ZeusParser.reportRec(this.context.OntologyDb(), performative.getContent());
            Fact[] factArray = new Fact[]{};
            reportRec.setPreconditions(factArray);
            reportRec.setPostconditions(factArray);
            this.offlineModel.addReport(reportRec);
        }
    }

    protected class ReportMenuBar
    extends JMenuBar
    implements ActionListener,
    ItemListener {
        protected JMenu fileMenu = new JMenu("File");
        protected JMenu requestMenu;
        protected JMenu helpMenu;
        protected JMenu viewMenu;
        protected JMenu playMenu;
        protected JMenu optionsMenu;
        protected JMenuItem connect;
        protected JMenuItem disconnect;
        protected JMenuItem exit;
        protected JMenuItem cc;
        protected JMenuItem un_cc;
        protected JMenuItem delete_one;
        protected JMenuItem delete_all;
        protected JMenuItem help;
        protected JMenuItem about;
        protected JMenuItem filter;
        protected JMenuItem player_speed;
        protected JMenuItem collapse;
        protected JMenuItem expand;
        protected JMenuItem recompute;
        protected JMenuItem redraw;
        protected JMenuItem select;
        protected JMenuItem selectAll;
        protected JMenuItem hide;
        protected JMenuItem show;
        protected JMenuItem sessions;
        protected JMenuItem load;
        protected JMenuItem save;
        protected JMenuItem close;
        protected JMenuItem forward;
        protected JMenuItem rewind;
        protected JMenuItem fforward;
        protected JMenuItem frewind;
        protected JMenuItem stop;
        protected JMenuItem forward_step;
        protected JMenuItem rewind_step;
        protected JMenuItem forward_last;
        protected JMenuItem rewind_first;
        protected JMenuItem delete;
        protected JMenuItem purge;
        protected JCheckBoxMenuItem auto_delete;
        protected JCheckBoxMenuItem joint_graph;
        protected static final int CHECK = 0;
        protected static final int PLAIN = 1;
        protected static final int RADIO = 2;

        public ReportMenuBar() {
            this.fileMenu.setMnemonic('F');
            this.connect = this.createMenuItem(this.fileMenu, 1, "Connect to namservers", 67);
            this.disconnect = this.createMenuItem(this.fileMenu, 1, "Disconnect from nameservers", 68);
            this.exit = this.createMenuItem(this.fileMenu, 1, "Quit", 81);
            this.add(this.fileMenu);
            this.requestMenu = new JMenu("Reports");
            this.requestMenu.setMnemonic('R');
            this.cc = this.createMenuItem(this.requestMenu, 1, "Request reports", 0);
            this.un_cc = this.createMenuItem(this.requestMenu, 1, "Unrequest reports", 0);
            this.delete_one = this.createMenuItem(this.requestMenu, 1, "Delete current report", 0);
            this.delete_all = this.createMenuItem(this.requestMenu, 1, "Delete reports...", 0);
            this.auto_delete = (JCheckBoxMenuItem)this.createMenuItem(this.requestMenu, 0, "Auto-delete reports", 0);
            this.joint_graph = (JCheckBoxMenuItem)this.createMenuItem(this.requestMenu, 0, "Show connected reports", 0);
            this.auto_delete.setState(ReportTool.this.onlineModel.getAutoDelete());
            this.joint_graph.setState(ReportTool.this.onlineModel.getShowJointGraphs());
            this.add(this.requestMenu);
            JMenu jMenu = new JMenu("Playback");
            jMenu.setMnemonic('P');
            this.sessions = this.createMenuItem(jMenu, 1, "Request saved sessions", 0);
            this.delete = this.createMenuItem(jMenu, 1, "Delete session", 0);
            this.purge = this.createMenuItem(jMenu, 1, "Purge database", 0);
            jMenu.addSeparator();
            this.load = this.createMenuItem(jMenu, 1, "Load session", 0);
            this.save = this.createMenuItem(jMenu, 1, "Record session", 0);
            this.close = this.createMenuItem(jMenu, 1, "Close session", 0);
            jMenu.addSeparator();
            this.forward = this.createMenuItem(jMenu, 1, "Forward", 0);
            this.rewind = this.createMenuItem(jMenu, 1, "Rewind", 0);
            this.fforward = this.createMenuItem(jMenu, 1, "Fast forward", 0);
            this.frewind = this.createMenuItem(jMenu, 1, "Fast rewind", 0);
            this.forward_step = this.createMenuItem(jMenu, 1, "Step forward", 0);
            this.rewind_step = this.createMenuItem(jMenu, 1, "Step backward", 0);
            this.forward_last = this.createMenuItem(jMenu, 1, "Forward to end", 0);
            this.rewind_first = this.createMenuItem(jMenu, 1, "Rewind to beginning", 0);
            this.stop = this.createMenuItem(jMenu, 1, "Stop", 0);
            this.add(jMenu);
            this.optionsMenu = new JMenu("Options");
            this.optionsMenu.setMnemonic('O');
            this.filter = this.createMenuItem(this.optionsMenu, 1, "Filter messages...", 0);
            this.player_speed = this.createMenuItem(this.optionsMenu, 1, "Player speed...", 0);
            this.add(this.optionsMenu);
            this.viewMenu = new JMenu("View");
            this.viewMenu.setMnemonic('V');
            this.collapse = this.createMenuItem(this.viewMenu, 1, "Collapse", 0);
            this.expand = this.createMenuItem(this.viewMenu, 1, "Expand", 0);
            this.recompute = this.createMenuItem(this.viewMenu, 1, "Recompute", 0);
            this.redraw = this.createMenuItem(this.viewMenu, 1, "Redraw", 0);
            this.viewMenu.addSeparator();
            this.select = this.createMenuItem(this.viewMenu, 1, "Select", 0);
            this.selectAll = this.createMenuItem(this.viewMenu, 1, "Select all", 0);
            this.viewMenu.addSeparator();
            this.hide = this.createMenuItem(this.viewMenu, 1, "Hide", 0);
            this.show = this.createMenuItem(this.viewMenu, 1, "Show", 0);
            this.helpMenu = new JMenu("Help");
            this.helpMenu.setMnemonic('H');
            this.help = this.createMenuItem(this.helpMenu, 1, "Using the control tool", 85);
            this.about = this.createMenuItem(this.helpMenu, 1, "About ZEUS", 65);
            this.add(this.helpMenu);
        }

        private JMenuItem createMenuItem(JMenu jMenu, int n, String string, int n2) {
            JMenuItem jMenuItem;
            switch (n) {
                case 0: {
                    jMenuItem = new JCheckBoxMenuItem(string);
                    ((JCheckBoxMenuItem)jMenuItem).setState(false);
                    jMenuItem.addItemListener(this);
                    break;
                }
                case 2: {
                    jMenuItem = new JRadioButtonMenuItem(string);
                    jMenuItem.addActionListener(this);
                }
                default: {
                    jMenuItem = new JMenuItem(string);
                    jMenuItem.addActionListener(this);
                }
            }
            if (n2 > 0) {
                jMenuItem.setMnemonic(n2);
            }
            jMenu.add(jMenuItem);
            return jMenuItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.connect) {
                ReportTool.this.Connect(true);
            } else if (object == this.disconnect) {
                ReportTool.this.Connect(false);
            } else if (object == this.exit) {
                ReportTool.this.Exit();
            } else if (object == this.cc) {
                ReportTool.this.StreamReports(true);
            } else if (object == this.un_cc) {
                ReportTool.this.StreamReports(false);
            } else if (object == this.delete_one) {
                ReportTool.this.DeleteReport();
            } else if (object == this.delete_all) {
                ReportTool.this.DeleteReports();
            } else if (object == this.sessions) {
                ReportTool.this.Sessions();
            } else if (object == this.delete) {
                ReportTool.this.Delete();
            } else if (object == this.purge) {
                ReportTool.this.Purge();
            } else if (object == this.load) {
                ReportTool.this.Load();
            } else if (object == this.save) {
                ReportTool.this.Record();
            } else if (object == this.close) {
                ReportTool.this.Close();
            } else if (object == this.forward) {
                ReportTool.this.Forward();
            } else if (object == this.rewind) {
                ReportTool.this.Rewind();
            } else if (object == this.fforward) {
                ReportTool.this.FForward();
            } else if (object == this.frewind) {
                ReportTool.this.FRewind();
            } else if (object == this.stop) {
                ReportTool.this.Stop();
            } else if (object == this.forward_step) {
                ReportTool.this.StepForward();
            } else if (object == this.forward_last) {
                ReportTool.this.ForwardEnd();
            } else if (object == this.rewind_step) {
                ReportTool.this.StepRewind();
            } else if (object == this.rewind_first) {
                ReportTool.this.RewindBegin();
            } else if (object == this.player_speed) {
                ReportTool.this.PlayerSpeed();
            } else if (object == this.filter) {
                ReportTool.this.Filter();
            } else if (object == this.collapse) {
                ReportTool.this.graph.collapse();
            } else if (object == this.expand) {
                ReportTool.this.graph.expand();
            } else if (object == this.recompute) {
                ReportTool.this.graph.recompute();
            } else if (object == this.redraw) {
                ReportTool.this.graph.redraw();
            } else if (object == this.select) {
                ReportTool.this.graph.select();
            } else if (object == this.selectAll) {
                ReportTool.this.graph.selectAll();
            } else if (object == this.hide) {
                ReportTool.this.graph.hide();
            } else if (object == this.show) {
                ReportTool.this.graph.show();
            } else if (object == this.help) {
                ReportTool.this.Help();
            } else if (object == this.about) {
                ReportTool.this.About();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == this.auto_delete) {
                ReportTool.this.setAutoDeleteReport(this.auto_delete.getState());
            } else if (object == this.joint_graph) {
                ReportTool.this.setShowJointGraphs(this.joint_graph.getState());
            }
        }

        public void update(int n) {
            boolean bl = n == 0;
            this.cc.setEnabled(!bl);
            this.forward.setEnabled(bl);
            this.rewind.setEnabled(bl);
            this.fforward.setEnabled(bl);
            this.frewind.setEnabled(bl);
            this.stop.setEnabled(bl);
            this.forward_step.setEnabled(bl);
            this.rewind_step.setEnabled(bl);
            this.forward_last.setEnabled(bl);
            this.rewind_first.setEnabled(bl);
        }
    }
}

