/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.report;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import zeus.concepts.ReportRec;
import zeus.gui.graph.AbstractGraphModel;
import zeus.gui.graph.GraphNode;
import zeus.util.Core;
import zeus.util.HSet;

public class ReportModel
extends AbstractGraphModel {
    protected boolean isNodeEditable = true;
    protected boolean auto_delete = false;
    protected boolean show_joint_graphs = false;
    protected Hashtable nodeTable = new Hashtable();
    protected Hashtable agentTable = new Hashtable();
    protected Hashtable taskTable = new Hashtable();
    protected DefaultListModel taskListModel = new DefaultListModel();
    protected DefaultListModel agentListModel = new DefaultListModel();
    protected EventListenerList listeners = new EventListenerList();
    protected String isShowingAgent = null;
    protected String isShowingTask = null;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public ReportModel() {
        this.reset();
    }

    public void reset() {
        this.agentTable.clear();
        this.taskTable.clear();
        this.nodeTable.clear();
        this.isShowingAgent = null;
        this.isShowingTask = null;
        this.fireChanged();
        this.fireGraphStructureChanged();
    }

    DefaultListModel getAgentListModel() {
        return this.agentListModel;
    }

    DefaultListModel getTaskListModel() {
        return this.taskListModel;
    }

    String getCurrentAgent() {
        return this.isShowingAgent;
    }

    String getCurrentTask() {
        return this.isShowingTask;
    }

    public Enumeration nodes() {
        return this.nodeTable.elements();
    }

    public void setValue(GraphNode graphNode, Object object) {
        Core.ERROR(null, 1, (Object)this);
    }

    public boolean isNodeEditable(GraphNode graphNode) {
        return this.isNodeEditable;
    }

    public boolean isLinkVisible(GraphNode graphNode, GraphNode graphNode2) {
        ReportRec reportRec = (ReportRec)graphNode.getUserObject();
        ReportRec reportRec2 = (ReportRec)graphNode2.getUserObject();
        return reportRec.hasParent(reportRec2.getName());
    }

    public void setShowJointGraphs(boolean bl) {
        this.show_joint_graphs = bl;
    }

    public void setAutoDelete(boolean bl) {
        this.auto_delete = bl;
    }

    public boolean getAutoDelete() {
        return this.auto_delete;
    }

    public boolean getShowJointGraphs() {
        return this.show_joint_graphs;
    }

    public synchronized GraphNode getNode(String string) {
        return (GraphNode)this.nodeTable.get(string);
    }

    public synchronized void addAgent(String string) {
        if (this.agentTable.containsKey(string)) {
            return;
        }
        this.agentTable.put(string, new HSet());
        this.agentListModel.addElement(string);
        this.fireChanged();
    }

    public synchronized void removeAgent(String string) {
        HSet hSet = (HSet)this.agentTable.remove(string);
        this.agentListModel.removeElement(string);
        this.removeTasks(hSet);
        this.fireChanged();
    }

    public void addAgents(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.addAgent((String)vector.elementAt(n));
            ++n;
        }
    }

    public synchronized void addAgents(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.addAgent(stringArray[n]);
            ++n;
        }
    }

    public synchronized void removeAgents(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.removeAgent((String)vector.elementAt(n));
            ++n;
        }
    }

    public synchronized void removeAgents(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.removeAgent(stringArray[n]);
            ++n;
        }
    }

    public synchronized String[] getAgents() {
        String[] stringArray = new String[this.agentTable.size()];
        Enumeration enumeration = this.agentTable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public synchronized String[] getTasks(String string) {
        HSet hSet = (HSet)this.agentTable.get(string);
        String[] stringArray = new String[hSet.size()];
        Enumeration enumeration = hSet.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public synchronized void removeTasks(String string, String[] stringArray) {
        HSet hSet = (HSet)this.agentTable.get(string);
        int n = 0;
        while (n < stringArray.length) {
            hSet.remove(stringArray[n]);
            ++n;
        }
        this.removeTasks(stringArray);
        this.fireChanged();
    }

    public synchronized void removeTask(String string, String string2) {
        if (string == null) {
            string = this.isShowingAgent;
        }
        HSet hSet = (HSet)this.agentTable.get(string);
        hSet.remove(string2);
        this.removeTask(string2);
        this.fireChanged();
    }

    public synchronized void removeTasks(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.taskTable.remove(stringArray[n]);
            this.taskListModel.removeElement(stringArray[n]);
            if (this.nodeTable.containsKey(stringArray[n])) {
                this.nodeTable.clear();
                this.fireGraphStructureChanged();
            }
            ++n;
        }
    }

    public synchronized void removeTasks(HSet hSet) {
        Enumeration enumeration = hSet.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.taskTable.remove(string);
            this.taskListModel.removeElement(string);
            if (!this.nodeTable.containsKey(string)) continue;
            this.nodeTable.clear();
            this.fireGraphStructureChanged();
        }
    }

    public synchronized void removeTask(String string) {
        this.taskTable.remove(string);
        this.taskListModel.removeElement(string);
        if (this.nodeTable.containsKey(string)) {
            this.nodeTable.clear();
            this.fireGraphStructureChanged();
        }
    }

    public synchronized void addReport(ReportRec reportRec) {
        GraphNode graphNode;
        Object object;
        Core.DEBUG(3, "ReportModel adding report " + reportRec);
        String string = reportRec.getAgent();
        String string2 = reportRec.getRootId();
        if (reportRec.isRoot()) {
            object = (HSet)this.agentTable.get(string);
            if (object == null) {
                object = new HSet();
                this.agentTable.put(string, object);
            }
            ((HSet)object).add(reportRec.getName());
        }
        if ((object = (Hashtable)this.taskTable.get(string2)) == null) {
            object = new Hashtable<String, ReportRec>();
            this.taskTable.put(string2, object);
        }
        ((Hashtable)object).put(reportRec.getName(), reportRec);
        if (this.nodeTable.containsKey(string2)) {
            graphNode = (GraphNode)this.nodeTable.get(reportRec.getName());
            if (graphNode == null) {
                graphNode = new GraphNode(reportRec);
                this.nodeTable.put(reportRec.getName(), graphNode);
                this.doReportAdded((Hashtable)object, graphNode, reportRec, true);
                this.fireGraphNodeAdded(graphNode);
                this.fireGraphStructureChanged();
            } else {
                graphNode.setUserObject(reportRec);
                this.doReportAdded((Hashtable)object, graphNode, reportRec, true);
                this.fireGraphNodeStateChanged(graphNode);
            }
        }
        if (reportRec.isRoot()) {
            if (this.isShowingAgent == null) {
                this.showAgent(string);
            }
            if (string.equals(this.isShowingAgent)) {
                if (!this.taskListModel.contains(reportRec.getName())) {
                    this.taskListModel.addElement(reportRec.getName());
                }
                if (this.isShowingTask == null) {
                    this.showTask(reportRec.getName());
                } else if (this.auto_delete && !this.isShowingTask.equals(reportRec.getName())) {
                    graphNode = (GraphNode)this.nodeTable.get(this.isShowingTask);
                    ReportRec reportRec2 = (ReportRec)graphNode.getUserObject();
                    switch (reportRec2.getState()) {
                        case 5: 
                        case 6: 
                        case 8: {
                            this.removeTask(string, this.isShowingTask);
                            this.showTask(reportRec.getName());
                            break;
                        }
                    }
                }
            }
            this.fireChanged();
        }
    }

    public synchronized void showAgent(String string) {
        Core.DEBUG(3, "Show agent: " + string);
        String[] stringArray = this.getTasks(string);
        this.taskListModel.removeAllElements();
        this.nodeTable.clear();
        this.fireGraphStructureChanged();
        int n = 0;
        while (n < stringArray.length) {
            this.taskListModel.addElement(stringArray[n]);
            ++n;
        }
        this.isShowingAgent = string;
    }

    public synchronized void showTask(String string) {
        this.nodeTable.clear();
        Hashtable hashtable = (Hashtable)this.taskTable.get(string);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ReportRec reportRec = (ReportRec)enumeration.nextElement();
            GraphNode graphNode = (GraphNode)this.nodeTable.get(reportRec.getName());
            if (graphNode == null) {
                graphNode = new GraphNode(reportRec);
                this.nodeTable.put(reportRec.getName(), graphNode);
            }
            this.doReportAdded(hashtable, graphNode, reportRec, false);
        }
        this.isShowingTask = string;
        this.fireGraphStructureChanged();
    }

    protected void doReportAdded(Hashtable hashtable, GraphNode graphNode, ReportRec reportRec, boolean bl) {
        GraphNode graphNode2;
        ReportRec reportRec2;
        String[] stringArray = reportRec.getParents();
        int n = 0;
        while (n < stringArray.length) {
            reportRec2 = (ReportRec)hashtable.get(stringArray[n]);
            if (reportRec2 != null) {
                graphNode2 = (GraphNode)this.nodeTable.get(reportRec2.getName());
                if (graphNode2 == null) {
                    graphNode2 = new GraphNode(reportRec2);
                    this.nodeTable.put(reportRec2.getName(), graphNode2);
                }
                graphNode.addParent(graphNode2);
                graphNode2.addChild(graphNode);
                if (bl) {
                    this.fireGraphNodeStateChanged(graphNode2);
                }
            }
            ++n;
        }
        String[] stringArray2 = reportRec.getChildren();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            reportRec2 = (ReportRec)hashtable.get(stringArray2[n2]);
            if (reportRec2 != null) {
                graphNode2 = (GraphNode)this.nodeTable.get(reportRec2.getName());
                if (graphNode2 == null) {
                    graphNode2 = new GraphNode(reportRec2);
                    this.nodeTable.put(reportRec2.getName(), graphNode2);
                }
                graphNode.addChild(graphNode2);
                graphNode2.addParent(graphNode);
                if (bl) {
                    this.fireGraphNodeStateChanged(graphNode2);
                }
            }
            ++n2;
        }
        String[] stringArray3 = reportRec.getSiblings();
        int n3 = 0;
        while (n3 < stringArray3.length) {
            reportRec2 = (ReportRec)hashtable.get(stringArray3[n3]);
            if (reportRec2 != null) {
                graphNode2 = (GraphNode)this.nodeTable.get(reportRec2.getName());
                if (graphNode2 == null) {
                    graphNode2 = new GraphNode(reportRec2);
                    this.nodeTable.put(reportRec2.getName(), graphNode2);
                }
                graphNode.addSibling(graphNode2);
                graphNode2.addSibling(graphNode);
                if (bl) {
                    this.fireGraphNodeStateChanged(graphNode2);
                }
            }
            ++n3;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ReportModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ReportModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? ReportModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                changeListener.stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

