/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.report;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import zeus.util.Misc;
import zeus.visualiser.report.ReportModel;

public class DeleteReportDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
ChangeListener {
    protected DefaultListModel agentListModel;
    protected DefaultListModel taskListModel;
    protected JList agentList;
    protected JList taskList;
    protected JButton cancelButton;
    protected JButton delButton;
    protected JButton selectButton;
    protected JButton clearButton;
    protected JButton invertButton;
    protected ReportModel graphModel = null;

    public DeleteReportDialog(JFrame jFrame, String string) {
        super(jFrame, string, false);
        JLabel jLabel = new JLabel("Agents");
        JLabel jLabel2 = new JLabel("Tasks");
        JLabel jLabel3 = new JLabel("");
        this.agentListModel = new DefaultListModel();
        this.taskListModel = new DefaultListModel();
        this.agentList = new JList(this.agentListModel);
        this.taskList = new JList(this.taskListModel);
        this.cancelButton = new JButton("Cancel");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        container.add(jLabel2);
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        container.add(jLabel3);
        JScrollPane jScrollPane = new JScrollPane(this.agentList);
        jScrollPane.setPreferredSize(new Dimension(100, 150));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        container.add(jScrollPane);
        jScrollPane = new JScrollPane(this.taskList);
        jScrollPane.setPreferredSize(new Dimension(100, 150));
        gridBagConstraints.insets = new Insets(5, 10, 10, 0);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        container.add(jScrollPane);
        this.selectButton = new JButton("Select All");
        this.clearButton = new JButton("Clear All");
        this.invertButton = new JButton("Invert Selection");
        this.delButton = new JButton("Delete");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1, 2, 2));
        jPanel.add(this.selectButton);
        jPanel.add(this.clearButton);
        jPanel.add(this.invertButton);
        jPanel.add(this.delButton);
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        container.add(jSeparator);
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        container.add(this.cancelButton);
        this.delButton.addActionListener(this);
        this.selectButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.invertButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.agentList.addListSelectionListener(this);
        this.taskList.addListSelectionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DeleteReportDialog.this.cancelBtnFn();
            }
        });
        this.agentList.setSelectionMode(0);
        this.taskList.setSelectionMode(2);
        this.agentList.addListSelectionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.selectButton) {
            int n = this.taskListModel.getSize();
            this.taskList.setSelectionInterval(0, n - 1);
        } else if (object == this.clearButton) {
            this.taskList.clearSelection();
        } else if (object == this.invertButton) {
            int n = this.taskListModel.getSize();
            int[] nArray = this.taskList.getSelectedIndices();
            this.taskList.clearSelection();
            int n2 = 0;
            while (n2 < n) {
                boolean bl = false;
                int n3 = 0;
                while (!bl && n3 < nArray.length) {
                    bl = nArray[n3] == n2;
                    ++n3;
                }
                if (!bl) {
                    this.taskList.addSelectionInterval(n2, n2);
                }
                ++n2;
            }
        } else if (object == this.delButton) {
            this.deleteBtnFn();
        } else if (object == this.cancelButton) {
            this.cancelBtnFn();
        }
    }

    private boolean agentSelected() {
        ListSelectionModel listSelectionModel = this.agentList.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "Select an agent before calling this operation", "Error", 0);
            return false;
        }
        return true;
    }

    private boolean taskSelected() {
        ListSelectionModel listSelectionModel = this.taskList.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "Select one or more task entries before\ncalling this operation", "Error", 0);
            return false;
        }
        return true;
    }

    protected void cancelBtnFn() {
        this.setVisible(false);
        if (this.graphModel != null) {
            this.graphModel.removeChangeListener(this);
        }
    }

    protected void deleteBtnFn() {
        if (!this.agentSelected() || !this.taskSelected()) {
            return;
        }
        String string = (String)this.agentList.getSelectedValue();
        Object[] objectArray = this.taskList.getSelectedValues();
        if (this.graphModel != null) {
            this.graphModel.removeTasks(string, Misc.stringArray(objectArray));
        }
    }

    public void display(ReportModel reportModel) {
        this.graphModel = reportModel;
        this.reset();
        reportModel.addChangeListener(this);
        this.pack();
        this.setVisible(true);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        String string = (String)jList.getSelectedValue();
        if (jList == this.agentList && this.graphModel != null && string != null) {
            String[] stringArray = this.graphModel.getTasks(string);
            this.taskList.clearSelection();
            this.taskListModel.removeAllElements();
            int n = 0;
            while (n < stringArray.length) {
                this.taskListModel.addElement(stringArray[n]);
                ++n;
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.graphModel != null && changeEvent.getSource() == this.graphModel) {
            String string = (String)this.agentList.getSelectedValue();
            Object[] objectArray = this.taskList.getSelectedValues();
            this.agentList.clearSelection();
            this.agentListModel.removeAllElements();
            String[] stringArray = this.graphModel.getAgents();
            int n = 0;
            while (n < stringArray.length) {
                this.agentListModel.addElement(stringArray[n]);
                ++n;
            }
            if (string != null) {
                this.agentList.setSelectedValue(string, true);
            }
            int n2 = this.taskListModel.getSize();
            int n3 = 0;
            while (n3 < objectArray.length) {
                int n4 = 0;
                while (n4 < n2) {
                    if (objectArray[n3] == this.taskListModel.getElementAt(n4)) {
                        this.taskList.addSelectionInterval(n4, n4);
                    }
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public void reset() {
        this.agentList.clearSelection();
        this.taskList.clearSelection();
        this.agentListModel.removeAllElements();
        if (this.graphModel != null) {
            String[] stringArray = this.graphModel.getAgents();
            int n = 0;
            while (n < stringArray.length) {
                this.agentListModel.addElement(stringArray[n]);
                ++n;
            }
        }
    }
}

