/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import zeus.util.Assert;
import zeus.visualiser.control.ControlTool;

public class ControlMenuBar
extends JMenuBar
implements ActionListener {
    protected JMenu fileMenu;
    protected JMenu agentMenu;
    protected JMenu goalMenu;
    protected JMenu orgMenu;
    protected JMenu coordMenu;
    protected JMenu societyMenu;
    protected JMenu helpMenu;
    protected JMenuItem connect;
    protected JMenuItem disconnect;
    protected JMenuItem exit;
    protected JMenuItem load;
    protected JMenuItem browse_agent;
    protected JMenuItem tune_agent;
    protected JMenuItem command;
    protected JMenuItem cc_fact;
    protected JMenuItem uncc_fact;
    protected JMenuItem browse_fact;
    protected JMenuItem add_fact;
    protected JMenuItem cc_task;
    protected JMenuItem uncc_task;
    protected JMenuItem browse_task;
    protected JMenuItem add_task;
    protected JMenuItem cc_rel;
    protected JMenuItem uncc_rel;
    protected JMenuItem browse_rel;
    protected JMenuItem add_rel;
    protected JMenuItem cc_sgy;
    protected JMenuItem uncc_sgy;
    protected JMenuItem browse_sgy;
    protected JMenuItem add_sgy;
    protected JMenuItem browse_goal;
    protected JMenuItem add_goal;
    protected JMenuItem cc_goal;
    protected JMenuItem uncc_goal;
    protected JMenuItem help;
    protected JMenuItem about;
    protected ControlTool view;
    protected static final int CHECK = 0;
    protected static final int PLAIN = 1;
    protected static final int RADIO = 2;

    public ControlMenuBar(ControlTool controlTool) {
        Assert.notNull(controlTool);
        this.view = controlTool;
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        this.connect = this.createMenuItem(this.fileMenu, 1, "Connect to namservers", 67);
        this.disconnect = this.createMenuItem(this.fileMenu, 1, "Disconnect from nameservers", 68);
        this.command = this.createMenuItem(this.fileMenu, 1, "Send commands...", 83);
        this.command.setEnabled(false);
        this.load = this.createMenuItem(this.fileMenu, 1, "Load Ontology...", 79);
        this.exit = this.createMenuItem(this.fileMenu, 1, "Quit", 81);
        this.add(this.fileMenu);
        this.agentMenu = new JMenu("Agents");
        this.agentMenu.setMnemonic('A');
        this.tune_agent = this.createMenuItem(this.agentMenu, 1, "Tune Agent...", 84);
        this.cc_fact = this.createMenuItem(this.agentMenu, 1, "Request a Resource...", 82);
        this.uncc_fact = this.createMenuItem(this.agentMenu, 1, "Unrequest Resource...", 85);
        this.browse_fact = this.createMenuItem(this.agentMenu, 1, "Browse Resources...", 66);
        this.add_fact = this.createMenuItem(this.agentMenu, 1, "Add a Resource...", 65);
        this.agentMenu.addSeparator();
        this.cc_task = this.createMenuItem(this.agentMenu, 1, "Request Tasks...", 0);
        this.uncc_task = this.createMenuItem(this.agentMenu, 1, "Unrequest Tasks...", 0);
        this.browse_task = this.createMenuItem(this.agentMenu, 1, "Browse Tasks...", 0);
        this.add_task = this.createMenuItem(this.agentMenu, 1, "Add a Task...", 0);
        this.add(this.agentMenu);
        this.agentMenu.setEnabled(false);
        this.goalMenu = new JMenu("Goals");
        this.goalMenu.setMnemonic('G');
        this.cc_goal = this.createMenuItem(this.agentMenu, 1, "Request Goals...", 82);
        this.uncc_goal = this.createMenuItem(this.agentMenu, 1, "Unrequest Goals...", 85);
        this.browse_goal = this.createMenuItem(this.agentMenu, 1, "Browse Goals...", 66);
        this.add_goal = this.createMenuItem(this.agentMenu, 1, "Add a Goal...", 65);
        this.add(this.goalMenu);
        this.goalMenu.setEnabled(false);
        this.orgMenu = new JMenu("Organisation");
        this.orgMenu.setMnemonic('O');
        this.cc_rel = this.createMenuItem(this.agentMenu, 1, "Request Relations...", 82);
        this.uncc_rel = this.createMenuItem(this.agentMenu, 1, "Unrequest Relations...", 85);
        this.browse_rel = this.createMenuItem(this.agentMenu, 1, "Browse Relations...", 66);
        this.add_rel = this.createMenuItem(this.agentMenu, 1, "Add a Relation...", 65);
        this.add(this.orgMenu);
        this.orgMenu.setEnabled(false);
        this.societyMenu = new JMenu("Society");
        this.societyMenu.setMnemonic('S');
        this.browse_agent = this.createMenuItem(this.agentMenu, 1, "Browse Agents...", 66);
        this.add(this.societyMenu);
        this.societyMenu.setEnabled(false);
        this.coordMenu = new JMenu("Co-ordination");
        this.coordMenu.setMnemonic('C');
        this.cc_sgy = this.createMenuItem(this.agentMenu, 1, "Request Strategies...", 82);
        this.uncc_sgy = this.createMenuItem(this.agentMenu, 1, "Unrequest Strategies...", 85);
        this.browse_sgy = this.createMenuItem(this.agentMenu, 1, "Browse Strategies...", 66);
        this.add_sgy = this.createMenuItem(this.agentMenu, 1, "Add a Strategy...", 65);
        this.add(this.coordMenu);
        this.coordMenu.setEnabled(false);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic('H');
        this.help = this.createMenuItem(this.helpMenu, 1, "Using the Control Tool", 85);
        this.about = this.createMenuItem(this.helpMenu, 1, "About ZEUS", 65);
        this.add(this.helpMenu);
    }

    private JMenuItem createMenuItem(JMenu jMenu, int n, String string, int n2) {
        JMenuItem jMenuItem;
        switch (n) {
            case 2: {
                jMenuItem = new JRadioButtonMenuItem();
                jMenuItem.addActionListener(this);
            }
        }
        jMenuItem = new JMenuItem();
        jMenuItem.addActionListener(this);
        jMenuItem.setText(string);
        if (n2 > 0) {
            jMenuItem.setMnemonic(n2);
        }
        jMenu.add(jMenuItem);
        return jMenuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.connect) {
            this.view.Connect(true);
        } else if (object == this.disconnect) {
            this.view.Connect(false);
        } else if (object == this.load) {
            this.view.LoadOntology();
        } else if (object == this.command) {
            this.view.SendCommand();
        } else if (object == this.exit) {
            this.view.Exit();
        } else if (object == this.help) {
            this.view.showHelp();
        } else if (object == this.about) {
            this.view.About();
        }
    }
}

