/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.basic;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import zeus.actors.AgentContext;
import zeus.concepts.Performative;
import zeus.concepts.ZeusParser;
import zeus.gui.EditableDoubleSelectionDialog;
import zeus.gui.EditableMultipleSelectionDialog;
import zeus.gui.NumberDialog;
import zeus.util.Misc;
import zeus.util.SystemProps;
import zeus.visualiser.VisualiserModel;
import zeus.visualiser.basic.BasicTool;
import zeus.visualiser.basic.Player;
import zeus.visualiser.basic.StateInfo;

public abstract class VideoTool
extends BasicTool {
    protected static final int PLAYBACK = 0;
    protected static final int ONLINE = 1;
    protected static final int FORWARD = 0;
    protected static final int BACKWARD = 1;
    private NumberDialog number_dialog = null;
    private EditableMultipleSelectionDialog dialog = null;
    private EditableDoubleSelectionDialog proxy_dialog = null;
    protected VideoToolBar videoToolbar = null;
    protected StateInfo state = new StateInfo();

    public VideoTool(AgentContext agentContext, VisualiserModel visualiserModel) {
        super(agentContext, visualiserModel);
        this.state.animating = true;
        this.state.mode = 1;
        this.state.saving = false;
        this.videoToolbar = new VideoToolBar();
    }

    public void Exit() {
        this.setVisible(false);
        this.removeSubscriptions();
        if (this.state.player != null) {
            this.state.player.terminate();
            this.state.player = null;
        }
        this.dispose();
    }

    protected boolean stopPlayback() {
        int n;
        if (this.state.mode == 0 && (n = JOptionPane.showConfirmDialog(this, "There is an open database connection\nClose connection?", "Warning", 0)) == 0) {
            this.Close();
        }
        return this.state.mode == 1;
    }

    public void Sessions() {
        if (!this.hubOK()) {
            return;
        }
        Object[] objectArray = this.model.getDbProxys();
        if (this.dialog == null) {
            this.dialog = new EditableMultipleSelectionDialog((Frame)this, "Select DbProxy");
            this.dialog.setLocationRelativeTo(this);
        }
        this.dialog.setListData(objectArray);
        Object[] objectArray2 = this.dialog.getSelection();
        if (objectArray2 != null) {
            this.model.addDbProxys(Misc.stringArray(this.dialog.getListData()));
            this.query("db_sessions " + this.getClass().getName(), Misc.stringArray(objectArray2), "db_sessions");
        }
    }

    public void Delete() {
        if (!this.hubOK()) {
            return;
        }
        String string = this.getClass().getName();
        Hashtable hashtable = this.model.getDbSessions(string);
        if (this.proxy_dialog == null) {
            this.proxy_dialog = new EditableDoubleSelectionDialog((Frame)this, "Select DbProxy & Session Name", "DbProxy Agent", "Session Name");
            this.proxy_dialog.setLocationRelativeTo(this);
        }
        this.proxy_dialog.setListData(hashtable);
        Object[] objectArray = this.proxy_dialog.getSelection();
        if (objectArray != null) {
            Hashtable hashtable2 = this.proxy_dialog.getListData();
            this.model.addDbSessions(string, hashtable2);
            this.request("db_delete " + string + " " + objectArray[1], (String)objectArray[0], "db_delete");
        }
    }

    public void Purge() {
        if (!this.hubOK()) {
            return;
        }
        Object[] objectArray = this.model.getDbProxys();
        if (this.dialog == null) {
            this.dialog = new EditableMultipleSelectionDialog((Frame)this, "Select DbProxy");
            this.dialog.setLocationRelativeTo(this);
        }
        this.dialog.setListData(objectArray);
        Object[] objectArray2 = this.dialog.getSelection();
        if (objectArray2 != null) {
            this.model.addDbProxys(Misc.stringArray(this.dialog.getListData()));
            this.request("db_purge " + this.getClass().getName(), Misc.stringArray(objectArray2), "db_purge");
        }
    }

    public void Load() {
        if (!this.hubOK()) {
            return;
        }
        if (!this.stopPlayback()) {
            return;
        }
        if (this.state.saving) {
            int n = JOptionPane.showConfirmDialog(this, "There is an open database connection\nand saving is in progress.\nClose current connection?", "Warning", 0);
            if (n == 0) {
                this.Close();
            } else {
                return;
            }
        }
        String string = this.getClass().getName();
        Hashtable hashtable = this.model.getDbSessions(string);
        if (this.proxy_dialog == null) {
            this.proxy_dialog = new EditableDoubleSelectionDialog((Frame)this, "Select DbProxy & Session Name", "DbProxy Agent", "Session Name");
            this.proxy_dialog.setLocationRelativeTo(this);
        }
        this.proxy_dialog.setListData(hashtable);
        Object[] objectArray = this.proxy_dialog.getSelection();
        if (objectArray != null) {
            Hashtable hashtable2 = this.proxy_dialog.getListData();
            this.model.addDbSessions(string, hashtable2);
            this.setMode(0);
            this.state.proxy = (String)objectArray[0];
            this.state.session = (String)objectArray[1];
            this.state.key = this.context.newId("LoadSessionKey");
            this.state.mode = 0;
            this.state.player = new Player(this);
            this.request("db_open " + string + " " + this.state.session + " " + this.state.key, this.state.proxy, "db_open");
        }
    }

    public void Record() {
        if (this.state.saving) {
            int n = JOptionPane.showConfirmDialog(this, "There is an open database connection\nand saving is in progress.\nClose current connection?", "Warning", 0);
            if (n == 0) {
                this.Close();
            } else {
                return;
            }
        }
        String string = this.getClass().getName();
        Hashtable hashtable = this.model.getDbSessions(string);
        if (this.proxy_dialog == null) {
            this.proxy_dialog = new EditableDoubleSelectionDialog((Frame)this, "Select DbProxy & Session Name", "DbProxy Agent", "Session Name");
            this.proxy_dialog.setLocationRelativeTo(this);
        }
        this.proxy_dialog.setListData(hashtable);
        Object[] objectArray = this.proxy_dialog.getSelection();
        if (objectArray != null) {
            Hashtable hashtable2 = this.proxy_dialog.getListData();
            this.model.addDbSessions(string, hashtable2);
            this.state.proxy = (String)objectArray[0];
            this.state.session = (String)objectArray[1];
            this.state.key = this.context.newId("SaveSessionKey");
            this.state.errored = false;
            this.request("db_create " + string + " " + this.state.session + " " + this.state.key, this.state.proxy, "db_create");
        }
    }

    public void Close() {
        if (this.hubOK() && this.state.key != null) {
            this.request("db_close " + this.state.key, this.state.proxy, "db_close");
            this.state.key = null;
            if (this.state.mode == 0 && this.state.player != null) {
                this.state.player.terminate();
                this.state.player = null;
            }
        }
        this.setMode(1);
        this.state.mode = 1;
        this.state.saving = false;
        this.state.errored = false;
    }

    public void Forward() {
        if (this.state.mode == 0 && !this.state.errored) {
            this.state.player.forward();
        }
    }

    public void Rewind() {
        if (this.state.mode == 0 && !this.state.errored) {
            this.state.player.rewind();
        }
    }

    public void FForward() {
        if (this.state.mode == 0 && !this.state.errored) {
            this.state.player.fforward();
        }
    }

    public void FRewind() {
        if (this.state.mode == 0 && !this.state.errored) {
            this.state.player.frewind();
        }
    }

    public void Stop() {
        if (this.state.mode == 0 && !this.state.errored) {
            this.state.player.pause();
        }
    }

    public void StepForward() {
        if (this.state.mode == 0 && !this.state.errored) {
            this.state.player.forward_step();
        }
    }

    public void ForwardEnd() {
        if (this.state.mode == 0 && !this.state.errored) {
            this.state.player.last();
        }
    }

    public void StepRewind() {
        if (this.state.mode == 0 && !this.state.errored) {
            this.state.player.rewind_step();
        }
    }

    public void RewindBegin() {
        if (this.state.mode == 0 && !this.state.errored) {
            this.state.player.first();
        }
    }

    protected boolean checkErrorMsg(Performative performative, String string) {
        String string2 = performative.getType();
        if (string2.equals("failure") || string2.equals("not-understood") || string2.equals("refuse")) {
            JOptionPane.showMessageDialog(this, string, "Error", 0);
            return true;
        }
        return false;
    }

    public void db_sessions(Performative performative) {
        if (this.checkErrorMsg(performative, "Cannot list sessions")) {
            return;
        }
        if (performative.getType().equals("inform")) {
            String string = this.getClass().getName();
            String string2 = performative.getSender();
            StringTokenizer stringTokenizer = new StringTokenizer(performative.getContent());
            while (stringTokenizer.hasMoreTokens()) {
                this.model.addDbSession(string, string2, stringTokenizer.nextToken());
            }
        }
    }

    public void db_delete(Performative performative) {
        this.checkErrorMsg(performative, "Cannot delete database session");
    }

    public void db_purge(Performative performative) {
        this.checkErrorMsg(performative, "Cannot purge database");
    }

    public void db_close(Performative performative) {
        this.checkErrorMsg(performative, "Cannot close database");
    }

    public void db_save(Performative performative) {
        if (this.checkErrorMsg(performative, "Cannot save item")) {
            this.Close();
        }
    }

    protected boolean record_item(Performative performative) {
        if (this.state.mode != 1 || !this.state.saving || this.state.errored) {
            return false;
        }
        String string = performative.getSender();
        String string2 = performative.getReceiver();
        if (string.equals(this.context.whoami()) && string2.equals(this.state.proxy) || string2.equals(this.context.whoami()) && string.equals(this.state.proxy)) {
            return false;
        }
        this.request("db_save " + this.state.key + " " + performative, this.state.proxy, "db_save");
        return true;
    }

    public void db_create(Performative performative) {
        this.state.errored = this.checkErrorMsg(performative, "Cannot create database session.\nClosing link.");
        if (this.state.errored) {
            this.setMode(1);
            this.state.mode = 1;
            this.state.saving = false;
            this.state.errored = false;
        } else {
            this.state.saving = true;
        }
    }

    public void db_prior(Performative performative) {
        if (this.checkErrorMsg(performative, "End of file reached")) {
            this.state.player.setCommand(8);
        } else {
            Performative performative2 = ZeusParser.performative(performative.getContent());
            this.visualiseVideoData(1, performative2);
        }
    }

    public void db_next(Performative performative) {
        if (this.checkErrorMsg(performative, "End of file reached")) {
            this.state.player.setCommand(8);
        } else {
            Performative performative2 = ZeusParser.performative(performative.getContent());
            this.visualiseVideoData(0, performative2);
        }
    }

    public void db_first(Performative performative) {
        if (this.checkErrorMsg(performative, "End of file reached")) {
            this.state.player.setCommand(8);
        }
    }

    public void db_last(Performative performative) {
        if (this.checkErrorMsg(performative, "End of file reached")) {
            this.state.player.setCommand(8);
        }
    }

    public void db_open(Performative performative) {
        if (this.checkErrorMsg(performative, "Cannot open database")) {
            this.state.key = null;
            this.Close();
            return;
        }
        this.state.player.setCommand(1);
        this.query("db_list " + this.state.key, this.state.proxy, "db_list");
    }

    public void db_list(Performative performative) {
        if (this.checkErrorMsg(performative, "Cannot obtain list of agents")) {
            this.Close();
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(performative.getContent());
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        this.registerListOfPlaybackAgents(vector);
        this.state.player.setCommand(0);
        this.query("db_count " + this.state.key, this.state.proxy, "db_count");
    }

    public void db_count(Performative performative) {
        if (this.checkErrorMsg(performative, "Cannot obtain count of itens")) {
            this.Close();
            return;
        }
        int n = Integer.parseInt(performative.getContent());
        this.state.player.setCount(n);
        this.state.player.setCommand(8);
    }

    void doPlayerCommand(String string) {
        this.query(string + " " + this.state.key, this.state.proxy, string);
    }

    public void PlayerSpeed() {
        long l;
        long l2 = l = this.state != null && this.state.player != null ? this.state.player.getSpeed() : Player.getDefaultSpeed();
        if (this.number_dialog == null) {
            this.number_dialog = new NumberDialog((Frame)this, "Set Player Speed", "Enter speed:");
            this.number_dialog.setLocationRelativeTo(this);
        }
        this.number_dialog.setValue(l);
        Long l3 = this.number_dialog.getValue();
        if (l3 != null) {
            if (this.state != null && this.state.player != null) {
                this.state.player.setSpeed(l3);
            } else {
                Player.setDefaultSpeed(l3);
            }
        }
    }

    protected abstract void registerListOfPlaybackAgents(Vector var1);

    protected abstract void visualiseVideoData(int var1, Performative var2);

    protected abstract void setMode(int var1);

    protected class VideoToolBar
    extends JToolBar
    implements ActionListener {
        protected JButton firstBtn;
        protected JButton fastRewindBtn;
        protected JButton rewindBtn;
        protected JButton stepRewindBtn;
        protected JButton stopBtn;
        protected JButton stepForwardBtn;
        protected JButton forwardBtn;
        protected JButton fastForwardBtn;
        protected JButton lastBtn;
        protected JButton recordBtn;

        public VideoToolBar() {
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + string + "visualiser" + string;
            this.firstBtn = new JButton(new ImageIcon(string2 + "first.gif"));
            this.add(this.firstBtn);
            this.firstBtn.setPreferredSize(new Dimension(24, 24));
            this.firstBtn.setToolTipText("First");
            this.firstBtn.setMargin(new Insets(0, 0, 0, 0));
            this.fastRewindBtn = new JButton(new ImageIcon(string2 + "fbwd.gif"));
            this.add(this.fastRewindBtn);
            this.fastRewindBtn.setPreferredSize(new Dimension(24, 24));
            this.fastRewindBtn.setToolTipText("Fast Rewind");
            this.fastRewindBtn.setMargin(new Insets(0, 0, 0, 0));
            this.rewindBtn = new JButton(new ImageIcon(string2 + "bwd.gif"));
            this.add(this.rewindBtn);
            this.rewindBtn.setPreferredSize(new Dimension(24, 24));
            this.rewindBtn.setToolTipText("Rewind");
            this.rewindBtn.setMargin(new Insets(0, 0, 0, 0));
            this.stepRewindBtn = new JButton(new ImageIcon(string2 + "prior.gif"));
            this.add(this.stepRewindBtn);
            this.stepRewindBtn.setPreferredSize(new Dimension(24, 24));
            this.stepRewindBtn.setToolTipText("Prior");
            this.stepRewindBtn.setMargin(new Insets(0, 0, 0, 0));
            this.addSeparator();
            this.stopBtn = new JButton(new ImageIcon(string2 + "stop.gif"));
            this.add(this.stopBtn);
            this.stopBtn.setPreferredSize(new Dimension(24, 24));
            this.stopBtn.setToolTipText("Stop");
            this.stopBtn.setMargin(new Insets(0, 0, 0, 0));
            this.addSeparator();
            this.stepForwardBtn = new JButton(new ImageIcon(string2 + "next.gif"));
            this.add(this.stepForwardBtn);
            this.stepForwardBtn.setPreferredSize(new Dimension(24, 24));
            this.stepForwardBtn.setToolTipText("Next");
            this.stepForwardBtn.setMargin(new Insets(0, 0, 0, 0));
            this.forwardBtn = new JButton(new ImageIcon(string2 + "fwd.gif"));
            this.add(this.forwardBtn);
            this.forwardBtn.setPreferredSize(new Dimension(24, 24));
            this.forwardBtn.setToolTipText("Play");
            this.forwardBtn.setMargin(new Insets(0, 0, 0, 0));
            this.fastForwardBtn = new JButton(new ImageIcon(string2 + "ffwd.gif"));
            this.add(this.fastForwardBtn);
            this.fastForwardBtn.setPreferredSize(new Dimension(24, 24));
            this.fastForwardBtn.setToolTipText("Fast Forward");
            this.fastForwardBtn.setMargin(new Insets(0, 0, 0, 0));
            this.lastBtn = new JButton(new ImageIcon(string2 + "last.gif"));
            this.add(this.lastBtn);
            this.lastBtn.setPreferredSize(new Dimension(24, 24));
            this.lastBtn.setToolTipText("Last");
            this.lastBtn.setMargin(new Insets(0, 0, 0, 0));
            this.addSeparator();
            this.recordBtn = new JButton(new ImageIcon(string2 + "rec.gif"));
            this.add(this.recordBtn);
            this.recordBtn.setPreferredSize(new Dimension(24, 24));
            this.recordBtn.setToolTipText("Record");
            this.recordBtn.setMargin(new Insets(0, 0, 0, 0));
            this.firstBtn.addActionListener(this);
            this.fastRewindBtn.addActionListener(this);
            this.rewindBtn.addActionListener(this);
            this.stepRewindBtn.addActionListener(this);
            this.stopBtn.addActionListener(this);
            this.stepForwardBtn.addActionListener(this);
            this.forwardBtn.addActionListener(this);
            this.fastForwardBtn.addActionListener(this);
            this.lastBtn.addActionListener(this);
            this.recordBtn.addActionListener(this);
            this.setPreferredSize(new Dimension(300, 32));
        }

        public void setStatus(boolean bl) {
            this.firstBtn.setEnabled(bl);
            this.fastRewindBtn.setEnabled(bl);
            this.rewindBtn.setEnabled(bl);
            this.stepRewindBtn.setEnabled(bl);
            this.stopBtn.setEnabled(bl);
            this.stepForwardBtn.setEnabled(bl);
            this.forwardBtn.setEnabled(bl);
            this.fastForwardBtn.setEnabled(bl);
            this.lastBtn.setEnabled(bl);
            this.recordBtn.setEnabled(!bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.firstBtn) {
                VideoTool.this.RewindBegin();
            } else if (object == this.fastRewindBtn) {
                VideoTool.this.FRewind();
            } else if (object == this.rewindBtn) {
                VideoTool.this.Rewind();
            } else if (object == this.stepRewindBtn) {
                VideoTool.this.StepRewind();
            } else if (object == this.stopBtn) {
                VideoTool.this.Stop();
            } else if (object == this.stepForwardBtn) {
                VideoTool.this.StepForward();
            } else if (object == this.forwardBtn) {
                VideoTool.this.Forward();
            } else if (object == this.fastForwardBtn) {
                VideoTool.this.FForward();
            } else if (object == this.lastBtn) {
                VideoTool.this.ForwardEnd();
            } else if (object == this.recordBtn) {
                VideoTool.this.Record();
            }
        }
    }
}

