/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.basic;

import zeus.util.Assert;
import zeus.visualiser.basic.VideoTool;

public class Player
extends Thread {
    static final int COUNT = 0;
    static final int LIST = 1;
    static final int NEXT = 2;
    static final int PRIOR = 3;
    static final int FIRST = 4;
    static final int LAST = 5;
    static final int OPEN = 6;
    static final int CLOSE = 7;
    static final int READY = 8;
    static final int STOP = 9;
    private static long CDEFAULT_SPEED = 1000L;
    private long DEFAULT_SPEED = CDEFAULT_SPEED;
    protected VideoTool video;
    private int max_count = -1;
    private int cmd = 6;
    private boolean playback = true;
    private boolean single_step = false;
    private long timeout;

    void setSpeed(long l) {
        this.DEFAULT_SPEED = l;
    }

    long getSpeed() {
        return this.DEFAULT_SPEED;
    }

    static long getDefaultSpeed() {
        return CDEFAULT_SPEED;
    }

    static void setDefaultSpeed(long l) {
        CDEFAULT_SPEED = l;
    }

    Player(VideoTool videoTool) {
        Assert.notNull(videoTool);
        this.video = videoTool;
        this.setPriority(3);
        this.start();
    }

    private boolean ready() {
        switch (this.cmd) {
            case 2: 
            case 3: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    synchronized void first() {
        if (!this.ready()) {
            return;
        }
        this.cmd = 4;
        this.single_step = false;
        this.timeout = this.DEFAULT_SPEED;
        this.notify();
    }

    synchronized void last() {
        if (!this.ready()) {
            return;
        }
        this.cmd = 5;
        this.single_step = false;
        this.timeout = this.DEFAULT_SPEED;
        this.notify();
    }

    synchronized void forward_step() {
        if (!this.ready()) {
            return;
        }
        this.cmd = 2;
        this.single_step = true;
        this.timeout = this.DEFAULT_SPEED;
        this.notify();
    }

    synchronized void rewind_step() {
        if (!this.ready()) {
            return;
        }
        this.cmd = 3;
        this.single_step = true;
        this.timeout = this.DEFAULT_SPEED;
        this.notify();
    }

    synchronized void forward() {
        if (!this.ready()) {
            return;
        }
        this.cmd = 2;
        this.single_step = false;
        this.timeout = this.DEFAULT_SPEED;
        this.notify();
    }

    synchronized void rewind() {
        if (!this.ready()) {
            return;
        }
        this.cmd = 3;
        this.single_step = false;
        this.timeout = this.DEFAULT_SPEED;
        this.notify();
    }

    synchronized void fforward() {
        if (!this.ready()) {
            return;
        }
        this.cmd = 2;
        this.single_step = false;
        this.timeout = this.DEFAULT_SPEED / 2L;
        this.notify();
    }

    synchronized void frewind() {
        if (!this.ready()) {
            return;
        }
        this.cmd = 3;
        this.single_step = false;
        this.timeout = this.DEFAULT_SPEED / 2L;
        this.notify();
    }

    synchronized void pause() {
        if (!this.ready()) {
            return;
        }
        this.cmd = 8;
        this.single_step = false;
        this.timeout = this.DEFAULT_SPEED;
    }

    synchronized void terminate() {
        this.playback = false;
        this.cmd = 9;
        this.notify();
    }

    private boolean running() {
        switch (this.cmd) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    void setCommand(int n) {
        this.cmd = n;
    }

    void setCount(int n) {
        this.max_count = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = 0;
        while (this.playback) {
            try {
                Player player = this;
                synchronized (player) {
                    while (!this.running()) {
                        this.wait();
                    }
                }
                if (this.cmd == 9) {
                    return;
                }
                if (this.cmd == 2 && n < this.max_count || this.cmd == 3 && n > 0) {
                    if (this.cmd == 2) {
                        ++n;
                    } else if (this.cmd == 3) {
                        --n;
                    }
                    if (this.cmd == 2) {
                        this.video.doPlayerCommand("db_next");
                    } else {
                        this.video.doPlayerCommand("db_prior");
                    }
                    if (this.single_step) {
                        this.cmd = 8;
                        continue;
                    }
                    Thread.sleep(this.timeout);
                    continue;
                }
                if (this.cmd == 4 || this.cmd == 5) {
                    int n2 = n = this.cmd == 4 ? 0 : this.max_count;
                    if (this.cmd == 4) {
                        this.video.doPlayerCommand("db_first");
                    } else {
                        this.video.doPlayerCommand("db_last");
                    }
                    this.single_step = false;
                    this.cmd = 8;
                    continue;
                }
                Player player2 = this;
                synchronized (player2) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

