/*
 * Decompiled with CFR 0.152.
 */
package zeus.visualiser.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import zeus.gui.fields.NameField;
import zeus.util.Misc;
import zeus.visualiser.basic.MsgFilter;

public class MsgFilterEditor
extends JDialog
implements ActionListener,
ItemListener {
    protected JButton okButton;
    protected JButton cancelButton;
    protected JLabel fromLabel = new JLabel("From agent: ");
    protected JLabel toLabel = new JLabel("To agent: ");
    protected JLabel aboutLabel = new JLabel("About topic: ");
    protected AgentList fromList;
    protected AgentList toList;
    protected JCheckBox checkbox = null;
    protected JTextField checkboxTf = null;
    protected MsgFilter filter = null;

    public MsgFilterEditor(JFrame jFrame, String string) {
        this(jFrame, string, null);
    }

    public MsgFilterEditor(JFrame jFrame, String string, String[] stringArray) {
        super(jFrame, string, true);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        this.getContentPane().add("South", jPanel);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.fromLabel, gridBagConstraints);
        jPanel2.add(this.fromLabel);
        this.fromList = new AgentList(stringArray);
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.fromList, gridBagConstraints);
        jPanel2.add(this.fromList);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.toLabel, gridBagConstraints);
        jPanel2.add(this.toLabel);
        this.toList = new AgentList(stringArray);
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.toList, gridBagConstraints);
        jPanel2.add(this.toList);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.aboutLabel, gridBagConstraints);
        jPanel2.add(this.aboutLabel);
        this.checkbox = new JCheckBox("About");
        this.checkboxTf = new JTextField(20);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.checkbox, gridBagConstraints);
        jPanel2.add(this.checkbox);
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.checkboxTf, gridBagConstraints);
        jPanel2.add(this.checkboxTf);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel2.add(jSeparator);
        this.getContentPane().add("Center", jPanel2);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.checkbox.addItemListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MsgFilterEditor.this.setVisible(false);
            }
        });
        this.checkbox.setSelected(false);
        this.checkboxTf.setText("");
        this.checkboxTf.setEnabled(this.checkbox.isSelected());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.checkbox) {
            this.checkboxTf.setEnabled(this.checkbox.isSelected());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.filter = new MsgFilter();
            this.filter.from = Misc.stringArray(this.fromList.getSelection());
            this.filter.to = Misc.stringArray(this.toList.getSelection());
            if (this.checkbox.isSelected()) {
                this.filter.about = this.checkboxTf.getText();
            }
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public void setListData(String[] stringArray) {
        this.fromList.setListData(stringArray);
        this.toList.setListData(stringArray);
    }

    public void setFilter(MsgFilter msgFilter) {
        Object[] objectArray = new String[]{};
        Object[] objectArray2 = new String[]{};
        String string = null;
        if (msgFilter != null) {
            objectArray = msgFilter.from;
            objectArray2 = msgFilter.to;
            string = msgFilter.about;
        }
        this.fromList.setSelection(objectArray);
        this.toList.setSelection(objectArray2);
        this.checkbox.setSelected(false);
        this.checkboxTf.setEditable(this.checkbox.isSelected());
        if (string != null) {
            this.checkbox.setSelected(true);
            this.checkboxTf.setEditable(this.checkbox.isSelected());
            this.checkboxTf.setText(string);
        }
    }

    public synchronized MsgFilter getFilter() {
        this.filter = null;
        this.pack();
        this.setVisible(true);
        return this.filter;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test");
        jFrame.setSize(200, 200);
        jFrame.show();
        String[] stringArray2 = new String[]{"Dave", "John", "Henry", "Alice", "Albert"};
        MsgFilterEditor msgFilterEditor = new MsgFilterEditor(jFrame, "Edit Filter", stringArray2);
        MsgFilter msgFilter = msgFilterEditor.getFilter();
        System.out.println(msgFilter);
        System.exit(0);
    }

    protected class AgentList
    extends JPanel
    implements ActionListener {
        protected JButton selectButton;
        protected JButton clearButton;
        protected JButton invertButton;
        protected String ENTER = "Add item:";
        protected String SELECT_ALL = "Select All";
        protected String CLEAR_ALL = "Clear All";
        protected String INVERT = "Invert Selection";
        protected NameField textfield;
        protected JList list = new JList();
        protected Object[] selection = null;

        public AgentList(Object[] objectArray) {
            this();
            this.list.setListData(objectArray);
        }

        public AgentList(Object[] objectArray, Object[] objectArray2) {
            this();
            this.list.setListData(objectArray);
            this.setSelection(objectArray2);
        }

        public AgentList() {
            this.list.setSelectionModel(new DefaultListSelectionModel());
            this.list.setSelectionMode(2);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().setView(this.list);
            jScrollPane.setPreferredSize(new Dimension(150, 150));
            this.selectButton = new JButton(this.SELECT_ALL);
            this.clearButton = new JButton(this.CLEAR_ALL);
            this.invertButton = new JButton(this.INVERT);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(3, 1, 2, 2));
            jPanel.add(this.selectButton);
            jPanel.add(this.clearButton);
            jPanel.add(this.invertButton);
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel2.setLayout(gridBagLayout);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            JLabel jLabel = new JLabel(this.ENTER);
            jLabel.setToolTipText("Enter new data into text field and press <return> to add to list");
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            this.textfield = new NameField(20);
            this.textfield.addActionListener(this);
            gridBagLayout.setConstraints(this.textfield, gridBagConstraints);
            jPanel2.add(this.textfield);
            this.setLayout(gridBagLayout);
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            this.add(jPanel2);
            gridBagConstraints.insets = new Insets(10, 10, 10, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(10, 40, 0, 10);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            this.selectButton.addActionListener(this);
            this.clearButton.addActionListener(this);
            this.invertButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = this.list.getModel().getSize();
            if (object == this.selectButton) {
                this.list.setSelectionInterval(0, n - 1);
            } else if (object == this.clearButton) {
                this.list.clearSelection();
            } else if (object == this.invertButton) {
                int[] nArray = this.list.getSelectedIndices();
                this.list.clearSelection();
                int n2 = 0;
                while (n2 < n) {
                    boolean bl = false;
                    int n3 = 0;
                    while (!bl && n3 < nArray.length) {
                        bl = nArray[n3] == n2;
                        ++n3;
                    }
                    if (!bl) {
                        this.list.addSelectionInterval(n2, n2);
                    }
                    ++n2;
                }
            } else if (object == this.textfield) {
                String string = this.textfield.getText();
                if (string == null) {
                    return;
                }
                if ((string = string.trim()).equals("")) {
                    return;
                }
                ListModel listModel = this.list.getModel();
                Vector vector = new Vector();
                int n4 = 0;
                while (n4 < listModel.getSize()) {
                    vector.addElement(listModel.getElementAt(n4));
                    ++n4;
                }
                if (!vector.contains(string)) {
                    vector.addElement(string);
                    this.list.setListData(vector);
                }
                this.textfield.setText("");
            }
        }

        public Object[] getPriorSelection() {
            return this.list.getSelectedValues();
        }

        public Object[] getSelection() {
            this.selection = this.list.getSelectedValues();
            if (this.selection.length == 0) {
                return null;
            }
            return this.selection;
        }

        public void setListData(Object[] objectArray) {
            this.list.setListData(objectArray);
        }

        public Object[] getListData() {
            ListModel listModel = this.list.getModel();
            Vector vector = new Vector();
            int n = 0;
            while (n < listModel.getSize()) {
                vector.addElement(listModel.getElementAt(n));
                ++n;
            }
            return vector.toArray();
        }

        public void setSelection(Object[] objectArray) {
            ListModel listModel = this.list.getModel();
            int n = listModel.getSize();
            this.list.clearSelection();
            int n2 = 0;
            while (n2 < objectArray.length) {
                int n3 = 0;
                while (n3 < n) {
                    if (objectArray[n2] == listModel.getElementAt(n3)) {
                        this.list.addSelectionInterval(n3, n3);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }
}

